/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.model.RenditionModel;
import org.alfresco.repo.transfer.ChildAssociatedNodeFinder;
import org.alfresco.repo.transfer.ContentClassFilter;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.transfer.NodeCrawler;
import org.alfresco.service.cmr.transfer.NodeCrawlerFactory;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.GUID;

public class NodeCrawlerTest
extends BaseAlfrescoSpringTest {
    private ServiceRegistry serviceRegistry;
    private NodeRef companyHome;
    private NodeCrawlerFactory nodeCrawlerFactory;

    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.nodeService = (NodeService)this.getApplicationContext().getBean("NodeService");
        this.serviceRegistry = (ServiceRegistry)this.getApplicationContext().getBean("ServiceRegistry");
        this.nodeCrawlerFactory = (NodeCrawlerFactory)this.getApplicationContext().getBean("NodeCrawlerFactory");
        ResultSet rs = this.serviceRegistry.getSearchService().query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", "/app:company_home");
        if (rs.length() == 0) {
            NodeCrawlerTest.fail((String)"Could not find company home");
        }
        this.companyHome = rs.getNodeRef(0);
    }

    public void testContentClassFilter() throws Exception {
        NodeRef node1 = this.makeNode(this.companyHome, ContentModel.TYPE_BASE);
        NodeRef node2 = this.makeNode(this.companyHome, ContentModel.TYPE_CONTENT);
        NodeRef node3 = this.makeNode(this.companyHome, ContentModel.TYPE_FOLDER);
        NodeRef node4 = this.makeNode(this.companyHome, ContentModel.TYPE_CONTENT);
        NodeRef node5 = this.makeNode(this.companyHome, ContentModel.TYPE_THUMBNAIL);
        this.nodeService.addAspect(node4, ContentModel.ASPECT_REFERENCEABLE, null);
        ContentClassFilter contentFilter = new ContentClassFilter();
        contentFilter.setServiceRegistry(this.serviceRegistry);
        contentFilter.setContentClasses(ContentModel.TYPE_BASE);
        NodeCrawlerTest.assertTrue((boolean)contentFilter.accept(node1));
        NodeCrawlerTest.assertTrue((boolean)contentFilter.accept(node2));
        NodeCrawlerTest.assertTrue((boolean)contentFilter.accept(node3));
        contentFilter.setDirectOnly(true);
        NodeCrawlerTest.assertTrue((boolean)contentFilter.accept(node1));
        NodeCrawlerTest.assertFalse((boolean)contentFilter.accept(node2));
        NodeCrawlerTest.assertFalse((boolean)contentFilter.accept(node3));
        contentFilter.setContentClasses(ContentModel.TYPE_BASE, ContentModel.ASPECT_REFERENCEABLE);
        NodeCrawlerTest.assertTrue((boolean)contentFilter.accept(node4));
        contentFilter.setExclude(true);
        contentFilter.setDirectOnly(false);
        contentFilter.setContentClasses(ContentModel.TYPE_CONTENT);
        NodeCrawlerTest.assertTrue((boolean)contentFilter.accept(node1));
        NodeCrawlerTest.assertFalse((boolean)contentFilter.accept(node2));
        NodeCrawlerTest.assertTrue((boolean)contentFilter.accept(node3));
        NodeCrawlerTest.assertFalse((boolean)contentFilter.accept(node5));
        contentFilter.setDirectOnly(true);
        NodeCrawlerTest.assertTrue((boolean)contentFilter.accept(node1));
        NodeCrawlerTest.assertFalse((boolean)contentFilter.accept(node2));
        NodeCrawlerTest.assertTrue((boolean)contentFilter.accept(node3));
        NodeCrawlerTest.assertTrue((boolean)contentFilter.accept(node5));
    }

    public void testChildAssociationFinder() {
        this.makeNode(this.companyHome, ContentModel.TYPE_BASE);
        this.makeNode(this.companyHome, ContentModel.TYPE_CONTENT);
        this.makeNode(this.companyHome, ContentModel.TYPE_CONTENT);
        this.makeNode(this.companyHome, ContentModel.TYPE_CONTENT);
        this.makeNode(this.companyHome, ContentModel.TYPE_CONTENT);
        this.makeNode(this.companyHome, ContentModel.TYPE_CONTENT);
        this.makeNode(this.companyHome, ContentModel.TYPE_CONTENT);
        NodeRef node8 = this.makeNode(this.companyHome, ContentModel.TYPE_FOLDER);
        this.makeNode(node8, ContentModel.TYPE_FOLDER);
        NodeRef node10 = this.makeNode(node8, ContentModel.TYPE_FOLDER);
        this.makeNode(node10, ContentModel.TYPE_FOLDER);
        NodeRef node12 = this.makeNode(node10, ContentModel.TYPE_FOLDER);
        NodeRef node13 = this.makeNode(node12, ContentModel.TYPE_FOLDER);
        this.makeNode(node13, ContentModel.TYPE_CONTENT);
        NodeRef node15 = this.makeNode(node13, ContentModel.TYPE_THUMBNAIL);
        this.nodeService.addAspect(node8, RenditionModel.ASPECT_RENDITIONED, null);
        this.nodeService.addChild(node8, node15, RenditionModel.ASSOC_RENDITION, QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"temp"));
        ChildAssociatedNodeFinder nodeFinder = new ChildAssociatedNodeFinder();
        nodeFinder.setServiceRegistry(this.serviceRegistry);
        nodeFinder.setAssociationTypes(ContentModel.ASSOC_CONTAINS);
        Set<NodeRef> results = nodeFinder.findFrom(node8);
        NodeCrawlerTest.assertEquals((int)2, (int)results.size());
        nodeFinder.setAssociationTypes(RenditionModel.ASSOC_RENDITION);
        results = nodeFinder.findFrom(node8);
        NodeCrawlerTest.assertEquals((int)1, (int)results.size());
        NodeCrawlerTest.assertEquals((Object)node15, (Object)new ArrayList<NodeRef>(results).get(0));
    }

    public void testCrawler() {
        NodeRef node8 = this.makeNode(this.companyHome, ContentModel.TYPE_FOLDER);
        NodeRef node9 = this.makeNode(node8, ContentModel.TYPE_FOLDER);
        NodeRef node10 = this.makeNode(node8, ContentModel.TYPE_FOLDER);
        NodeRef node11 = this.makeNode(node10, ContentModel.TYPE_FOLDER);
        NodeRef node12 = this.makeNode(node10, ContentModel.TYPE_FOLDER);
        NodeRef node13 = this.makeNode(node12, ContentModel.TYPE_FOLDER);
        this.makeNode(node10, ContentModel.TYPE_BASE);
        this.makeNode(node13, ContentModel.TYPE_CONTENT);
        this.makeNode(node10, ContentModel.TYPE_CONTENT);
        this.makeNode(node11, ContentModel.TYPE_CONTENT);
        this.makeNode(node8, ContentModel.TYPE_CONTENT);
        this.makeNode(node8, ContentModel.TYPE_CONTENT);
        this.makeNode(node9, ContentModel.TYPE_CONTENT);
        this.makeNode(node13, ContentModel.TYPE_CONTENT);
        NodeRef node15 = this.makeNode(node13, ContentModel.TYPE_THUMBNAIL);
        this.nodeService.addAspect(node8, RenditionModel.ASPECT_RENDITIONED, null);
        this.nodeService.addChild(node8, node15, RenditionModel.ASSOC_RENDITION, QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"temp"));
        NodeCrawler crawler = this.nodeCrawlerFactory.getNodeCrawler();
        crawler.setNodeFinders(new ChildAssociatedNodeFinder(ContentModel.ASSOC_CONTAINS));
        Set<NodeRef> crawledNodes = crawler.crawl(node8);
        NodeCrawlerTest.assertEquals((int)15, (int)crawledNodes.size());
        crawler.setNodeFilters(new ContentClassFilter(ContentModel.TYPE_FOLDER));
        crawledNodes = crawler.crawl(node8);
        NodeCrawlerTest.assertEquals((int)6, (int)crawledNodes.size());
    }

    private NodeRef makeNode(NodeRef parent, QName nodeType) {
        String uuid = GUID.generate();
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_NAME, uuid);
        ChildAssociationRef assoc = this.nodeService.createNode(parent, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)uuid), nodeType, props);
        return assoc.getChildRef();
    }
}

