/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.UserTransaction;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transfer.ContentChunkProcessor;
import org.alfresco.repo.transfer.ContentChunkerImpl;
import org.alfresco.repo.transfer.DeltaList;
import org.alfresco.repo.transfer.Transfer;
import org.alfresco.repo.transfer.TransferCommons;
import org.alfresco.repo.transfer.TransferEventProcessor;
import org.alfresco.repo.transfer.TransferModel;
import org.alfresco.repo.transfer.TransferTargetImpl;
import org.alfresco.repo.transfer.TransferTransmitter;
import org.alfresco.repo.transfer.manifest.TransferManifestDeletedNode;
import org.alfresco.repo.transfer.manifest.TransferManifestHeader;
import org.alfresco.repo.transfer.manifest.TransferManifestNode;
import org.alfresco.repo.transfer.manifest.TransferManifestNodeFactory;
import org.alfresco.repo.transfer.manifest.TransferManifestNodeHelper;
import org.alfresco.repo.transfer.manifest.TransferManifestNormalNode;
import org.alfresco.repo.transfer.manifest.TransferManifestProcessor;
import org.alfresco.repo.transfer.manifest.XMLTransferManifestReader;
import org.alfresco.repo.transfer.manifest.XMLTransferManifestWriter;
import org.alfresco.repo.transfer.report.TransferReporter;
import org.alfresco.repo.transfer.requisite.DeltaListRequsiteProcessor;
import org.alfresco.repo.transfer.requisite.XMLTransferRequsiteReader;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.transfer.TransferCallback;
import org.alfresco.service.cmr.transfer.TransferCancelledException;
import org.alfresco.service.cmr.transfer.TransferDefinition;
import org.alfresco.service.cmr.transfer.TransferEndEvent;
import org.alfresco.service.cmr.transfer.TransferEvent;
import org.alfresco.service.cmr.transfer.TransferEventCancelled;
import org.alfresco.service.cmr.transfer.TransferEventError;
import org.alfresco.service.cmr.transfer.TransferEventReport;
import org.alfresco.service.cmr.transfer.TransferEventSuccess;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferFailureException;
import org.alfresco.service.cmr.transfer.TransferProgress;
import org.alfresco.service.cmr.transfer.TransferService2;
import org.alfresco.service.cmr.transfer.TransferTarget;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferServiceImpl2
implements TransferService2 {
    private static Log logger = LogFactory.getLog(TransferServiceImpl2.class);
    private static final String MSG_NO_HOME = "transfer_service.unable_to_find_transfer_home";
    private static final String MSG_NO_GROUP = "transfer_service.unable_to_find_transfer_group";
    private static final String MSG_NO_TARGET = "transfer_service.unable_to_find_transfer_target";
    private static final String MSG_ERR_TRANSFER_ASYNC = "transfer_service.unable_to_transfer_async";
    private static final String MSG_TARGET_EXISTS = "transfer_service.target_exists";
    private static final String MSG_NO_NODES = "transfer_service.no_nodes";
    private static final String MSG_MISSING_ENDPOINT_PATH = "transfer_service.missing_endpoint_path";
    private static final String MSG_MISSING_ENDPOINT_PROTOCOL = "transfer_service.missing_endpoint_protocol";
    private static final String MSG_MISSING_ENDPOINT_HOST = "transfer_service.missing_endpoint_host";
    private static final String MSG_MISSING_ENDPOINT_PORT = "transfer_service.missing_endpoint_port";
    private static final String MSG_MISSING_ENDPOINT_USERNAME = "transfer_service.missing_endpoint_username";
    private static final String MSG_MISSING_ENDPOINT_PASSWORD = "transfer_service.missing_endpoint_password";
    private static final String MSG_FAILED_TO_GET_TRANSFER_STATUS = "transfer_service.failed_to_get_transfer_status";
    private static final String MSG_TARGET_ERROR = "transfer_service.target_error";
    private static final String MSG_UNKNOWN_TARGET_ERROR = "transfer_service.unknown_target_error";
    private static final String MSG_TARGET_NOT_ENABLED = "transfer_service.target_not_enabled";
    private static final String FILE_DIRECTORY = "transfer";
    private static final String FILE_SUFFIX = ".xml";
    private Map<String, TransferStatus> transferMonitoring = Collections.synchronizedMap(new TreeMap());
    private String transferSpaceQuery;
    private String defaultTransferGroup;
    private NodeService nodeService;
    private SearchService searchService;
    private TransferTransmitter transmitter;
    private TransactionService transactionService;
    private ActionService actionService;
    private TransferManifestNodeFactory transferManifestNodeFactory;
    private TransferReporter transferReporter;
    private TenantService tenantService;
    private DescriptorService descriptorService;
    private long commitPollDelay = 2000L;
    private Map<String, NodeRef> transferHomeMap = new ConcurrentHashMap<String, NodeRef>();

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"searchService", (Object)this.getSearchService());
        PropertyCheck.mandatory((Object)this, (String)"transferSpaceQuery", (Object)this.transferSpaceQuery);
        PropertyCheck.mandatory((Object)this, (String)"defaultTransferGroup", (Object)this.defaultTransferGroup);
        PropertyCheck.mandatory((Object)this, (String)"transmitter", (Object)this.transmitter);
        PropertyCheck.mandatory((Object)this, (String)"namespaceResolver", (Object)this.transmitter);
        PropertyCheck.mandatory((Object)this, (String)"actionService", (Object)this.actionService);
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"descriptorService", (Object)this.descriptorService);
    }

    @Override
    public TransferTarget createTransferTarget(String name) {
        NodeRef dummy = this.lookupTransferTarget(name);
        if (dummy != null) {
            throw new TransferException(MSG_TARGET_EXISTS, new Object[]{name});
        }
        TransferTargetImpl newTarget = new TransferTargetImpl();
        newTarget.setName(name);
        return newTarget;
    }

    @Override
    public TransferTarget createAndSaveTransferTarget(String name, String title, String description, String endpointProtocol, String endpointHost, int endpointPort, String endpointPath, String username, char[] password) {
        TransferTargetImpl newTarget = new TransferTargetImpl();
        newTarget.setName(name);
        newTarget.setTitle(title);
        newTarget.setDescription(description);
        newTarget.setEndpointProtocol(endpointProtocol);
        newTarget.setEndpointHost(endpointHost);
        newTarget.setEndpointPort(endpointPort);
        newTarget.setEndpointPath(endpointPath);
        newTarget.setUsername(username);
        newTarget.setPassword(password);
        return this.createTransferTarget(newTarget);
    }

    private TransferTarget createTransferTarget(TransferTarget newTarget) {
        NodeRef dummy = this.lookupTransferTarget(newTarget.getName());
        if (dummy != null) {
            throw new TransferException(MSG_TARGET_EXISTS, new Object[]{newTarget.getName()});
        }
        HashMap<QName, Object> properties = new HashMap<QName, Object>();
        properties.put(TransferModel.PROP_ENDPOINT_HOST, newTarget.getEndpointHost());
        properties.put(TransferModel.PROP_ENDPOINT_PORT, newTarget.getEndpointPort());
        properties.put(TransferModel.PROP_ENDPOINT_PROTOCOL, newTarget.getEndpointProtocol());
        properties.put(TransferModel.PROP_ENDPOINT_PATH, newTarget.getEndpointPath());
        properties.put(TransferModel.PROP_USERNAME, newTarget.getUsername());
        properties.put(TransferModel.PROP_PASSWORD, new String(this.encrypt(newTarget.getPassword())));
        properties.put(ContentModel.PROP_TITLE, newTarget.getTitle());
        properties.put(ContentModel.PROP_NAME, newTarget.getName());
        properties.put(ContentModel.PROP_DESCRIPTION, newTarget.getDescription());
        properties.put(TransferModel.PROP_ENABLED, Boolean.TRUE);
        NodeRef home = this.getTransferHome();
        NodeRef defaultGroup = this.nodeService.getChildByName(home, ContentModel.ASSOC_CONTAINS, this.defaultTransferGroup);
        ChildAssociationRef ref = this.nodeService.createNode(defaultGroup, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/transfer/1.0", (String)newTarget.getName()), TransferModel.TYPE_TRANSFER_TARGET, properties);
        TransferTargetImpl retVal = new TransferTargetImpl();
        this.mapTransferTarget(ref.getChildRef(), retVal);
        return retVal;
    }

    @Override
    public Set<TransferTarget> getTransferTargets() {
        NodeRef home = this.getTransferHome();
        HashSet<TransferTarget> ret = new HashSet<TransferTarget>();
        List groups = this.nodeService.getChildAssocs(home);
        for (ChildAssociationRef group : groups) {
            NodeRef groupNode = group.getChildRef();
            ret.addAll(this.getTransferTargets(groupNode));
        }
        return ret;
    }

    @Override
    public Set<TransferTarget> getTransferTargets(String groupName) {
        NodeRef home = this.getTransferHome();
        NodeRef groupNode = this.nodeService.getChildByName(home, ContentModel.ASSOC_CONTAINS, groupName);
        if (groupNode == null) {
            throw new TransferException(MSG_NO_GROUP, new Object[]{groupName});
        }
        return this.getTransferTargets(groupNode);
    }

    private Set<TransferTarget> getTransferTargets(NodeRef groupNode) {
        HashSet<TransferTarget> result = new HashSet<TransferTarget>();
        List children = this.nodeService.getChildAssocs(groupNode, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
        for (ChildAssociationRef child : children) {
            if (!this.nodeService.getType(child.getChildRef()).equals((Object)TransferModel.TYPE_TRANSFER_TARGET)) continue;
            TransferTargetImpl newTarget = new TransferTargetImpl();
            this.mapTransferTarget(child.getChildRef(), newTarget);
            result.add(newTarget);
        }
        return result;
    }

    @Override
    public void deleteTransferTarget(String name) {
        NodeRef nodeRef = this.lookupTransferTarget(name);
        if (nodeRef == null) {
            throw new TransferException(MSG_NO_TARGET, new Object[]{name});
        }
        this.nodeService.deleteNode(nodeRef);
    }

    @Override
    public void enableTransferTarget(String name, boolean enable) {
        NodeRef nodeRef = this.lookupTransferTarget(name);
        this.nodeService.setProperty(nodeRef, TransferModel.PROP_ENABLED, (Serializable)new Boolean(enable));
    }

    @Override
    public boolean targetExists(String name) {
        return this.lookupTransferTarget(name) != null;
    }

    @Override
    public TransferTarget getTransferTarget(String name) {
        NodeRef nodeRef = this.lookupTransferTarget(name);
        if (nodeRef == null) {
            throw new TransferException(MSG_NO_TARGET, new Object[]{name});
        }
        TransferTargetImpl newTarget = new TransferTargetImpl();
        this.mapTransferTarget(nodeRef, newTarget);
        return newTarget;
    }

    @Override
    public TransferTarget saveTransferTarget(TransferTarget update) {
        if (update.getNodeRef() == null) {
            return this.createTransferTarget(update);
        }
        NodeRef nodeRef = this.lookupTransferTarget(update.getName());
        if (nodeRef == null) {
            throw new TransferException(MSG_NO_TARGET, new Object[]{update.getName()});
        }
        HashMap<QName, Object> properties = new HashMap<QName, Object>();
        properties.put(TransferModel.PROP_ENDPOINT_HOST, update.getEndpointHost());
        properties.put(TransferModel.PROP_ENDPOINT_PORT, update.getEndpointPort());
        properties.put(TransferModel.PROP_ENDPOINT_PROTOCOL, update.getEndpointProtocol());
        properties.put(TransferModel.PROP_ENDPOINT_PATH, update.getEndpointPath());
        properties.put(TransferModel.PROP_USERNAME, update.getUsername());
        properties.put(TransferModel.PROP_PASSWORD, new String(this.encrypt(update.getPassword())));
        properties.put(ContentModel.PROP_TITLE, update.getTitle());
        properties.put(ContentModel.PROP_NAME, update.getName());
        properties.put(ContentModel.PROP_DESCRIPTION, update.getDescription());
        properties.put(TransferModel.PROP_ENABLED, new Boolean(update.isEnabled()));
        this.nodeService.setProperties(nodeRef, properties);
        TransferTargetImpl newTarget = new TransferTargetImpl();
        this.mapTransferTarget(nodeRef, newTarget);
        return newTarget;
    }

    @Override
    public void transferAsync(String targetName, TransferDefinition definition, TransferCallback ... callbacks) {
        this.transferAsync(targetName, definition, Arrays.asList(callbacks));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void transferAsync(String targetName, TransferDefinition definition, Collection<TransferCallback> callbacks) {
        TransferEventProcessor eventProcessor = new TransferEventProcessor();
        if (callbacks != null) {
            eventProcessor.observers.addAll(callbacks);
        }
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("targetName", (Serializable)((Object)targetName));
        params.put("definition", definition);
        params.put("callbacks", (Serializable)((Object)callbacks));
        Action transferAction = this.getActionService().createAction("transfer-async", params);
        boolean success = false;
        UserTransaction trx = this.transactionService.getNonPropagatingUserTransaction();
        try {
            try {
                trx.begin();
                logger.debug((Object)"calling action service to execute action");
                this.getActionService().executeAction(transferAction, null, false, true);
                trx.commit();
                logger.debug((Object)"committed successfully");
                return;
            }
            catch (Exception error) {
                logger.error((Object)"unexpected exception", (Throwable)error);
                throw new AlfrescoRuntimeException(MSG_ERR_TRANSFER_ASYNC, (Throwable)error);
            }
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            if (success) throw throwable;
            try {
                logger.debug((Object)"rolling back after error");
                trx.rollback();
                throw throwable;
            }
            catch (Exception error) {
                logger.error((Object)"unexpected exception during rollback", (Throwable)error);
            }
            throw throwable;
        }
    }

    @Override
    public TransferEndEvent transfer(String targetName, TransferDefinition definition, TransferCallback ... callbacks) throws TransferFailureException {
        return this.transfer(targetName, definition, Arrays.asList(callbacks));
    }

    @Override
    public TransferEndEvent transfer(String targetName, TransferDefinition definition, Collection<TransferCallback> callbacks) throws TransferFailureException {
        TransferEventProcessor eventProcessor = new TransferEventProcessor();
        if (callbacks != null) {
            eventProcessor.observers.addAll(callbacks);
        }
        return this.transferImpl(targetName, definition, eventProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private TransferEndEvent transferImpl(String targetName, TransferDefinition definition, TransferEventProcessor eventProcessor) throws TransferFailureException {
        block50: {
            if (TransferServiceImpl2.logger.isDebugEnabled()) {
                TransferServiceImpl2.logger.debug((Object)("transfer started to :" + targetName));
            }
            endEvent /* !! */  = null;
            failureException /* !! */  = null;
            target = null;
            transfer = null;
            transferReportEvents = new LinkedList<TransferEvent>();
            sourceReport = null;
            destinationReport = null;
            manifest = null;
            requisite = null;
            pollRetries = 0;
            pollPosition = -1;
            cancelled = false;
            reportCallback = new TransferCallback(){
                private static final long serialVersionUID = 4072579605731036522L;

                public void processEvent(TransferEvent event) {
                    transferReportEvents.add(event);
                }
            };
            eventProcessor.addObserver(reportCallback);
            clientState = ClientTransferState.Begin;
            while (clientState != ClientTransferState.Exit) {
                try {
                    switch (6.$SwitchMap$org$alfresco$repo$transfer$TransferServiceImpl2$ClientTransferState[clientState.ordinal()]) {
                        case 1: {
                            eventProcessor.start();
                            manifest = this.createManifest(definition);
                            TransferServiceImpl2.logger.debug((Object)"transfer begin");
                            target = this.getTransferTarget(targetName);
                            this.checkTargetEnabled(target);
                            transfer = this.transmitter.begin(target);
                            transferId = transfer.getTransferId();
                            status = new TransferStatus();
                            this.transferMonitoring.put(transferId, status);
                            TransferServiceImpl2.logger.debug((Object)("transfer begun transferId:" + transferId));
                            eventProcessor.begin(transferId);
                            this.checkCancel(transferId);
                            clientState = ClientTransferState.Prepare;
                            break;
                        }
                        case 2: {
                            eventProcessor.sendSnapshot(1L, 1L);
                            requisite = this.createRequisiteFile();
                            reqOutput = new FileOutputStream(requisite);
                            this.transmitter.sendManifest(transfer, manifest, reqOutput);
                            TransferServiceImpl2.logger.debug((Object)"manifest sent");
                            this.checkCancel(transfer.getTransferId());
                            if (TransferServiceImpl2.logger.isDebugEnabled()) {
                                TransferServiceImpl2.logger.debug((Object)"requisite file written to local filesystem");
                                try {
                                    TransferServiceImpl2.outputFile(requisite);
                                }
                                catch (IOException error) {
                                    TransferServiceImpl2.logger.debug((Object)"error while outputting snapshotFile");
                                    error.printStackTrace();
                                }
                            }
                            this.sendContent(transfer, definition, eventProcessor, manifest, requisite);
                            TransferServiceImpl2.logger.debug((Object)"content sending finished");
                            this.checkCancel(transfer.getTransferId());
                            eventProcessor.prepare();
                            this.transmitter.prepare(transfer);
                            this.checkCancel(transfer.getTransferId());
                            clientState = ClientTransferState.Commit;
                            break;
                        }
                        case 3: {
                            TransferServiceImpl2.logger.debug((Object)("about to start committing transferId:" + transfer.getTransferId()));
                            eventProcessor.commit();
                            this.transmitter.commit(transfer);
                            TransferServiceImpl2.logger.debug((Object)("committing transferId:" + transfer.getTransferId()));
                            this.checkCancel(transfer.getTransferId());
                            clientState = ClientTransferState.Poll;
                            break;
                        }
                        case 4: {
                            progress = null;
                            try {
                                progress = this.transmitter.getStatus(transfer);
                                pollRetries = 0;
                            }
                            catch (TransferException e) {
                                if (++pollRetries != 3) ** GOTO lbl77
                                throw new TransferException("transfer_service.failed_to_get_transfer_status", new Object[]{target.getName()});
                            }
lbl77:
                            // 2 sources

                            if (progress.getStatus() == TransferProgress.Status.ERROR) {
                                targetError = progress.getError();
                                if (targetError == null) {
                                    targetError = new TransferException("transfer_service.unknown_target_error");
                                }
                                failureException /* !! */  = Exception.class.isAssignableFrom(targetError.getClass()) != false ? (Exception)targetError : new TransferException("transfer_service.target_error", new Object[]{targetError.getMessage()}, (Throwable)targetError);
                                clientState = ClientTransferState.Finished;
                                break;
                            }
                            if (progress.getStatus() == TransferProgress.Status.CANCELLED) {
                                cancelled = true;
                                clientState = ClientTransferState.Finished;
                                break;
                            }
                            if (progress.getCurrentPosition() != pollPosition) {
                                pollPosition = progress.getCurrentPosition();
                                TransferServiceImpl2.logger.debug((Object)("committing :" + pollPosition));
                                eventProcessor.committing(progress.getEndPosition(), pollPosition);
                            }
                            if (progress.getStatus() == TransferProgress.Status.COMPLETE) {
                                clientState = ClientTransferState.Finished;
                                break;
                            }
                            this.checkCancel(transfer.getTransferId());
                            try {
                                Thread.sleep(this.commitPollDelay);
                            }
                            catch (InterruptedException e) {}
                            break;
                        }
                        case 5: {
                            TransferServiceImpl2.logger.debug((Object)"Abort - waiting for target confirmation of cancel");
                            this.transmitter.abort(transfer);
                            clientState = ClientTransferState.Poll;
                            break;
                        }
                        case 6: {
                            try {
                                endEventImpl = null;
                                reportName = null;
                                try {
                                    if (failureException /* !! */  != null) {
                                        TransferServiceImpl2.logger.debug((Object)"TransferException - unable to transfer", (Throwable)failureException /* !! */ );
                                        errorEvent = new TransferEventError();
                                        errorEvent.setTransferState(TransferEvent.TransferState.ERROR);
                                        errorEvent.setException(failureException /* !! */ );
                                        errorEvent.setMessage(failureException /* !! */ .getMessage());
                                        endEventImpl = errorEvent;
                                        reportName = "error";
                                    } else if (cancelled) {
                                        endEventImpl = new TransferEventCancelled();
                                        endEventImpl.setTransferState(TransferEvent.TransferState.CANCELLED);
                                        endEventImpl.setMessage("cancelled");
                                        reportName = "cancelled";
                                    } else {
                                        TransferServiceImpl2.logger.debug((Object)("committed transferId:" + transfer.getTransferId()));
                                        endEventImpl = new TransferEventSuccess();
                                        endEventImpl.setTransferState(TransferEvent.TransferState.SUCCESS);
                                        endEventImpl.setMessage("success");
                                        reportName = "success";
                                    }
                                    transferReportEvents.add(endEventImpl);
                                }
                                catch (Exception e) {
                                    failureException /* !! */  = e;
                                    reportName = "error";
                                    TransferServiceImpl2.logger.warn((Object)"Exception - unable to notify end transfer state", (Throwable)e);
                                }
                                reportName = reportName + "_" + new SimpleDateFormat("yyyyMMddhhmmssSSS").format(new Date());
                                try {
                                    if (transfer != null) {
                                        TransferServiceImpl2.logger.debug((Object)"now pull back the destination transfer report");
                                        destinationReport = this.persistDestinationTransferReport(reportName, transfer, target);
                                        if (destinationReport != null) {
                                            eventProcessor.writeReport(destinationReport, TransferEventReport.ReportType.DESTINATION, endEventImpl.getTransferState());
                                        }
                                    }
                                    TransferServiceImpl2.logger.debug((Object)"now persist the client side transfer report");
                                    sourceReport = this.persistTransferReport(reportName, transfer, target, definition, transferReportEvents, manifest, failureException /* !! */ );
                                    if (sourceReport != null) {
                                        eventProcessor.writeReport(sourceReport, TransferEventReport.ReportType.SOURCE, endEventImpl.getTransferState());
                                    }
                                }
                                catch (Exception e) {
                                    TransferServiceImpl2.logger.warn((Object)"Exception - unable to write transfer reports", (Throwable)e);
                                }
                                try {
                                    endEventImpl.setLast(true);
                                    endEventImpl.setSourceReport(sourceReport);
                                    endEventImpl.setDestinationReport(destinationReport);
                                    endEvent /* !! */  = endEventImpl;
                                    eventProcessor.end(endEvent /* !! */ );
                                }
                                catch (Exception e) {
                                    failureException /* !! */  = e;
                                    TransferServiceImpl2.logger.warn((Object)"Exception - unable to notify end transfer state", (Throwable)e);
                                }
                                var22_29 = null;
                                clientState = ClientTransferState.Exit;
                                break;
                            }
                            catch (Throwable var21_30) {
                                var22_29 = null;
                                clientState = ClientTransferState.Exit;
                                throw var21_30;
                            }
                        }
                    }
                }
                catch (TransferCancelledException e) {
                    TransferServiceImpl2.logger.debug((Object)"Interrupted by transfer cancel request from client");
                    clientState = ClientTransferState.Cancel;
                }
                catch (Exception e) {
                    TransferServiceImpl2.logger.debug((Object)"Exception - unable to transfer", (Throwable)e);
                    if (failureException /* !! */  == null) {
                        failureException /* !! */  = e;
                    }
                    if (transfer != null && (clientState == ClientTransferState.Begin || clientState == ClientTransferState.Prepare || clientState == ClientTransferState.Commit)) {
                        clientState = ClientTransferState.Cancel;
                        continue;
                    }
                    clientState = ClientTransferState.Finished;
                }
            }
            try {
                if (endEvent /* !! */  == null) {
                    error = new TransferEventError();
                    error.setTransferState(TransferEvent.TransferState.ERROR);
                    endException = new TransferFailureException(error);
                    error.setMessage(endException.getMessage());
                    error.setException((Exception)endException);
                    error.setSourceReport(sourceReport);
                    error.setDestinationReport(destinationReport);
                    error.setLast(true);
                    endEvent /* !! */  = error;
                }
                if (endEvent /* !! */  instanceof TransferEventError) {
                    endError = endEvent /* !! */ ;
                    throw new TransferFailureException(endError);
                }
                var18_18 = endEvent /* !! */ ;
                var24_31 = null;
                if (transfer == null) break block50;
                this.transferMonitoring.remove(transfer.getTransferId());
            }
            catch (Throwable var23_33) {
                block51: {
                    var24_32 = null;
                    if (transfer != null) {
                        this.transferMonitoring.remove(transfer.getTransferId());
                    }
                    if (manifest != null) {
                        manifest.delete();
                        TransferServiceImpl2.logger.debug((Object)"manifest file deleted");
                    }
                    if (requisite == null) break block51;
                    requisite.delete();
                    TransferServiceImpl2.logger.debug((Object)"requisite file deleted");
                }
                throw var23_33;
            }
        }
        if (manifest != null) {
            manifest.delete();
            TransferServiceImpl2.logger.debug((Object)"manifest file deleted");
        }
        if (requisite != null) {
            requisite.delete();
            TransferServiceImpl2.logger.debug((Object)"requisite file deleted");
        }
        return var18_18;
    }

    private File createManifest(TransferDefinition definition) throws IOException, SAXException {
        Set<NodeRef> nodes = definition.getNodes();
        if (nodes == null || nodes.size() == 0) {
            logger.debug((Object)"no nodes to transfer");
            throw new TransferException(MSG_NO_NODES);
        }
        logger.debug((Object)"create snapshot");
        File tempDir = TempFileProvider.getLongLifeTempDir((String)FILE_DIRECTORY);
        File snapshotFile = TempFileProvider.createTempFile((String)"TRX-SNAP", (String)FILE_SUFFIX, (File)tempDir);
        BufferedWriter snapshotWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(snapshotFile), "UTF-8"));
        XMLTransferManifestWriter formatter = new XMLTransferManifestWriter();
        TransferManifestHeader header = new TransferManifestHeader();
        Descriptor descriptor = this.descriptorService.getCurrentRepositoryDescriptor();
        header.setRepositoryId(descriptor.getId());
        header.setCreatedDate(new Date());
        header.setNodeCount(nodes.size());
        header.setSync(definition.isSync());
        header.setReadOnly(definition.isReadOnly());
        formatter.startTransferManifest(snapshotWriter);
        formatter.writeTransferManifestHeader(header);
        for (NodeRef nodeRef : nodes) {
            TransferManifestNode node = this.transferManifestNodeFactory.createTransferManifestNode(nodeRef, definition);
            formatter.writeTransferManifestNode(node);
        }
        formatter.endTransferManifest();
        ((Writer)snapshotWriter).close();
        logger.debug((Object)"snapshot file written to local filesystem");
        if (logger.isDebugEnabled()) {
            try {
                TransferServiceImpl2.outputFile(snapshotFile);
            }
            catch (IOException error) {
                logger.debug((Object)"error while outputting snapshotFile");
                error.printStackTrace();
            }
        }
        return snapshotFile;
    }

    private File createRequisiteFile() {
        File tempDir = TempFileProvider.getLongLifeTempDir((String)FILE_DIRECTORY);
        File reqFile = TempFileProvider.createTempFile((String)"TRX-REQ", (String)FILE_SUFFIX, (File)tempDir);
        return reqFile;
    }

    private void sendContent(final Transfer transfer, TransferDefinition definition, final TransferEventProcessor eventProcessor, File manifest, File requisite) throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        SAXParser parser = saxParserFactory.newSAXParser();
        DeltaListRequsiteProcessor reqProcessor = new DeltaListRequsiteProcessor();
        XMLTransferRequsiteReader reqReader = new XMLTransferRequsiteReader(reqProcessor);
        parser.parse(requisite, (DefaultHandler)reqReader);
        final DeltaList deltaList = reqProcessor.getDeltaList();
        final ContentChunkerImpl chunker = new ContentChunkerImpl();
        final Long fRange = definition.getNodes().size();
        chunker.setHandler(new ContentChunkProcessor(){
            private long counter = 0L;

            @Override
            public void processChunk(Set<ContentData> data) {
                TransferServiceImpl2.this.checkCancel(transfer.getTransferId());
                logger.debug((Object)"send chunk to transmitter");
                for (ContentData file : data) {
                    ++this.counter;
                    eventProcessor.sendContent(file, fRange, this.counter);
                }
                TransferServiceImpl2.this.transmitter.sendContent(transfer, data);
            }
        });
        TransferManifestProcessor processor = new TransferManifestProcessor(){

            public void processTransferManifestNode(TransferManifestNormalNode node) {
                Set<ContentData> data = TransferManifestNodeHelper.getContentData(node);
                for (ContentData d : data) {
                    TransferServiceImpl2.this.checkCancel(transfer.getTransferId());
                    logger.debug((Object)"add content to chunker");
                    if (deltaList != null) {
                        String partName = TransferCommons.URLToPartName(d.getContentUrl());
                        if (!deltaList.getRequiredParts().contains(partName)) continue;
                        logger.debug((Object)("content is required :" + d.getContentUrl()));
                        chunker.addContent(d);
                        continue;
                    }
                    chunker.addContent(d);
                }
            }

            public void processTransferManifiestHeader(TransferManifestHeader header) {
            }

            public void startTransferManifest() {
            }

            public void endTransferManifest() {
            }

            public void processTransferManifestNode(TransferManifestDeletedNode node) {
            }
        };
        XMLTransferManifestReader reader = new XMLTransferManifestReader(processor);
        parser.parse(manifest, (DefaultHandler)reader);
        chunker.flush();
    }

    @Override
    public void cancelAsync(String transferHandle) {
        TransferStatus status = this.transferMonitoring.get(transferHandle);
        if (status != null) {
            logger.debug((Object)("canceling transfer :" + transferHandle));
            status.cancelMe = true;
        }
    }

    private void checkCancel(String transferHandle) throws TransferException {
        TransferStatus status = this.transferMonitoring.get(transferHandle);
        if (status != null && !status.cancelInProgress && status.cancelMe) {
            status.cancelInProgress = true;
            throw new TransferCancelledException();
        }
    }

    private void checkTargetEnabled(TransferTarget target) throws TransferException {
        if (!target.isEnabled()) {
            logger.debug((Object)"target is not enabled");
            throw new TransferException(MSG_TARGET_NOT_ENABLED, new Object[]{target.getName()});
        }
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public SearchService getSearchService() {
        return this.searchService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setTransferSpaceQuery(String transferSpaceQuery) {
        this.transferSpaceQuery = transferSpaceQuery;
    }

    public String getTransferSpaceQuery() {
        return this.transferSpaceQuery;
    }

    public void setDefaultTransferGroup(String defaultGroup) {
        this.defaultTransferGroup = defaultGroup;
    }

    public String getDefaultTransferGroup() {
        return this.defaultTransferGroup;
    }

    public TransferTransmitter getTransmitter() {
        return this.transmitter;
    }

    public void setTransmitter(TransferTransmitter transmitter) {
        this.transmitter = transmitter;
    }

    protected NodeRef getTransferHome() {
        String tenantDomain = this.tenantService.getUserDomain(AuthenticationUtil.getRunAsUser());
        NodeRef transferHome = this.transferHomeMap.get(tenantDomain);
        if (transferHome == null) {
            String query = this.transferSpaceQuery;
            ResultSet result = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", query);
            if (result.length() == 0) {
                throw new TransferException(MSG_NO_HOME, new Object[]{query});
            }
            if (result.getNodeRefs().size() != 0) {
                transferHome = result.getNodeRef(0);
                this.transferHomeMap.put(tenantDomain, transferHome);
            }
        }
        return transferHome;
    }

    private char[] encrypt(char[] text) {
        return text;
    }

    private char[] decrypt(char[] text) {
        return text;
    }

    private NodeRef lookupTransferTarget(String name) {
        String query = "+TYPE:\"trx:transferTarget\" +@cm\\:name:\"" + name + "\"";
        ResultSet result = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "lucene", query);
        if (result.length() == 1) {
            return result.getNodeRef(0);
        }
        return null;
    }

    private void mapTransferTarget(NodeRef nodeRef, TransferTargetImpl def) {
        def.setNodeRef(nodeRef);
        Map properties = this.nodeService.getProperties(nodeRef);
        String name = (String)properties.get(ContentModel.PROP_NAME);
        String endpointPath = (String)properties.get(TransferModel.PROP_ENDPOINT_PATH);
        if (endpointPath == null) {
            throw new TransferException(MSG_MISSING_ENDPOINT_PATH, new Object[]{name});
        }
        def.setEndpointPath(endpointPath);
        String endpointProtocol = (String)properties.get(TransferModel.PROP_ENDPOINT_PROTOCOL);
        if (endpointProtocol == null) {
            throw new TransferException(MSG_MISSING_ENDPOINT_PROTOCOL, new Object[]{name});
        }
        def.setEndpointProtocol(endpointProtocol);
        String endpointHost = (String)properties.get(TransferModel.PROP_ENDPOINT_HOST);
        if (endpointHost == null) {
            throw new TransferException(MSG_MISSING_ENDPOINT_HOST, new Object[]{name});
        }
        def.setEndpointHost(endpointHost);
        Integer endpointPort = (Integer)properties.get(TransferModel.PROP_ENDPOINT_PORT);
        if (endpointPort == null) {
            throw new TransferException(MSG_MISSING_ENDPOINT_PORT, new Object[]{name});
        }
        def.setEndpointPort(endpointPort);
        String username = (String)properties.get(TransferModel.PROP_USERNAME);
        if (username == null) {
            throw new TransferException(MSG_MISSING_ENDPOINT_USERNAME, new Object[]{name});
        }
        def.setUsername(username);
        Serializable passwordVal = (Serializable)properties.get(TransferModel.PROP_PASSWORD);
        if (passwordVal == null) {
            throw new TransferException(MSG_MISSING_ENDPOINT_PASSWORD, new Object[]{name});
        }
        if (passwordVal.getClass().isArray()) {
            def.setPassword(this.decrypt((char[])passwordVal));
        }
        if (passwordVal instanceof String) {
            String password = (String)((Object)passwordVal);
            def.setPassword(this.decrypt(password.toCharArray()));
        }
        def.setName(name);
        def.setTitle((String)properties.get(ContentModel.PROP_TITLE));
        def.setDescription((String)properties.get(ContentModel.PROP_DESCRIPTION));
        if (this.nodeService.hasAspect(nodeRef, TransferModel.ASPECT_ENABLEABLE)) {
            def.setEnabled((Boolean)properties.get(TransferModel.PROP_ENABLED));
        } else {
            def.setEnabled(Boolean.TRUE);
        }
    }

    @Override
    public void verify(TransferTarget target) throws TransferException {
        this.transmitter.verifyTarget(target);
    }

    private static void outputFile(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        String s = reader.readLine();
        while (s != null) {
            System.out.println(s);
            s = reader.readLine();
        }
    }

    private NodeRef persistTransferReport(final String transferName, final Transfer transfer, final TransferTarget target, final TransferDefinition definition, final List<TransferEvent> events, final File snapshotFile, final Exception exception) {
        NodeRef reportNode = this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                logger.debug((Object)"transfer report starting");
                NodeRef reportNode = null;
                reportNode = exception != null ? TransferServiceImpl2.this.transferReporter.createTransferReport(transferName, exception, target, definition, (List<TransferEvent>)events, snapshotFile) : TransferServiceImpl2.this.transferReporter.createTransferReport(transferName, transfer, target, definition, (List<TransferEvent>)events, snapshotFile);
                logger.debug((Object)"transfer report done");
                return reportNode;
            }
        }, false, true);
        return reportNode;
    }

    private NodeRef persistDestinationTransferReport(final String transferName, final Transfer transfer, final TransferTarget target) {
        NodeRef reportNode = this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                try {
                    File tempDir = TempFileProvider.getLongLifeTempDir((String)TransferServiceImpl2.FILE_DIRECTORY);
                    File destReportFile = TempFileProvider.createTempFile((String)"TRX-DREP", (String)TransferServiceImpl2.FILE_SUFFIX, (File)tempDir);
                    FileOutputStream destReportOutput = new FileOutputStream(destReportFile);
                    TransferServiceImpl2.this.transmitter.getTransferReport(transfer, destReportOutput);
                    logger.debug((Object)"transfer report (destination) starting");
                    NodeRef reportNode = TransferServiceImpl2.this.transferReporter.writeDestinationReport(transferName, target, destReportFile);
                    logger.debug((Object)"transfer report (destination) done");
                    if (destReportFile != null) {
                        destReportFile.delete();
                    }
                    logger.debug((Object)"destination report temp file deleted");
                    return reportNode;
                }
                catch (FileNotFoundException ie) {
                    logger.debug((Object)"unexpected error while obtaining destination transfer report", (Throwable)ie);
                    return null;
                }
                catch (TransferException ie) {
                    logger.debug((Object)"unexpected error while obtaining destination transfer report", (Throwable)((Object)ie));
                    return null;
                }
            }
        }, false, true);
        return reportNode;
    }

    public void setTransferManifestNodeFactory(TransferManifestNodeFactory transferManifestNodeFactory) {
        this.transferManifestNodeFactory = transferManifestNodeFactory;
    }

    public TransferManifestNodeFactory getTransferManifestNodeFactory() {
        return this.transferManifestNodeFactory;
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public ActionService getActionService() {
        return this.actionService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public TransactionService getTransactionService() {
        return this.transactionService;
    }

    public void setTransferReporter(TransferReporter transferReporter) {
        this.transferReporter = transferReporter;
    }

    public TransferReporter getTransferReporter() {
        return this.transferReporter;
    }

    public void setCommitPollDelay(long commitPollDelay) {
        this.commitPollDelay = commitPollDelay;
    }

    public long getCommitPollDelay() {
        return this.commitPollDelay;
    }

    public void setDescriptorService(DescriptorService descriptorService) {
        this.descriptorService = descriptorService;
    }

    public DescriptorService getDescriptorService() {
        return this.descriptorService;
    }

    static class 6 {
        static final /* synthetic */ int[] $SwitchMap$org$alfresco$repo$transfer$TransferServiceImpl2$ClientTransferState;

        static {
            $SwitchMap$org$alfresco$repo$transfer$TransferServiceImpl2$ClientTransferState = new int[ClientTransferState.values().length];
            try {
                6.$SwitchMap$org$alfresco$repo$transfer$TransferServiceImpl2$ClientTransferState[ClientTransferState.Begin.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                6.$SwitchMap$org$alfresco$repo$transfer$TransferServiceImpl2$ClientTransferState[ClientTransferState.Prepare.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                6.$SwitchMap$org$alfresco$repo$transfer$TransferServiceImpl2$ClientTransferState[ClientTransferState.Commit.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                6.$SwitchMap$org$alfresco$repo$transfer$TransferServiceImpl2$ClientTransferState[ClientTransferState.Poll.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                6.$SwitchMap$org$alfresco$repo$transfer$TransferServiceImpl2$ClientTransferState[ClientTransferState.Cancel.ordinal()] = 5;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                6.$SwitchMap$org$alfresco$repo$transfer$TransferServiceImpl2$ClientTransferState[ClientTransferState.Finished.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    private class TransferStatus {
        boolean cancelMe = false;
        boolean cancelInProgress = false;

        private TransferStatus() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ClientTransferState {
        Begin,
        Prepare,
        Commit,
        Poll,
        Cancel,
        Finished,
        Exit;

    }
}

