/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.transaction.UserTransaction;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import junit.framework.Assert;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transfer.PathHelper;
import org.alfresco.repo.transfer.TestTransferCallback;
import org.alfresco.repo.transfer.TransferModel;
import org.alfresco.repo.transfer.TransferServiceImpl2;
import org.alfresco.repo.transfer.UnitTestInProcessTransmitterImpl;
import org.alfresco.repo.transfer.UnitTestTransferManifestNodeFactory;
import org.alfresco.repo.transfer.manifest.TransferManifestNodeFactory;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.transfer.TransferCallback;
import org.alfresco.service.cmr.transfer.TransferDefinition;
import org.alfresco.service.cmr.transfer.TransferEvent;
import org.alfresco.service.cmr.transfer.TransferEventBegin;
import org.alfresco.service.cmr.transfer.TransferEventReport;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferReceiver;
import org.alfresco.service.cmr.transfer.TransferService;
import org.alfresco.service.cmr.transfer.TransferTarget;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.TempFileProvider;
import org.mockito.Mockito;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.ResourceUtils;

public class TransferServiceImplTest
extends BaseAlfrescoSpringTest {
    private TransferService transferService;
    private ContentService contentService;
    private TransferServiceImpl2 transferServiceImpl;
    private SearchService searchService;
    private TransactionService transactionService;
    private TransferReceiver receiver;
    private TransferManifestNodeFactory transferManifestNodeFactory;
    private PermissionService permissionService;
    private LockService lockService;
    private PersonService personService;
    private DescriptorService descriptorService;
    private CopyService copyService;
    String COMPANY_HOME_XPATH_QUERY = "/{http://www.alfresco.org/model/application/1.0}company_home";
    String GUEST_HOME_XPATH_QUERY = "/{http://www.alfresco.org/model/application/1.0}company_home/{http://www.alfresco.org/model/application/1.0}guest_home";
    String REPO_ID_A = "RepoIdA";
    String REPO_ID_B;
    String REPO_ID_C = "RepoIdC";

    public void runBare() throws Throwable {
        this.preventTransaction();
        super.runBare();
    }

    protected void onSetUp() throws Exception {
        super.onSetUp();
        this.transferService = (TransferService)this.applicationContext.getBean("TransferService");
        this.contentService = (ContentService)this.applicationContext.getBean("ContentService");
        this.transferServiceImpl = (TransferServiceImpl2)this.applicationContext.getBean("transferService2");
        this.searchService = (SearchService)this.applicationContext.getBean("SearchService");
        this.transactionService = (TransactionService)this.applicationContext.getBean("TransactionService");
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("authenticationService");
        this.actionService = (ActionService)this.applicationContext.getBean("actionService");
        this.permissionService = (PermissionService)this.applicationContext.getBean("permissionService");
        this.receiver = (TransferReceiver)this.applicationContext.getBean("transferReceiver");
        this.transferManifestNodeFactory = (TransferManifestNodeFactory)this.applicationContext.getBean("transferManifestNodeFactory");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.lockService = (LockService)this.applicationContext.getBean("lockService");
        this.personService = (PersonService)this.applicationContext.getBean("PersonService");
        this.descriptorService = (DescriptorService)this.applicationContext.getBean("DescriptorService");
        this.copyService = (CopyService)this.applicationContext.getBean("CopyService");
        this.REPO_ID_B = this.descriptorService.getCurrentRepositoryDescriptor().getId();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.setTransactionDefinition((TransactionDefinition)new DefaultTransactionDefinition(3));
        TransferServiceImplTest.assertNotNull((String)"receiver is null", (Object)this.receiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCreateTarget() throws Exception {
        String name = "name";
        String title = "title";
        String description = "description";
        String endpointProtocol = "http";
        String endpointHost = "localhost";
        int endpointPort = 8080;
        String endpointPath = "rhubarb";
        String username = "admin";
        char[] password = "password".toCharArray();
        this.startNewTransaction();
        try {
            try {
                TransferTarget ret = this.transferService.createAndSaveTransferTarget(name, title, description, endpointProtocol, endpointHost, endpointPort, endpointPath, username, password);
                TransferServiceImplTest.assertNotNull((String)"return value is null", (Object)ret);
                TransferServiceImplTest.assertNotNull((String)"node ref is null", (Object)ret.getNodeRef());
                TransferServiceImplTest.assertEquals((String)"name not equal", (String)ret.getName(), (String)name);
                TransferServiceImplTest.assertEquals((String)"title not equal", (String)ret.getTitle(), (String)title);
                TransferServiceImplTest.assertEquals((String)"description not equal", (String)ret.getDescription(), (String)description);
                TransferServiceImplTest.assertEquals((String)"endpointProtocol not equal", (String)ret.getEndpointProtocol(), (String)endpointProtocol);
                TransferServiceImplTest.assertEquals((String)"endpointHost not equal", (String)ret.getEndpointHost(), (String)endpointHost);
                TransferServiceImplTest.assertEquals((String)"endpointPort not equal", (int)ret.getEndpointPort(), (int)endpointPort);
                TransferServiceImplTest.assertEquals((String)"endpointPath not equal", (String)ret.getEndpointPath(), (String)endpointPath);
                TransferServiceImplTest.assertEquals((String)"username not equal", (String)ret.getUsername(), (String)username);
                char[] password2 = ret.getPassword();
                TransferServiceImplTest.assertEquals((int)password.length, (int)password2.length);
                for (int i = 0; i < password.length; ++i) {
                    if (password[i] == password2[i]) continue;
                    TransferServiceImplTest.fail((String)("password not equal:" + new String(password) + new String(password2)));
                }
                this.transferService.createAndSaveTransferTarget(name, title, description, endpointProtocol, endpointHost, endpointPort, endpointPath, username, password);
                TransferServiceImplTest.fail((String)"duplicate name not detected");
            }
            catch (TransferException e) {
                Object var14_15 = null;
                this.endTransaction();
                return;
            }
            Object var14_14 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCreateTargetSyntax2() throws Exception {
        String name = "nameSyntax2";
        String title = "title";
        String description = "description";
        String endpointProtocol = "http";
        String endpointHost = "localhost";
        int endpointPort = 8080;
        String endpointPath = "rhubarb";
        String username = "admin";
        char[] password = "password".toCharArray();
        this.startNewTransaction();
        try {
            try {
                TransferTarget newValue = this.transferService.createTransferTarget(name);
                newValue.setDescription(description);
                newValue.setEndpointHost(endpointHost);
                newValue.setEndpointPort(endpointPort);
                newValue.setEndpointPath(endpointPath);
                newValue.setEndpointProtocol(endpointProtocol);
                newValue.setPassword(password);
                newValue.setTitle(title);
                newValue.setUsername(username);
                TransferTarget ret = this.transferService.saveTransferTarget(newValue);
                TransferServiceImplTest.assertNotNull((String)"return value is null", (Object)ret);
                TransferServiceImplTest.assertNotNull((String)"node ref is null", (Object)ret.getNodeRef());
                TransferServiceImplTest.assertEquals((String)"name not equal", (String)ret.getName(), (String)name);
                TransferServiceImplTest.assertEquals((String)"title not equal", (String)ret.getTitle(), (String)title);
                TransferServiceImplTest.assertEquals((String)"description not equal", (String)ret.getDescription(), (String)description);
                TransferServiceImplTest.assertEquals((String)"endpointProtocol not equal", (String)ret.getEndpointProtocol(), (String)endpointProtocol);
                TransferServiceImplTest.assertEquals((String)"endpointHost not equal", (String)ret.getEndpointHost(), (String)endpointHost);
                TransferServiceImplTest.assertEquals((String)"endpointPort not equal", (int)ret.getEndpointPort(), (int)endpointPort);
                TransferServiceImplTest.assertEquals((String)"endpointPath not equal", (String)ret.getEndpointPath(), (String)endpointPath);
                TransferServiceImplTest.assertEquals((String)"username not equal", (String)ret.getUsername(), (String)username);
                char[] password2 = ret.getPassword();
                TransferServiceImplTest.assertEquals((int)password.length, (int)password2.length);
                for (int i = 0; i < password.length; ++i) {
                    if (password[i] == password2[i]) continue;
                    TransferServiceImplTest.fail((String)("password not equal:" + new String(password) + new String(password2)));
                }
                this.transferService.createAndSaveTransferTarget(name, title, description, endpointProtocol, endpointHost, endpointPort, endpointPath, username, password);
                TransferServiceImplTest.fail((String)"duplicate name not detected");
            }
            catch (TransferException e) {
                Object var15_16 = null;
                this.endTransaction();
                return;
            }
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetTransferTargets() throws Exception {
        String nameA = "nameA";
        String nameB = "nameB";
        String title = "title";
        String description = "description";
        String endpointProtocol = "http";
        String endpointHost = "localhost";
        int endpointPort = 8080;
        String endpointPath = "rhubarb";
        String username = "admin";
        char[] password = "password".toCharArray();
        this.startNewTransaction();
        try {
            TransferTarget targetA = this.transferService.createAndSaveTransferTarget(nameA, title, description, endpointProtocol, endpointHost, endpointPort, endpointPath, username, password);
            TransferTarget targetB = this.transferService.createAndSaveTransferTarget(nameB, title, description, endpointProtocol, endpointHost, endpointPort, endpointPath, username, password);
            Set<TransferTarget> targets = this.transferService.getTransferTargets();
            TransferServiceImplTest.assertTrue((String)"targets is empty", (targets.size() > 0 ? 1 : 0) != 0);
            TransferServiceImplTest.assertTrue((String)"didn't find target A", (boolean)targets.contains(targetA));
            TransferServiceImplTest.assertTrue((String)"didn't find target B", (boolean)targets.contains(targetB));
            for (TransferTarget target : targets) {
                System.out.println("found target: " + target.getName());
            }
            Object var17_16 = null;
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testGetAllTransferTargetsByGroup() throws Exception {
        String getMe = "getMe";
        String title = "title";
        String description = "description";
        String endpointProtocol = "http";
        String endpointHost = "localhost";
        int endpointPort = 8080;
        String endpointPath = "rhubarb";
        String username = "admin";
        char[] password = "password".toCharArray();
        this.startNewTransaction();
        try {
            try {
                this.transferService.createAndSaveTransferTarget(getMe, title, description, endpointProtocol, endpointHost, endpointPort, endpointPath, username, password);
                Set<TransferTarget> targets = this.transferService.getTransferTargets("Default Group");
                TransferServiceImplTest.assertTrue((String)"targets is empty", (targets.size() > 0 ? 1 : 0) != 0);
                targets = this.transferService.getTransferTargets("Rubbish");
                TransferServiceImplTest.assertTrue((String)"targets is empty", (targets.size() > 0 ? 1 : 0) != 0);
                TransferServiceImplTest.fail((String)"group does not exist");
            }
            catch (TransferException te) {
                Object var12_13 = null;
                this.endTransaction();
                return;
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateTransferTarget() throws Exception {
        this.startNewTransaction();
        try {
            String updateMe = "updateMe";
            String title = "title";
            String description = "description";
            String endpointProtocol = "http";
            String endpointHost = "localhost";
            int endpointPort = 8080;
            String endpointPath = "rhubarb";
            String username = "admin";
            char[] password = "password".toCharArray();
            TransferTarget target = this.transferService.createAndSaveTransferTarget(updateMe, title, description, endpointProtocol, endpointHost, endpointPort, endpointPath, username, password);
            TransferTarget update1 = this.transferService.saveTransferTarget(target);
            TransferServiceImplTest.assertNotNull((String)"return value is null", (Object)update1);
            TransferServiceImplTest.assertNotNull((String)"node ref is null", (Object)update1.getNodeRef());
            TransferServiceImplTest.assertEquals((String)"name not equal", (String)update1.getName(), (String)updateMe);
            TransferServiceImplTest.assertEquals((String)"title not equal", (String)update1.getTitle(), (String)title);
            TransferServiceImplTest.assertEquals((String)"description not equal", (String)update1.getDescription(), (String)description);
            TransferServiceImplTest.assertEquals((String)"endpointProtocol not equal", (String)update1.getEndpointProtocol(), (String)endpointProtocol);
            TransferServiceImplTest.assertEquals((String)"endpointHost not equal", (String)update1.getEndpointHost(), (String)endpointHost);
            TransferServiceImplTest.assertEquals((String)"endpointPort not equal", (int)update1.getEndpointPort(), (int)endpointPort);
            TransferServiceImplTest.assertEquals((String)"endpointPath not equal", (String)update1.getEndpointPath(), (String)endpointPath);
            TransferServiceImplTest.assertEquals((String)"username not equal", (String)update1.getUsername(), (String)username);
            char[] pass = update1.getPassword();
            TransferServiceImplTest.assertEquals((int)password.length, (int)pass.length);
            for (int i = 0; i < password.length; ++i) {
                if (password[i] == pass[i]) continue;
                TransferServiceImplTest.fail((String)("password not equal:" + new String(password) + new String(pass)));
            }
            String title2 = "Two";
            String description2 = "descriptionTwo";
            String endpointProtocol2 = "https";
            String endpointHost2 = "1.0.0.127";
            int endpointPort2 = 4040;
            String endpointPath2 = "custard";
            String username2 = "admin_two";
            char[] password2 = "two".toCharArray();
            target.setDescription(description2);
            target.setTitle(title2);
            target.setEndpointHost(endpointHost2);
            target.setEndpointPath(endpointPath2);
            target.setEndpointPort(endpointPort2);
            target.setEndpointProtocol(endpointProtocol2);
            target.setPassword(password2);
            target.setUsername(username2);
            TransferTarget update2 = this.transferService.saveTransferTarget(target);
            TransferServiceImplTest.assertNotNull((String)"return value is null", (Object)update2);
            TransferServiceImplTest.assertNotNull((String)"node ref is null", (Object)update2.getNodeRef());
            TransferServiceImplTest.assertEquals((String)"name not equal", (String)update2.getName(), (String)updateMe);
            TransferServiceImplTest.assertEquals((String)"title not equal", (String)update2.getTitle(), (String)title2);
            TransferServiceImplTest.assertEquals((String)"description not equal", (String)update2.getDescription(), (String)description2);
            TransferServiceImplTest.assertEquals((String)"endpointProtocol not equal", (String)update2.getEndpointProtocol(), (String)endpointProtocol2);
            TransferServiceImplTest.assertEquals((String)"endpointHost not equal", (String)update2.getEndpointHost(), (String)endpointHost2);
            TransferServiceImplTest.assertEquals((String)"endpointPort not equal", (int)update2.getEndpointPort(), (int)endpointPort2);
            TransferServiceImplTest.assertEquals((String)"endpointPath not equal", (String)update2.getEndpointPath(), (String)endpointPath2);
            TransferServiceImplTest.assertEquals((String)"username not equal", (String)update2.getUsername(), (String)username2);
            pass = update2.getPassword();
            TransferServiceImplTest.assertEquals((int)password2.length, (int)pass.length);
            for (int i = 0; i < pass.length; ++i) {
                if (pass[i] == password2[i]) continue;
                TransferServiceImplTest.fail((String)("password not equal:" + new String(pass) + new String(password2)));
            }
            Object var24_24 = null;
        }
        catch (Throwable throwable) {
            Object var24_25 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteTransferTarget() throws Exception {
        this.startNewTransaction();
        try {
            String deleteMe = "deleteMe";
            String title = "title";
            String description = "description";
            String endpointProtocol = "http";
            String endpointHost = "localhost";
            int endpointPort = 8080;
            String endpointPath = "rhubarb";
            String username = "admin";
            char[] password = "password".toCharArray();
            this.transferService.createAndSaveTransferTarget(deleteMe, title, description, endpointProtocol, endpointHost, endpointPort, endpointPath, username, password);
            this.transferService.deleteTransferTarget(deleteMe);
            try {
                this.transferService.deleteTransferTarget(deleteMe);
                TransferServiceImplTest.fail((String)"duplicate name not detected");
            }
            catch (TransferException e) {
                // empty catch block
            }
            try {
                this.transferService.deleteTransferTarget("rubbish");
                TransferServiceImplTest.fail((String)"rubbish deleted");
            }
            catch (TransferException e) {
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnableTransferTarget() throws Exception {
        this.startNewTransaction();
        try {
            String targetName = "enableMe";
            TransferTarget enableMe = this.createTransferTarget(targetName);
            try {
                TransferTarget target = this.transferService.getTransferTarget(targetName);
                TransferServiceImplTest.assertTrue((String)"new target is not enabled", (boolean)enableMe.isEnabled());
                this.transferService.enableTransferTarget(targetName, false);
                target = this.transferService.getTransferTarget(targetName);
                TransferServiceImplTest.assertFalse((String)"target is not disabled", (boolean)target.isEnabled());
                this.transferService.enableTransferTarget(targetName, true);
                target = this.transferService.getTransferTarget(targetName);
                TransferServiceImplTest.assertTrue((String)"re-enabled target is not enabled", (boolean)target.isEnabled());
                Object var5_4 = null;
                this.transferService.deleteTransferTarget(targetName);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.transferService.deleteTransferTarget(targetName);
                throw throwable;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransferOneNode() throws Exception {
        HashSet<Object> nodes;
        TransferDefinition definition;
        String contentStr;
        ContentReader reader;
        ContentWriter writer;
        Date srcCreatedDate;
        Date destCreatedDate;
        Date srcModifiedDate;
        Date destModifiedDate;
        NodeRef destNodeRef;
        HashSet<Object> nodes2;
        TransferDefinition definition2;
        TransferTarget transferMe;
        NodeRef contentNodeRef;
        this.setDefaultRollback(false);
        String CONTENT_TITLE = "ContentTitle";
        String CONTENT_TITLE_UPDATED = "ContentTitleUpdated";
        Locale CONTENT_LOCALE = Locale.GERMAN;
        String CONTENT_STRING = "Hello World";
        String CONTENT_UPDATE_STRING = "Foo Bar";
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter(transmitter);
        UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory(testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)PathHelper.stringToPath(this.GUEST_HOME_XPATH_QUERY), (Object)PathHelper.stringToPath(this.COMPANY_HOME_XPATH_QUERY)));
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        String targetName = "testTransferOneNode";
        this.startNewTransaction();
        try {
            String guestHomeQuery = "/app:company_home/app:guest_home";
            ResultSet guestHomeResult = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", guestHomeQuery);
            TransferServiceImplTest.assertEquals((String)"", (int)1, (int)guestHomeResult.length());
            NodeRef guestHome = guestHomeResult.getNodeRef(0);
            String name = GUID.generate();
            ChildAssociationRef child = this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_CONTENT);
            contentNodeRef = child.getChildRef();
            this.nodeService.setProperty(contentNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(contentNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
            transferMe = !this.transferService.targetExists(targetName) ? this.createTransferTarget(targetName) : this.transferService.getTransferTarget(targetName);
            this.transferService.enableTransferTarget(targetName, true);
            Object var20_20 = null;
        }
        catch (Throwable throwable) {
            Object var20_21 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.logger.debug((Object)"First transfer - create new node (no content yet)");
        this.startNewTransaction();
        try {
            definition2 = new TransferDefinition();
            nodes2 = new HashSet<NodeRef>();
            nodes2.add(contentNodeRef);
            definition2.setNodes(nodes2);
            this.transferService.transfer(targetName, definition2);
            Object var22_23 = null;
        }
        catch (Throwable throwable) {
            Object var22_24 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            destNodeRef = testNodeFactory.getMappedNodeRef(contentNodeRef);
            TransferServiceImplTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)destNodeRef.equals((Object)transferMe.getNodeRef()));
            TransferServiceImplTest.assertTrue((String)"dest node ref does not exist", (boolean)this.nodeService.exists(destNodeRef));
            TransferServiceImplTest.assertEquals((String)"title is wrong", (String)((String)((Object)this.nodeService.getProperty(destNodeRef, ContentModel.PROP_TITLE))), (String)CONTENT_TITLE);
            TransferServiceImplTest.assertEquals((String)"type is wrong", (Object)this.nodeService.getType(contentNodeRef), (Object)this.nodeService.getType(destNodeRef));
            destModifiedDate = (Date)this.nodeService.getProperty(destNodeRef, ContentModel.PROP_MODIFIED);
            srcModifiedDate = (Date)this.nodeService.getProperty(contentNodeRef, ContentModel.PROP_MODIFIED);
            this.logger.debug((Object)("srcModifiedDate : " + srcModifiedDate + " destModifiedDate : " + destModifiedDate));
            TransferServiceImplTest.assertTrue((String)"dest modified date is not correct", (destModifiedDate.compareTo(srcModifiedDate) == 0 ? 1 : 0) != 0);
            destCreatedDate = (Date)this.nodeService.getProperty(destNodeRef, ContentModel.PROP_CREATED);
            srcCreatedDate = (Date)this.nodeService.getProperty(contentNodeRef, ContentModel.PROP_CREATED);
            this.logger.debug((Object)("srcCreatedDate : " + srcCreatedDate + " destCreatedDate : " + destCreatedDate));
            TransferServiceImplTest.assertTrue((String)"dest created date is not correct", (destCreatedDate.compareTo(srcCreatedDate) == 0 ? 1 : 0) != 0);
            TransferServiceImplTest.assertNotNull((String)"transferredAspect", (Object)((String)((Object)this.nodeService.getProperty(destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
            this.nodeService.setProperty(contentNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE_UPDATED));
            Object var24_27 = null;
        }
        catch (Throwable throwable) {
            Object var24_28 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.logger.debug((Object)"Second transfer - update title property (no content yet)");
        this.startNewTransaction();
        try {
            definition2 = new TransferDefinition();
            nodes2 = new HashSet();
            nodes2.add(contentNodeRef);
            definition2.setNodes(nodes2);
            this.transferService.transfer(targetName, definition2);
            Object var26_30 = null;
        }
        catch (Throwable throwable) {
            Object var26_31 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferServiceImplTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)destNodeRef.equals((Object)transferMe.getNodeRef()));
            TransferServiceImplTest.assertTrue((String)"dest node ref does not exist", (boolean)this.nodeService.exists(destNodeRef));
            TransferServiceImplTest.assertEquals((String)"title is wrong", (String)((String)((Object)this.nodeService.getProperty(destNodeRef, ContentModel.PROP_TITLE))), (String)CONTENT_TITLE_UPDATED);
            TransferServiceImplTest.assertEquals((String)"type is wrong", (Object)this.nodeService.getType(contentNodeRef), (Object)this.nodeService.getType(destNodeRef));
            destModifiedDate = (Date)this.nodeService.getProperty(destNodeRef, ContentModel.PROP_MODIFIED);
            srcModifiedDate = (Date)this.nodeService.getProperty(contentNodeRef, ContentModel.PROP_MODIFIED);
            this.logger.debug((Object)("srcModifiedDate : " + srcModifiedDate + " destModifiedDate : " + destModifiedDate));
            TransferServiceImplTest.assertTrue((String)"after update, modified date is not correct", (destModifiedDate.compareTo(srcModifiedDate) == 0 ? 1 : 0) != 0);
            destCreatedDate = (Date)this.nodeService.getProperty(destNodeRef, ContentModel.PROP_CREATED);
            srcCreatedDate = (Date)this.nodeService.getProperty(contentNodeRef, ContentModel.PROP_CREATED);
            this.logger.debug((Object)("srcCreatedDate : " + srcCreatedDate + " destCreatedDate : " + destCreatedDate));
            TransferServiceImplTest.assertTrue((String)"after update, created date is not correct", (destCreatedDate.compareTo(srcCreatedDate) == 0 ? 1 : 0) != 0);
            TransferServiceImplTest.assertNotNull((String)"transferredAspect", (Object)((String)((Object)this.nodeService.getProperty(destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
            Object var28_33 = null;
        }
        catch (Throwable throwable) {
            Object var28_34 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            writer = this.contentService.getWriter(contentNodeRef, ContentModel.PROP_CONTENT, true);
            writer.setLocale(CONTENT_LOCALE);
            writer.putContent(CONTENT_STRING);
            Object var30_36 = null;
        }
        catch (Throwable throwable) {
            Object var30_37 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.logger.debug((Object)"Transfer again - this is an update to add new content");
        this.startNewTransaction();
        try {
            definition2 = new TransferDefinition();
            nodes2 = new HashSet();
            nodes2.add(contentNodeRef);
            definition2.setNodes(nodes2);
            this.transferService.transfer(targetName, definition2);
            Object var32_39 = null;
        }
        catch (Throwable throwable) {
            Object var32_40 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            reader = this.contentService.getReader(destNodeRef, ContentModel.PROP_CONTENT);
            TransferServiceImplTest.assertNotNull((String)"reader is null", (Object)reader);
            contentStr = reader.getContentString();
            TransferServiceImplTest.assertEquals((String)"Content is wrong", (String)contentStr, (String)CONTENT_STRING);
            Object var34_42 = null;
        }
        catch (Throwable throwable) {
            Object var34_43 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.logger.debug((Object)"Transfer again - with no new content");
        this.startNewTransaction();
        try {
            definition2 = new TransferDefinition();
            nodes2 = new HashSet();
            nodes2.add(contentNodeRef);
            definition2.setNodes(nodes2);
            this.transferService.transfer(targetName, definition2);
            Object var36_45 = null;
        }
        catch (Throwable throwable) {
            Object var36_46 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferServiceImplTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)destNodeRef.equals((Object)transferMe.getNodeRef()));
            TransferServiceImplTest.assertTrue((String)"dest node ref does not exist", (boolean)this.nodeService.exists(destNodeRef));
            TransferServiceImplTest.assertEquals((String)"title is wrong", (String)((String)((Object)this.nodeService.getProperty(destNodeRef, ContentModel.PROP_TITLE))), (String)CONTENT_TITLE_UPDATED);
            TransferServiceImplTest.assertEquals((String)"type is wrong", (Object)this.nodeService.getType(contentNodeRef), (Object)this.nodeService.getType(destNodeRef));
            reader = this.contentService.getReader(destNodeRef, ContentModel.PROP_CONTENT);
            TransferServiceImplTest.assertNotNull((String)"reader is null", (Object)reader);
            contentStr = reader.getContentString();
            TransferServiceImplTest.assertEquals((String)"Content is wrong", (String)contentStr, (String)CONTENT_STRING);
            TransferServiceImplTest.assertNotNull((String)"transferredAspect", (Object)((String)((Object)this.nodeService.getProperty(destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
            Object var38_48 = null;
        }
        catch (Throwable throwable) {
            Object var38_49 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            writer = this.contentService.getWriter(contentNodeRef, ContentModel.PROP_CONTENT, true);
            writer.setLocale(CONTENT_LOCALE);
            writer.putContent(CONTENT_UPDATE_STRING);
            Object var40_51 = null;
        }
        catch (Throwable throwable) {
            Object var40_52 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.logger.debug((Object)"Transfer again - this is an update to add new content");
        this.startNewTransaction();
        try {
            definition2 = new TransferDefinition();
            nodes2 = new HashSet();
            nodes2.add(contentNodeRef);
            definition2.setNodes(nodes2);
            this.transferService.transfer(targetName, definition2);
            Object var42_54 = null;
        }
        catch (Throwable throwable) {
            Object var42_55 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            reader = this.contentService.getReader(destNodeRef, ContentModel.PROP_CONTENT);
            TransferServiceImplTest.assertNotNull((String)"reader is null", (Object)reader);
            contentStr = reader.getContentString();
            TransferServiceImplTest.assertEquals((String)"Content is wrong", (String)CONTENT_UPDATE_STRING, (String)contentStr);
            Object var44_57 = null;
        }
        catch (Throwable throwable) {
            Object var44_58 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.logger.debug((Object)"Transfer again - to delete a node through transferring an archive node");
        this.startNewTransaction();
        try {
            this.nodeService.deleteNode(contentNodeRef);
            Object var46_60 = null;
        }
        catch (Throwable throwable) {
            Object var46_61 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        NodeRef deletedContentNodeRef = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, contentNodeRef.getId());
        this.startNewTransaction();
        try {
            definition = new TransferDefinition();
            nodes = new HashSet<NodeRef>();
            nodes.add(deletedContentNodeRef);
            definition.setNodes(nodes);
            this.transferService.transfer(targetName, definition);
            Object var48_63 = null;
        }
        catch (Throwable throwable) {
            Object var48_64 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferServiceImplTest.assertFalse((String)"dest node still exists", (boolean)this.nodeService.exists(destNodeRef));
            Object var50_66 = null;
        }
        catch (Throwable throwable) {
            Object var50_67 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.logger.debug((Object)"Transfer again - with no content - should throw exception");
        try {
            definition = new TransferDefinition();
            this.transferService.transfer(targetName, definition);
            TransferServiceImplTest.fail((String)"exception not thrown");
        }
        catch (TransferException te) {
            // empty catch block
        }
        this.logger.debug((Object)"Transfer again - with no content - should throw exception");
        try {
            this.transferService.enableTransferTarget(targetName, false);
            definition = new TransferDefinition();
            nodes = new HashSet();
            nodes.add(deletedContentNodeRef);
            definition.setNodes(nodes);
            this.transferService.transfer(targetName, definition);
            TransferServiceImplTest.fail((String)"target not enabled exception not thrown");
        }
        catch (TransferException te) {
            TransferServiceImplTest.assertTrue((String)"check contents of exception message", (boolean)te.getCause().getMessage().contains("enabled"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoveNode() throws Exception {
        ChildAssociationRef destParent;
        NodeRef destParentNodeRef;
        NodeRef destNodeRef;
        HashSet<Object> nodes;
        TransferDefinition definition;
        NodeRef moveToNodeRef;
        NodeRef contentNodeRef;
        NodeRef parentNodeRef;
        this.setDefaultRollback(false);
        String CONTENT_TITLE = "ContentTitle";
        String CONTENT_TITLE_UPDATED = "ContentTitleUpdated";
        Locale CONTENT_LOCALE = Locale.GERMAN;
        String CONTENT_STRING = "Hello";
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter(transmitter);
        UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory(testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)PathHelper.stringToPath(this.GUEST_HOME_XPATH_QUERY), (Object)PathHelper.stringToPath(this.COMPANY_HOME_XPATH_QUERY)));
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        String targetName = "testTransferMoveNode";
        this.startNewTransaction();
        try {
            String guestHomeQuery = "/app:company_home/app:guest_home";
            ResultSet guestHomeResult = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", guestHomeQuery);
            TransferServiceImplTest.assertEquals((String)"", (int)1, (int)guestHomeResult.length());
            NodeRef guestHome = guestHomeResult.getNodeRef(0);
            String name = GUID.generate();
            ChildAssociationRef newParent = this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_FOLDER);
            parentNodeRef = newParent.getChildRef();
            this.nodeService.setProperty(parentNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(parentNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
            ChildAssociationRef child = this.nodeService.createNode(parentNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"TransferOneNode"), ContentModel.TYPE_CONTENT);
            contentNodeRef = child.getChildRef();
            this.nodeService.setProperty(contentNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(contentNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"TransferOneNode"));
            ChildAssociationRef moveTo = this.nodeService.createNode(parentNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"moveTo"), ContentModel.TYPE_FOLDER);
            moveToNodeRef = moveTo.getChildRef();
            this.nodeService.setProperty(moveToNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(moveToNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"moveTo"));
            if (!this.transferService.targetExists(targetName)) {
                TransferTarget transferMe = this.createTransferTarget(targetName);
            } else {
                TransferTarget transferMe = this.transferService.getTransferTarget(targetName);
            }
            this.transferService.enableTransferTarget(targetName, true);
            Object var23_22 = null;
        }
        catch (Throwable throwable) {
            Object var23_23 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.logger.debug((Object)"First transfer - create new node (no content yet)");
        this.startNewTransaction();
        try {
            definition = new TransferDefinition();
            nodes = new HashSet<NodeRef>();
            nodes.add(parentNodeRef);
            nodes.add(contentNodeRef);
            nodes.add(moveToNodeRef);
            definition.setNodes(nodes);
            this.transferService.transfer(targetName, definition);
            Object var25_25 = null;
        }
        catch (Throwable throwable) {
            Object var25_26 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            destNodeRef = testNodeFactory.getMappedNodeRef(contentNodeRef);
            destParentNodeRef = testNodeFactory.getMappedNodeRef(parentNodeRef);
            destParent = this.nodeService.getPrimaryParent(destNodeRef);
            TransferServiceImplTest.assertEquals((String)"parent node ref not correct prior to test", (Object)destParentNodeRef, (Object)destParent.getParentRef());
            Object var27_29 = null;
        }
        catch (Throwable throwable) {
            Object var27_30 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.logger.debug((Object)"Transfer again with moved node");
        this.startNewTransaction();
        try {
            this.nodeService.moveNode(contentNodeRef, moveToNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"testOneNode"));
            Object var29_32 = null;
        }
        catch (Throwable throwable) {
            Object var29_33 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            definition = new TransferDefinition();
            nodes = new HashSet();
            nodes.add(contentNodeRef);
            definition.setNodes(nodes);
            this.transferService.transfer(targetName, definition);
            Object var31_35 = null;
        }
        catch (Throwable throwable) {
            Object var31_36 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            destNodeRef = testNodeFactory.getMappedNodeRef(contentNodeRef);
            destParentNodeRef = testNodeFactory.getMappedNodeRef(moveToNodeRef);
            destParent = this.nodeService.getPrimaryParent(destNodeRef);
            TransferServiceImplTest.assertEquals((String)"node not moved", (Object)destParentNodeRef, (Object)destParent.getParentRef());
            Object var33_38 = null;
        }
        catch (Throwable throwable) {
            Object var33_39 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testManyNodes() throws Exception {
        TransferTarget transferMe;
        NodeRef nodeABC;
        NodeRef nodeABB;
        NodeRef nodeABA;
        NodeRef nodeAB;
        NodeRef nodeAA;
        NodeRef nodeB;
        NodeRef nodeA;
        ChildAssociationRef child;
        this.setDefaultRollback(false);
        String CONTENT_TITLE = "ContentTitle";
        String CONTENT_TITLE_UPDATED = "ContentTitleUpdated";
        String CONTENT_NAME = "Demo Node 1";
        Locale CONTENT_LOCALE = Locale.GERMAN;
        String CONTENT_STRING = "The quick brown fox";
        HashSet<NodeRef> nodes = new HashSet<NodeRef>();
        String targetName = "testManyNodes";
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter(transmitter);
        UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory(testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)PathHelper.stringToPath(this.GUEST_HOME_XPATH_QUERY), (Object)PathHelper.stringToPath(this.COMPANY_HOME_XPATH_QUERY)));
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        this.startNewTransaction();
        try {
            String guestHomeQuery = "/app:company_home/app:guest_home";
            ResultSet guestHomeResult = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", guestHomeQuery);
            TransferServiceImplTest.assertEquals((String)"", (int)1, (int)guestHomeResult.length());
            NodeRef guestHome = guestHomeResult.getNodeRef(0);
            String guid = GUID.generate();
            child = this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)guid), ContentModel.TYPE_FOLDER);
            NodeRef testRootNode = child.getChildRef();
            this.nodeService.setProperty(testRootNode, ContentModel.PROP_TITLE, (Serializable)((Object)guid));
            this.nodeService.setProperty(testRootNode, ContentModel.PROP_NAME, (Serializable)((Object)guid));
            nodes.add(testRootNode);
            child = this.nodeService.createNode(testRootNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"testNodeAC"), ContentModel.TYPE_CONTENT);
            NodeRef nodeAC = child.getChildRef();
            this.nodeService.setProperty(nodeAC, ContentModel.PROP_TITLE, (Serializable)((Object)(CONTENT_TITLE + "AC")));
            this.nodeService.setProperty(nodeAC, ContentModel.PROP_NAME, (Serializable)((Object)"DemoNodeAC"));
            ContentWriter writer = this.contentService.getWriter(nodeAC, ContentModel.PROP_CONTENT, true);
            writer.setLocale(CONTENT_LOCALE);
            writer.putContent(CONTENT_STRING);
            nodes.add(nodeAC);
            child = this.nodeService.createNode(testRootNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testNodeA"), ContentModel.TYPE_FOLDER);
            nodeA = child.getChildRef();
            this.nodeService.setProperty(nodeA, ContentModel.PROP_TITLE, (Serializable)((Object)"TestNodeA"));
            this.nodeService.setProperty(nodeA, ContentModel.PROP_NAME, (Serializable)((Object)"TestNodeA"));
            nodes.add(nodeA);
            child = this.nodeService.createNode(testRootNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testNodeB"), ContentModel.TYPE_FOLDER);
            nodeB = child.getChildRef();
            this.nodeService.setProperty(nodeB, ContentModel.PROP_TITLE, (Serializable)((Object)"TestNodeB"));
            this.nodeService.setProperty(nodeB, ContentModel.PROP_NAME, (Serializable)((Object)"TestNodeB"));
            nodes.add(nodeB);
            child = this.nodeService.createNode(nodeA, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testNodeAA"), ContentModel.TYPE_FOLDER);
            nodeAA = child.getChildRef();
            this.nodeService.setProperty(nodeAA, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(nodeAA, ContentModel.PROP_NAME, (Serializable)((Object)"DemoNodeAA"));
            nodes.add(nodeAA);
            child = this.nodeService.createNode(nodeA, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testNodeAB"), ContentModel.TYPE_FOLDER);
            nodeAB = child.getChildRef();
            this.nodeService.setProperty(nodeAB, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(nodeAB, ContentModel.PROP_NAME, (Serializable)((Object)"DemoNodeAB"));
            nodes.add(nodeAB);
            child = this.nodeService.createNode(nodeAB, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testNodeABA"), ContentModel.TYPE_FOLDER);
            nodeABA = child.getChildRef();
            this.nodeService.setProperty(nodeABA, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(nodeABA, ContentModel.PROP_NAME, (Serializable)((Object)"DemoNodeABA"));
            nodes.add(nodeABA);
            child = this.nodeService.createNode(nodeAB, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testNodeABB"), ContentModel.TYPE_FOLDER);
            nodeABB = child.getChildRef();
            this.nodeService.setProperty(nodeABB, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(nodeABB, ContentModel.PROP_NAME, (Serializable)((Object)"DemoNodeABB"));
            nodes.add(nodeABB);
            child = this.nodeService.createNode(nodeAB, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testNodeABC"), ContentModel.TYPE_FOLDER);
            nodeABC = child.getChildRef();
            this.nodeService.setProperty(nodeABC, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(nodeABC, ContentModel.PROP_NAME, (Serializable)((Object)"DemoNodeABC"));
            nodes.add(nodeABC);
            transferMe = !this.transferService.targetExists(targetName) ? this.createTransferTarget(targetName) : this.transferService.getTransferTarget(targetName);
            Object var29_28 = null;
        }
        catch (Throwable throwable) {
            Object var29_29 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferDefinition definition = new TransferDefinition();
            definition.setNodes(nodes);
            this.transferService.transfer(targetName, definition);
            Object var31_34 = null;
        }
        catch (Throwable throwable) {
            Object var31_35 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            NodeRef destNodeA = testNodeFactory.getMappedNodeRef(nodeA);
            TransferServiceImplTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)destNodeA.equals((Object)transferMe.getNodeRef()));
            TransferServiceImplTest.assertTrue((String)"dest node ref A does not exist", (boolean)this.nodeService.exists(destNodeA));
            TransferServiceImplTest.assertEquals((String)"title is wrong", (String)((String)((Object)this.nodeService.getProperty(destNodeA, ContentModel.PROP_TITLE))), (String)"TestNodeA");
            TransferServiceImplTest.assertEquals((String)"type is wrong", (Object)this.nodeService.getType(nodeA), (Object)this.nodeService.getType(destNodeA));
            NodeRef destNodeB = testNodeFactory.getMappedNodeRef(nodeB);
            TransferServiceImplTest.assertTrue((String)"dest node B does not exist", (boolean)this.nodeService.exists(destNodeB));
            NodeRef destNodeAA = testNodeFactory.getMappedNodeRef(nodeAA);
            TransferServiceImplTest.assertTrue((String)"dest node AA ref does not exist", (boolean)this.nodeService.exists(destNodeAA));
            NodeRef destNodeAB = testNodeFactory.getMappedNodeRef(nodeAB);
            TransferServiceImplTest.assertTrue((String)"dest node AB ref does not exist", (boolean)this.nodeService.exists(destNodeAB));
            NodeRef destNodeABA = testNodeFactory.getMappedNodeRef(nodeABA);
            TransferServiceImplTest.assertTrue((String)"dest node ABA ref does not exist", (boolean)this.nodeService.exists(destNodeABA));
            NodeRef destNodeABB = testNodeFactory.getMappedNodeRef(nodeABB);
            TransferServiceImplTest.assertTrue((String)"dest node ABB ref does not exist", (boolean)this.nodeService.exists(destNodeABB));
            NodeRef destNodeABC = testNodeFactory.getMappedNodeRef(nodeABC);
            TransferServiceImplTest.assertTrue((String)"dest node ABC ref does not exist", (boolean)this.nodeService.exists(destNodeABC));
            Object var33_38 = null;
        }
        catch (Throwable throwable) {
            Object var33_39 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            this.nodeService.setProperty(nodeAB, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE_UPDATED));
            TransferDefinition definition = new TransferDefinition();
            HashSet<NodeRef> toUpdate = new HashSet<NodeRef>();
            toUpdate.add(nodeAB);
            definition.setNodes(toUpdate);
            this.transferService.transfer(targetName, definition);
            Object var35_41 = null;
        }
        catch (Throwable throwable) {
            Object var35_42 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            for (int i = 0; i < 100; ++i) {
                child = this.nodeService.createNode(nodeABA, ContentModel.ASSOC_CONTAINS, QName.createQName((String)(GUID.generate() + i)), ContentModel.TYPE_CONTENT);
                NodeRef nodeX = child.getChildRef();
                this.nodeService.setProperty(nodeX, ContentModel.PROP_TITLE, (Serializable)((Object)(CONTENT_TITLE + i)));
                this.nodeService.setProperty(nodeX, ContentModel.PROP_NAME, (Serializable)((Object)(CONTENT_NAME + i)));
                nodes.add(nodeX);
                ContentWriter writer = this.contentService.getWriter(nodeX, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent(CONTENT_STRING + i);
            }
            Object var37_44 = null;
        }
        catch (Throwable throwable) {
            Object var37_45 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferDefinition definition = new TransferDefinition();
            definition.setNodes(nodes);
            this.transferService.transfer(targetName, definition);
            Object var39_47 = null;
            this.transferService.deleteTransferTarget(targetName);
        }
        catch (Throwable throwable) {
            Object var39_48 = null;
            this.transferService.deleteTransferTarget(targetName);
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPathBasedUpdate() throws Exception {
        NodeRef newContentNodeRef;
        NodeRef contentNodeRef;
        ChildAssociationRef child;
        NodeRef guestHome;
        this.setDefaultRollback(false);
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter(transmitter);
        UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory(testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)PathHelper.stringToPath(this.GUEST_HOME_XPATH_QUERY), (Object)PathHelper.stringToPath(this.COMPANY_HOME_XPATH_QUERY)));
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        String CONTENT_TITLE = "ContentTitle";
        String CONTENT_TITLE_UPDATED = "ContentTitleUpdated";
        String CONTENT_NAME = GUID.generate();
        Locale CONTENT_LOCALE = Locale.GERMAN;
        String CONTENT_STRING = "Hello";
        String targetName = GUID.generate();
        QName TEST_QNAME = QName.createQName((String)CONTENT_NAME);
        this.startNewTransaction();
        try {
            String guestHomeQuery = "/app:company_home/app:guest_home";
            ResultSet guestHomeResult = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", guestHomeQuery);
            TransferServiceImplTest.assertEquals((String)"", (int)1, (int)guestHomeResult.length());
            guestHome = guestHomeResult.getNodeRef(0);
            child = this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, TEST_QNAME, ContentModel.TYPE_CONTENT);
            contentNodeRef = child.getChildRef();
            this.nodeService.setProperty(contentNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(contentNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)CONTENT_NAME));
            ContentWriter writer = this.contentService.getWriter(contentNodeRef, ContentModel.PROP_CONTENT, true);
            writer.setLocale(CONTENT_LOCALE);
            writer.putContent(CONTENT_STRING);
            if (!this.transferService.targetExists(targetName)) {
                this.createTransferTarget(targetName);
            } else {
                this.transferService.getTransferTarget(targetName);
            }
            Object var20_18 = null;
        }
        catch (Throwable throwable) {
            Object var20_19 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferDefinition definition = new TransferDefinition();
            HashSet<NodeRef> nodes = new HashSet<NodeRef>();
            nodes.add(contentNodeRef);
            definition.setNodes(nodes);
            this.transferService.transfer(targetName, definition);
            Object var22_21 = null;
        }
        catch (Throwable throwable) {
            Object var22_22 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            NodeRef destNodeRef = testNodeFactory.getMappedNodeRef(contentNodeRef);
            TransferServiceImplTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)destNodeRef.equals((Object)contentNodeRef));
            TransferServiceImplTest.assertTrue((String)"dest node ref does not exist", (boolean)this.nodeService.exists(destNodeRef));
            TransferServiceImplTest.assertEquals((String)"title is wrong", (String)((String)((Object)this.nodeService.getProperty(destNodeRef, ContentModel.PROP_TITLE))), (String)CONTENT_TITLE);
            TransferServiceImplTest.assertEquals((String)"type is wrong", (Object)this.nodeService.getType(contentNodeRef), (Object)this.nodeService.getType(destNodeRef));
            this.nodeService.deleteNode(contentNodeRef);
            child = this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, TEST_QNAME, ContentModel.TYPE_CONTENT);
            newContentNodeRef = child.getChildRef();
            this.nodeService.setProperty(newContentNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE_UPDATED));
            TransferDefinition definition = new TransferDefinition();
            HashSet<NodeRef> nodes = new HashSet<NodeRef>();
            nodes.add(newContentNodeRef);
            definition.setNodes(nodes);
            this.transferService.transfer(targetName, definition);
            Object var24_25 = null;
        }
        catch (Throwable throwable) {
            Object var24_26 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            NodeRef oldDestNodeRef = testNodeFactory.getMappedNodeRef(contentNodeRef);
            NodeRef newDestNodeRef = testNodeFactory.getMappedNodeRef(newContentNodeRef);
            TransferServiceImplTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)oldDestNodeRef.equals((Object)newDestNodeRef));
            TransferServiceImplTest.assertFalse((String)"new dest node ref exists", (boolean)this.nodeService.exists(newDestNodeRef));
            TransferServiceImplTest.assertTrue((String)"old dest node does not exists", (boolean)this.nodeService.exists(oldDestNodeRef));
            TransferServiceImplTest.assertEquals((String)"title is wrong", (String)((String)((Object)this.nodeService.getProperty(oldDestNodeRef, ContentModel.PROP_TITLE))), (String)CONTENT_TITLE_UPDATED);
            Object var26_28 = null;
        }
        catch (Throwable throwable) {
            Object var26_29 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    public void testAsyncCallback() throws Exception {
        int MAX_SLEEPS = 5;
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        UnitTestTransferManifestNodeFactory testNodeFactory = this.unitTestKludgeToTransferGuestHomeToCompanyHome();
        String CONTENT_TITLE = "ContentTitle";
        String CONTENT_NAME_A = "Demo Node A";
        String CONTENT_NAME_B = "Demo Node B";
        final Locale CONTENT_LOCALE = Locale.GERMAN;
        String CONTENT_STRING = "Hello";
        String targetName = "testAsyncCallback";
        class TestContext {
            TransferTarget transferMe;
            NodeRef nodeRefA = null;
            NodeRef nodeRefB = null;

            TestContext() {
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<TestContext> setupCB = new RetryingTransactionHelper.RetryingTransactionCallback<TestContext>(){

            @Override
            public TestContext execute() throws Throwable {
                ContentWriter writer;
                ChildAssociationRef child;
                TestContext ctx = new TestContext();
                String guestHomeQuery = "/app:company_home/app:guest_home";
                ResultSet guestHomeResult = TransferServiceImplTest.this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", guestHomeQuery);
                Assert.assertEquals((String)"", (int)1, (int)guestHomeResult.length());
                NodeRef guestHome = guestHomeResult.getNodeRef(0);
                ctx.nodeRefA = TransferServiceImplTest.this.nodeService.getChildByName(guestHome, ContentModel.ASSOC_CONTAINS, "Demo Node A");
                if (ctx.nodeRefA == null) {
                    child = TransferServiceImplTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)GUID.generate()), ContentModel.TYPE_CONTENT);
                    ctx.nodeRefA = child.getChildRef();
                    TransferServiceImplTest.this.nodeService.setProperty(ctx.nodeRefA, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                    TransferServiceImplTest.this.nodeService.setProperty(ctx.nodeRefA, ContentModel.PROP_NAME, (Serializable)((Object)"Demo Node A"));
                    writer = TransferServiceImplTest.this.contentService.getWriter(ctx.nodeRefA, ContentModel.PROP_CONTENT, true);
                    writer.setLocale(CONTENT_LOCALE);
                    writer.putContent("Hello");
                }
                ctx.nodeRefB = TransferServiceImplTest.this.nodeService.getChildByName(guestHome, ContentModel.ASSOC_CONTAINS, "Demo Node B");
                if (ctx.nodeRefB == null) {
                    child = TransferServiceImplTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)GUID.generate()), ContentModel.TYPE_CONTENT);
                    ctx.nodeRefB = child.getChildRef();
                    TransferServiceImplTest.this.nodeService.setProperty(ctx.nodeRefB, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                    TransferServiceImplTest.this.nodeService.setProperty(ctx.nodeRefB, ContentModel.PROP_NAME, (Serializable)((Object)"Demo Node B"));
                    writer = TransferServiceImplTest.this.contentService.getWriter(ctx.nodeRefB, ContentModel.PROP_CONTENT, true);
                    writer.setLocale(CONTENT_LOCALE);
                    writer.putContent("Hello");
                }
                if (!TransferServiceImplTest.this.transferService.targetExists("testAsyncCallback")) {
                    TransferServiceImplTest.this.createTransferTarget("testAsyncCallback");
                } else {
                    TransferServiceImplTest.this.transferService.getTransferTarget("testAsyncCallback");
                }
                return ctx;
            }
        };
        final TestContext testContext = tran.doInTransaction(setupCB);
        RetryingTransactionHelper.RetryingTransactionCallback<List<TransferEvent>> transferCB = new RetryingTransactionHelper.RetryingTransactionCallback<List<TransferEvent>>(){
            {
            }

            @Override
            public List<TransferEvent> execute() throws Throwable {
                ArrayList<TransferEvent> transferReport = new ArrayList<TransferEvent>(50);
                TestTransferCallback callback = new TestTransferCallback();
                HashSet<TransferCallback> callbacks = new HashSet<TransferCallback>();
                callbacks.add(callback);
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testContext.nodeRefA);
                nodes.add(testContext.nodeRefB);
                definition.setNodes(nodes);
                TransferServiceImplTest.this.transferService.transferAsync("testAsyncCallback", definition, callbacks);
                TransferServiceImplTest.this.logger.debug((Object)"transfer async has returned");
                Queue<TransferEvent> events = callback.getEvents();
                int sleepCount = 5;
                boolean ended = false;
                TransferEvent event = events.poll();
                while (!ended) {
                    TransferServiceImplTest.this.logger.debug((Object)("polling loop:" + sleepCount));
                    while (event != null) {
                        sleepCount = 5;
                        TransferServiceImplTest.this.logger.debug((Object)("Got an event" + event.toString()));
                        transferReport.add(event);
                        if (event.isLast()) {
                            TransferServiceImplTest.this.logger.debug((Object)"got last event");
                            ended = true;
                        }
                        event = events.poll();
                    }
                    if (event != null || ended) continue;
                    if (sleepCount <= 0) {
                        Assert.fail((String)"timed out without receiving last event");
                        ended = true;
                    } else if (sleepCount-- > 0) {
                        Thread.sleep(5000L);
                    }
                    event = events.poll();
                }
                return transferReport;
            }
        };
        List<TransferEvent> transferReport = tran.doInTransaction(transferCB);
        TransferServiceImplTest.assertTrue((String)"transfer report is too small", (transferReport.size() > 2 ? 1 : 0) != 0);
        TransferServiceImplTest.assertTrue((String)"transfer report does not start with START", (boolean)transferReport.get(0).getTransferState().equals((Object)TransferEvent.TransferState.START));
        boolean success = false;
        for (TransferEvent event : transferReport) {
            if (event.getTransferState() != TransferEvent.TransferState.SUCCESS) continue;
            success = true;
        }
        TransferServiceImplTest.assertTrue((String)"transfer report does not contain SUCCESS", (boolean)success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAsyncCancel() throws Exception {
        int MAX_SLEEPS = 5;
        String guestHomeQuery = "/app:company_home/app:guest_home";
        ResultSet guestHomeResult = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", guestHomeQuery);
        TransferServiceImplTest.assertEquals((String)"", (int)1, (int)guestHomeResult.length());
        NodeRef guestHome = guestHomeResult.getNodeRef(0);
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter(transmitter);
        UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory(testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)PathHelper.stringToPath(this.GUEST_HOME_XPATH_QUERY), (Object)PathHelper.stringToPath(this.COMPANY_HOME_XPATH_QUERY)));
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        String CONTENT_TITLE = "ContentTitle";
        String CONTENT_NAME_A = "Demo Node A";
        String CONTENT_NAME_B = "Demo Node B";
        Locale CONTENT_LOCALE = Locale.GERMAN;
        String CONTENT_STRING = "Hello";
        NodeRef nodeRefA = null;
        NodeRef nodeRefB = null;
        String targetName = "testAsyncCallback";
        UserTransaction trx = this.transactionService.getNonPropagatingUserTransaction();
        trx.begin();
        try {
            ContentWriter writer;
            ChildAssociationRef child;
            nodeRefA = this.nodeService.getChildByName(guestHome, ContentModel.ASSOC_CONTAINS, CONTENT_NAME_A);
            if (nodeRefA == null) {
                child = this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)GUID.generate()), ContentModel.TYPE_CONTENT);
                nodeRefA = child.getChildRef();
                this.nodeService.setProperty(nodeRefA, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
                this.nodeService.setProperty(nodeRefA, ContentModel.PROP_NAME, (Serializable)((Object)CONTENT_NAME_A));
                writer = this.contentService.getWriter(nodeRefA, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent(CONTENT_STRING);
            }
            if ((nodeRefB = this.nodeService.getChildByName(guestHome, ContentModel.ASSOC_CONTAINS, CONTENT_NAME_B)) == null) {
                child = this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)GUID.generate()), ContentModel.TYPE_CONTENT);
                nodeRefB = child.getChildRef();
                this.nodeService.setProperty(nodeRefB, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
                this.nodeService.setProperty(nodeRefB, ContentModel.PROP_NAME, (Serializable)((Object)CONTENT_NAME_B));
                writer = this.contentService.getWriter(nodeRefB, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent(CONTENT_STRING);
            }
            if (!this.transferService.targetExists(targetName)) {
                this.createTransferTarget(targetName);
            } else {
                this.transferService.getTransferTarget(targetName);
            }
            Object var21_20 = null;
        }
        catch (Throwable throwable) {
            Object var21_21 = null;
            int status = trx.getStatus();
            trx.commit();
            throw throwable;
        }
        int status = trx.getStatus();
        trx.commit();
        ArrayList<TransferEvent> transferReport = new ArrayList<TransferEvent>(50);
        this.startNewTransaction();
        try {
            TransferCallback poison = new TransferCallback(){
                String transferId = null;

                public void processEvent(TransferEvent event) {
                    TransferServiceImplTest.this.logger.debug((Object)event.toString());
                    if (event instanceof TransferEventBegin) {
                        TransferEventBegin beginEvent = (TransferEventBegin)event;
                        this.transferId = beginEvent.getTransferId();
                        TransferServiceImplTest.this.transferService.cancelAsync(this.transferId);
                    }
                }
            };
            TestTransferCallback callback = new TestTransferCallback();
            HashSet<TransferCallback> callbacks = new HashSet<TransferCallback>();
            callbacks.add(callback);
            callbacks.add(poison);
            TransferDefinition definition = new TransferDefinition();
            HashSet<NodeRef> nodes = new HashSet<NodeRef>();
            nodes.add(nodeRefA);
            nodes.add(nodeRefB);
            definition.setNodes(nodes);
            this.transferService.transferAsync(targetName, definition, callbacks);
            this.logger.debug((Object)"transfer async has returned");
            Queue<TransferEvent> events = callback.getEvents();
            int sleepCount = MAX_SLEEPS;
            boolean ended = false;
            TransferEvent event = events.poll();
            while (!ended) {
                this.logger.debug((Object)("polling loop:" + sleepCount));
                while (event != null) {
                    sleepCount = MAX_SLEEPS;
                    this.logger.debug((Object)("Got an event" + event.toString()));
                    transferReport.add(event);
                    if (event.isLast()) {
                        this.logger.debug((Object)"got last event");
                        ended = true;
                    }
                    event = events.poll();
                }
                if (event != null || ended) continue;
                if (sleepCount <= 0) {
                    TransferServiceImplTest.fail((String)"timed out without receiving last event");
                    ended = true;
                } else if (sleepCount-- > 0) {
                    Thread.sleep(5000L);
                }
                event = events.poll();
            }
            TransferServiceImplTest.assertTrue((String)"transfer report is too small", (transferReport.size() > 3 ? 1 : 0) != 0);
            TransferServiceImplTest.assertTrue((String)"transfer report does not start with START", (boolean)((TransferEvent)transferReport.get(0)).getTransferState().equals((Object)TransferEvent.TransferState.START));
            TransferServiceImplTest.assertTrue((String)"transfer report does not end with CANCELLED", (boolean)((TransferEvent)transferReport.get(transferReport.size() - 1)).getTransferState().equals((Object)TransferEvent.TransferState.CANCELLED));
            Object var28_31 = null;
            this.transferService.deleteTransferTarget(targetName);
        }
        catch (Throwable throwable) {
            Object var28_32 = null;
            this.transferService.deleteTransferTarget(targetName);
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransferReport() throws Exception {
        Validator validator;
        Schema schema;
        String TRANSFER_REPORT_SCHEMA_LOCATION;
        SchemaFactory sf;
        Validator validator2;
        SchemaFactory sf2;
        StreamSource transferReportSource;
        String name;
        ContentReader reader;
        TransferEventReport reportEvent;
        HashSet<Object> nodes;
        TransferDefinition definition;
        HashSet<TransferCallback> callbacks;
        TestTransferCallback callback;
        this.setDefaultRollback(false);
        String guestHomeQuery = "/app:company_home/app:guest_home";
        ResultSet guestHomeResult = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", guestHomeQuery);
        TransferServiceImplTest.assertEquals((String)"", (int)1, (int)guestHomeResult.length());
        NodeRef guestHome = guestHomeResult.getNodeRef(0);
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter(transmitter);
        UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory(testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)PathHelper.stringToPath(this.GUEST_HOME_XPATH_QUERY), (Object)PathHelper.stringToPath(this.COMPANY_HOME_XPATH_QUERY)));
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        String CONTENT_TITLE = "ContentTitle";
        String CONTENT_NAME_A = "Report Node A";
        String CONTENT_NAME_B = "Report Node B";
        Locale CONTENT_LOCALE = Locale.GERMAN;
        String CONTENT_STRING = "Hello";
        NodeRef nodeRefA = null;
        NodeRef nodeRefB = null;
        NodeRef testFolder = null;
        String targetName = "testTransferReport";
        this.startNewTransaction();
        try {
            String name2 = GUID.generate();
            ChildAssociationRef child = this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name2), ContentModel.TYPE_FOLDER);
            testFolder = child.getChildRef();
            this.nodeService.setProperty(testFolder, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(testFolder, ContentModel.PROP_NAME, (Serializable)((Object)name2));
            ChildAssociationRef child2 = this.nodeService.createNode(testFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)GUID.generate()), ContentModel.TYPE_CONTENT);
            nodeRefA = child2.getChildRef();
            this.nodeService.setProperty(nodeRefA, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(nodeRefA, ContentModel.PROP_NAME, (Serializable)((Object)CONTENT_NAME_A));
            ContentWriter writer = this.contentService.getWriter(nodeRefA, ContentModel.PROP_CONTENT, true);
            writer.setLocale(CONTENT_LOCALE);
            writer.putContent(CONTENT_STRING);
            child2 = this.nodeService.createNode(testFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)GUID.generate()), ContentModel.TYPE_CONTENT);
            nodeRefB = child2.getChildRef();
            this.nodeService.setProperty(nodeRefB, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(nodeRefB, ContentModel.PROP_NAME, (Serializable)((Object)CONTENT_NAME_B));
            writer = this.contentService.getWriter(nodeRefB, ContentModel.PROP_CONTENT, true);
            writer.setLocale(CONTENT_LOCALE);
            writer.putContent(CONTENT_STRING);
            if (!this.transferService.targetExists(targetName)) {
                this.createTransferTarget(targetName);
            }
            Object var20_19 = null;
        }
        catch (Throwable throwable) {
            Object var20_20 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        NodeRef transferReport = null;
        NodeRef transferDestReport = null;
        this.setDefaultRollback(true);
        this.startNewTransaction();
        try {
            callback = new TestTransferCallback();
            callbacks = new HashSet<TransferCallback>();
            callbacks.add(callback);
            definition = new TransferDefinition();
            nodes = new HashSet<NodeRef>();
            nodes.add(nodeRefA);
            nodes.add(nodeRefB);
            definition.setNodes(nodes);
            try {
                this.transferService.transfer(targetName, definition, callbacks);
                TransferServiceImplTest.fail((String)"transfer should have failed with an orphan not found exception");
            }
            catch (TransferException te) {
                this.logger.debug((Object)"deliberatly caught and ignored exception");
            }
            boolean foundSourceReport = false;
            boolean foundDestReport = false;
            for (TransferEvent event : callback.getEvents()) {
                if (!(event instanceof TransferEventReport)) continue;
                reportEvent = (TransferEventReport)event;
                switch (reportEvent.getReportType()) {
                    case DESTINATION: {
                        foundDestReport = true;
                        transferDestReport = reportEvent.getNodeRef();
                        TransferServiceImplTest.assertNotNull((String)"dest transfer nodeId null", (Object)transferDestReport);
                        break;
                    }
                    case SOURCE: {
                        foundSourceReport = true;
                        transferReport = reportEvent.getNodeRef();
                    }
                }
            }
            TransferServiceImplTest.assertTrue((String)"source report not found", (boolean)foundSourceReport);
            TransferServiceImplTest.assertTrue((String)"dest report not found", (boolean)foundDestReport);
            Object var29_40 = null;
        }
        catch (Throwable throwable) {
            Object var29_41 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.setDefaultRollback(false);
        this.startNewTransaction();
        try {
            reader = this.contentService.getReader(transferReport, ContentModel.PROP_CONTENT);
            TransferServiceImplTest.assertNotNull((String)"transfer reader is null", (Object)reader);
            TransferServiceImplTest.assertEquals((String)"client report mimetype not set", (String)reader.getMimetype(), (String)"text/xml");
            name = (String)((Object)this.nodeService.getProperty(transferReport, ContentModel.PROP_NAME));
            TransferServiceImplTest.assertTrue((String)"client report does not end with .xml", (boolean)name.endsWith(".xml"));
            this.logger.debug((Object)"This report should have failed");
            if (this.logger.isDebugEnabled()) {
                this.dumpToSystemOut(transferReport);
            }
            transferReportSource = new StreamSource(reader.getContentInputStream());
            sf2 = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            String TRANSFER_REPORT_SCHEMA_LOCATION2 = "classpath:org/alfresco/repo/transfer/report/TransferReport2.xsd";
            Schema schema2 = sf2.newSchema(ResourceUtils.getURL((String)"classpath:org/alfresco/repo/transfer/report/TransferReport2.xsd"));
            validator2 = schema2.newValidator();
            try {
                validator2.validate(transferReportSource);
            }
            catch (Exception e) {
                TransferServiceImplTest.fail((String)e.getMessage());
            }
            Object var31_44 = null;
        }
        catch (Throwable throwable) {
            Object var31_45 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            callback = new TestTransferCallback();
            callbacks = new HashSet();
            callbacks.add(callback);
            definition = new TransferDefinition();
            nodes = new HashSet();
            nodes.add(nodeRefA);
            nodes.add(nodeRefB);
            nodes.add(testFolder);
            definition.setNodes(nodes);
            transferReport = this.transferService.transfer(targetName, definition, callbacks);
            TransferServiceImplTest.assertNotNull((String)"transfer report is null", (Object)transferReport);
            boolean foundSourceReport = false;
            boolean foundDestReport = false;
            for (TransferEvent event : callback.getEvents()) {
                if (!(event instanceof TransferEventReport)) continue;
                reportEvent = (TransferEventReport)event;
                switch (reportEvent.getReportType()) {
                    case DESTINATION: {
                        foundDestReport = true;
                        transferDestReport = reportEvent.getNodeRef();
                        TransferServiceImplTest.assertNotNull((String)"dest transfer nodeId null", (Object)transferDestReport);
                        TransferServiceImplTest.assertFalse((String)"dest transfer nodeId not correct", (boolean)transferReport.equals((Object)transferDestReport));
                        break;
                    }
                    case SOURCE: {
                        foundSourceReport = true;
                        TransferServiceImplTest.assertEquals((String)"source transfer nodeId not correct", (Object)transferReport, (Object)reportEvent.getNodeRef());
                    }
                }
            }
            TransferServiceImplTest.assertTrue((String)"source report not found", (boolean)foundSourceReport);
            TransferServiceImplTest.assertTrue((String)"dest report not found", (boolean)foundDestReport);
            Object var33_48 = null;
        }
        catch (Throwable throwable) {
            Object var33_49 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            reader = this.contentService.getReader(transferReport, ContentModel.PROP_CONTENT);
            TransferServiceImplTest.assertNotNull((String)"transfer reader is null", (Object)reader);
            this.logger.debug((Object)"This report should succeed");
            if (this.logger.isDebugEnabled()) {
                this.dumpToSystemOut(transferReport);
            }
            StreamSource transferReportSource2 = new StreamSource(reader.getContentInputStream());
            sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            TRANSFER_REPORT_SCHEMA_LOCATION = "classpath:org/alfresco/repo/transfer/report/TransferReport2.xsd";
            schema = sf.newSchema(ResourceUtils.getURL((String)"classpath:org/alfresco/repo/transfer/report/TransferReport2.xsd"));
            validator = schema.newValidator();
            try {
                validator.validate(transferReportSource2);
            }
            catch (Exception e) {
                TransferServiceImplTest.fail((String)e.getMessage());
            }
            Object var35_51 = null;
        }
        catch (Throwable throwable) {
            Object var35_52 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            reader = this.contentService.getReader(transferDestReport, ContentModel.PROP_CONTENT);
            TransferServiceImplTest.assertNotNull((String)"transfer reader is null", (Object)reader);
            TransferServiceImplTest.assertEquals((String)"dest report mimetype not set", (String)reader.getMimetype(), (String)"text/xml");
            name = (String)((Object)this.nodeService.getProperty(transferReport, ContentModel.PROP_NAME));
            TransferServiceImplTest.assertTrue((String)"dest report does not end with .xml", (boolean)name.endsWith(".xml"));
            if (this.logger.isDebugEnabled()) {
                this.dumpToSystemOut(transferDestReport);
            }
            transferReportSource = new StreamSource(reader.getContentInputStream());
            sf2 = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            String TRANSFER_REPORT_SCHEMA_LOCATION3 = "classpath:org/alfresco/repo/transfer/reportd/TransferDestinationReport.xsd";
            Schema schema3 = sf2.newSchema(ResourceUtils.getURL((String)"classpath:org/alfresco/repo/transfer/reportd/TransferDestinationReport.xsd"));
            validator2 = schema3.newValidator();
            try {
                validator2.validate(transferReportSource);
            }
            catch (Exception e) {
                TransferServiceImplTest.fail((String)("Destination Transfer Report " + e.getMessage()));
            }
            Object var37_54 = null;
        }
        catch (Throwable throwable) {
            Object var37_55 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            String query = "TYPE:\"trx:transferReportDest\"";
            ResultSet results = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "lucene", query);
            sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            TRANSFER_REPORT_SCHEMA_LOCATION = "classpath:org/alfresco/repo/transfer/reportd/TransferDestinationReport.xsd";
            schema = sf.newSchema(ResourceUtils.getURL((String)"classpath:org/alfresco/repo/transfer/reportd/TransferDestinationReport.xsd"));
            validator = schema.newValidator();
            for (ResultSetRow result : results) {
                NodeRef reportNode = result.getNodeRef();
                this.logger.debug((Object)("validating  reportNode " + reportNode));
                ContentReader reader2 = this.contentService.getReader(reportNode, ContentModel.PROP_CONTENT);
                TransferServiceImplTest.assertNotNull((String)"transfer reader is null", (Object)reader2);
                if (!reader2.getMimetype().equals("text/xml")) continue;
                StreamSource transferReportSource3 = new StreamSource(reader2.getContentInputStream());
                try {
                    validator.validate(transferReportSource3);
                }
                catch (Exception e) {
                    TransferServiceImplTest.fail((String)("Destination Transfer Report reportNode:" + reportNode + " message :" + e.getMessage()));
                }
            }
            Object var39_57 = null;
        }
        catch (Throwable throwable) {
            Object var39_58 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            this.logger.debug((Object)("now delete the target:" + targetName));
            this.transferService.deleteTransferTarget(targetName);
            Object var41_60 = null;
        }
        catch (Throwable throwable) {
            Object var41_61 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    private void dumpToSystemOut(NodeRef nodeRef) throws IOException {
        ContentReader reader2 = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
        TransferServiceImplTest.assertNotNull((String)"transfer reader is null", (Object)reader2);
        InputStream is = reader2.getContentInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String s = br.readLine();
        while (s != null) {
            System.out.println(s);
            s = br.readLine();
        }
    }

    private UnitTestTransferManifestNodeFactory unitTestKludgeToTransferGuestHomeToCompanyHome() {
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter(transmitter);
        UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory(testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)PathHelper.stringToPath(this.GUEST_HOME_XPATH_QUERY), (Object)PathHelper.stringToPath(this.COMPANY_HOME_XPATH_QUERY)));
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        return testNodeFactory;
    }

    public void testTransferOneNodeWithBigContent() throws Exception {
        boolean runTest = false;
        if (runTest || this.logger.isDebugEnabled()) {
            String CONTENT_TITLE = "ContentTitle";
            String CONTENT_NAME = "BigContent";
            final Locale CONTENT_LOCALE = Locale.UK;
            this.logger.debug((Object)"testTransferOneNodeWithBigContent starting");
            RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
            final UnitTestTransferManifestNodeFactory testNodeFactory = this.unitTestKludgeToTransferGuestHomeToCompanyHome();
            String targetName = "testTransferOneNodeWithBigContent";
            class TestContext {
                TransferTarget transferMe;
                NodeRef contentNodeRef;
                NodeRef destNodeRef;

                TestContext() {
                }
            }
            RetryingTransactionHelper.RetryingTransactionCallback<TestContext> setupCB = new RetryingTransactionHelper.RetryingTransactionCallback<TestContext>(){

                @Override
                public TestContext execute() throws Throwable {
                    TestContext ctx = new TestContext();
                    String guestHomeQuery = "/app:company_home/app:guest_home";
                    ResultSet result = TransferServiceImplTest.this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", guestHomeQuery);
                    Assert.assertEquals((String)"", (int)1, (int)result.length());
                    NodeRef guestHome = result.getNodeRef(0);
                    System.out.println("Guest home:" + guestHome);
                    Assert.assertNotNull((Object)guestHome);
                    ctx.contentNodeRef = TransferServiceImplTest.this.nodeService.getChildByName(guestHome, ContentModel.ASSOC_CONTAINS, "BigContent");
                    if (ctx.contentNodeRef == null) {
                        ChildAssociationRef child = TransferServiceImplTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"BigContent"), ContentModel.TYPE_CONTENT);
                        File tempFile = TempFileProvider.createTempFile((String)"test", (String)".dat");
                        FileWriter fw = new FileWriter(tempFile);
                        for (int i = 0; i < 100000000; ++i) {
                            fw.write("hello world this is my text, I wonder how much text I can transfer?" + i);
                        }
                        System.out.println("Temp File Size is:" + tempFile.length());
                        fw.close();
                        ctx.contentNodeRef = child.getChildRef();
                        ContentWriter writer = TransferServiceImplTest.this.contentService.getWriter(ctx.contentNodeRef, ContentModel.PROP_CONTENT, true);
                        writer.setLocale(CONTENT_LOCALE);
                        writer.setMimetype("application/data");
                        writer.putContent(tempFile);
                        tempFile.delete();
                        TransferServiceImplTest.this.nodeService.setProperty(ctx.contentNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                        TransferServiceImplTest.this.nodeService.setProperty(ctx.contentNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"BigContent"));
                    }
                    if (!TransferServiceImplTest.this.transferService.targetExists("testTransferOneNodeWithBigContent")) {
                        TransferServiceImplTest.this.createTransferTarget("testTransferOneNodeWithBigContent");
                    }
                    return ctx;
                }
            };
            final TestContext testContext = tran.doInTransaction(setupCB);
            RetryingTransactionHelper.RetryingTransactionCallback<Void> transferCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
                {
                }

                @Override
                public Void execute() throws Throwable {
                    TransferDefinition definition = new TransferDefinition();
                    HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                    nodes.add(testContext.contentNodeRef);
                    definition.setNodes(nodes);
                    TransferServiceImplTest.this.transferService.transfer("testTransferOneNodeWithBigContent", definition);
                    return null;
                }
            };
            RetryingTransactionHelper.RetryingTransactionCallback<Void> finishCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
                {
                }

                @Override
                public Void execute() throws Throwable {
                    NodeRef oldDestNodeRef = testNodeFactory.getMappedNodeRef(testContext.contentNodeRef);
                    ContentReader source = TransferServiceImplTest.this.contentService.getReader(testContext.contentNodeRef, ContentModel.PROP_CONTENT);
                    ContentReader destination = TransferServiceImplTest.this.contentService.getReader(oldDestNodeRef, ContentModel.PROP_CONTENT);
                    Assert.assertNotNull((String)"source is null", (Object)source);
                    Assert.assertNotNull((String)"destination is null", (Object)destination);
                    Assert.assertEquals((String)"size different", (long)source.getSize(), (long)destination.getSize());
                    TransferServiceImplTest.this.nodeService.deleteNode(oldDestNodeRef);
                    return null;
                }
            };
            tran.doInTransaction(transferCB);
            tran.doInTransaction(finishCB);
        } else {
            System.out.println("test supressed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransferSyncNodes() throws Exception {
        NodeRef archivedNode;
        ContentWriter writer;
        ChildAssociationRef child;
        NodeRef destNodeRef;
        HashSet<Object> nodes;
        TransferDefinition definition;
        TransferTarget transferMe;
        NodeRef A5NodeRef;
        NodeRef A4NodeRef;
        NodeRef A3NodeRef;
        NodeRef A2NodeRef;
        NodeRef A1NodeRef;
        this.setDefaultRollback(false);
        String CONTENT_TITLE = "ContentTitle";
        String CONTENT_TITLE_UPDATED = "ContentTitleUpdated";
        Locale CONTENT_LOCALE = Locale.GERMAN;
        String CONTENT_STRING = "Hello";
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter(transmitter);
        UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory(testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)PathHelper.stringToPath(this.GUEST_HOME_XPATH_QUERY), (Object)PathHelper.stringToPath(this.COMPANY_HOME_XPATH_QUERY)));
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        String targetName = "testTransferSyncNodes";
        this.startNewTransaction();
        try {
            String guestHomeQuery = "/app:company_home/app:guest_home";
            ResultSet guestHomeResult = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", guestHomeQuery);
            TransferServiceImplTest.assertEquals((String)"", (int)1, (int)guestHomeResult.length());
            NodeRef guestHome = guestHomeResult.getNodeRef(0);
            String name = GUID.generate();
            ChildAssociationRef child2 = this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_FOLDER);
            A1NodeRef = child2.getChildRef();
            this.nodeService.setProperty(A1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(A1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
            ChildAssociationRef child3 = this.nodeService.createNode(A1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A2"), ContentModel.TYPE_FOLDER);
            A2NodeRef = child3.getChildRef();
            this.nodeService.setProperty(A2NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(A2NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A2"));
            child3 = this.nodeService.createNode(A1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A3"), ContentModel.TYPE_CONTENT);
            A3NodeRef = child3.getChildRef();
            this.nodeService.setProperty(A3NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(A3NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A3"));
            ContentWriter writer2 = this.contentService.getWriter(A3NodeRef, ContentModel.PROP_CONTENT, true);
            writer2.setLocale(CONTENT_LOCALE);
            writer2.putContent(CONTENT_STRING);
            child3 = this.nodeService.createNode(A2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A4"), ContentModel.TYPE_CONTENT);
            A4NodeRef = child3.getChildRef();
            this.nodeService.setProperty(A4NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(A4NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A4"));
            writer2 = this.contentService.getWriter(A4NodeRef, ContentModel.PROP_CONTENT, true);
            writer2.setLocale(CONTENT_LOCALE);
            writer2.putContent(CONTENT_STRING);
            child3 = this.nodeService.createNode(A2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A5"), ContentModel.TYPE_CONTENT);
            A5NodeRef = child3.getChildRef();
            this.nodeService.setProperty(A5NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(A5NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A5"));
            writer2 = this.contentService.getWriter(A5NodeRef, ContentModel.PROP_CONTENT, true);
            writer2.setLocale(CONTENT_LOCALE);
            writer2.putContent(CONTENT_STRING);
            transferMe = !this.transferService.targetExists(targetName) ? this.createTransferTarget(targetName) : this.transferService.getTransferTarget(targetName);
            Object var23_21 = null;
        }
        catch (Throwable throwable) {
            Object var23_22 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            definition = new TransferDefinition();
            nodes = new HashSet<NodeRef>();
            nodes.add(A1NodeRef);
            definition.setNodes(nodes);
            definition.setSync(true);
            this.transferService.transfer(targetName, definition);
            Object var25_24 = null;
        }
        catch (Throwable throwable) {
            Object var25_25 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            destNodeRef = testNodeFactory.getMappedNodeRef(A1NodeRef);
            TransferServiceImplTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)destNodeRef.equals((Object)transferMe.getNodeRef()));
            TransferServiceImplTest.assertTrue((String)"dest node ref does not exist", (boolean)this.nodeService.exists(destNodeRef));
            TransferServiceImplTest.assertEquals((String)"title is wrong", (String)((String)((Object)this.nodeService.getProperty(destNodeRef, ContentModel.PROP_TITLE))), (String)CONTENT_TITLE);
            TransferServiceImplTest.assertEquals((String)"type is wrong", (Object)this.nodeService.getType(A1NodeRef), (Object)this.nodeService.getType(destNodeRef));
            TransferServiceImplTest.assertNotNull((String)"transferredAspect", (Object)((String)((Object)this.nodeService.getProperty(destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
            Object var27_28 = null;
        }
        catch (Throwable throwable) {
            Object var27_29 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            definition = new TransferDefinition();
            nodes = new HashSet();
            nodes.add(A1NodeRef);
            nodes.add(A2NodeRef);
            nodes.add(A3NodeRef);
            nodes.add(A4NodeRef);
            nodes.add(A5NodeRef);
            definition.setNodes(nodes);
            definition.setSync(true);
            this.transferService.transfer(targetName, definition);
            Object var29_31 = null;
        }
        catch (Throwable throwable) {
            Object var29_32 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            destNodeRef = testNodeFactory.getMappedNodeRef(A1NodeRef);
            TransferServiceImplTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)destNodeRef.equals((Object)transferMe.getNodeRef()));
            TransferServiceImplTest.assertTrue((String)"dest node ref A1 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A1NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node ref A2 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A2NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node ref A3 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A3NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node ref A4 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A4NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node ref A5 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A5NodeRef)));
            TransferServiceImplTest.assertNotNull((String)"transferredAspect", (Object)((String)((Object)this.nodeService.getProperty(destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
            Object var31_34 = null;
        }
        catch (Throwable throwable) {
            Object var31_35 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            this.nodeService.deleteNode(A2NodeRef);
            Object var33_37 = null;
        }
        catch (Throwable throwable) {
            Object var33_38 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            definition = new TransferDefinition();
            nodes = new HashSet();
            nodes.add(A1NodeRef);
            nodes.add(A3NodeRef);
            definition.setNodes(nodes);
            definition.setSync(true);
            this.transferService.transfer(targetName, definition);
            Object var35_40 = null;
        }
        catch (Throwable throwable) {
            Object var35_41 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            destNodeRef = testNodeFactory.getMappedNodeRef(A1NodeRef);
            TransferServiceImplTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)destNodeRef.equals((Object)transferMe.getNodeRef()));
            TransferServiceImplTest.assertTrue((String)"dest node ref A1 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A1NodeRef)));
            TransferServiceImplTest.assertFalse((String)"dest node ref A2 has not been deleted", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A2NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node ref A3 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A3NodeRef)));
            TransferServiceImplTest.assertFalse((String)"dest node ref A4 has not been deleted", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A4NodeRef)));
            TransferServiceImplTest.assertFalse((String)"dest node ref A5 has not been deleted", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A5NodeRef)));
            TransferServiceImplTest.assertNotNull((String)"transferredAspect", (Object)((String)((Object)this.nodeService.getProperty(destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
            Object var37_43 = null;
        }
        catch (Throwable throwable) {
            Object var37_44 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            this.nodeService.deleteNode(A3NodeRef);
            Object var39_46 = null;
        }
        catch (Throwable throwable) {
            Object var39_47 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            definition = new TransferDefinition();
            nodes = new HashSet();
            nodes.add(A1NodeRef);
            definition.setNodes(nodes);
            definition.setSync(true);
            this.transferService.transfer(targetName, definition);
            Object var41_49 = null;
        }
        catch (Throwable throwable) {
            Object var41_50 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            destNodeRef = testNodeFactory.getMappedNodeRef(A1NodeRef);
            TransferServiceImplTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)destNodeRef.equals((Object)transferMe.getNodeRef()));
            TransferServiceImplTest.assertTrue((String)"dest node ref A1 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A1NodeRef)));
            TransferServiceImplTest.assertFalse((String)"dest node ref A2 has not been deleted", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A2NodeRef)));
            TransferServiceImplTest.assertFalse((String)"dest node ref A3 has not been deleted", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A3NodeRef)));
            TransferServiceImplTest.assertFalse((String)"dest node ref A4 has not been deleted", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A4NodeRef)));
            TransferServiceImplTest.assertFalse((String)"dest node ref A5 has not been deleted", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A5NodeRef)));
            TransferServiceImplTest.assertNotNull((String)"transferredAspect", (Object)((String)((Object)this.nodeService.getProperty(destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
            Object var43_52 = null;
        }
        catch (Throwable throwable) {
            Object var43_53 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            child = this.nodeService.createNode(A1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A3"), ContentModel.TYPE_CONTENT);
            A3NodeRef = child.getChildRef();
            this.nodeService.setProperty(A3NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(A3NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A3"));
            writer = this.contentService.getWriter(A3NodeRef, ContentModel.PROP_CONTENT, true);
            writer.setLocale(CONTENT_LOCALE);
            writer.putContent(CONTENT_STRING);
            Object var45_55 = null;
        }
        catch (Throwable throwable) {
            Object var45_56 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            definition = new TransferDefinition();
            nodes = new HashSet();
            nodes.add(A1NodeRef);
            nodes.add(A3NodeRef);
            definition.setNodes(nodes);
            definition.setSync(true);
            this.transferService.transfer(targetName, definition);
            Object var47_58 = null;
        }
        catch (Throwable throwable) {
            Object var47_59 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            destNodeRef = testNodeFactory.getMappedNodeRef(A1NodeRef);
            TransferServiceImplTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)destNodeRef.equals((Object)transferMe.getNodeRef()));
            TransferServiceImplTest.assertTrue((String)"dest node ref A1 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A1NodeRef)));
            TransferServiceImplTest.assertFalse((String)"dest node ref A2 has not been deleted", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A2NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node A3 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A3NodeRef)));
            TransferServiceImplTest.assertFalse((String)"dest node ref A4 has not been deleted", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A4NodeRef)));
            TransferServiceImplTest.assertFalse((String)"dest node ref A5 has not been deleted", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A5NodeRef)));
            TransferServiceImplTest.assertNotNull((String)"transferredAspect", (Object)((String)((Object)this.nodeService.getProperty(destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
            Object var49_61 = null;
        }
        catch (Throwable throwable) {
            Object var49_62 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            child = this.nodeService.createNode(A1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A2"), ContentModel.TYPE_FOLDER);
            A2NodeRef = child.getChildRef();
            this.nodeService.setProperty(A2NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(A2NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A2"));
            child = this.nodeService.createNode(A2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A4"), ContentModel.TYPE_CONTENT);
            A4NodeRef = child.getChildRef();
            this.nodeService.setProperty(A4NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(A4NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A4"));
            writer = this.contentService.getWriter(A4NodeRef, ContentModel.PROP_CONTENT, true);
            writer.setLocale(CONTENT_LOCALE);
            writer.putContent(CONTENT_STRING);
            child = this.nodeService.createNode(A2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A5"), ContentModel.TYPE_CONTENT);
            A5NodeRef = child.getChildRef();
            this.nodeService.setProperty(A5NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(A5NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A5"));
            writer = this.contentService.getWriter(A5NodeRef, ContentModel.PROP_CONTENT, true);
            writer.setLocale(CONTENT_LOCALE);
            writer.putContent(CONTENT_STRING);
            Object var51_64 = null;
        }
        catch (Throwable throwable) {
            Object var51_65 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            definition = new TransferDefinition();
            nodes = new HashSet();
            nodes.add(A1NodeRef);
            nodes.add(A2NodeRef);
            nodes.add(A3NodeRef);
            nodes.add(A4NodeRef);
            nodes.add(A5NodeRef);
            definition.setNodes(nodes);
            definition.setSync(true);
            this.transferService.transfer(targetName, definition);
            Object var53_67 = null;
        }
        catch (Throwable throwable) {
            Object var53_68 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            destNodeRef = testNodeFactory.getMappedNodeRef(A1NodeRef);
            TransferServiceImplTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)destNodeRef.equals((Object)transferMe.getNodeRef()));
            TransferServiceImplTest.assertTrue((String)"dest node A1 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A1NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node A2 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A2NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node A3 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A3NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node A4 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A4NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node A5 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A5NodeRef)));
            TransferServiceImplTest.assertNotNull((String)"transferredAspect", (Object)((String)((Object)this.nodeService.getProperty(destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
            Object var55_70 = null;
        }
        catch (Throwable throwable) {
            Object var55_71 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            this.logger.debug((Object)"Step 7 - delete node A3");
            this.nodeService.deleteNode(A3NodeRef);
            Object var57_73 = null;
        }
        catch (Throwable throwable) {
            Object var57_74 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            definition = new TransferDefinition();
            nodes = new HashSet();
            nodes.add(A1NodeRef);
            nodes.add(A2NodeRef);
            nodes.add(A4NodeRef);
            nodes.add(A5NodeRef);
            definition.setNodes(nodes);
            definition.setSync(true);
            this.transferService.transfer(targetName, definition);
            Object var59_76 = null;
        }
        catch (Throwable throwable) {
            Object var59_77 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferServiceImplTest.assertTrue((String)"dest node ref A1 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A1NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node ref A2 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A2NodeRef)));
            TransferServiceImplTest.assertFalse((String)"dest node ref A3 has not been deleted", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A3NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node ref A4 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A4NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node ref A5 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A5NodeRef)));
            Object var61_79 = null;
        }
        catch (Throwable throwable) {
            Object var61_80 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            archivedNode = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, A3NodeRef.getId());
            NodeRef newNodeRef = this.nodeService.restoreNode(archivedNode, A1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A3"));
            TransferServiceImplTest.assertEquals((String)"restored node ref is different", (Object)newNodeRef, (Object)A3NodeRef);
            this.logger.debug((Object)"Step 7 - restore node A3");
            Object var63_82 = null;
        }
        catch (Throwable throwable) {
            Object var63_83 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            definition = new TransferDefinition();
            nodes = new HashSet();
            nodes.add(A1NodeRef);
            nodes.add(A2NodeRef);
            nodes.add(A3NodeRef);
            nodes.add(A4NodeRef);
            nodes.add(A5NodeRef);
            definition.setNodes(nodes);
            definition.setSync(true);
            this.transferService.transfer(targetName, definition);
            Object var65_85 = null;
        }
        catch (Throwable throwable) {
            Object var65_86 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferServiceImplTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)destNodeRef.equals((Object)transferMe.getNodeRef()));
            TransferServiceImplTest.assertTrue((String)"dest node ref A1 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A1NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node ref A2 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A2NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node ref A3 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A3NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node ref A4 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A4NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node ref A5 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A5NodeRef)));
            Object var67_88 = null;
        }
        catch (Throwable throwable) {
            Object var67_89 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            this.nodeService.deleteNode(A2NodeRef);
            Object var69_91 = null;
        }
        catch (Throwable throwable) {
            Object var69_92 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            definition = new TransferDefinition();
            nodes = new HashSet();
            nodes.add(A1NodeRef);
            nodes.add(A3NodeRef);
            definition.setNodes(nodes);
            definition.setSync(true);
            this.transferService.transfer(targetName, definition);
            Object var71_94 = null;
        }
        catch (Throwable throwable) {
            Object var71_95 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            destNodeRef = testNodeFactory.getMappedNodeRef(A1NodeRef);
            TransferServiceImplTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)destNodeRef.equals((Object)transferMe.getNodeRef()));
            TransferServiceImplTest.assertTrue((String)"dest node ref A1 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A1NodeRef)));
            TransferServiceImplTest.assertFalse((String)"dest node ref A2 has not been deleted", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A2NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node ref A3 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A3NodeRef)));
            TransferServiceImplTest.assertFalse((String)"dest node ref A4 has not been deleted", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A4NodeRef)));
            TransferServiceImplTest.assertFalse((String)"dest node ref A5 has not been deleted", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A5NodeRef)));
            Object var73_97 = null;
        }
        catch (Throwable throwable) {
            Object var73_98 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            archivedNode = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, A2NodeRef.getId());
            this.nodeService.restoreNode(archivedNode, A1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A2"));
            Object var75_100 = null;
        }
        catch (Throwable throwable) {
            Object var75_101 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            definition = new TransferDefinition();
            nodes = new HashSet();
            nodes.add(A1NodeRef);
            nodes.add(A2NodeRef);
            nodes.add(A3NodeRef);
            nodes.add(A4NodeRef);
            nodes.add(A5NodeRef);
            definition.setNodes(nodes);
            definition.setSync(true);
            this.transferService.transfer(targetName, definition);
            Object var77_103 = null;
        }
        catch (Throwable throwable) {
            Object var77_104 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            destNodeRef = testNodeFactory.getMappedNodeRef(A1NodeRef);
            TransferServiceImplTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)destNodeRef.equals((Object)transferMe.getNodeRef()));
            TransferServiceImplTest.assertTrue((String)"dest node ref A1 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A1NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node ref A2 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A2NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node ref A3 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A3NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node ref A4 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A4NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node ref A5 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A5NodeRef)));
            Object var79_106 = null;
        }
        catch (Throwable throwable) {
            Object var79_107 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransferInvadedByLocalAlienNodes() throws Exception {
        NodeRef B11NodeRef;
        NodeRef B13NodeRef;
        NodeRef A6destNodeRef;
        NodeRef B14NodeRef;
        NodeRef B12NodeRef;
        NodeRef A2destNodeRef;
        NodeRef B10NodeRef;
        ContentWriter writer;
        NodeRef B9NodeRef;
        ChildAssociationRef child;
        NodeRef destNodeRef;
        NodeRef A1destNodeRef;
        TransferTarget transferMe;
        NodeRef A8NodeRef;
        NodeRef A7NodeRef;
        NodeRef A6NodeRef;
        NodeRef A5NodeRef;
        NodeRef A4NodeRef;
        NodeRef A3NodeRef;
        NodeRef A2NodeRef;
        NodeRef A1NodeRef;
        this.setDefaultRollback(false);
        String CONTENT_TITLE = "ContentTitle";
        String CONTENT_TITLE_UPDATED = "ContentTitleUpdated";
        Locale CONTENT_LOCALE = Locale.JAPAN;
        String CONTENT_STRING = "Hello";
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter(transmitter);
        UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory(testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)PathHelper.stringToPath(this.GUEST_HOME_XPATH_QUERY), (Object)PathHelper.stringToPath(this.COMPANY_HOME_XPATH_QUERY)));
        String localRepositoryId = this.descriptorService.getCurrentRepositoryDescriptor().getId();
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        String targetName = "testSyncWithAlienNodes";
        this.startNewTransaction();
        try {
            String guestHomeQuery = "/app:company_home/app:guest_home";
            ResultSet guestHomeResult = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", guestHomeQuery);
            TransferServiceImplTest.assertEquals((String)"", (int)1, (int)guestHomeResult.length());
            NodeRef guestHome = guestHomeResult.getNodeRef(0);
            String name = GUID.generate();
            ChildAssociationRef child2 = this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_FOLDER);
            A1NodeRef = child2.getChildRef();
            this.nodeService.setProperty(A1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(A1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
            ChildAssociationRef child3 = this.nodeService.createNode(A1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A2"), ContentModel.TYPE_FOLDER);
            A2NodeRef = child3.getChildRef();
            this.nodeService.setProperty(A2NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(A2NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A2"));
            child3 = this.nodeService.createNode(A1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A3"), ContentModel.TYPE_CONTENT);
            A3NodeRef = child3.getChildRef();
            this.nodeService.setProperty(A3NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(A3NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A3"));
            ContentWriter writer2 = this.contentService.getWriter(A3NodeRef, ContentModel.PROP_CONTENT, true);
            writer2.setLocale(CONTENT_LOCALE);
            writer2.putContent(CONTENT_STRING);
            child3 = this.nodeService.createNode(A2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A4"), ContentModel.TYPE_FOLDER);
            A4NodeRef = child3.getChildRef();
            this.nodeService.setProperty(A4NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(A4NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A4"));
            child3 = this.nodeService.createNode(A2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A5"), ContentModel.TYPE_CONTENT);
            A5NodeRef = child3.getChildRef();
            this.nodeService.setProperty(A5NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(A5NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A5"));
            writer2 = this.contentService.getWriter(A5NodeRef, ContentModel.PROP_CONTENT, true);
            writer2.setLocale(CONTENT_LOCALE);
            writer2.putContent(CONTENT_STRING);
            child3 = this.nodeService.createNode(A2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A6"), ContentModel.TYPE_FOLDER);
            A6NodeRef = child3.getChildRef();
            this.nodeService.setProperty(A6NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(A6NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A6"));
            child3 = this.nodeService.createNode(A4NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A7"), ContentModel.TYPE_CONTENT);
            A7NodeRef = child3.getChildRef();
            this.nodeService.setProperty(A7NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(A7NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A7"));
            writer2 = this.contentService.getWriter(A7NodeRef, ContentModel.PROP_CONTENT, true);
            writer2.setLocale(CONTENT_LOCALE);
            writer2.putContent(CONTENT_STRING);
            child3 = this.nodeService.createNode(A6NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A8"), ContentModel.TYPE_CONTENT);
            A8NodeRef = child3.getChildRef();
            this.nodeService.setProperty(A8NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(A8NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A8"));
            writer2 = this.contentService.getWriter(A8NodeRef, ContentModel.PROP_CONTENT, true);
            writer2.setLocale(CONTENT_LOCALE);
            writer2.putContent(CONTENT_STRING);
            transferMe = !this.transferService.targetExists(targetName) ? this.createTransferTarget(targetName) : this.transferService.getTransferTarget(targetName);
            Object var33_25 = null;
        }
        catch (Throwable throwable) {
            Object var33_26 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferDefinition definition = new TransferDefinition();
            HashSet<NodeRef> nodes = new HashSet<NodeRef>();
            nodes.add(A1NodeRef);
            nodes.add(A2NodeRef);
            nodes.add(A3NodeRef);
            nodes.add(A4NodeRef);
            nodes.add(A5NodeRef);
            nodes.add(A6NodeRef);
            nodes.add(A7NodeRef);
            nodes.add(A8NodeRef);
            definition.setNodes(nodes);
            definition.setSync(true);
            this.transferService.transfer(targetName, definition);
            Object var35_29 = null;
        }
        catch (Throwable throwable) {
            Object var35_30 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            A1destNodeRef = testNodeFactory.getMappedNodeRef(A1NodeRef);
            TransferServiceImplTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)A1destNodeRef.equals((Object)transferMe.getNodeRef()));
            TransferServiceImplTest.assertTrue((String)"dest node ref does not exist", (boolean)this.nodeService.exists(A1destNodeRef));
            TransferServiceImplTest.assertEquals((String)"title is wrong", (String)((String)((Object)this.nodeService.getProperty(A1destNodeRef, ContentModel.PROP_TITLE))), (String)CONTENT_TITLE);
            TransferServiceImplTest.assertEquals((String)"type is wrong", (Object)this.nodeService.getType(A1NodeRef), (Object)this.nodeService.getType(A1destNodeRef));
            TransferServiceImplTest.assertFalse((String)"A1 is alien", (boolean)this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertNotNull((String)"transferredAspect", (Object)((String)((Object)this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
            Object var37_33 = null;
        }
        catch (Throwable throwable) {
            Object var37_34 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            destNodeRef = testNodeFactory.getMappedNodeRef(A1NodeRef);
            child = this.nodeService.createNode(destNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B9"), ContentModel.TYPE_CONTENT);
            B9NodeRef = child.getChildRef();
            this.nodeService.setProperty(B9NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(B9NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B9"));
            writer = this.contentService.getWriter(B9NodeRef, ContentModel.PROP_CONTENT, true);
            writer.setLocale(CONTENT_LOCALE);
            writer.putContent(CONTENT_STRING);
            Object var39_38 = null;
        }
        catch (Throwable throwable) {
            Object var39_39 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            A1destNodeRef = testNodeFactory.getMappedNodeRef(A1NodeRef);
            TransferServiceImplTest.assertTrue((String)"dest node ref does not exist", (boolean)this.nodeService.exists(A1destNodeRef));
            TransferServiceImplTest.assertTrue((String)"node A1 is not alien aspect", (boolean)this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertNotNull((String)"repository id is null", (Object)((String)((Object)this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
            TransferServiceImplTest.assertNotNull((String)"from repository id is null", (Object)((String)((Object)this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_FROM_REPOSITORY_ID))));
            TransferServiceImplTest.assertTrue((String)"node B9 is not alien", (boolean)this.nodeService.hasAspect(B9NodeRef, TransferModel.ASPECT_ALIEN));
            List invaders = (List)((Object)this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_INVADED_BY));
            TransferServiceImplTest.assertTrue((String)"invaders contains local repository Id", (boolean)invaders.contains(localRepositoryId));
            TransferServiceImplTest.assertFalse((String)"invaders contains REPO_ID_A", (boolean)invaders.contains(this.REPO_ID_A));
            Object var41_41 = null;
        }
        catch (Throwable throwable) {
            Object var41_42 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            this.logger.debug((Object)"delete node B9");
            this.nodeService.deleteNode(B9NodeRef);
            Object var43_44 = null;
        }
        catch (Throwable throwable) {
            Object var43_45 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            A1destNodeRef = testNodeFactory.getMappedNodeRef(A1NodeRef);
            NodeRef A3destNodeRef = testNodeFactory.getMappedNodeRef(A3NodeRef);
            List invaders = (List)((Object)this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_INVADED_BY));
            TransferServiceImplTest.assertTrue((String)"dest node ref does not exist", (boolean)this.nodeService.exists(A1destNodeRef));
            TransferServiceImplTest.assertFalse((String)"node A1 is still alien", (boolean)this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertFalse((String)"node A3 is alien", (boolean)this.nodeService.hasAspect(A3destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertNotNull((String)"repository id is null", (Object)((String)((Object)this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
            TransferServiceImplTest.assertNotNull((String)"from repository id is null", (Object)((String)((Object)this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_FROM_REPOSITORY_ID))));
            Object var45_47 = null;
        }
        catch (Throwable throwable) {
            Object var45_48 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            destNodeRef = testNodeFactory.getMappedNodeRef(A2NodeRef);
            child = this.nodeService.createNode(destNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B10"), ContentModel.TYPE_CONTENT);
            B10NodeRef = child.getChildRef();
            this.nodeService.setProperty(B10NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(B10NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B10"));
            writer = this.contentService.getWriter(B10NodeRef, ContentModel.PROP_CONTENT, true);
            writer.setLocale(CONTENT_LOCALE);
            writer.putContent(CONTENT_STRING);
            Object var47_51 = null;
        }
        catch (Throwable throwable) {
            Object var47_52 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            A1destNodeRef = testNodeFactory.getMappedNodeRef(A1NodeRef);
            A2destNodeRef = testNodeFactory.getMappedNodeRef(A2NodeRef);
            TransferServiceImplTest.assertTrue((String)"node A1 is not alien aspect", (boolean)this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertTrue((String)"node A2 is not alien aspect", (boolean)this.nodeService.hasAspect(A2destNodeRef, TransferModel.ASPECT_ALIEN));
            Object var49_54 = null;
        }
        catch (Throwable throwable) {
            Object var49_55 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            this.logger.debug((Object)"delete node B10");
            this.nodeService.deleteNode(B10NodeRef);
            Object var51_57 = null;
        }
        catch (Throwable throwable) {
            Object var51_58 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            A1destNodeRef = testNodeFactory.getMappedNodeRef(A1NodeRef);
            A2destNodeRef = testNodeFactory.getMappedNodeRef(A2NodeRef);
            TransferServiceImplTest.assertFalse((String)"node A1 is still alien aspect", (boolean)this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertFalse((String)"node A2 is still alien aspect", (boolean)this.nodeService.hasAspect(A2destNodeRef, TransferModel.ASPECT_ALIEN));
            Object var53_60 = null;
        }
        catch (Throwable throwable) {
            Object var53_61 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            destNodeRef = testNodeFactory.getMappedNodeRef(A6NodeRef);
            child = this.nodeService.createNode(destNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B12"), ContentModel.TYPE_FOLDER);
            B12NodeRef = child.getChildRef();
            this.nodeService.setProperty(B12NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(B12NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B12"));
            child = this.nodeService.createNode(B12NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B14"), ContentModel.TYPE_CONTENT);
            B14NodeRef = child.getChildRef();
            this.nodeService.setProperty(B14NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(B14NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B14"));
            Object var55_65 = null;
        }
        catch (Throwable throwable) {
            Object var55_66 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            A1destNodeRef = testNodeFactory.getMappedNodeRef(A1NodeRef);
            A2destNodeRef = testNodeFactory.getMappedNodeRef(A2NodeRef);
            A6destNodeRef = testNodeFactory.getMappedNodeRef(A6NodeRef);
            TransferServiceImplTest.assertTrue((String)"node A1 is not alien", (boolean)this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertTrue((String)"node A2 is not alien", (boolean)this.nodeService.hasAspect(A2destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertTrue((String)"node A6 is not alien", (boolean)this.nodeService.hasAspect(A6destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertTrue((String)"node B14 is not alien", (boolean)this.nodeService.hasAspect(B14NodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertTrue((String)"node B12 is not alien", (boolean)this.nodeService.hasAspect(B12NodeRef, TransferModel.ASPECT_ALIEN));
            Object var57_68 = null;
        }
        catch (Throwable throwable) {
            Object var57_69 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            this.nodeService.deleteNode(B14NodeRef);
            Object var59_71 = null;
        }
        catch (Throwable throwable) {
            Object var59_72 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            A1destNodeRef = testNodeFactory.getMappedNodeRef(A1NodeRef);
            A2destNodeRef = testNodeFactory.getMappedNodeRef(A2NodeRef);
            A6destNodeRef = testNodeFactory.getMappedNodeRef(A6NodeRef);
            TransferServiceImplTest.assertTrue((String)"node A1 is not alien", (boolean)this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertTrue((String)"node A2 is not alien", (boolean)this.nodeService.hasAspect(A2destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertTrue((String)"node A6 is not alien", (boolean)this.nodeService.hasAspect(A6destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertTrue((String)"node B12 is not alien", (boolean)this.nodeService.hasAspect(B12NodeRef, TransferModel.ASPECT_ALIEN));
            Object var61_74 = null;
        }
        catch (Throwable throwable) {
            Object var61_75 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            destNodeRef = testNodeFactory.getMappedNodeRef(A6NodeRef);
            child = this.nodeService.createNode(destNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B13"), ContentModel.TYPE_CONTENT);
            B13NodeRef = child.getChildRef();
            this.nodeService.setProperty(B13NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(B13NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B13"));
            writer = this.contentService.getWriter(B13NodeRef, ContentModel.PROP_CONTENT, true);
            writer.setLocale(CONTENT_LOCALE);
            writer.putContent(CONTENT_STRING);
            Object var63_78 = null;
        }
        catch (Throwable throwable) {
            Object var63_79 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            A1destNodeRef = testNodeFactory.getMappedNodeRef(A1NodeRef);
            A2destNodeRef = testNodeFactory.getMappedNodeRef(A2NodeRef);
            A6destNodeRef = testNodeFactory.getMappedNodeRef(A6NodeRef);
            TransferServiceImplTest.assertTrue((String)"node A1 is not alien", (boolean)this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertTrue((String)"node A2 is not alien", (boolean)this.nodeService.hasAspect(A2destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertTrue((String)"node A6 is not alien", (boolean)this.nodeService.hasAspect(A6destNodeRef, TransferModel.ASPECT_ALIEN));
            Object var65_81 = null;
        }
        catch (Throwable throwable) {
            Object var65_82 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            this.nodeService.deleteNode(B13NodeRef);
            Object var67_84 = null;
        }
        catch (Throwable throwable) {
            Object var67_85 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            A1destNodeRef = testNodeFactory.getMappedNodeRef(A1NodeRef);
            A2destNodeRef = testNodeFactory.getMappedNodeRef(A2NodeRef);
            A6destNodeRef = testNodeFactory.getMappedNodeRef(A6NodeRef);
            TransferServiceImplTest.assertTrue((String)"node A1 is not alien", (boolean)this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertTrue((String)"node A2 is not alien", (boolean)this.nodeService.hasAspect(A2destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertTrue((String)"node A6 is not alien", (boolean)this.nodeService.hasAspect(A6destNodeRef, TransferModel.ASPECT_ALIEN));
            Object var69_87 = null;
        }
        catch (Throwable throwable) {
            Object var69_88 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            this.nodeService.deleteNode(B12NodeRef);
            Object var71_90 = null;
        }
        catch (Throwable throwable) {
            Object var71_91 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            A1destNodeRef = testNodeFactory.getMappedNodeRef(A1NodeRef);
            A2destNodeRef = testNodeFactory.getMappedNodeRef(A2NodeRef);
            A6destNodeRef = testNodeFactory.getMappedNodeRef(A6NodeRef);
            TransferServiceImplTest.assertFalse((String)"node A1 is still alien", (boolean)this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertFalse((String)"node A2 is still alien", (boolean)this.nodeService.hasAspect(A2destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertFalse((String)"node A6 is still alien", (boolean)this.nodeService.hasAspect(A6destNodeRef, TransferModel.ASPECT_ALIEN));
            Object var73_93 = null;
        }
        catch (Throwable throwable) {
            Object var73_94 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            destNodeRef = testNodeFactory.getMappedNodeRef(A1NodeRef);
            child = this.nodeService.createNode(destNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B9"), ContentModel.TYPE_CONTENT);
            B9NodeRef = child.getChildRef();
            this.nodeService.setProperty(B9NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(B9NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B9"));
            writer = this.contentService.getWriter(B9NodeRef, ContentModel.PROP_CONTENT, true);
            writer.setLocale(CONTENT_LOCALE);
            writer.putContent(CONTENT_STRING);
            destNodeRef = testNodeFactory.getMappedNodeRef(A2NodeRef);
            child = this.nodeService.createNode(destNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B10"), ContentModel.TYPE_CONTENT);
            B10NodeRef = child.getChildRef();
            this.nodeService.setProperty(B10NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(B10NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B10"));
            writer = this.contentService.getWriter(B10NodeRef, ContentModel.PROP_CONTENT, true);
            writer.setLocale(CONTENT_LOCALE);
            writer.putContent(CONTENT_STRING);
            Object var75_96 = null;
        }
        catch (Throwable throwable) {
            Object var75_97 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            A1destNodeRef = testNodeFactory.getMappedNodeRef(A1NodeRef);
            A2destNodeRef = testNodeFactory.getMappedNodeRef(A2NodeRef);
            TransferServiceImplTest.assertTrue((String)"node A1 is not alien", (boolean)this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertTrue((String)"node A2 is not alien", (boolean)this.nodeService.hasAspect(A2destNodeRef, TransferModel.ASPECT_ALIEN));
            Object var77_99 = null;
        }
        catch (Throwable throwable) {
            Object var77_100 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            this.nodeService.deleteNode(B10NodeRef);
            Object var79_102 = null;
        }
        catch (Throwable throwable) {
            Object var79_103 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            A1destNodeRef = testNodeFactory.getMappedNodeRef(A1NodeRef);
            A2destNodeRef = testNodeFactory.getMappedNodeRef(A2NodeRef);
            TransferServiceImplTest.assertTrue((String)"node A1 is still alien", (boolean)this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertFalse((String)"node A2 is still alien", (boolean)this.nodeService.hasAspect(A2destNodeRef, TransferModel.ASPECT_ALIEN));
            Object var81_105 = null;
        }
        catch (Throwable throwable) {
            Object var81_106 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.logger.debug((Object)"Step 12 Add Node B11, Delete A2 and sync");
        this.startNewTransaction();
        try {
            destNodeRef = testNodeFactory.getMappedNodeRef(A4NodeRef);
            child = this.nodeService.createNode(destNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B11"), ContentModel.TYPE_CONTENT);
            B11NodeRef = child.getChildRef();
            this.nodeService.setProperty(B11NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(B11NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B11"));
            writer = this.contentService.getWriter(B11NodeRef, ContentModel.PROP_CONTENT, true);
            writer.setLocale(CONTENT_LOCALE);
            writer.putContent(CONTENT_STRING);
            this.nodeService.deleteNode(A2NodeRef);
            Object var83_109 = null;
        }
        catch (Throwable throwable) {
            Object var83_110 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            A1destNodeRef = testNodeFactory.getMappedNodeRef(A1NodeRef);
            A2destNodeRef = testNodeFactory.getMappedNodeRef(A2NodeRef);
            NodeRef A4destNodeRef = testNodeFactory.getMappedNodeRef(A4NodeRef);
            TransferServiceImplTest.assertTrue((String)"node A1 is not alien", (boolean)this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertTrue((String)"node A2 is not alien", (boolean)this.nodeService.hasAspect(A2destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertTrue((String)"node A4 is not alien", (boolean)this.nodeService.hasAspect(A4destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertFalse((String)"test error: node A2 not deleted", (boolean)this.nodeService.exists(A2NodeRef));
            TransferServiceImplTest.assertFalse((String)"test error: node A4 not deleted", (boolean)this.nodeService.exists(A4NodeRef));
            TransferServiceImplTest.assertFalse((String)"test error: node A5 not deleted", (boolean)this.nodeService.exists(A5NodeRef));
            TransferServiceImplTest.assertFalse((String)"test error: node A6 not deleted", (boolean)this.nodeService.exists(A6NodeRef));
            TransferServiceImplTest.assertFalse((String)"test error: node A7 not deleted", (boolean)this.nodeService.exists(A7NodeRef));
            TransferServiceImplTest.assertFalse((String)"test error: node A8 not deleted", (boolean)this.nodeService.exists(A8NodeRef));
            TransferServiceImplTest.assertTrue((String)"test error: node does not exist", (boolean)this.nodeService.exists(A3NodeRef));
            TransferDefinition definition = new TransferDefinition();
            HashSet<NodeRef> nodes = new HashSet<NodeRef>();
            nodes.add(A1NodeRef);
            nodes.add(A3NodeRef);
            definition.setNodes(nodes);
            definition.setSync(true);
            this.transferService.transfer(targetName, definition);
            Object var85_112 = null;
        }
        catch (Throwable throwable) {
            Object var85_113 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            A1destNodeRef = testNodeFactory.getMappedNodeRef(A1NodeRef);
            A2destNodeRef = testNodeFactory.getMappedNodeRef(A2NodeRef);
            NodeRef A3destNodeRef = testNodeFactory.getMappedNodeRef(A3NodeRef);
            NodeRef A4destNodeRef = testNodeFactory.getMappedNodeRef(A4NodeRef);
            NodeRef A5destNodeRef = testNodeFactory.getMappedNodeRef(A5NodeRef);
            NodeRef A6destNodeRef2 = testNodeFactory.getMappedNodeRef(A6NodeRef);
            NodeRef A7destNodeRef = testNodeFactory.getMappedNodeRef(A7NodeRef);
            NodeRef A8destNodeRef = testNodeFactory.getMappedNodeRef(A8NodeRef);
            TransferServiceImplTest.assertTrue((String)"node A1 not alien", (boolean)this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertTrue((String)"node A2 not alien", (boolean)this.nodeService.hasAspect(A2destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertTrue((String)"node A4 not alien", (boolean)this.nodeService.hasAspect(A4destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertTrue((String)"node B11 does not exist", (boolean)this.nodeService.exists(B11NodeRef));
            TransferServiceImplTest.assertTrue((String)"node A3 deleted", (boolean)this.nodeService.exists(A3destNodeRef));
            TransferServiceImplTest.assertFalse((String)"node A5 not deleted", (boolean)this.nodeService.exists(A5destNodeRef));
            TransferServiceImplTest.assertFalse((String)"node A6 not deleted", (boolean)this.nodeService.exists(A6destNodeRef2));
            TransferServiceImplTest.assertFalse((String)"node A7 not deleted", (boolean)this.nodeService.exists(A7destNodeRef));
            TransferServiceImplTest.assertFalse((String)"node A8 not deleted", (boolean)this.nodeService.exists(A8destNodeRef));
            Object var87_115 = null;
        }
        catch (Throwable throwable) {
            Object var87_116 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLocalAlienRestore() throws Exception {
        NodeRef B3NodeRef;
        NodeRef B2ArchiveNodeRef;
        List invaders;
        NodeRef B2NodeRef;
        NodeRef A1destNodeRef;
        NodeRef B1NodeRef;
        NodeRef A1NodeRef;
        NodeRef A0NodeRef;
        ChildAssociationRef child;
        this.setDefaultRollback(false);
        String CONTENT_TITLE = "ContentTitle";
        String CONTENT_TITLE_UPDATED = "ContentTitleUpdated";
        Locale CONTENT_LOCALE = Locale.JAPAN;
        String CONTENT_STRING = "Hello";
        String targetName = "testRestoreOfAlienNodes";
        this.startNewTransaction();
        try {
            String guestHomeQuery = "/app:company_home/app:guest_home";
            ResultSet guestHomeResult = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", guestHomeQuery);
            TransferServiceImplTest.assertEquals((String)"", (int)1, (int)guestHomeResult.length());
            NodeRef guestHome = guestHomeResult.getNodeRef(0);
            String name = GUID.generate();
            child = this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_FOLDER);
            NodeRef S0NodeRef = child.getChildRef();
            this.nodeService.setProperty(S0NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(S0NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
            ChildAssociationRef child2 = this.nodeService.createNode(S0NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A0"), ContentModel.TYPE_FOLDER);
            A0NodeRef = child2.getChildRef();
            this.nodeService.setProperty(A0NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(A0NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A0"));
            child2 = this.nodeService.createNode(A0NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A1"), ContentModel.TYPE_FOLDER);
            A1NodeRef = child2.getChildRef();
            this.nodeService.setProperty(A1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(A1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A1"));
            child2 = this.nodeService.createNode(S0NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B1"), ContentModel.TYPE_FOLDER);
            B1NodeRef = child2.getChildRef();
            this.nodeService.setProperty(B1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(B1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B1"));
            if (!this.transferService.targetExists(targetName)) {
                TransferTarget transferMe = this.createTransferTarget(targetName);
            } else {
                TransferTarget transferMe = this.transferService.getTransferTarget(targetName);
            }
            Object var20_17 = null;
        }
        catch (Throwable throwable) {
            Object var20_18 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter(transmitter);
        UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory(testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)this.nodeService.getPath(A0NodeRef), (Object)this.nodeService.getPath(B1NodeRef)));
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        this.startNewTransaction();
        try {
            TransferDefinition definition = new TransferDefinition();
            HashSet<NodeRef> nodes = new HashSet<NodeRef>();
            nodes.add(A1NodeRef);
            definition.setNodes(nodes);
            definition.setSync(true);
            this.transferService.transfer(targetName, definition);
            Object var22_21 = null;
        }
        catch (Throwable throwable) {
            Object var22_22 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            A1destNodeRef = testNodeFactory.getMappedNodeRef(A1NodeRef);
            TransferServiceImplTest.assertTrue((String)"dest node ref does not exist", (boolean)this.nodeService.exists(A1destNodeRef));
            TransferServiceImplTest.assertFalse((String)"A1 is alien", (boolean)this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertNotNull((String)"transferredAspect", (Object)((String)((Object)this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
            Object var24_24 = null;
        }
        catch (Throwable throwable) {
            Object var24_25 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            NodeRef destNodeRef = testNodeFactory.getMappedNodeRef(A1NodeRef);
            child = this.nodeService.createNode(destNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B2"), ContentModel.TYPE_FOLDER);
            B2NodeRef = child.getChildRef();
            this.nodeService.setProperty(B2NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(B2NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B2"));
            Object var26_29 = null;
        }
        catch (Throwable throwable) {
            Object var26_30 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            A1destNodeRef = testNodeFactory.getMappedNodeRef(A1NodeRef);
            TransferServiceImplTest.assertTrue((String)"dest node ref does not exist", (boolean)this.nodeService.exists(A1destNodeRef));
            TransferServiceImplTest.assertTrue((String)"node A1 is not alien aspect", (boolean)this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertNotNull((String)"repository id is null", (Object)((String)((Object)this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
            TransferServiceImplTest.assertNotNull((String)"from repository id is null", (Object)((String)((Object)this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_FROM_REPOSITORY_ID))));
            TransferServiceImplTest.assertTrue((String)"node B2 is not alien", (boolean)this.nodeService.hasAspect(B2NodeRef, TransferModel.ASPECT_ALIEN));
            Object var28_32 = null;
        }
        catch (Throwable throwable) {
            Object var28_33 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            this.logger.debug((Object)"delete node B2");
            this.nodeService.deleteNode(B2NodeRef);
            Object var30_35 = null;
        }
        catch (Throwable throwable) {
            Object var30_36 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            A1destNodeRef = testNodeFactory.getMappedNodeRef(A1NodeRef);
            invaders = (List)((Object)this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_INVADED_BY));
            TransferServiceImplTest.assertTrue((String)"dest node ref does not exist", (boolean)this.nodeService.exists(A1destNodeRef));
            TransferServiceImplTest.assertFalse((String)"node A1 is still alien", (boolean)this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertNotNull((String)"repository id is null", (Object)((String)((Object)this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
            TransferServiceImplTest.assertNotNull((String)"from repository id is null", (Object)((String)((Object)this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_FROM_REPOSITORY_ID))));
            Object var32_38 = null;
        }
        catch (Throwable throwable) {
            Object var32_39 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            this.logger.debug((Object)"restore node B2");
            B2ArchiveNodeRef = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, B2NodeRef.getId());
            this.nodeService.restoreNode(B2ArchiveNodeRef, testNodeFactory.getMappedNodeRef(A1NodeRef), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B2"));
            Object var34_41 = null;
        }
        catch (Throwable throwable) {
            Object var34_42 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            A1destNodeRef = testNodeFactory.getMappedNodeRef(A1NodeRef);
            TransferServiceImplTest.assertTrue((String)"dest node ref does not exist", (boolean)this.nodeService.exists(A1destNodeRef));
            TransferServiceImplTest.assertTrue((String)"node A1 is not alien", (boolean)this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertNotNull((String)"repository id is null", (Object)((String)((Object)this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
            TransferServiceImplTest.assertNotNull((String)"from repository id is null", (Object)((String)((Object)this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_FROM_REPOSITORY_ID))));
            Object var36_44 = null;
        }
        catch (Throwable throwable) {
            Object var36_45 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            child = this.nodeService.createNode(B2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B3"), ContentModel.TYPE_FOLDER);
            B3NodeRef = child.getChildRef();
            this.nodeService.setProperty(B3NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(B3NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B3"));
            Object var38_48 = null;
        }
        catch (Throwable throwable) {
            Object var38_49 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferServiceImplTest.assertTrue((String)"node B3 is not alien", (boolean)this.nodeService.hasAspect(B3NodeRef, TransferModel.ASPECT_ALIEN));
            Object var40_51 = null;
        }
        catch (Throwable throwable) {
            Object var40_52 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            this.logger.debug((Object)"delete node B2");
            this.nodeService.deleteNode(B2NodeRef);
            Object var42_54 = null;
        }
        catch (Throwable throwable) {
            Object var42_55 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            A1destNodeRef = testNodeFactory.getMappedNodeRef(A1NodeRef);
            invaders = (List)((Object)this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_INVADED_BY));
            TransferServiceImplTest.assertTrue((String)"dest node ref does not exist", (boolean)this.nodeService.exists(A1destNodeRef));
            TransferServiceImplTest.assertFalse((String)"node A1 is still alien", (boolean)this.nodeService.hasAspect(A1destNodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertNotNull((String)"repository id is null", (Object)((String)((Object)this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
            TransferServiceImplTest.assertNotNull((String)"from repository id is null", (Object)((String)((Object)this.nodeService.getProperty(A1destNodeRef, TransferModel.PROP_FROM_REPOSITORY_ID))));
            Object var44_57 = null;
        }
        catch (Throwable throwable) {
            Object var44_58 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            this.logger.debug((Object)"restore node B2");
            B2ArchiveNodeRef = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, B2NodeRef.getId());
            this.nodeService.restoreNode(B2ArchiveNodeRef, B1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B2"));
            Object var46_60 = null;
        }
        catch (Throwable throwable) {
            Object var46_61 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferServiceImplTest.assertFalse((String)"node A1 is still alien", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(A1NodeRef), TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertFalse((String)"node A2 is still alien", (boolean)this.nodeService.hasAspect(B2NodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertFalse((String)"node A3 is still alien", (boolean)this.nodeService.hasAspect(B3NodeRef, TransferModel.ASPECT_ALIEN));
            Object var48_63 = null;
        }
        catch (Throwable throwable) {
            Object var48_64 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransferWithPermissions() throws Exception {
        Set destPerm;
        boolean destInherit;
        Set srcPerm;
        NodeRef destNodeRef;
        HashSet<Object> nodes;
        TransferTarget transferMe;
        NodeRef contentNodeRef;
        this.setDefaultRollback(false);
        String CONTENT_TITLE = "ContentTitle";
        String CONTENT_TITLE_UPDATED = "ContentTitleUpdated";
        Locale CONTENT_LOCALE = Locale.GERMAN;
        String CONTENT_STRING = "Hello";
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter(transmitter);
        UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory(testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)PathHelper.stringToPath(this.GUEST_HOME_XPATH_QUERY), (Object)PathHelper.stringToPath(this.COMPANY_HOME_XPATH_QUERY)));
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        String targetName = "testTransferWithPermissions";
        this.startNewTransaction();
        try {
            String guestHomeQuery = "/app:company_home/app:guest_home";
            ResultSet guestHomeResult = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", guestHomeQuery);
            TransferServiceImplTest.assertEquals((String)"", (int)1, (int)guestHomeResult.length());
            NodeRef guestHome = guestHomeResult.getNodeRef(0);
            String name = GUID.generate();
            ChildAssociationRef child = this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_CONTENT);
            contentNodeRef = child.getChildRef();
            this.nodeService.setProperty(contentNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(contentNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
            ContentWriter writer = this.contentService.getWriter(contentNodeRef, ContentModel.PROP_CONTENT, true);
            writer.setLocale(CONTENT_LOCALE);
            writer.putContent(CONTENT_STRING);
            this.permissionService.setInheritParentPermissions(contentNodeRef, false);
            this.permissionService.setPermission(contentNodeRef, "admin", "Read", true);
            transferMe = !this.transferService.targetExists(targetName) ? this.createTransferTarget(targetName) : this.transferService.getTransferTarget(targetName);
            Object var20_26 = null;
        }
        catch (Throwable throwable) {
            Object var20_27 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.logger.debug((Object)"First transfer - create new node with inheritParent permission off");
        this.startNewTransaction();
        try {
            TransferDefinition definition = new TransferDefinition();
            nodes = new HashSet<NodeRef>();
            nodes.add(contentNodeRef);
            definition.setNodes(nodes);
            this.transferService.transfer(targetName, definition);
            Object var22_29 = null;
        }
        catch (Throwable throwable) {
            Object var22_30 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            destNodeRef = testNodeFactory.getMappedNodeRef(contentNodeRef);
            TransferServiceImplTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)destNodeRef.equals((Object)transferMe.getNodeRef()));
            TransferServiceImplTest.assertTrue((String)"dest node ref does not exist", (boolean)this.nodeService.exists(destNodeRef));
            TransferServiceImplTest.assertEquals((String)"title is wrong", (String)((String)((Object)this.nodeService.getProperty(destNodeRef, ContentModel.PROP_TITLE))), (String)CONTENT_TITLE);
            TransferServiceImplTest.assertEquals((String)"type is wrong", (Object)this.nodeService.getType(contentNodeRef), (Object)this.nodeService.getType(destNodeRef));
            boolean srcInherit = this.permissionService.getInheritParentPermissions(contentNodeRef);
            srcPerm = this.permissionService.getAllSetPermissions(contentNodeRef);
            destInherit = this.permissionService.getInheritParentPermissions(destNodeRef);
            destPerm = this.permissionService.getAllSetPermissions(destNodeRef);
            TransferServiceImplTest.assertFalse((String)"inherit parent permissions (src) flag is incorrect", (boolean)srcInherit);
            TransferServiceImplTest.assertFalse((String)"inherit parent permissions (dest) flag is incorrect", (boolean)destInherit);
            for (AccessPermission p : srcPerm) {
                this.logger.debug((Object)("checking permission :" + p));
                TransferServiceImplTest.assertTrue((String)"permission is missing", (boolean)destPerm.contains(p));
            }
            Object var24_33 = null;
        }
        catch (Throwable throwable) {
            Object var24_34 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            this.permissionService.setPermission(contentNodeRef, "EVERYONE", "Read", false);
            this.permissionService.setPermission(contentNodeRef, "admin", "FullControl", true);
            Object var26_36 = null;
        }
        catch (Throwable throwable) {
            Object var26_37 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferDefinition definition = new TransferDefinition();
            nodes = new HashSet();
            nodes.add(contentNodeRef);
            definition.setNodes(nodes);
            this.transferService.transfer(targetName, definition);
            Object var28_39 = null;
        }
        catch (Throwable throwable) {
            Object var28_40 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            destNodeRef = testNodeFactory.getMappedNodeRef(contentNodeRef);
            boolean srcInherit = this.permissionService.getInheritParentPermissions(contentNodeRef);
            srcPerm = this.permissionService.getAllSetPermissions(contentNodeRef);
            destInherit = this.permissionService.getInheritParentPermissions(destNodeRef);
            destPerm = this.permissionService.getAllSetPermissions(destNodeRef);
            TransferServiceImplTest.assertFalse((String)"inherit parent permissions (src) flag is incorrect", (boolean)srcInherit);
            TransferServiceImplTest.assertFalse((String)"inherit parent permissions (dest) flag is incorrect", (boolean)destInherit);
            for (AccessPermission p : srcPerm) {
                this.logger.debug((Object)("checking permission :" + p));
                TransferServiceImplTest.assertTrue((String)"Step2, permission is missing", (boolean)destPerm.contains(p));
            }
            Object var30_42 = null;
        }
        catch (Throwable throwable) {
            Object var30_43 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            this.permissionService.deletePermission(contentNodeRef, "admin", "FullControl");
            Object var32_45 = null;
        }
        catch (Throwable throwable) {
            Object var32_46 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferDefinition definition = new TransferDefinition();
            nodes = new HashSet();
            nodes.add(contentNodeRef);
            definition.setNodes(nodes);
            this.transferService.transfer(targetName, definition);
            Object var34_48 = null;
        }
        catch (Throwable throwable) {
            Object var34_49 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            destNodeRef = testNodeFactory.getMappedNodeRef(contentNodeRef);
            boolean srcInherit = this.permissionService.getInheritParentPermissions(contentNodeRef);
            srcPerm = this.permissionService.getAllSetPermissions(contentNodeRef);
            destInherit = this.permissionService.getInheritParentPermissions(destNodeRef);
            destPerm = this.permissionService.getAllSetPermissions(destNodeRef);
            TransferServiceImplTest.assertFalse((String)"inherit parent permissions (src) flag is incorrect", (boolean)srcInherit);
            TransferServiceImplTest.assertFalse((String)"inherit parent permissions (dest) flag is incorrect", (boolean)destInherit);
            for (AccessPermission p : srcPerm) {
                this.logger.debug((Object)("checking permission :" + p));
                TransferServiceImplTest.assertTrue((String)"permission is missing", (boolean)destPerm.contains(p));
            }
            Object var36_51 = null;
        }
        catch (Throwable throwable) {
            Object var36_52 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            this.permissionService.setInheritParentPermissions(contentNodeRef, true);
            Object var38_54 = null;
        }
        catch (Throwable throwable) {
            Object var38_55 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferDefinition definition = new TransferDefinition();
            nodes = new HashSet();
            nodes.add(contentNodeRef);
            definition.setNodes(nodes);
            this.transferService.transfer(targetName, definition);
            Object var40_57 = null;
        }
        catch (Throwable throwable) {
            Object var40_58 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            destNodeRef = testNodeFactory.getMappedNodeRef(contentNodeRef);
            TransferServiceImplTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)destNodeRef.equals((Object)transferMe.getNodeRef()));
            TransferServiceImplTest.assertTrue((String)"dest node ref does not exist", (boolean)this.nodeService.exists(destNodeRef));
            TransferServiceImplTest.assertEquals((String)"title is wrong", (String)((String)((Object)this.nodeService.getProperty(destNodeRef, ContentModel.PROP_TITLE))), (String)CONTENT_TITLE);
            TransferServiceImplTest.assertEquals((String)"type is wrong", (Object)this.nodeService.getType(contentNodeRef), (Object)this.nodeService.getType(destNodeRef));
            boolean srcInherit = this.permissionService.getInheritParentPermissions(contentNodeRef);
            srcPerm = this.permissionService.getAllSetPermissions(contentNodeRef);
            destInherit = this.permissionService.getInheritParentPermissions(destNodeRef);
            destPerm = this.permissionService.getAllSetPermissions(destNodeRef);
            TransferServiceImplTest.assertTrue((String)"inherit parent permissions (src) flag is incorrect", (boolean)srcInherit);
            TransferServiceImplTest.assertTrue((String)"inherit parent permissions (dest) flag is incorrect", (boolean)destInherit);
            for (AccessPermission p : srcPerm) {
                if (!p.isSetDirectly()) continue;
                this.logger.debug((Object)("checking permission :" + p));
                TransferServiceImplTest.assertTrue((String)("permission is missing:" + p), (boolean)destPerm.contains(p));
            }
            Object var42_60 = null;
        }
        catch (Throwable throwable) {
            Object var42_61 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadOnlyFlag() throws Exception {
        TransferDefinition definition;
        NodeRef nodeD;
        NodeRef nodeC;
        NodeRef nodeB;
        NodeRef nodeA;
        this.setDefaultRollback(false);
        String CONTENT_TITLE = "ContentTitle";
        String CONTENT_TITLE_UPDATED = "ContentTitleUpdated";
        String CONTENT_NAME = "Demo Node 1";
        Locale CONTENT_LOCALE = Locale.GERMAN;
        String CONTENT_STRING = "The quick brown fox";
        HashSet<NodeRef> nodes = new HashSet<NodeRef>();
        String USER_ONE = "TransferServiceImplTest";
        String PASSWORD = "Password";
        String targetName = "testReadOnlyFlag";
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter(transmitter);
        UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory(testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)PathHelper.stringToPath(this.GUEST_HOME_XPATH_QUERY), (Object)PathHelper.stringToPath(this.COMPANY_HOME_XPATH_QUERY)));
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        this.startNewTransaction();
        try {
            String guestHomeQuery = "/app:company_home/app:guest_home";
            ResultSet guestHomeResult = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", guestHomeQuery);
            TransferServiceImplTest.assertEquals((String)"", (int)1, (int)guestHomeResult.length());
            NodeRef guestHome = guestHomeResult.getNodeRef(0);
            String guid = GUID.generate();
            ChildAssociationRef child = this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)guid), ContentModel.TYPE_FOLDER);
            nodeA = child.getChildRef();
            this.nodeService.setProperty(nodeA, ContentModel.PROP_TITLE, (Serializable)((Object)guid));
            this.nodeService.setProperty(nodeA, ContentModel.PROP_NAME, (Serializable)((Object)guid));
            nodes.add(nodeA);
            child = this.nodeService.createNode(nodeA, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"testNodeB"), ContentModel.TYPE_CONTENT);
            nodeB = child.getChildRef();
            this.nodeService.setProperty(nodeB, ContentModel.PROP_TITLE, (Serializable)((Object)(CONTENT_TITLE + "B")));
            this.nodeService.setProperty(nodeB, ContentModel.PROP_NAME, (Serializable)((Object)"DemoNodeB"));
            ContentWriter writer = this.contentService.getWriter(nodeB, ContentModel.PROP_CONTENT, true);
            writer.setLocale(CONTENT_LOCALE);
            writer.putContent(CONTENT_STRING);
            nodes.add(nodeB);
            child = this.nodeService.createNode(nodeA, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testNodeC"), ContentModel.TYPE_FOLDER);
            nodeC = child.getChildRef();
            this.nodeService.setProperty(nodeC, ContentModel.PROP_TITLE, (Serializable)((Object)"TestNodeC"));
            this.nodeService.setProperty(nodeC, ContentModel.PROP_NAME, (Serializable)((Object)"TestNodeC"));
            nodes.add(nodeC);
            child = this.nodeService.createNode(nodeC, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"testNodeD"), ContentModel.TYPE_CONTENT);
            nodeD = child.getChildRef();
            this.nodeService.setProperty(nodeD, ContentModel.PROP_TITLE, (Serializable)((Object)(CONTENT_TITLE + "D")));
            this.nodeService.setProperty(nodeD, ContentModel.PROP_NAME, (Serializable)((Object)"DemoNodeD"));
            writer = this.contentService.getWriter(nodeD, ContentModel.PROP_CONTENT, true);
            writer.setLocale(CONTENT_LOCALE);
            writer.putContent(CONTENT_STRING);
            nodes.add(nodeD);
            this.createUser(USER_ONE, PASSWORD);
            if (!this.transferService.targetExists(targetName)) {
                TransferTarget transferMe = this.createTransferTarget(targetName);
            } else {
                TransferTarget transferMe = this.transferService.getTransferTarget(targetName);
            }
            Object var26_26 = null;
        }
        catch (Throwable throwable) {
            Object var26_27 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.logger.debug((Object)"transfer read only - step 1");
        this.startNewTransaction();
        try {
            definition = new TransferDefinition();
            definition.setNodes(nodes);
            definition.setReadOnly(true);
            this.transferService.transfer(targetName, definition);
            Object var28_29 = null;
        }
        catch (Throwable throwable) {
            Object var28_30 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferServiceImplTest.assertTrue((String)"dest node A does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(nodeA)));
            TransferServiceImplTest.assertTrue((String)"dest node B does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(nodeB)));
            TransferServiceImplTest.assertTrue((String)"dest node C does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(nodeC)));
            TransferServiceImplTest.assertTrue((String)"dest node D does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(nodeD)));
            TransferServiceImplTest.assertTrue((String)"dest node A not locked", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(nodeA), ContentModel.ASPECT_LOCKABLE));
            TransferServiceImplTest.assertTrue((String)"dest node B not locked", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(nodeB), ContentModel.ASPECT_LOCKABLE));
            TransferServiceImplTest.assertTrue((String)"dest node C not locked", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(nodeC), ContentModel.ASPECT_LOCKABLE));
            TransferServiceImplTest.assertTrue((String)"dest node D not locked", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(nodeD), ContentModel.ASPECT_LOCKABLE));
            Object var30_32 = null;
        }
        catch (Throwable throwable) {
            Object var30_33 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            AuthenticationUtil.pushAuthentication();
            AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
            this.lockService.lock(nodeB, LockType.READ_ONLY_LOCK);
            Object var32_35 = null;
        }
        catch (Throwable throwable) {
            Object var32_36 = null;
            TransferServiceImplTest.assertEquals((String)"test error: dest node B lock ownership", (Object)this.nodeService.getProperty(nodeB, ContentModel.PROP_LOCK_OWNER), (Object)USER_ONE);
            AuthenticationUtil.popAuthentication();
            this.endTransaction();
            throw throwable;
        }
        TransferServiceImplTest.assertEquals((String)"test error: dest node B lock ownership", (Object)this.nodeService.getProperty(nodeB, ContentModel.PROP_LOCK_OWNER), (Object)USER_ONE);
        AuthenticationUtil.popAuthentication();
        this.endTransaction();
        this.logger.debug((Object)"transfer read only - step 2");
        this.startNewTransaction();
        try {
            definition = new TransferDefinition();
            definition.setNodes(nodes);
            definition.setReadOnly(true);
            this.transferService.transfer(targetName, definition);
            Object var34_38 = null;
        }
        catch (Throwable throwable) {
            Object var34_39 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferServiceImplTest.assertTrue((String)"dest node A does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(nodeA)));
            TransferServiceImplTest.assertTrue((String)"dest node B does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(nodeB)));
            TransferServiceImplTest.assertTrue((String)"dest node C does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(nodeC)));
            TransferServiceImplTest.assertTrue((String)"dest node D does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(nodeD)));
            TransferServiceImplTest.assertTrue((String)"dest node A not locked", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(nodeA), ContentModel.ASPECT_LOCKABLE));
            TransferServiceImplTest.assertTrue((String)"dest node B not locked", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(nodeB), ContentModel.ASPECT_LOCKABLE));
            TransferServiceImplTest.assertTrue((String)"dest node C not locked", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(nodeC), ContentModel.ASPECT_LOCKABLE));
            TransferServiceImplTest.assertTrue((String)"dest node D not locked", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(nodeD), ContentModel.ASPECT_LOCKABLE));
            TransferServiceImplTest.assertTrue((String)"lock owner not changed", (!USER_ONE.equalsIgnoreCase((String)((Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(nodeB), ContentModel.PROP_LOCK_OWNER))) ? 1 : 0) != 0);
            Object var36_41 = null;
        }
        catch (Throwable throwable) {
            Object var36_42 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            AuthenticationUtil.pushAuthentication();
            AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
            this.lockService.lock(nodeC, LockType.READ_ONLY_LOCK);
            Object var38_44 = null;
        }
        catch (Throwable throwable) {
            Object var38_45 = null;
            TransferServiceImplTest.assertEquals((String)"test error: dest node C lock ownership", (Object)this.nodeService.getProperty(nodeC, ContentModel.PROP_LOCK_OWNER), (Object)USER_ONE);
            AuthenticationUtil.popAuthentication();
            this.endTransaction();
            throw throwable;
        }
        TransferServiceImplTest.assertEquals((String)"test error: dest node C lock ownership", (Object)this.nodeService.getProperty(nodeC, ContentModel.PROP_LOCK_OWNER), (Object)USER_ONE);
        AuthenticationUtil.popAuthentication();
        this.endTransaction();
        this.logger.debug((Object)"transfer read only - step 3");
        this.startNewTransaction();
        try {
            definition = new TransferDefinition();
            definition.setNodes(nodes);
            definition.setReadOnly(true);
            this.transferService.transfer(targetName, definition);
            Object var40_47 = null;
        }
        catch (Throwable throwable) {
            Object var40_48 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferServiceImplTest.assertTrue((String)"dest node A does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(nodeA)));
            TransferServiceImplTest.assertTrue((String)"dest node B does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(nodeB)));
            TransferServiceImplTest.assertTrue((String)"dest node C does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(nodeC)));
            TransferServiceImplTest.assertTrue((String)"dest node D does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(nodeD)));
            TransferServiceImplTest.assertTrue((String)"dest node A not locked", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(nodeA), ContentModel.ASPECT_LOCKABLE));
            TransferServiceImplTest.assertTrue((String)"dest node B not locked", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(nodeB), ContentModel.ASPECT_LOCKABLE));
            TransferServiceImplTest.assertTrue((String)"dest node C not locked", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(nodeC), ContentModel.ASPECT_LOCKABLE));
            TransferServiceImplTest.assertTrue((String)"dest node D not locked", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(nodeD), ContentModel.ASPECT_LOCKABLE));
            TransferServiceImplTest.assertTrue((String)"lock owner not changed", (!USER_ONE.equalsIgnoreCase((String)((Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(nodeB), ContentModel.PROP_LOCK_OWNER))) ? 1 : 0) != 0);
            TransferServiceImplTest.assertTrue((String)"lock owner not changed", (!USER_ONE.equalsIgnoreCase((String)((Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(nodeC), ContentModel.PROP_LOCK_OWNER))) ? 1 : 0) != 0);
            Object var42_50 = null;
        }
        catch (Throwable throwable) {
            Object var42_51 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.logger.debug((Object)"transfer read only - step 4");
        this.startNewTransaction();
        try {
            definition = new TransferDefinition();
            definition.setNodes(nodes);
            definition.setReadOnly(false);
            this.transferService.transfer(targetName, definition);
            Object var44_53 = null;
        }
        catch (Throwable throwable) {
            Object var44_54 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferServiceImplTest.assertTrue((String)"dest node A does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(nodeA)));
            TransferServiceImplTest.assertTrue((String)"dest node B does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(nodeB)));
            TransferServiceImplTest.assertTrue((String)"dest node C does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(nodeC)));
            TransferServiceImplTest.assertTrue((String)"dest node D does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(nodeD)));
            TransferServiceImplTest.assertFalse((String)"dest node A not locked", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(nodeA), ContentModel.ASPECT_LOCKABLE));
            TransferServiceImplTest.assertTrue((String)"dest node B not locked", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(nodeB), ContentModel.ASPECT_LOCKABLE));
            TransferServiceImplTest.assertTrue((String)"dest node C not locked", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(nodeC), ContentModel.ASPECT_LOCKABLE));
            TransferServiceImplTest.assertFalse((String)"dest node D not locked", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(nodeD), ContentModel.ASPECT_LOCKABLE));
            TransferServiceImplTest.assertEquals((String)"dest node B lock ownership", (Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(nodeB), ContentModel.PROP_LOCK_OWNER), (Object)USER_ONE);
            TransferServiceImplTest.assertEquals((String)"dest node C lock ownership", (Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(nodeC), ContentModel.PROP_LOCK_OWNER), (Object)USER_ONE);
            Object var46_56 = null;
        }
        catch (Throwable throwable) {
            Object var46_57 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.logger.debug((Object)"transfer read only - step 5");
        this.startNewTransaction();
        try {
            this.lockService.unlock(nodeB);
            this.lockService.unlock(nodeC);
            Object var48_59 = null;
        }
        catch (Throwable throwable) {
            Object var48_60 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            definition = new TransferDefinition();
            definition.setNodes(nodes);
            definition.setReadOnly(false);
            this.transferService.transfer(targetName, definition);
            Object var50_62 = null;
        }
        catch (Throwable throwable) {
            Object var50_63 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferServiceImplTest.assertTrue((String)"dest node A does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(nodeA)));
            TransferServiceImplTest.assertTrue((String)"dest node B does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(nodeB)));
            TransferServiceImplTest.assertTrue((String)"dest node C does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(nodeC)));
            TransferServiceImplTest.assertTrue((String)"dest node D does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(nodeD)));
            TransferServiceImplTest.assertFalse((String)"test fail: dest node B is still locked", (boolean)this.nodeService.hasAspect(nodeB, ContentModel.ASPECT_LOCKABLE));
            TransferServiceImplTest.assertFalse((String)"test fail: dest node C is still locked", (boolean)this.nodeService.hasAspect(nodeC, ContentModel.ASPECT_LOCKABLE));
            TransferServiceImplTest.assertFalse((String)"dest node A not locked", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(nodeA), ContentModel.ASPECT_LOCKABLE));
            TransferServiceImplTest.assertFalse((String)"dest node B not locked", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(nodeB), ContentModel.ASPECT_LOCKABLE));
            TransferServiceImplTest.assertFalse((String)"dest node C not locked", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(nodeC), ContentModel.ASPECT_LOCKABLE));
            TransferServiceImplTest.assertFalse((String)"dest node D not locked", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(nodeD), ContentModel.ASPECT_LOCKABLE));
            Object var52_65 = null;
        }
        catch (Throwable throwable) {
            Object var52_66 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTwoRepoSync() throws Exception {
        NodeRef A7NodeRef;
        ContentWriter writer;
        NodeRef B6NodeRef;
        ChildAssociationRef child;
        TransferDefinition definition;
        NodeRef A5NodeRef;
        NodeRef A4NodeRef;
        NodeRef A3NodeRef;
        NodeRef A2NodeRef;
        NodeRef A1NodeRef;
        this.setDefaultRollback(false);
        String CONTENT_TITLE = "ContentTitle";
        String CONTENT_TITLE_UPDATED = "ContentTitleUpdated";
        Locale CONTENT_LOCALE = Locale.GERMAN;
        String CONTENT_STRING = "Hello";
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter(transmitter);
        UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory(testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)PathHelper.stringToPath(this.GUEST_HOME_XPATH_QUERY), (Object)PathHelper.stringToPath(this.COMPANY_HOME_XPATH_QUERY)));
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        String repositoryId = this.REPO_ID_A;
        String targetName = "testTransferSyncNodes";
        this.startNewTransaction();
        try {
            String guestHomeQuery = "/app:company_home/app:guest_home";
            ResultSet guestHomeResult = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", guestHomeQuery);
            TransferServiceImplTest.assertEquals((String)"", (int)1, (int)guestHomeResult.length());
            NodeRef guestHome = guestHomeResult.getNodeRef(0);
            String name = GUID.generate();
            ChildAssociationRef child2 = this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_FOLDER);
            A1NodeRef = child2.getChildRef();
            this.nodeService.setProperty(A1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(A1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
            ChildAssociationRef child3 = this.nodeService.createNode(A1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A2"), ContentModel.TYPE_FOLDER);
            A2NodeRef = child3.getChildRef();
            this.nodeService.setProperty(A2NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(A2NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A2"));
            child3 = this.nodeService.createNode(A1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A3"), ContentModel.TYPE_CONTENT);
            A3NodeRef = child3.getChildRef();
            this.nodeService.setProperty(A3NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(A3NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A3"));
            ContentWriter writer2 = this.contentService.getWriter(A3NodeRef, ContentModel.PROP_CONTENT, true);
            writer2.setLocale(CONTENT_LOCALE);
            writer2.putContent(CONTENT_STRING);
            child3 = this.nodeService.createNode(A2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A4"), ContentModel.TYPE_CONTENT);
            A4NodeRef = child3.getChildRef();
            this.nodeService.setProperty(A4NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(A4NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A4"));
            writer2 = this.contentService.getWriter(A4NodeRef, ContentModel.PROP_CONTENT, true);
            writer2.setLocale(CONTENT_LOCALE);
            writer2.putContent(CONTENT_STRING);
            child3 = this.nodeService.createNode(A2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A5"), ContentModel.TYPE_CONTENT);
            A5NodeRef = child3.getChildRef();
            this.nodeService.setProperty(A5NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(A5NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A5"));
            writer2 = this.contentService.getWriter(A5NodeRef, ContentModel.PROP_CONTENT, true);
            writer2.setLocale(CONTENT_LOCALE);
            writer2.putContent(CONTENT_STRING);
            if (!this.transferService.targetExists(targetName)) {
                TransferTarget transferMe = this.createTransferTarget(targetName);
            } else {
                TransferTarget transferMe = this.transferService.getTransferTarget(targetName);
            }
            Object var25_23 = null;
        }
        catch (Throwable throwable) {
            Object var25_24 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        HashSet<NodeRef> nodes = new HashSet<NodeRef>();
        nodes.add(A1NodeRef);
        nodes.add(A2NodeRef);
        nodes.add(A3NodeRef);
        nodes.add(A4NodeRef);
        nodes.add(A5NodeRef);
        this.startNewTransaction();
        try {
            definition = new TransferDefinition();
            definition.setNodes(nodes);
            definition.setSync(true);
            this.transferService.transfer(targetName, definition);
            Object var27_26 = null;
        }
        catch (Throwable throwable) {
            Object var27_27 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            NodeRef a1Dest = testNodeFactory.getMappedNodeRef(A1NodeRef);
            TransferServiceImplTest.assertTrue((String)"dest node A does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A1NodeRef)));
            TransferServiceImplTest.assertEquals((String)"dest node A1 From RepositoryId", (Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(A1NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)repositoryId);
            TransferServiceImplTest.assertEquals((String)"dest node A1 Repository Id", (Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(A1NodeRef), TransferModel.PROP_REPOSITORY_ID), (Object)repositoryId);
            TransferServiceImplTest.assertEquals((String)"dest node A2 From RepositoryId", (Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(A2NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)repositoryId);
            TransferServiceImplTest.assertEquals((String)"dest node A2 Repository Id", (Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(A2NodeRef), TransferModel.PROP_REPOSITORY_ID), (Object)repositoryId);
            TransferServiceImplTest.assertEquals((String)"dest node A3 From RepositoryId", (Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(A3NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)repositoryId);
            TransferServiceImplTest.assertEquals((String)"dest node A3 Repository Id", (Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(A3NodeRef), TransferModel.PROP_REPOSITORY_ID), (Object)repositoryId);
            TransferServiceImplTest.assertEquals((String)"dest node A4 From RepositoryId", (Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(A4NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)repositoryId);
            TransferServiceImplTest.assertEquals((String)"dest node A4 Repository Id", (Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(A4NodeRef), TransferModel.PROP_REPOSITORY_ID), (Object)repositoryId);
            TransferServiceImplTest.assertEquals((String)"dest node A5 From RepositoryId", (Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(A5NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)repositoryId);
            TransferServiceImplTest.assertEquals((String)"dest node A5 Repository Id", (Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(A5NodeRef), TransferModel.PROP_REPOSITORY_ID), (Object)repositoryId);
            child = this.nodeService.createNode(a1Dest, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B6"), ContentModel.TYPE_CONTENT);
            B6NodeRef = child.getChildRef();
            this.nodeService.setProperty(B6NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(B6NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B6"));
            writer = this.contentService.getWriter(B6NodeRef, ContentModel.PROP_CONTENT, true);
            writer.setLocale(CONTENT_LOCALE);
            writer.putContent(CONTENT_STRING);
            Object var29_30 = null;
        }
        catch (Throwable throwable) {
            Object var29_31 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            definition = new TransferDefinition();
            definition.setNodes(nodes);
            definition.setSync(true);
            this.transferService.transfer(targetName, definition);
            Object var31_33 = null;
        }
        catch (Throwable throwable) {
            Object var31_34 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferServiceImplTest.assertTrue((String)"dest node B6 does not exist", (boolean)this.nodeService.exists(B6NodeRef));
            TransferServiceImplTest.assertTrue((String)"B6 not alien", (boolean)this.nodeService.hasAspect(B6NodeRef, TransferModel.ASPECT_ALIEN));
            Object var33_36 = null;
        }
        catch (Throwable throwable) {
            Object var33_37 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        String NEW_TITLE = "Chain sync";
        this.startNewTransaction();
        try {
            this.nodeService.setProperty(A1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)NEW_TITLE));
            this.nodeService.setProperty(A1NodeRef, TransferModel.PROP_FROM_REPOSITORY_ID, (Serializable)((Object)this.REPO_ID_B));
            this.nodeService.setProperty(A1NodeRef, TransferModel.PROP_REPOSITORY_ID, (Serializable)((Object)this.REPO_ID_B));
            this.nodeService.setProperty(A2NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)NEW_TITLE));
            this.nodeService.setProperty(A2NodeRef, TransferModel.PROP_FROM_REPOSITORY_ID, (Serializable)((Object)this.REPO_ID_B));
            this.nodeService.setProperty(A2NodeRef, TransferModel.PROP_REPOSITORY_ID, (Serializable)((Object)this.REPO_ID_B));
            this.nodeService.setProperty(A3NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)NEW_TITLE));
            this.nodeService.setProperty(A3NodeRef, TransferModel.PROP_FROM_REPOSITORY_ID, (Serializable)((Object)this.REPO_ID_B));
            this.nodeService.setProperty(A3NodeRef, TransferModel.PROP_REPOSITORY_ID, (Serializable)((Object)this.REPO_ID_B));
            child = this.nodeService.createNode(A2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A7"), ContentModel.TYPE_CONTENT);
            A7NodeRef = child.getChildRef();
            this.nodeService.setProperty(A7NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)NEW_TITLE));
            this.nodeService.setProperty(A7NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A7"));
            this.nodeService.setProperty(A7NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)NEW_TITLE));
            this.nodeService.setProperty(A7NodeRef, TransferModel.PROP_FROM_REPOSITORY_ID, (Serializable)((Object)this.REPO_ID_B));
            this.nodeService.setProperty(A7NodeRef, TransferModel.PROP_REPOSITORY_ID, (Serializable)((Object)this.REPO_ID_B));
            writer = this.contentService.getWriter(A3NodeRef, ContentModel.PROP_CONTENT, true);
            writer.setLocale(CONTENT_LOCALE);
            writer.putContent(CONTENT_STRING);
            Object var35_40 = null;
        }
        catch (Throwable throwable) {
            Object var35_41 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        nodes.add(A7NodeRef);
        this.startNewTransaction();
        try {
            TransferDefinition definition2 = new TransferDefinition();
            definition2.setNodes(nodes);
            definition2.setSync(true);
            this.transferService.transfer(targetName, definition2);
            Object var37_43 = null;
        }
        catch (Throwable throwable) {
            Object var37_44 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        try {
            TransferServiceImplTest.assertTrue((String)"dest node A7 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A7NodeRef)));
            TransferServiceImplTest.assertEquals((String)"dest node A1 Title", (Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(A1NodeRef), ContentModel.PROP_TITLE), (Object)NEW_TITLE);
            TransferServiceImplTest.assertEquals((String)"dest node A1 Repository Id", (Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(A1NodeRef), TransferModel.PROP_REPOSITORY_ID), (Object)this.REPO_ID_B);
            TransferServiceImplTest.assertEquals((String)"dest node A1 Repository Id", (Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(A1NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)repositoryId);
            TransferServiceImplTest.assertEquals((String)"dest node A2 Title", (Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(A2NodeRef), ContentModel.PROP_TITLE), (Object)NEW_TITLE);
            TransferServiceImplTest.assertEquals((String)"dest node A2 Repository Id", (Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(A2NodeRef), TransferModel.PROP_REPOSITORY_ID), (Object)this.REPO_ID_B);
            TransferServiceImplTest.assertEquals((String)"dest node A2 Repository Id", (Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(A2NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)repositoryId);
            TransferServiceImplTest.assertEquals((String)"dest node A3 Title", (Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(A3NodeRef), ContentModel.PROP_TITLE), (Object)NEW_TITLE);
            TransferServiceImplTest.assertEquals((String)"dest node A3 Repository Id", (Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(A3NodeRef), TransferModel.PROP_REPOSITORY_ID), (Object)this.REPO_ID_B);
            TransferServiceImplTest.assertEquals((String)"dest node A3 Repository Id", (Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(A3NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)repositoryId);
            Object var39_46 = null;
        }
        catch (Throwable throwable) {
            Object var39_47 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiRepoTransfer() throws Exception {
        ChildAssociationRef A3Ref;
        ArrayList<Object> nodes;
        TransferDefinition definition;
        NodeRef C4NodeRef;
        NodeRef A3Dummy;
        NodeRef C3NodeRef;
        NodeRef C2NodeRef;
        NodeRef C1NodeRef;
        NodeRef B1NodeRef;
        NodeRef A3NodeRef;
        NodeRef A2NodeRef;
        NodeRef A1NodeRef;
        this.setDefaultRollback(false);
        String CONTENT_TITLE = "ContentTitle";
        String CONTENT_TITLE_UPDATED = "ContentTitleUpdated";
        Locale CONTENT_LOCALE = Locale.GERMAN;
        String CONTENT_STRING = "Hello";
        String targetName = "testMultiRepoTransfer";
        this.startNewTransaction();
        try {
            String guestHomeQuery = "/app:company_home/app:guest_home";
            ResultSet guestHomeResult = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", guestHomeQuery);
            TransferServiceImplTest.assertEquals((String)"", (int)1, (int)guestHomeResult.length());
            NodeRef guestHome = guestHomeResult.getNodeRef(0);
            String name = GUID.generate();
            ChildAssociationRef child = this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_FOLDER);
            NodeRef S0NodeRef = child.getChildRef();
            this.nodeService.setProperty(S0NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(S0NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
            ChildAssociationRef child2 = this.nodeService.createNode(S0NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A1"), ContentModel.TYPE_FOLDER);
            A1NodeRef = child2.getChildRef();
            this.nodeService.setProperty(A1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"A1"));
            this.nodeService.setProperty(A1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A1"));
            child2 = this.nodeService.createNode(A1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"images"), ContentModel.TYPE_FOLDER);
            A2NodeRef = child2.getChildRef();
            this.nodeService.setProperty(A2NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"images"));
            this.nodeService.setProperty(A2NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"images"));
            child2 = this.nodeService.createNode(A2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A3"), ContentModel.TYPE_FOLDER);
            A3NodeRef = child2.getChildRef();
            this.nodeService.setProperty(A3NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"A3"));
            this.nodeService.setProperty(A3NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A3"));
            child2 = this.nodeService.createNode(S0NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B1"), ContentModel.TYPE_FOLDER);
            B1NodeRef = child2.getChildRef();
            this.nodeService.setProperty(B1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"B1"));
            this.nodeService.setProperty(B1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B1"));
            child2 = this.nodeService.createNode(S0NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"C1"), ContentModel.TYPE_FOLDER);
            C1NodeRef = child2.getChildRef();
            this.nodeService.setProperty(C1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"C1"));
            this.nodeService.setProperty(C1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"C1"));
            child2 = this.nodeService.createNode(C1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"images"), ContentModel.TYPE_FOLDER);
            C2NodeRef = child2.getChildRef();
            this.nodeService.setProperty(C2NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(C2NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"images"));
            child2 = this.nodeService.createNode(C2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"C3"), ContentModel.TYPE_FOLDER);
            C3NodeRef = child2.getChildRef();
            this.nodeService.setProperty(C3NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(C3NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"C3"));
            child2 = this.nodeService.createNode(C2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A3"), ContentModel.TYPE_FOLDER);
            A3Dummy = child2.getChildRef();
            this.nodeService.setProperty(A3Dummy, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(A3Dummy, ContentModel.PROP_NAME, (Serializable)((Object)"A3 Dummy"));
            child2 = this.nodeService.createNode(A3Dummy, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"C4"), ContentModel.TYPE_FOLDER);
            C4NodeRef = child2.getChildRef();
            this.nodeService.setProperty(C4NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(C4NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"C4"));
            if (!this.transferService.targetExists(targetName)) {
                TransferTarget transferMe = this.createTransferTarget(targetName);
            } else {
                TransferTarget transferMe = this.transferService.getTransferTarget(targetName);
            }
            Object var23_23 = null;
        }
        catch (Throwable throwable) {
            Object var23_24 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter(transmitter);
        UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory(testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        this.nodeService.getPath(A2NodeRef);
        pathMap.add((Pair<Path, Path>)new Pair((Object)this.nodeService.getPath(A1NodeRef), (Object)this.nodeService.getPath(B1NodeRef)));
        pathMap.add((Pair<Path, Path>)new Pair((Object)this.nodeService.getPath(C1NodeRef), (Object)this.nodeService.getPath(B1NodeRef)));
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        this.startNewTransaction();
        try {
            definition = new TransferDefinition();
            nodes = new ArrayList<NodeRef>();
            nodes.add(A1NodeRef);
            nodes.add(A2NodeRef);
            nodes.add(A3NodeRef);
            definition.setNodes(nodes);
            definition.setSync(true);
            this.transferService.transfer(targetName, definition);
            Object var25_27 = null;
        }
        catch (Throwable throwable) {
            Object var25_28 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferServiceImplTest.assertTrue((String)"dest node A2 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A2NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node A3 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A3NodeRef)));
            A3Ref = this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(A3NodeRef));
            TransferServiceImplTest.assertEquals((String)"A3 dest is connected to the wrong node", (Object)A3Ref.getParentRef(), (Object)testNodeFactory.getMappedNodeRef(A2NodeRef));
            ChildAssociationRef A2Ref = this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(A2NodeRef));
            TransferServiceImplTest.assertEquals((String)"A2 dest is connected to the wrong node", (Object)A2Ref.getParentRef(), (Object)B1NodeRef);
            TransferServiceImplTest.assertEquals((String)"A2 dest owned by wrong repo", (Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(A2NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)this.REPO_ID_A);
            TransferServiceImplTest.assertEquals((String)"A3 dest owned by wrong repo", (Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(A3NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)this.REPO_ID_A);
            Object var27_30 = null;
        }
        catch (Throwable throwable) {
            Object var27_31 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_C);
            this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
            definition = new TransferDefinition();
            nodes = new ArrayList();
            nodes.add(C1NodeRef);
            nodes.add(C2NodeRef);
            nodes.add(C3NodeRef);
            definition.setNodes(nodes);
            definition.setSync(true);
            this.transferService.transfer(targetName, definition);
            Object var29_33 = null;
        }
        catch (Throwable throwable) {
            Object var29_34 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferServiceImplTest.assertTrue((String)"dest node A3 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A3NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node C3 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(C3NodeRef)));
            A3Ref = this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(A3NodeRef));
            TransferServiceImplTest.assertEquals((String)"A3 dest is connected to the wrong node", (Object)A3Ref.getParentRef(), (Object)testNodeFactory.getMappedNodeRef(A2NodeRef));
            ChildAssociationRef C3Ref = this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(A3NodeRef));
            TransferServiceImplTest.assertEquals((String)"C3 dest is connected to the wrong node", (Object)C3Ref.getParentRef(), (Object)testNodeFactory.getMappedNodeRef(A2NodeRef));
            ChildAssociationRef A2Ref = this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(A2NodeRef));
            TransferServiceImplTest.assertEquals((String)"A2 dest is connected to the wrong node", (Object)A2Ref.getParentRef(), (Object)B1NodeRef);
            TransferServiceImplTest.assertTrue((String)"A2 dest is not invaded", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(A2NodeRef), TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertTrue((String)"C3 dest is not invaded", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(C3NodeRef), TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertFalse((String)"A3 dest is invaded", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(A3NodeRef), TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertEquals((String)"A2 dest owned by wrong repo", (Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(A2NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)this.REPO_ID_A);
            TransferServiceImplTest.assertEquals((String)"A3 dest owned by wrong repo", (Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(A3NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)this.REPO_ID_A);
            TransferServiceImplTest.assertEquals((String)"C3 dest owned by wrong repo", (Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(C3NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)this.REPO_ID_C);
            Object var31_36 = null;
        }
        catch (Throwable throwable) {
            Object var31_37 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_C);
            this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
            definition = new TransferDefinition();
            nodes = new ArrayList();
            nodes.add(C4NodeRef);
            definition.setNodes(nodes);
            definition.setSync(false);
            this.transferService.transfer(targetName, definition);
            Object var33_39 = null;
        }
        catch (Throwable throwable) {
            Object var33_40 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferServiceImplTest.assertTrue((String)"dest node A3 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A3NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node C3 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(C3NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node C4 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(C4NodeRef)));
            TransferServiceImplTest.assertTrue((String)"C4 is not an invader", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(C4NodeRef), TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertTrue((String)"A3 is not an invader", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(A3NodeRef), TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertEquals((String)"A2 dest owned by wrong repo", (Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(A2NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)this.REPO_ID_A);
            TransferServiceImplTest.assertEquals((String)"A3 dest owned by wrong repo", (Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(A3NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)this.REPO_ID_A);
            TransferServiceImplTest.assertEquals((String)"C3 dest owned by wrong repo", (Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(C3NodeRef), TransferModel.PROP_FROM_REPOSITORY_ID), (Object)this.REPO_ID_C);
            Object var35_42 = null;
        }
        catch (Throwable throwable) {
            Object var35_43 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            this.nodeService.deleteNode(C4NodeRef);
            Object var37_45 = null;
        }
        catch (Throwable throwable) {
            Object var37_46 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_C);
            this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
            definition = new TransferDefinition();
            nodes = new ArrayList();
            nodes.add(A3Dummy);
            definition.setNodes(nodes);
            definition.setSync(true);
            this.transferService.transfer(targetName, definition);
            Object var39_48 = null;
        }
        catch (Throwable throwable) {
            Object var39_49 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferServiceImplTest.assertTrue((String)"dest node A3 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A3NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node C3 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(C3NodeRef)));
            TransferServiceImplTest.assertFalse((String)"dest node C4 not deleted", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(C4NodeRef)));
            this.logger.debug((Object)("A3 Dest is " + testNodeFactory.getMappedNodeRef(A3NodeRef)));
            TransferServiceImplTest.assertFalse((String)"A3 Dest still invaded by C4", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(A3NodeRef), TransferModel.ASPECT_ALIEN));
            Object var41_51 = null;
        }
        catch (Throwable throwable) {
            Object var41_52 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            this.nodeService.deleteNode(C3NodeRef);
            Object var43_54 = null;
        }
        catch (Throwable throwable) {
            Object var43_55 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_C);
            this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
            definition = new TransferDefinition();
            nodes = new ArrayList();
            NodeRef C3Deleted = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, C3NodeRef.getId());
            nodes.add(C3Deleted);
            definition.setNodes(nodes);
            definition.setSync(false);
            this.transferService.transfer(targetName, definition);
            Object var45_57 = null;
        }
        catch (Throwable throwable) {
            Object var45_58 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferServiceImplTest.assertTrue((String)"dest node A3 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A3NodeRef)));
            TransferServiceImplTest.assertFalse((String)"dest node C3 not deleted", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(C3NodeRef)));
            TransferServiceImplTest.assertFalse((String)"dest node C4 not deleted", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(C4NodeRef)));
            TransferServiceImplTest.assertFalse((String)"A3 still invaded", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(A3NodeRef), TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertFalse((String)"A2 still invaded", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(A2NodeRef), TransferModel.ASPECT_ALIEN));
            Object var47_60 = null;
        }
        catch (Throwable throwable) {
            Object var47_61 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    private TransferTarget createTransferTarget(String name) {
        String title = "title";
        String description = "description";
        String endpointProtocol = "http";
        String endpointHost = "MARKR02";
        int endpointPort = 7080;
        String endpointPath = "/alfresco/service/api/transfer";
        String username = "admin";
        char[] password = "admin".toCharArray();
        TransferTarget target = this.transferService.createAndSaveTransferTarget(name, title, description, endpointProtocol, endpointHost, endpointPort, endpointPath, username, password);
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiRepoTransferMove() throws Exception {
        NodeRef B6NodeRef;
        ChildAssociationRef A5Ref;
        ArrayList<Object> nodes;
        TransferDefinition definition;
        NodeRef A5NodeRef;
        NodeRef A4NodeRef;
        NodeRef C3DummyNodeRef;
        NodeRef C2DummyNodeRef;
        NodeRef C3NodeRef;
        NodeRef C2NodeRef;
        NodeRef C1NodeRef;
        NodeRef B1NodeRef;
        NodeRef A1NodeRef;
        ChildAssociationRef child;
        this.setDefaultRollback(false);
        String localRepositoryId = this.descriptorService.getCurrentRepositoryDescriptor().getId();
        String CONTENT_TITLE = "ContentTitle";
        String CONTENT_TITLE_UPDATED = "ContentTitleUpdated";
        Locale CONTENT_LOCALE = Locale.GERMAN;
        String CONTENT_STRING = "Hello";
        String targetName = "testMultiRepoTransferMove";
        QName C2Path = QName.createQName((String)"p2");
        QName C3Path = QName.createQName((String)"p3");
        this.startNewTransaction();
        try {
            String guestHomeQuery = "/app:company_home/app:guest_home";
            ResultSet guestHomeResult = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", guestHomeQuery);
            TransferServiceImplTest.assertEquals((String)"", (int)1, (int)guestHomeResult.length());
            NodeRef guestHome = guestHomeResult.getNodeRef(0);
            String name = GUID.generate();
            child = this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_FOLDER);
            NodeRef S0NodeRef = child.getChildRef();
            this.nodeService.setProperty(S0NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(S0NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
            ChildAssociationRef child2 = this.nodeService.createNode(S0NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A1"), ContentModel.TYPE_FOLDER);
            A1NodeRef = child2.getChildRef();
            this.nodeService.setProperty(A1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"A1"));
            this.nodeService.setProperty(A1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A1"));
            child2 = this.nodeService.createNode(S0NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B1"), ContentModel.TYPE_FOLDER);
            B1NodeRef = child2.getChildRef();
            this.nodeService.setProperty(B1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"B1"));
            this.nodeService.setProperty(B1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B1"));
            child2 = this.nodeService.createNode(S0NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"C1"), ContentModel.TYPE_FOLDER);
            C1NodeRef = child2.getChildRef();
            this.nodeService.setProperty(C1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"C1"));
            this.nodeService.setProperty(C1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"C1"));
            child2 = this.nodeService.createNode(C1NodeRef, ContentModel.ASSOC_CONTAINS, C2Path, ContentModel.TYPE_FOLDER);
            C2NodeRef = child2.getChildRef();
            this.nodeService.setProperty(C2NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"C2"));
            this.nodeService.setProperty(C2NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"C2"));
            child2 = this.nodeService.createNode(C1NodeRef, ContentModel.ASSOC_CONTAINS, C3Path, ContentModel.TYPE_FOLDER);
            C3NodeRef = child2.getChildRef();
            this.nodeService.setProperty(C3NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"C3"));
            this.nodeService.setProperty(C3NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"C3"));
            child2 = this.nodeService.createNode(A1NodeRef, ContentModel.ASSOC_CONTAINS, C2Path, ContentModel.TYPE_FOLDER);
            C2DummyNodeRef = child2.getChildRef();
            this.nodeService.setProperty(C2DummyNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(C2DummyNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"C2 Dummy"));
            child2 = this.nodeService.createNode(A1NodeRef, ContentModel.ASSOC_CONTAINS, C3Path, ContentModel.TYPE_FOLDER);
            C3DummyNodeRef = child2.getChildRef();
            this.nodeService.setProperty(C3DummyNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(C3DummyNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"C3 Dummy"));
            child2 = this.nodeService.createNode(A1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"C4"), ContentModel.TYPE_FOLDER);
            A4NodeRef = child2.getChildRef();
            this.nodeService.setProperty(A4NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"A4"));
            this.nodeService.setProperty(A4NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A4"));
            child2 = this.nodeService.createNode(C2DummyNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A5"), ContentModel.TYPE_FOLDER);
            A5NodeRef = child2.getChildRef();
            this.nodeService.setProperty(A5NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"A5"));
            this.nodeService.setProperty(A5NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A5"));
            if (!this.transferService.targetExists(targetName)) {
                TransferTarget transferMe = this.createTransferTarget(targetName);
            } else {
                TransferTarget transferMe = this.transferService.getTransferTarget(targetName);
            }
            Object var27_26 = null;
        }
        catch (Throwable throwable) {
            Object var27_27 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter(transmitter);
        UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory(testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)this.nodeService.getPath(A1NodeRef), (Object)this.nodeService.getPath(B1NodeRef)));
        pathMap.add((Pair<Path, Path>)new Pair((Object)this.nodeService.getPath(C1NodeRef), (Object)this.nodeService.getPath(B1NodeRef)));
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_C);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        this.startNewTransaction();
        try {
            definition = new TransferDefinition();
            nodes = new ArrayList<NodeRef>();
            nodes.add(C1NodeRef);
            nodes.add(C2NodeRef);
            nodes.add(C3NodeRef);
            definition.setNodes(nodes);
            definition.setSync(true);
            this.transferService.transfer(targetName, definition);
            Object var29_30 = null;
        }
        catch (Throwable throwable) {
            Object var29_31 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferServiceImplTest.assertTrue((String)"dest node C2 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(C2NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node C3 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(C3NodeRef)));
            ChildAssociationRef C3Ref = this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(C3NodeRef));
            TransferServiceImplTest.assertEquals((String)"A3 dest is connected to the wrong node", (Object)C3Ref.getParentRef(), (Object)B1NodeRef);
            ChildAssociationRef C2Ref = this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(C2NodeRef));
            TransferServiceImplTest.assertEquals((String)"A2 dest is connected to the wrong node", (Object)C2Ref.getParentRef(), (Object)B1NodeRef);
            Object var31_33 = null;
        }
        catch (Throwable throwable) {
            Object var31_34 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        this.startNewTransaction();
        try {
            definition = new TransferDefinition();
            nodes = new ArrayList();
            nodes.add(A4NodeRef);
            nodes.add(A5NodeRef);
            definition.setNodes(nodes);
            definition.setSync(true);
            this.transferService.transfer(targetName, definition);
            Object var33_36 = null;
        }
        catch (Throwable throwable) {
            Object var33_37 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferServiceImplTest.assertTrue((String)"dest node A5 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A5NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node C3 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(C3NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node C2 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(C2NodeRef)));
            A5Ref = this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(A5NodeRef));
            TransferServiceImplTest.assertEquals((String)"A5 dest is connected to the wrong node", (Object)A5Ref.getParentRef(), (Object)testNodeFactory.getMappedNodeRef(C2NodeRef));
            TransferServiceImplTest.assertTrue((String)"C2 dest is not invaded", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(C2NodeRef), TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertFalse((String)"C3 dest is not invaded", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(C3NodeRef), TransferModel.ASPECT_ALIEN));
            ChildAssociationRef A4Ref = this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(A4NodeRef));
            TransferServiceImplTest.assertEquals((String)"A4 dest is connected to the wrong node", (Object)A4Ref.getParentRef(), (Object)B1NodeRef);
            Object var35_39 = null;
        }
        catch (Throwable throwable) {
            Object var35_40 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            this.nodeService.moveNode(A5NodeRef, C3DummyNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"C4"));
            Object var37_42 = null;
        }
        catch (Throwable throwable) {
            Object var37_43 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            definition = new TransferDefinition();
            nodes = new ArrayList();
            nodes.add(A5NodeRef);
            definition.setNodes(nodes);
            definition.setSync(true);
            this.transferService.transfer(targetName, definition);
            Object var39_45 = null;
        }
        catch (Throwable throwable) {
            Object var39_46 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferServiceImplTest.assertTrue((String)"dest node A5 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A5NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node C3 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(C3NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node C2 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(C2NodeRef)));
            A5Ref = this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(A5NodeRef));
            TransferServiceImplTest.assertEquals((String)"A5 dest is connected to the wrong node", (Object)A5Ref.getParentRef(), (Object)testNodeFactory.getMappedNodeRef(C3NodeRef));
            TransferServiceImplTest.assertTrue((String)"A5 dest is not invaded", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(A5NodeRef), TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertTrue((String)"C3 dest is not invaded", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(C3NodeRef), TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertFalse((String)"C2 dest is still invaded", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(C2NodeRef), TransferModel.ASPECT_ALIEN));
            Object var41_48 = null;
        }
        catch (Throwable throwable) {
            Object var41_49 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            this.nodeService.moveNode(A5NodeRef, C2DummyNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B6"));
            child = this.nodeService.createNode(testNodeFactory.getMappedNodeRef(A5NodeRef), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B6"), ContentModel.TYPE_FOLDER);
            B6NodeRef = child.getChildRef();
            this.nodeService.setProperty(B6NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"B6"));
            this.nodeService.setProperty(B6NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B6"));
            Object var43_52 = null;
        }
        catch (Throwable throwable) {
            Object var43_53 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            definition = new TransferDefinition();
            nodes = new ArrayList();
            nodes.add(A5NodeRef);
            definition.setNodes(nodes);
            definition.setSync(true);
            this.transferService.transfer(targetName, definition);
            Object var45_55 = null;
        }
        catch (Throwable throwable) {
            Object var45_56 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferServiceImplTest.assertTrue((String)"dest node A5 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A5NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node C3 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(C3NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node C2 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(C2NodeRef)));
            A5Ref = this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(A5NodeRef));
            ChildAssociationRef B6Ref = this.nodeService.getPrimaryParent(B6NodeRef);
            TransferServiceImplTest.assertEquals((String)"A5 dest is connected to the wrong node", (Object)A5Ref.getParentRef(), (Object)testNodeFactory.getMappedNodeRef(C2NodeRef));
            TransferServiceImplTest.assertEquals((String)"B6 connected to the wrong node", (Object)B6Ref.getParentRef(), (Object)testNodeFactory.getMappedNodeRef(A5NodeRef));
            TransferServiceImplTest.assertTrue((String)"A5 dest is not invaded", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(A5NodeRef), TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertTrue((String)"C2 dest is not invaded", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(C2NodeRef), TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertFalse((String)"C3 dest is still invaded", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(C3NodeRef), TransferModel.ASPECT_ALIEN));
            List invaders = (List)((Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(C2NodeRef), TransferModel.PROP_INVADED_BY));
            TransferServiceImplTest.assertTrue((String)"invaders is too small", (invaders.size() > 1 ? 1 : 0) != 0);
            TransferServiceImplTest.assertTrue((String)"invaders does not contain REPO A", (boolean)invaders.contains(this.REPO_ID_A));
            TransferServiceImplTest.assertTrue((String)"invaders does not contain REPO B", (boolean)invaders.contains(localRepositoryId));
            Object var47_58 = null;
        }
        catch (Throwable throwable) {
            Object var47_59 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            this.nodeService.moveNode(A5NodeRef, A4NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A5"));
            Object var49_61 = null;
        }
        catch (Throwable throwable) {
            Object var49_62 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            definition = new TransferDefinition();
            nodes = new ArrayList();
            nodes.add(A5NodeRef);
            definition.setNodes(nodes);
            definition.setSync(true);
            this.transferService.transfer(targetName, definition);
            Object var51_64 = null;
        }
        catch (Throwable throwable) {
            Object var51_65 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferServiceImplTest.assertTrue((String)"dest node A5 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A5NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node C3 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(C3NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node C2 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(C2NodeRef)));
            A5Ref = this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(A5NodeRef));
            TransferServiceImplTest.assertEquals((String)"A5 dest is connected to the wrong node", (Object)A5Ref.getParentRef(), (Object)testNodeFactory.getMappedNodeRef(A4NodeRef));
            TransferServiceImplTest.assertTrue((String)"A4 dest is not invaded", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(A4NodeRef), TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertTrue((String)"A5 dest is not invaded", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(A5NodeRef), TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertTrue((String)"B6 dest is not invaded", (boolean)this.nodeService.hasAspect(B6NodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertFalse((String)"C2 dest is still invaded", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(C2NodeRef), TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertFalse((String)"C3 dest is still invaded", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(C3NodeRef), TransferModel.ASPECT_ALIEN));
            List invaders = (List)((Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(A4NodeRef), TransferModel.PROP_INVADED_BY));
            TransferServiceImplTest.assertTrue((String)"invaders is too big", (invaders.size() < 2 ? 1 : 0) != 0);
            TransferServiceImplTest.assertFalse((String)"invaders contains REPO A", (boolean)invaders.contains(this.REPO_ID_A));
            TransferServiceImplTest.assertTrue((String)"invaders does not contains REPO B", (boolean)invaders.contains(this.REPO_ID_B));
            Object var53_67 = null;
        }
        catch (Throwable throwable) {
            Object var53_68 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyTransferredNode() throws Exception {
        NodeRef B2NodeRef;
        NodeRef B1NodeRef;
        NodeRef A3NodeRef;
        NodeRef A2NodeRef;
        NodeRef A1NodeRef;
        this.setDefaultRollback(false);
        String CONTENT_TITLE = "ContentTitle";
        String targetName = "testCopyTransferredNode";
        this.startNewTransaction();
        try {
            String guestHomeQuery = "/app:company_home/app:guest_home";
            ResultSet guestHomeResult = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", guestHomeQuery);
            TransferServiceImplTest.assertEquals((String)"", (int)1, (int)guestHomeResult.length());
            NodeRef guestHome = guestHomeResult.getNodeRef(0);
            String name = GUID.generate();
            ChildAssociationRef child = this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_FOLDER);
            NodeRef S0NodeRef = child.getChildRef();
            this.nodeService.setProperty(S0NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(S0NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
            ChildAssociationRef child2 = this.nodeService.createNode(S0NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A1"), ContentModel.TYPE_FOLDER);
            A1NodeRef = child2.getChildRef();
            this.nodeService.setProperty(A1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"A1"));
            this.nodeService.setProperty(A1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A1"));
            child2 = this.nodeService.createNode(A1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A2"), ContentModel.TYPE_FOLDER);
            A2NodeRef = child2.getChildRef();
            this.nodeService.setProperty(A2NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"A2"));
            this.nodeService.setProperty(A2NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A2"));
            child2 = this.nodeService.createNode(A2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A3"), ContentModel.TYPE_FOLDER);
            A3NodeRef = child2.getChildRef();
            this.nodeService.setProperty(A3NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"A3"));
            this.nodeService.setProperty(A3NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A3"));
            child2 = this.nodeService.createNode(S0NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B1"), ContentModel.TYPE_FOLDER);
            B1NodeRef = child2.getChildRef();
            this.nodeService.setProperty(B1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"B1"));
            this.nodeService.setProperty(B1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B1"));
            child2 = this.nodeService.createNode(S0NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B2"), ContentModel.TYPE_FOLDER);
            B2NodeRef = child2.getChildRef();
            this.nodeService.setProperty(B1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"B2"));
            this.nodeService.setProperty(B1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B2"));
            TransferTarget transferMe = !this.transferService.targetExists(targetName) ? this.createTransferTarget(targetName) : this.transferService.getTransferTarget(targetName);
            Object var16_15 = null;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter(transmitter);
        UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory(testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)this.nodeService.getPath(A1NodeRef), (Object)this.nodeService.getPath(B1NodeRef)));
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        this.logger.debug((Object)"First transfer - ");
        this.startNewTransaction();
        try {
            TransferDefinition definition = new TransferDefinition();
            HashSet<NodeRef> nodes = new HashSet<NodeRef>();
            nodes.add(A2NodeRef);
            nodes.add(A3NodeRef);
            definition.setNodes(nodes);
            definition.setReadOnly(true);
            this.transferService.transfer(targetName, definition);
            Object var18_19 = null;
        }
        catch (Throwable throwable) {
            Object var18_20 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            NodeRef A2destNodeRef = testNodeFactory.getMappedNodeRef(A2NodeRef);
            TransferServiceImplTest.assertTrue((String)"dest node ref does not exist", (boolean)this.nodeService.exists(A2destNodeRef));
            NodeRef copiedNode = this.copyService.copy(A2destNodeRef, B2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A2Copy"));
            TransferServiceImplTest.assertTrue((String)"copied node does not exist", (boolean)this.nodeService.exists(copiedNode));
            System.out.println("copied node is " + copiedNode);
            TransferServiceImplTest.assertFalse((String)"copied node still has transferred aspect", (boolean)this.nodeService.hasAspect(copiedNode, TransferModel.ASPECT_TRANSFERRED));
            TransferServiceImplTest.assertNull((String)"copied node still has from repository id", (Object)this.nodeService.getProperty(copiedNode, TransferModel.PROP_FROM_REPOSITORY_ID));
            TransferServiceImplTest.assertNull((String)"copied node still has original repository id", (Object)this.nodeService.getProperty(copiedNode, TransferModel.PROP_REPOSITORY_ID));
            Set aspects = this.nodeService.getAspects(copiedNode);
            copiedNode = this.copyService.copy(A2destNodeRef, B2NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A2Copy2"), true);
            TransferServiceImplTest.assertTrue((String)"copied node does not exist", (boolean)this.nodeService.exists(copiedNode));
            System.out.println("copied node is " + copiedNode);
            TransferServiceImplTest.assertFalse((String)"copied node still has transferred aspect", (boolean)this.nodeService.hasAspect(copiedNode, TransferModel.ASPECT_TRANSFERRED));
            TransferServiceImplTest.assertNull((String)"copied node still has from repository id", (Object)this.nodeService.getProperty(copiedNode, TransferModel.PROP_FROM_REPOSITORY_ID));
            TransferServiceImplTest.assertNull((String)"copied node still has original repository id", (Object)this.nodeService.getProperty(copiedNode, TransferModel.PROP_REPOSITORY_ID));
            List children = this.nodeService.getChildAssocs(copiedNode);
            for (ChildAssociationRef child : children) {
                TransferServiceImplTest.assertFalse((String)"copied node still has transferred aspect", (boolean)this.nodeService.hasAspect(child.getChildRef(), TransferModel.ASPECT_TRANSFERRED));
                TransferServiceImplTest.assertNull((String)"copied node still has from repository id", (Object)this.nodeService.getProperty(child.getChildRef(), TransferModel.PROP_FROM_REPOSITORY_ID));
                TransferServiceImplTest.assertNull((String)"copied node still has original repository id", (Object)this.nodeService.getProperty(child.getChildRef(), TransferModel.PROP_REPOSITORY_ID));
            }
            Object var21_24 = null;
        }
        catch (Throwable throwable) {
            Object var21_25 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyAlien() throws Exception {
        List C2invaders;
        NodeRef copyRef;
        ArrayList<Object> nodes;
        TransferDefinition definition;
        NodeRef A5NodeRef;
        NodeRef A4NodeRef;
        NodeRef C3NodeRef;
        NodeRef C2NodeRef;
        NodeRef C1NodeRef;
        NodeRef B1NodeRef;
        NodeRef A1NodeRef;
        ChildAssociationRef child;
        this.setDefaultRollback(false);
        String CONTENT_TITLE = "ContentTitle";
        String CONTENT_TITLE_UPDATED = "ContentTitleUpdated";
        Locale CONTENT_LOCALE = Locale.GERMAN;
        String CONTENT_STRING = "Hello";
        String targetName = "testCopyAlien";
        QName C2Path = QName.createQName((String)"p2");
        QName C3Path = QName.createQName((String)"p3");
        String localRepositoryId = this.descriptorService.getCurrentRepositoryDescriptor().getId();
        this.startNewTransaction();
        try {
            String guestHomeQuery = "/app:company_home/app:guest_home";
            ResultSet guestHomeResult = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", guestHomeQuery);
            TransferServiceImplTest.assertEquals((String)"", (int)1, (int)guestHomeResult.length());
            NodeRef guestHome = guestHomeResult.getNodeRef(0);
            String name = GUID.generate();
            child = this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_FOLDER);
            NodeRef S0NodeRef = child.getChildRef();
            this.nodeService.setProperty(S0NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(S0NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
            ChildAssociationRef child2 = this.nodeService.createNode(S0NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A1"), ContentModel.TYPE_FOLDER);
            A1NodeRef = child2.getChildRef();
            this.nodeService.setProperty(A1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"A1"));
            this.nodeService.setProperty(A1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A1"));
            child2 = this.nodeService.createNode(S0NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B1"), ContentModel.TYPE_FOLDER);
            B1NodeRef = child2.getChildRef();
            this.nodeService.setProperty(B1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"B1"));
            this.nodeService.setProperty(B1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B1"));
            child2 = this.nodeService.createNode(S0NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"C1"), ContentModel.TYPE_FOLDER);
            C1NodeRef = child2.getChildRef();
            this.nodeService.setProperty(C1NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"C1"));
            this.nodeService.setProperty(C1NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"C1"));
            child2 = this.nodeService.createNode(C1NodeRef, ContentModel.ASSOC_CONTAINS, C2Path, ContentModel.TYPE_FOLDER);
            C2NodeRef = child2.getChildRef();
            this.nodeService.setProperty(C2NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"C2"));
            this.nodeService.setProperty(C2NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"C2"));
            child2 = this.nodeService.createNode(C1NodeRef, ContentModel.ASSOC_CONTAINS, C3Path, ContentModel.TYPE_FOLDER);
            C3NodeRef = child2.getChildRef();
            this.nodeService.setProperty(C3NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"C3"));
            this.nodeService.setProperty(C3NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"C3"));
            child2 = this.nodeService.createNode(A1NodeRef, ContentModel.ASSOC_CONTAINS, C2Path, ContentModel.TYPE_FOLDER);
            NodeRef C2DummyNodeRef = child2.getChildRef();
            this.nodeService.setProperty(C2DummyNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(C2DummyNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"C2 Dummy"));
            child2 = this.nodeService.createNode(A1NodeRef, ContentModel.ASSOC_CONTAINS, C3Path, ContentModel.TYPE_FOLDER);
            NodeRef C3DummyNodeRef = child2.getChildRef();
            this.nodeService.setProperty(C3DummyNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(C3DummyNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"C3 Dummy"));
            child2 = this.nodeService.createNode(A1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"C4"), ContentModel.TYPE_FOLDER);
            A4NodeRef = child2.getChildRef();
            this.nodeService.setProperty(A4NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"A4"));
            this.nodeService.setProperty(A4NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A4"));
            child2 = this.nodeService.createNode(C2DummyNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A5"), ContentModel.TYPE_FOLDER);
            A5NodeRef = child2.getChildRef();
            this.nodeService.setProperty(A5NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"A5"));
            this.nodeService.setProperty(A5NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A5"));
            TransferTarget transferMe = !this.transferService.targetExists(targetName) ? this.createTransferTarget(targetName) : this.transferService.getTransferTarget(targetName);
            Object var27_25 = null;
        }
        catch (Throwable throwable) {
            Object var27_26 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter(transmitter);
        UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory(testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)this.nodeService.getPath(A1NodeRef), (Object)this.nodeService.getPath(B1NodeRef)));
        pathMap.add((Pair<Path, Path>)new Pair((Object)this.nodeService.getPath(C1NodeRef), (Object)this.nodeService.getPath(B1NodeRef)));
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_C);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        this.startNewTransaction();
        try {
            definition = new TransferDefinition();
            nodes = new ArrayList<NodeRef>();
            nodes.add(C1NodeRef);
            nodes.add(C2NodeRef);
            nodes.add(C3NodeRef);
            definition.setNodes(nodes);
            definition.setSync(true);
            this.transferService.transfer(targetName, definition);
            Object var29_29 = null;
        }
        catch (Throwable throwable) {
            Object var29_30 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferServiceImplTest.assertTrue((String)"dest node C2 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(C2NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node C3 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(C3NodeRef)));
            ChildAssociationRef C3Ref = this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(C3NodeRef));
            TransferServiceImplTest.assertEquals((String)"A3 dest is connected to the wrong node", (Object)C3Ref.getParentRef(), (Object)B1NodeRef);
            ChildAssociationRef C2Ref = this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(C2NodeRef));
            TransferServiceImplTest.assertEquals((String)"A2 dest is connected to the wrong node", (Object)C2Ref.getParentRef(), (Object)B1NodeRef);
            Object var31_33 = null;
        }
        catch (Throwable throwable) {
            Object var31_34 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        this.startNewTransaction();
        try {
            definition = new TransferDefinition();
            nodes = new ArrayList();
            nodes.add(A4NodeRef);
            nodes.add(A5NodeRef);
            definition.setNodes(nodes);
            definition.setSync(true);
            this.transferService.transfer(targetName, definition);
            Object var33_36 = null;
        }
        catch (Throwable throwable) {
            Object var33_37 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferServiceImplTest.assertTrue((String)"dest node A5 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A5NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node C3 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(C3NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node C2 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(C2NodeRef)));
            ChildAssociationRef A5Ref = this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(A5NodeRef));
            TransferServiceImplTest.assertEquals((String)"A5 dest is connected to the wrong node", (Object)A5Ref.getParentRef(), (Object)testNodeFactory.getMappedNodeRef(C2NodeRef));
            TransferServiceImplTest.assertTrue((String)"C2 dest is not invaded", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(C2NodeRef), TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertFalse((String)"C3 dest is not invaded", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(C3NodeRef), TransferModel.ASPECT_ALIEN));
            ChildAssociationRef A4Ref = this.nodeService.getPrimaryParent(testNodeFactory.getMappedNodeRef(A4NodeRef));
            TransferServiceImplTest.assertEquals((String)"A4 dest is connected to the wrong node", (Object)A4Ref.getParentRef(), (Object)B1NodeRef);
            Object var35_39 = null;
        }
        catch (Throwable throwable) {
            Object var35_40 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            copyRef = this.copyService.copy(testNodeFactory.getMappedNodeRef(A5NodeRef), testNodeFactory.getMappedNodeRef(C3NodeRef), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A5 Copy 1"));
            TransferServiceImplTest.assertTrue((String)"dest node C3 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(C3NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node C2 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(C2NodeRef)));
            TransferServiceImplTest.assertTrue((String)"A5(copy 1) is not invaded", (boolean)this.nodeService.hasAspect(copyRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertTrue((String)"C3 dest is not invaded", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(C3NodeRef), TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertTrue((String)"C2 dest is not invaded", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(C2NodeRef), TransferModel.ASPECT_ALIEN));
            C2invaders = (List)((Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(C2NodeRef), TransferModel.PROP_INVADED_BY));
            List C3invaders = (List)((Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(C3NodeRef), TransferModel.PROP_INVADED_BY));
            TransferServiceImplTest.assertTrue((String)"C3 invaders contains local repository Id", (boolean)C3invaders.contains(localRepositoryId));
            TransferServiceImplTest.assertFalse((String)"C3 invaders contains REPO_ID_A", (boolean)C3invaders.contains(this.REPO_ID_A));
            TransferServiceImplTest.assertFalse((String)"C2 invaders contains local repository Id", (boolean)C2invaders.contains(localRepositoryId));
            TransferServiceImplTest.assertTrue((String)"C2 invaders contains REPO_ID_A", (boolean)C2invaders.contains(this.REPO_ID_A));
            Object var37_42 = null;
        }
        catch (Throwable throwable) {
            Object var37_43 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            copyRef = this.copyService.copy(testNodeFactory.getMappedNodeRef(A5NodeRef), testNodeFactory.getMappedNodeRef(A4NodeRef), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A5 Copy 2"));
            TransferServiceImplTest.assertTrue((String)"dest node A4 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(A4NodeRef)));
            TransferServiceImplTest.assertTrue((String)"dest node C2 does not exist", (boolean)this.nodeService.exists(testNodeFactory.getMappedNodeRef(C2NodeRef)));
            TransferServiceImplTest.assertTrue((String)"A5(copy 2) is not invaded", (boolean)this.nodeService.hasAspect(copyRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertTrue((String)"A4 dest is not invaded", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(A4NodeRef), TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertTrue((String)"C2 dest is not invaded", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(C2NodeRef), TransferModel.ASPECT_ALIEN));
            C2invaders = (List)((Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(C2NodeRef), TransferModel.PROP_INVADED_BY));
            List A4invaders = (List)((Object)this.nodeService.getProperty(testNodeFactory.getMappedNodeRef(A4NodeRef), TransferModel.PROP_INVADED_BY));
            TransferServiceImplTest.assertTrue((String)"A4 invaders contains local repository Id", (boolean)A4invaders.contains(localRepositoryId));
            TransferServiceImplTest.assertFalse((String)"C2 invaders contains local repository Id", (boolean)C2invaders.contains(localRepositoryId));
            TransferServiceImplTest.assertTrue((String)"C2 invaders contains REPO_ID_A", (boolean)C2invaders.contains(this.REPO_ID_A));
            Object var39_45 = null;
        }
        catch (Throwable throwable) {
            Object var39_46 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            child = this.nodeService.createNode(testNodeFactory.getMappedNodeRef(A5NodeRef), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"B6"), ContentModel.TYPE_FOLDER);
            NodeRef B6NodeRef = child.getChildRef();
            this.nodeService.setProperty(B6NodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"B6"));
            this.nodeService.setProperty(B6NodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"B6"));
            TransferServiceImplTest.assertTrue((String)"A4 dest is not invaded prior to test - test error", (boolean)this.nodeService.hasAspect(testNodeFactory.getMappedNodeRef(A4NodeRef), TransferModel.ASPECT_ALIEN));
            NodeRef copyRef2 = this.copyService.copy(testNodeFactory.getMappedNodeRef(A5NodeRef), B1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A5 Copy 3"));
            TransferServiceImplTest.assertFalse((String)"B1 is invaded", (boolean)this.nodeService.hasAspect(B1NodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertFalse((String)"A5 copy 3 is invaded", (boolean)this.nodeService.hasAspect(copyRef2, TransferModel.ASPECT_ALIEN));
            Object var41_49 = null;
        }
        catch (Throwable throwable) {
            Object var41_50 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferServiceImplTest.assertFalse((String)"B1 is invaded prior to test - test error", (boolean)this.nodeService.hasAspect(B1NodeRef, TransferModel.ASPECT_ALIEN));
            copyRef = this.copyService.copy(testNodeFactory.getMappedNodeRef(A5NodeRef), B1NodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A5 Copy 4"), true);
            TransferServiceImplTest.assertFalse((String)"B1 is invaded", (boolean)this.nodeService.hasAspect(B1NodeRef, TransferModel.ASPECT_ALIEN));
            TransferServiceImplTest.assertFalse((String)"A5 copy 4 is invaded", (boolean)this.nodeService.hasAspect(copyRef, TransferModel.ASPECT_ALIEN));
            List refs = this.nodeService.getChildAssocs(copyRef);
            TransferServiceImplTest.assertTrue((String)"can't find child of A5 copy 4", (refs.size() == 1 ? 1 : 0) != 0);
            for (ChildAssociationRef ref : refs) {
                TransferServiceImplTest.assertFalse((String)"B6 copy is invaded", (boolean)this.nodeService.hasAspect(ref.getChildRef(), TransferModel.ASPECT_ALIEN));
            }
            Object var43_52 = null;
        }
        catch (Throwable throwable) {
            Object var43_53 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEmptyContent() throws Exception {
        ContentReader reader;
        NodeRef destinationNodeRef;
        NodeRef savedDestinationNodeRef;
        Serializable modifiedDate;
        HashSet<Object> nodes;
        TransferDefinition definition;
        Map props;
        ContentReader reader2;
        NodeRef contentNodeRef;
        this.setDefaultRollback(false);
        String CONTENT_TITLE = "ContentTitle";
        String CONTENT_TITLE_UPDATED = "ContentTitleUpdated";
        Locale CONTENT_LOCALE = Locale.ENGLISH;
        String CONTENT_ENCODING = "UTF-8";
        String CONTENT_STRING = "The quick brown fox jumps over the lazy dog.";
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter(transmitter);
        UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory(testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)PathHelper.stringToPath(this.GUEST_HOME_XPATH_QUERY), (Object)PathHelper.stringToPath(this.COMPANY_HOME_XPATH_QUERY)));
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        String targetName = "testTransferEmptyContent";
        this.startNewTransaction();
        try {
            String guestHomeQuery = "/app:company_home/app:guest_home";
            ResultSet guestHomeResult = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", guestHomeQuery);
            TransferServiceImplTest.assertEquals((String)"", (int)1, (int)guestHomeResult.length());
            NodeRef guestHome = guestHomeResult.getNodeRef(0);
            String name = GUID.generate();
            ChildAssociationRef child = this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_CONTENT);
            contentNodeRef = child.getChildRef();
            this.nodeService.setProperty(contentNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
            this.nodeService.setProperty(contentNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
            ContentData cd = new ContentData(null, null, 0L, null);
            this.nodeService.setProperty(contentNodeRef, ContentModel.PROP_CONTENT, (Serializable)cd);
            if (!this.transferService.targetExists(targetName)) {
                TransferTarget transferMe = this.createTransferTarget(targetName);
            } else {
                TransferTarget transferMe = this.transferService.getTransferTarget(targetName);
            }
            this.transferService.enableTransferTarget(targetName, true);
            Object var21_20 = null;
        }
        catch (Throwable throwable) {
            Object var21_21 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        this.logger.debug((Object)"testEmptyContent : First transfer - create new node (empty content)");
        this.startNewTransaction();
        try {
            reader2 = this.contentService.getReader(contentNodeRef, ContentModel.PROP_CONTENT);
            TransferServiceImplTest.assertNull((String)"test setup content reader not null", (Object)reader2);
            props = this.nodeService.getProperties(contentNodeRef);
            TransferServiceImplTest.assertTrue((boolean)props.containsKey(ContentModel.PROP_CONTENT));
            definition = new TransferDefinition();
            nodes = new HashSet<NodeRef>();
            nodes.add(contentNodeRef);
            definition.setNodes(nodes);
            this.transferService.transfer(targetName, definition);
            Object var23_23 = null;
        }
        catch (Throwable throwable) {
            Object var23_24 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            NodeRef destinationNodeRef2;
            modifiedDate = this.nodeService.getProperty(contentNodeRef, ContentModel.PROP_MODIFIED);
            if (modifiedDate instanceof Date) {
                this.logger.debug((Object)("srcModified: " + SDF.format(modifiedDate)));
            }
            savedDestinationNodeRef = destinationNodeRef2 = testNodeFactory.getMappedNodeRef(contentNodeRef);
            TransferServiceImplTest.assertTrue((String)"content node (dest) does not exist", (boolean)this.nodeService.exists(destinationNodeRef2));
            ContentReader reader3 = this.contentService.getReader(destinationNodeRef2, ContentModel.PROP_CONTENT);
            TransferServiceImplTest.assertNull((String)"content reader not null", (Object)reader3);
            Map props2 = this.nodeService.getProperties(destinationNodeRef2);
            TransferServiceImplTest.assertTrue((boolean)props2.containsKey(ContentModel.PROP_CONTENT));
            Object var25_27 = null;
        }
        catch (Throwable throwable) {
            Object var25_28 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.logger.debug((Object)"testEmptyContent : Second transfer - replace empty content with some content");
        this.startNewTransaction();
        try {
            modifiedDate = this.nodeService.getProperty(contentNodeRef, ContentModel.PROP_MODIFIED);
            if (modifiedDate instanceof Date) {
                this.logger.debug((Object)("srcModified: " + SDF.format(modifiedDate)));
            }
            ContentWriter writer = this.contentService.getWriter(contentNodeRef, ContentModel.PROP_CONTENT, true);
            writer.setLocale(CONTENT_LOCALE);
            writer.setEncoding(CONTENT_ENCODING);
            writer.putContent(CONTENT_STRING);
            Object var27_30 = null;
        }
        catch (Throwable throwable) {
            Object var27_31 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            reader2 = this.contentService.getReader(contentNodeRef, ContentModel.PROP_CONTENT);
            TransferServiceImplTest.assertNotNull((String)"test setup content reader not null", (Object)reader2);
            props = this.nodeService.getProperties(contentNodeRef);
            TransferServiceImplTest.assertTrue((boolean)props.containsKey(ContentModel.PROP_CONTENT));
            definition = new TransferDefinition();
            nodes = new HashSet();
            nodes.add(contentNodeRef);
            definition.setNodes(nodes);
            this.transferService.transfer(targetName, definition);
            Object var29_33 = null;
        }
        catch (Throwable throwable) {
            Object var29_34 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            destinationNodeRef = testNodeFactory.getMappedNodeRef(contentNodeRef);
            TransferServiceImplTest.assertEquals((String)"test error destinationNodeRef not correct", (Object)savedDestinationNodeRef, (Object)destinationNodeRef);
            reader = this.contentService.getReader(destinationNodeRef, ContentModel.PROP_CONTENT);
            TransferServiceImplTest.assertNotNull((String)"content reader is null", (Object)reader);
            TransferServiceImplTest.assertEquals((String)"content encoding is wrong", (String)reader.getEncoding(), (String)CONTENT_ENCODING);
            TransferServiceImplTest.assertEquals((String)"content locale is wrong", (Object)reader.getLocale(), (Object)CONTENT_LOCALE);
            TransferServiceImplTest.assertTrue((String)"content does not exist", (boolean)reader.exists());
            String contentStr = reader.getContentString();
            TransferServiceImplTest.assertEquals((String)"Content is wrong", (String)contentStr, (String)CONTENT_STRING);
            Object var31_36 = null;
        }
        catch (Throwable throwable) {
            Object var31_37 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.logger.debug((Object)"testEmptyContent : Third transfer - remove existing content");
        this.startNewTransaction();
        try {
            ContentData cd = new ContentData(null, null, 0L, null);
            this.nodeService.setProperty(contentNodeRef, ContentModel.PROP_CONTENT, (Serializable)cd);
            Object var33_39 = null;
        }
        catch (Throwable throwable) {
            Object var33_40 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            reader2 = this.contentService.getReader(contentNodeRef, ContentModel.PROP_CONTENT);
            TransferServiceImplTest.assertNull((String)"test setup content reader not null", (Object)reader2);
            props = this.nodeService.getProperties(contentNodeRef);
            TransferServiceImplTest.assertTrue((boolean)props.containsKey(ContentModel.PROP_CONTENT));
            definition = new TransferDefinition();
            nodes = new HashSet();
            nodes.add(contentNodeRef);
            definition.setNodes(nodes);
            this.transferService.transfer(targetName, definition);
            Object var35_42 = null;
        }
        catch (Throwable throwable) {
            Object var35_43 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            destinationNodeRef = testNodeFactory.getMappedNodeRef(contentNodeRef);
            TransferServiceImplTest.assertTrue((String)"content node (dest) does not exist", (boolean)this.nodeService.exists(destinationNodeRef));
            reader = this.contentService.getReader(destinationNodeRef, ContentModel.PROP_CONTENT);
            TransferServiceImplTest.assertNull((String)"content reader not null", (Object)reader);
            Map props3 = this.nodeService.getProperties(destinationNodeRef);
            TransferServiceImplTest.assertTrue((boolean)props3.containsKey(ContentModel.PROP_CONTENT));
            Object var37_45 = null;
        }
        catch (Throwable throwable) {
            Object var37_46 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    public void testRepeatUpdateOfContent() throws Exception {
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        String CONTENT_TITLE = "ContentTitle";
        final Locale CONTENT_LOCALE = Locale.GERMAN;
        String CONTENT_ENCODING = "UTF-8";
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter(transmitter);
        final UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory(testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)PathHelper.stringToPath(this.GUEST_HOME_XPATH_QUERY), (Object)PathHelper.stringToPath(this.COMPANY_HOME_XPATH_QUERY)));
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        String targetName = "testRepeatUpdateOfContent";
        class TestContext {
            TransferTarget transferMe;
            NodeRef contentNodeRef;
            NodeRef destNodeRef;
            String contentString;

            TestContext() {
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<TestContext> setupCB = new RetryingTransactionHelper.RetryingTransactionCallback<TestContext>(){

            @Override
            public TestContext execute() throws Throwable {
                TestContext testContext = new TestContext();
                String guestHomeQuery = "/app:company_home/app:guest_home";
                ResultSet guestHomeResult = TransferServiceImplTest.this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", guestHomeQuery);
                Assert.assertEquals((String)"", (int)1, (int)guestHomeResult.length());
                NodeRef guestHome = guestHomeResult.getNodeRef(0);
                String name = GUID.generate();
                ChildAssociationRef child = TransferServiceImplTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_CONTENT);
                testContext.contentNodeRef = child.getChildRef();
                TransferServiceImplTest.this.nodeService.setProperty(testContext.contentNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.contentNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
                testContext.transferMe = !TransferServiceImplTest.this.transferService.targetExists("testRepeatUpdateOfContent") ? TransferServiceImplTest.this.createTransferTarget("testRepeatUpdateOfContent") : TransferServiceImplTest.this.transferService.getTransferTarget("testRepeatUpdateOfContent");
                TransferServiceImplTest.this.transferService.enableTransferTarget("testRepeatUpdateOfContent", true);
                return testContext;
            }
        };
        final TestContext testContext = tran.doInTransaction(setupCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> updateContentCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                ContentWriter writer = TransferServiceImplTest.this.contentService.getWriter(testContext.contentNodeRef, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.setEncoding("UTF-8");
                writer.putContent(testContext.contentString);
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> transferCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testContext.contentNodeRef);
                definition.setNodes(nodes);
                TransferServiceImplTest.this.transferService.transfer("testRepeatUpdateOfContent", definition);
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> checkTransferCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                NodeRef destNodeRef = testNodeFactory.getMappedNodeRef(testContext.contentNodeRef);
                ContentReader reader = TransferServiceImplTest.this.contentService.getReader(destNodeRef, ContentModel.PROP_CONTENT);
                Assert.assertNotNull((String)"content reader is null", (Object)reader);
                Assert.assertEquals((String)"content encoding is wrong", (String)reader.getEncoding(), (String)"UTF-8");
                Assert.assertEquals((String)"content locale is wrong", (Object)reader.getLocale(), (Object)CONTENT_LOCALE);
                Assert.assertTrue((String)"content does not exist", (boolean)reader.exists());
                String contentStr = reader.getContentString();
                Assert.assertEquals((String)"Content is wrong", (String)contentStr, (String)testContext.contentString);
                return null;
            }
        };
        for (int i = 0; i < 6; ++i) {
            this.logger.debug((Object)("testRepeatUpdateContent - iteration:" + i));
            testContext.contentString = String.valueOf(i);
            tran.doInTransaction(updateContentCB);
            tran.doInTransaction(transferCB);
            tran.doInTransaction(checkTransferCB);
        }
    }

    public void testReplaceNode() throws Exception {
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        String CONTENT_TITLE = "ContentTitle";
        String CONTENT_TITLE_UPDATED = "ContentTitleUpdated";
        Locale CONTENT_LOCALE = Locale.GERMAN;
        String CONTENT_STRING = "Hello World";
        String CONTENT_UPDATE_STRING = "Foo Bar";
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter(transmitter);
        UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory(testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)PathHelper.stringToPath(this.GUEST_HOME_XPATH_QUERY), (Object)PathHelper.stringToPath(this.COMPANY_HOME_XPATH_QUERY)));
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        String guestHomeQuery = "/app:company_home/app:guest_home";
        ResultSet guestHomeResult = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", guestHomeQuery);
        TransferServiceImplTest.assertEquals((String)"", (int)1, (int)guestHomeResult.length());
        final NodeRef guestHome = guestHomeResult.getNodeRef(0);
        String targetName = "testRepeatUpdateOfContent";
        class TestContext {
            TransferTarget transferMe;
            NodeRef parentNodeRef;
            NodeRef middleNodeRef;
            NodeRef childNodeRef;
            QName parentName;
            QName middleName;
            QName childName;

            TestContext() {
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<TestContext> setupCB = new RetryingTransactionHelper.RetryingTransactionCallback<TestContext>(){

            @Override
            public TestContext execute() throws Throwable {
                TestContext testContext = new TestContext();
                String name = GUID.generate();
                testContext.parentName = QName.createQName((String)name);
                testContext.childName = QName.createQName((String)"Ermintrude");
                testContext.middleName = QName.createQName((String)"Matilda");
                ChildAssociationRef child = TransferServiceImplTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, testContext.parentName, ContentModel.TYPE_FOLDER);
                testContext.parentNodeRef = child.getChildRef();
                TransferServiceImplTest.this.logger.debug((Object)("parentNodeRef created:" + testContext.parentNodeRef));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.parentNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.parentNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)testContext.parentName.getLocalName()));
                ChildAssociationRef child2 = TransferServiceImplTest.this.nodeService.createNode(testContext.parentNodeRef, ContentModel.ASSOC_CONTAINS, testContext.childName, ContentModel.TYPE_FOLDER);
                testContext.middleNodeRef = child2.getChildRef();
                TransferServiceImplTest.this.logger.debug((Object)("middleNodeRef created:" + testContext.middleNodeRef));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.middleNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.middleNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)testContext.childName.getLocalName()));
                ChildAssociationRef child3 = TransferServiceImplTest.this.nodeService.createNode(testContext.middleNodeRef, ContentModel.ASSOC_CONTAINS, testContext.childName, ContentModel.TYPE_CONTENT);
                testContext.childNodeRef = child3.getChildRef();
                TransferServiceImplTest.this.logger.debug((Object)("childNodeRef created:" + testContext.childNodeRef));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.childNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.childNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)testContext.childName.getLocalName()));
                testContext.transferMe = !TransferServiceImplTest.this.transferService.targetExists("testRepeatUpdateOfContent") ? TransferServiceImplTest.this.createTransferTarget("testRepeatUpdateOfContent") : TransferServiceImplTest.this.transferService.getTransferTarget("testRepeatUpdateOfContent");
                TransferServiceImplTest.this.transferService.enableTransferTarget("testRepeatUpdateOfContent", true);
                return testContext;
            }
        };
        final TestContext testContext = tran.doInTransaction(setupCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> transferCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                ArrayList<NodeRef> nodes = new ArrayList<NodeRef>();
                nodes.add(testContext.childNodeRef);
                nodes.add(testContext.parentNodeRef);
                nodes.add(testContext.middleNodeRef);
                definition.setSync(true);
                definition.setNodes(nodes);
                TransferServiceImplTest.this.transferService.transfer("testRepeatUpdateOfContent", definition);
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> checkTransferCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> replaceNodesCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                TransferServiceImplTest.this.nodeService.deleteNode(testContext.middleNodeRef);
                TransferServiceImplTest.this.logger.debug((Object)"deleted node");
                ChildAssociationRef child2 = TransferServiceImplTest.this.nodeService.createNode(testContext.parentNodeRef, ContentModel.ASSOC_CONTAINS, testContext.childName, ContentModel.TYPE_FOLDER);
                testContext.middleNodeRef = child2.getChildRef();
                TransferServiceImplTest.this.logger.debug((Object)("middleNodeRef created:" + testContext.middleNodeRef));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.middleNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.middleNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)testContext.childName.getLocalName()));
                ChildAssociationRef child3 = TransferServiceImplTest.this.nodeService.createNode(testContext.middleNodeRef, ContentModel.ASSOC_CONTAINS, testContext.childName, ContentModel.TYPE_CONTENT);
                testContext.childNodeRef = child3.getChildRef();
                TransferServiceImplTest.this.logger.debug((Object)("childNodeRef created:" + testContext.childNodeRef));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.childNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.childNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)testContext.childName.getLocalName()));
                return null;
            }
        };
        tran.doInTransaction(transferCB);
        tran.doInTransaction(replaceNodesCB);
        tran.doInTransaction(transferCB);
        tran.doInTransaction(checkTransferCB);
    }

    public void testHorriblePaths() throws Exception {
        this.setDefaultRollback(false);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        String CONTENT_TITLE = "ContentTitle";
        String CONTENT_TITLE_UPDATED = "ContentTitleUpdated";
        String CONTENT_NAME = "Demo Node 1";
        final Locale CONTENT_LOCALE = Locale.GERMAN;
        String CONTENT_STRING = "The quick brown fox";
        final HashSet nodes = new HashSet();
        String targetName = "testManyNodes";
        final UnitTestTransferManifestNodeFactory testNodeFactory = this.unitTestKludgeToTransferGuestHomeToCompanyHome();
        final QName[] difficult = new QName[]{QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testNodeB"), QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"with.dot"), QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"8332"), QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"&#~@"), QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"_-+ )"), QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"with space"), QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"A\u00e9"), QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"\u0391\u03a9")};
        class TestContext {
            TransferTarget transferMe;
            NodeRef nodeA = null;
            NodeRef childNode = null;

            TestContext() {
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<TestContext> setupCB = new RetryingTransactionHelper.RetryingTransactionCallback<TestContext>(){

            @Override
            public TestContext execute() throws Throwable {
                TestContext ctx = new TestContext();
                String guestHomeQuery = "/app:company_home/app:guest_home";
                ResultSet guestHomeResult = TransferServiceImplTest.this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", guestHomeQuery);
                Assert.assertEquals((String)"", (int)1, (int)guestHomeResult.length());
                NodeRef guestHome = guestHomeResult.getNodeRef(0);
                String guid = GUID.generate();
                ChildAssociationRef child = TransferServiceImplTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)guid), ContentModel.TYPE_FOLDER);
                NodeRef testRootNode = child.getChildRef();
                TransferServiceImplTest.this.nodeService.setProperty(testRootNode, ContentModel.PROP_TITLE, (Serializable)((Object)guid));
                TransferServiceImplTest.this.nodeService.setProperty(testRootNode, ContentModel.PROP_NAME, (Serializable)((Object)guid));
                nodes.add(testRootNode);
                child = TransferServiceImplTest.this.nodeService.createNode(testRootNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testNodeA"), ContentModel.TYPE_FOLDER);
                ctx.nodeA = child.getChildRef();
                TransferServiceImplTest.this.nodeService.setProperty(ctx.nodeA, ContentModel.PROP_TITLE, (Serializable)((Object)"TestNodeA"));
                TransferServiceImplTest.this.nodeService.setProperty(ctx.nodeA, ContentModel.PROP_NAME, (Serializable)((Object)"TestNodeA"));
                nodes.add(ctx.nodeA);
                NodeRef current = ctx.nodeA;
                for (QName name : difficult) {
                    child = TransferServiceImplTest.this.nodeService.createNode(current, ContentModel.ASSOC_CONTAINS, name, ContentModel.TYPE_FOLDER);
                    current = child.getChildRef();
                    TransferServiceImplTest.this.nodeService.setProperty(current, ContentModel.PROP_TITLE, (Serializable)name);
                    TransferServiceImplTest.this.nodeService.setProperty(current, ContentModel.PROP_NAME, (Serializable)((Object)"testName"));
                    nodes.add(current);
                }
                child = TransferServiceImplTest.this.nodeService.createNode(current, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"testNodeAC"), ContentModel.TYPE_CONTENT);
                ctx.childNode = child.getChildRef();
                TransferServiceImplTest.this.nodeService.setProperty(ctx.childNode, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitleAC"));
                TransferServiceImplTest.this.nodeService.setProperty(ctx.childNode, ContentModel.PROP_NAME, (Serializable)((Object)"DemoNodeAC"));
                ContentWriter writer = TransferServiceImplTest.this.contentService.getWriter(ctx.childNode, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("The quick brown fox");
                nodes.add(ctx.childNode);
                ctx.transferMe = !TransferServiceImplTest.this.transferService.targetExists("testManyNodes") ? TransferServiceImplTest.this.createTransferTarget("testManyNodes") : TransferServiceImplTest.this.transferService.getTransferTarget("testManyNodes");
                return ctx;
            }
        };
        final TestContext testContext = tran.doInTransaction(setupCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> transferCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                definition.setNodes(nodes);
                TransferServiceImplTest.this.transferService.transfer("testManyNodes", definition);
                return null;
            }
        };
        tran.doInTransaction(transferCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> check1CB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                NodeRef destChildNode = testNodeFactory.getMappedNodeRef(testContext.childNode);
                Assert.assertTrue((String)"dest node does not exist", (boolean)TransferServiceImplTest.this.nodeService.exists(destChildNode));
                Path srcPath = TransferServiceImplTest.this.nodeService.getPath(testContext.childNode);
                Path destPath = TransferServiceImplTest.this.nodeService.getPath(destChildNode);
                int srcSize = srcPath.size();
                int destSize = destPath.size();
                Path dest = destPath.subPath(2, destSize - 1);
                Path src = srcPath.subPath(3, srcSize - 1);
                Assert.assertEquals((String)"paths are different", (String)src.toString(), (String)dest.toString());
                return null;
            }
        };
        tran.doInTransaction(check1CB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> updateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                return null;
            }
        };
        tran.doInTransaction(updateCB);
        tran.doInTransaction(transferCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> check2CB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                Assert.assertTrue((String)"dest node does not exist", (boolean)TransferServiceImplTest.this.nodeService.exists(testNodeFactory.getMappedNodeRef(testContext.childNode)));
                return null;
            }
        };
        tran.doInTransaction(check2CB);
    }

    private void createUser(String userName, String password) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, password.toCharArray());
            PropertyMap ppOne = new PropertyMap(4);
            ppOne.put(ContentModel.PROP_USERNAME, userName);
            ppOne.put(ContentModel.PROP_FIRSTNAME, "firstName");
            ppOne.put(ContentModel.PROP_LASTNAME, "lastName");
            ppOne.put(ContentModel.PROP_EMAIL, "email@email.com");
            ppOne.put(ContentModel.PROP_JOBTITLE, "jobTitle");
            this.personService.createPerson(ppOne);
        }
    }

    private DescriptorService getMockDescriptorService(String repositoryId) {
        DescriptorService descriptorService = (DescriptorService)Mockito.mock(DescriptorService.class);
        Descriptor descriptor = (Descriptor)Mockito.mock(Descriptor.class);
        Mockito.when((Object)descriptor.getId()).thenReturn((Object)repositoryId);
        Mockito.when((Object)descriptorService.getCurrentRepositoryDescriptor()).thenReturn((Object)descriptor);
        return descriptorService;
    }
}

