/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.version.BaseVersionStoreTest;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.debug.NodeStoreInspector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NodeServiceImplTest
extends BaseVersionStoreTest {
    private static Log logger = LogFactory.getLog(NodeServiceImplTest.class);
    protected NodeService versionStoreNodeService = null;
    private static final String MSG_ERR = "This operation is not supported by a version store implementation of the node service.";
    private NodeRef dummyNodeRef = null;
    private QName dummyQName = null;

    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.versionStoreNodeService = (NodeService)this.applicationContext.getBean("versionNodeService");
        this.dummyNodeRef = new NodeRef(this.versionService.getVersionStoreReference(), "dummy");
        this.dummyQName = QName.createQName((String)"{dummy}dummy");
    }

    public void testGetType() {
        NodeRef versionableNode = this.createNewVersionableNode();
        Version version = this.createVersion(versionableNode, this.versionProperties);
        QName versionedType = this.versionStoreNodeService.getType(version.getFrozenStateNodeRef());
        NodeServiceImplTest.assertNotNull((Object)versionedType);
        NodeServiceImplTest.assertEquals((Object)this.dbNodeService.getType(versionableNode), (Object)versionedType);
    }

    public void testGetProperties() {
        NodeRef versionableNode = this.createNewVersionableNode();
        Map origProps = this.dbNodeService.getProperties(versionableNode);
        Version version = this.createVersion(versionableNode, this.versionProperties);
        Map versionedProperties = this.versionStoreNodeService.getProperties(version.getFrozenStateNodeRef());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("original (" + origProps.size() + "):  " + origProps.keySet()));
            logger.debug((Object)("versioned (" + versionedProperties.size() + "): " + versionedProperties.keySet()));
        }
        for (QName key : origProps.keySet()) {
            NodeServiceImplTest.assertTrue((boolean)versionedProperties.containsKey(key));
            NodeServiceImplTest.assertEquals((String)("" + key), origProps.get(key), versionedProperties.get(key));
        }
        NodeServiceImplTest.assertEquals((Object)"1.0", versionedProperties.get(ContentModel.PROP_VERSION_LABEL));
    }

    public void testGetProperty() {
        NodeRef versionableNode = this.createNewVersionableNode();
        Version version = this.createVersion(versionableNode, this.versionProperties);
        Serializable value1 = this.versionStoreNodeService.getProperty(version.getFrozenStateNodeRef(), PROP_1);
        NodeServiceImplTest.assertEquals((Object)"value1", (Object)value1);
        Collection multiValue = (Collection)((Object)this.versionStoreNodeService.getProperty(version.getFrozenStateNodeRef(), MULTI_PROP));
        NodeServiceImplTest.assertNotNull((Object)multiValue);
        NodeServiceImplTest.assertEquals((int)2, (int)multiValue.size());
        String[] array = multiValue.toArray(new String[multiValue.size()]);
        NodeServiceImplTest.assertEquals((String)"multi1", (String)array[0]);
        NodeServiceImplTest.assertEquals((String)"multi2", (String)array[1]);
    }

    public void testGetChildAssocs() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(NodeStoreInspector.dumpNodeStore(this.dbNodeService, this.versionService.getVersionStoreReference()) + "\n\n"));
            logger.trace((Object)"");
        }
        NodeRef versionableNode = this.createNewVersionableNode();
        List originalChildren = this.dbNodeService.getChildAssocs(versionableNode);
        NodeServiceImplTest.assertNotNull((Object)originalChildren);
        HashMap<String, ChildAssociationRef> originalChildAssocRefs = new HashMap<String, ChildAssociationRef>();
        for (ChildAssociationRef ref : originalChildren) {
            originalChildAssocRefs.put(ref.getChildRef().getId(), ref);
        }
        Version version = this.createVersion(versionableNode, this.versionProperties);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)NodeStoreInspector.dumpNodeStore(this.dbNodeService, this.versionService.getVersionStoreReference()));
            logger.trace((Object)"");
        }
        List versionedChildren = this.versionStoreNodeService.getChildAssocs(version.getFrozenStateNodeRef());
        NodeServiceImplTest.assertNotNull((Object)versionedChildren);
        NodeServiceImplTest.assertEquals((int)originalChildren.size(), (int)versionedChildren.size());
        for (ChildAssociationRef versionedChildRef : versionedChildren) {
            ChildAssociationRef origChildAssocRef = (ChildAssociationRef)originalChildAssocRefs.get(versionedChildRef.getChildRef().getId());
            NodeServiceImplTest.assertNotNull((Object)origChildAssocRef);
            NodeServiceImplTest.assertEquals((Object)origChildAssocRef.getChildRef(), (Object)versionedChildRef.getChildRef());
            NodeServiceImplTest.assertEquals((boolean)origChildAssocRef.isPrimary(), (boolean)versionedChildRef.isPrimary());
            NodeServiceImplTest.assertEquals((int)origChildAssocRef.getNthSibling(), (int)versionedChildRef.getNthSibling());
        }
    }

    public void testGetAssociationTargets() {
        NodeRef versionableNode = this.createNewVersionableNode();
        List origAssocs = this.dbNodeService.getTargetAssocs(versionableNode, RegexQNamePattern.MATCH_ALL);
        Version version = this.createVersion(versionableNode, this.versionProperties);
        List assocs = this.versionStoreNodeService.getTargetAssocs(version.getFrozenStateNodeRef(), RegexQNamePattern.MATCH_ALL);
        NodeServiceImplTest.assertNotNull((Object)assocs);
        NodeServiceImplTest.assertEquals((int)origAssocs.size(), (int)assocs.size());
    }

    public void testHasAspect() {
        NodeRef versionableNode = this.createNewVersionableNode();
        Version version = this.createVersion(versionableNode, this.versionProperties);
        boolean test1 = this.versionStoreNodeService.hasAspect(version.getFrozenStateNodeRef(), ApplicationModel.ASPECT_UIFACETS);
        NodeServiceImplTest.assertFalse((boolean)test1);
        boolean test2 = this.versionStoreNodeService.hasAspect(version.getFrozenStateNodeRef(), ContentModel.ASPECT_VERSIONABLE);
        NodeServiceImplTest.assertTrue((boolean)test2);
    }

    public void testGetAspects() {
        NodeRef versionableNode = this.createNewVersionableNode();
        Set origAspects = this.dbNodeService.getAspects(versionableNode);
        Version version = this.createVersion(versionableNode, this.versionProperties);
        Set aspects = this.versionStoreNodeService.getAspects(version.getFrozenStateNodeRef());
        NodeServiceImplTest.assertEquals((int)origAspects.size(), (int)aspects.size());
        for (QName origAspect : origAspects) {
            NodeServiceImplTest.assertTrue((String)(origAspect + ""), (boolean)aspects.contains(origAspect));
        }
    }

    public void testGetParentAssocs() {
        NodeRef versionableNode = this.createNewVersionableNode();
        Version version = this.createVersion(versionableNode, this.versionProperties);
        NodeRef nodeRef = version.getFrozenStateNodeRef();
        List results = this.versionStoreNodeService.getParentAssocs(nodeRef);
        NodeServiceImplTest.assertNotNull((Object)results);
        NodeServiceImplTest.assertEquals((int)1, (int)results.size());
        ChildAssociationRef childAssoc = (ChildAssociationRef)results.get(0);
        NodeServiceImplTest.assertEquals((Object)nodeRef, (Object)childAssoc.getChildRef());
        NodeRef versionStoreRoot = this.dbNodeService.getRootNode(this.versionService.getVersionStoreReference());
        NodeServiceImplTest.assertEquals((Object)versionStoreRoot, (Object)childAssoc.getParentRef());
    }

    public void testGetPrimaryParent() {
        NodeRef versionableNode = this.createNewVersionableNode();
        Version version = this.createVersion(versionableNode, this.versionProperties);
        NodeRef nodeRef = version.getFrozenStateNodeRef();
        ChildAssociationRef childAssoc = this.versionStoreNodeService.getPrimaryParent(nodeRef);
        NodeServiceImplTest.assertNotNull((Object)childAssoc);
        NodeServiceImplTest.assertEquals((Object)nodeRef, (Object)childAssoc.getChildRef());
        NodeRef versionStoreRoot = this.dbNodeService.getRootNode(this.versionService.getVersionStoreReference());
        NodeServiceImplTest.assertEquals((Object)versionStoreRoot, (Object)childAssoc.getParentRef());
    }

    public void testCreateNode() {
        block2: {
            try {
                this.versionStoreNodeService.createNode(this.dummyNodeRef, null, this.dummyQName, ContentModel.TYPE_CONTENT);
                NodeServiceImplTest.fail((String)"This operation is not supported.");
            }
            catch (UnsupportedOperationException exception) {
                if (exception.getMessage() == MSG_ERR) break block2;
                NodeServiceImplTest.fail((String)("Unexpected exception raised during method excution: " + exception.getMessage()));
            }
        }
    }

    public void testAddAspect() {
        block2: {
            try {
                this.versionStoreNodeService.addAspect(this.dummyNodeRef, TEST_ASPECT_QNAME, null);
                NodeServiceImplTest.fail((String)"This operation is not supported.");
            }
            catch (UnsupportedOperationException exception) {
                if (exception.getMessage() == MSG_ERR) break block2;
                NodeServiceImplTest.fail((String)("Unexpected exception raised during method excution: " + exception.getMessage()));
            }
        }
    }

    public void testRemoveAspect() {
        block2: {
            try {
                this.versionStoreNodeService.removeAspect(this.dummyNodeRef, TEST_ASPECT_QNAME);
                NodeServiceImplTest.fail((String)"This operation is not supported.");
            }
            catch (UnsupportedOperationException exception) {
                if (exception.getMessage() == MSG_ERR) break block2;
                NodeServiceImplTest.fail((String)("Unexpected exception raised during method excution: " + exception.getMessage()));
            }
        }
    }

    public void testDeleteNode() {
        block2: {
            try {
                this.versionStoreNodeService.deleteNode(this.dummyNodeRef);
                NodeServiceImplTest.fail((String)"This operation is not supported.");
            }
            catch (UnsupportedOperationException exception) {
                if (exception.getMessage() == MSG_ERR) break block2;
                NodeServiceImplTest.fail((String)("Unexpected exception raised during method excution: " + exception.getMessage()));
            }
        }
    }

    public void testAddChild() {
        block2: {
            try {
                this.versionStoreNodeService.addChild(this.dummyNodeRef, this.dummyNodeRef, this.dummyQName, this.dummyQName);
                NodeServiceImplTest.fail((String)"This operation is not supported.");
            }
            catch (UnsupportedOperationException exception) {
                if (exception.getMessage() == MSG_ERR) break block2;
                NodeServiceImplTest.fail((String)("Unexpected exception raised during method excution: " + exception.getMessage()));
            }
        }
    }

    public void testRemoveChild() {
        block2: {
            try {
                this.versionStoreNodeService.removeChild(this.dummyNodeRef, this.dummyNodeRef);
                NodeServiceImplTest.fail((String)"This operation is not supported.");
            }
            catch (UnsupportedOperationException exception) {
                if (exception.getMessage() == MSG_ERR) break block2;
                NodeServiceImplTest.fail((String)("Unexpected exception raised during method excution: " + exception.getMessage()));
            }
        }
    }

    public void testSetProperties() {
        block2: {
            try {
                this.versionStoreNodeService.setProperties(this.dummyNodeRef, new HashMap());
                NodeServiceImplTest.fail((String)"This operation is not supported.");
            }
            catch (UnsupportedOperationException exception) {
                if (exception.getMessage() == MSG_ERR) break block2;
                NodeServiceImplTest.fail((String)("Unexpected exception raised during method excution: " + exception.getMessage()));
            }
        }
    }

    public void testSetProperty() {
        block2: {
            try {
                this.versionStoreNodeService.setProperty(this.dummyNodeRef, this.dummyQName, (Serializable)((Object)"dummy"));
                NodeServiceImplTest.fail((String)"This operation is not supported.");
            }
            catch (UnsupportedOperationException exception) {
                if (exception.getMessage() == MSG_ERR) break block2;
                NodeServiceImplTest.fail((String)("Unexpected exception raised during method excution: " + exception.getMessage()));
            }
        }
    }

    public void testCreateAssociation() {
        block2: {
            try {
                this.versionStoreNodeService.createAssociation(this.dummyNodeRef, this.dummyNodeRef, this.dummyQName);
                NodeServiceImplTest.fail((String)"This operation is not supported.");
            }
            catch (UnsupportedOperationException exception) {
                if (exception.getMessage() == MSG_ERR) break block2;
                NodeServiceImplTest.fail((String)("Unexpected exception raised during method excution: " + exception.getMessage()));
            }
        }
    }

    public void testRemoveAssociation() {
        block2: {
            try {
                this.versionStoreNodeService.removeAssociation(this.dummyNodeRef, this.dummyNodeRef, this.dummyQName);
                NodeServiceImplTest.fail((String)"This operation is not supported.");
            }
            catch (UnsupportedOperationException exception) {
                if (exception.getMessage() == MSG_ERR) break block2;
                NodeServiceImplTest.fail((String)("Unexpected exception raised during method excution: " + exception.getMessage()));
            }
        }
    }

    public void testGetAssociationSources() {
        block2: {
            try {
                this.versionStoreNodeService.getSourceAssocs(this.dummyNodeRef, (QNamePattern)this.dummyQName);
                NodeServiceImplTest.fail((String)"This operation is not supported.");
            }
            catch (UnsupportedOperationException exception) {
                if (exception.getMessage() == MSG_ERR) break block2;
                NodeServiceImplTest.fail((String)("Unexpected exception raised during method excution: " + exception.getMessage()));
            }
        }
    }

    public void testGetPath() {
        Path path = this.versionStoreNodeService.getPath(this.dummyNodeRef);
    }

    public void testGetPaths() {
        List paths = this.versionStoreNodeService.getPaths(this.dummyNodeRef, false);
    }
}

