/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version.common.versionlabel;

import java.io.Serializable;
import java.util.HashMap;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.version.common.VersionImpl;
import org.alfresco.repo.version.common.versionlabel.SerialVersionLabelPolicy;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.version.VersionType;

public class SerialVersionLabelPolicyTest
extends TestCase {
    public void testGetVersionLabelValue() {
        SerialVersionLabelPolicy policy = new SerialVersionLabelPolicy();
        NodeRef dummyNodeRef = new NodeRef(new StoreRef("", ""), "");
        HashMap<String, Serializable> versionProp1 = new HashMap<String, Serializable>();
        versionProp1.put("versionType", (Serializable)((Object)VersionType.MINOR));
        String initialVersion = policy.calculateVersionLabel(ContentModel.TYPE_CMOBJECT, null, 0, versionProp1);
        SerialVersionLabelPolicyTest.assertEquals((String)"1.0", (String)initialVersion);
        HashMap<String, Serializable> versionProp2 = new HashMap<String, Serializable>();
        versionProp2.put("versionLabel", (Serializable)((Object)"1.0"));
        VersionImpl version1 = new VersionImpl(versionProp2, dummyNodeRef);
        String verisonLabel1 = policy.calculateVersionLabel(ContentModel.TYPE_CMOBJECT, version1, 1, versionProp1);
        SerialVersionLabelPolicyTest.assertEquals((String)"1.1", (String)verisonLabel1);
        HashMap<String, Serializable> versionProp3 = new HashMap<String, Serializable>();
        versionProp3.put("versionLabel", (Serializable)((Object)"1.1"));
        VersionImpl version2 = new VersionImpl(versionProp3, dummyNodeRef);
        HashMap<String, Serializable> versionProp4 = new HashMap<String, Serializable>();
        versionProp4.put("versionType", (Serializable)((Object)VersionType.MAJOR));
        String verisonLabel2 = policy.calculateVersionLabel(ContentModel.TYPE_CMOBJECT, version2, 1, versionProp4);
        SerialVersionLabelPolicyTest.assertEquals((String)"2.0", (String)verisonLabel2);
    }
}

