/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.workflow.TaskComponent;
import org.alfresco.repo.workflow.WorkflowComponent;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BPMEngineRegistry {
    private static final String ID_SEPERATOR = "$";
    private static final String ID_SEPERATOR_REGEX = "\\$";
    private static Log logger = LogFactory.getLog((String)"org.alfresco.repo.workflow");
    private Map<String, WorkflowComponent> workflowComponents = new HashMap<String, WorkflowComponent>();
    private Map<String, TaskComponent> taskComponents = new HashMap<String, TaskComponent>();

    public void registerWorkflowComponent(String engineId, WorkflowComponent engine) {
        if (this.workflowComponents.containsKey(engineId)) {
            throw new WorkflowException("Workflow Component already registered for engine id '" + engineId + "'");
        }
        this.workflowComponents.put(engineId, engine);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Registered Workflow Component '" + engineId + "' (" + engine.getClass() + ")"));
        }
    }

    public String[] getWorkflowComponents() {
        return this.workflowComponents.keySet().toArray(new String[this.workflowComponents.keySet().size()]);
    }

    public WorkflowComponent getWorkflowComponent(String engineId) {
        return this.workflowComponents.get(engineId);
    }

    public void registerTaskComponent(String engineId, TaskComponent engine) {
        if (this.taskComponents.containsKey(engineId)) {
            throw new WorkflowException("Task Component already registered for engine id '" + engineId + "'");
        }
        this.taskComponents.put(engineId, engine);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Registered Task Component '" + engineId + "' (" + engine.getClass() + ")"));
        }
    }

    public String[] getTaskComponents() {
        return this.taskComponents.keySet().toArray(new String[this.taskComponents.keySet().size()]);
    }

    public TaskComponent getTaskComponent(String engineId) {
        return this.taskComponents.get(engineId);
    }

    public static String createGlobalId(String engineId, String localId) {
        return engineId + ID_SEPERATOR + localId;
    }

    public static String[] getGlobalIdParts(String globalId) {
        String[] parts = globalId.split(ID_SEPERATOR_REGEX);
        if (parts.length != 2) {
            throw new WorkflowException("Invalid Global Id '" + globalId + "'");
        }
        return parts;
    }

    public static String getEngineId(String globalId) {
        return BPMEngineRegistry.getGlobalIdParts(globalId)[0];
    }

    public static String getLocalId(String globalId) {
        return BPMEngineRegistry.getGlobalIdParts(globalId)[1];
    }
}

