/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WCMModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.workflow.BPMEngineRegistry;
import org.alfresco.repo.workflow.TaskComponent;
import org.alfresco.repo.workflow.WorkflowComponent;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.WorkflowPackageComponent;
import org.alfresco.service.cmr.avmsync.AVMDifference;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowDeployment;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskDefinition;
import org.alfresco.service.cmr.workflow.WorkflowTaskQuery;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.cmr.workflow.WorkflowTimer;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowServiceImpl
implements WorkflowService {
    private static Log logger = LogFactory.getLog((String)"org.alfresco.repo.workflow");
    private AuthorityService authorityService;
    private BPMEngineRegistry registry;
    private WorkflowPackageComponent workflowPackageComponent;
    private NodeService nodeService;
    private ContentService contentService;
    private AVMSyncService avmSyncService;
    private DictionaryService dictionaryService;
    private NodeService protectedNodeService;

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setBPMEngineRegistry(BPMEngineRegistry registry) {
        this.registry = registry;
    }

    public void setWorkflowPackageComponent(WorkflowPackageComponent workflowPackageComponent) {
        this.workflowPackageComponent = workflowPackageComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setAvmSyncService(AVMSyncService avmSyncService) {
        this.avmSyncService = avmSyncService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setProtectedNodeService(NodeService protectedNodeService) {
        this.protectedNodeService = protectedNodeService;
    }

    @Override
    public WorkflowDeployment deployDefinition(String engineId, InputStream workflowDefinition, String mimetype) {
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        WorkflowDeployment deployment = component.deployDefinition(workflowDefinition, mimetype);
        if (logger.isDebugEnabled() && deployment.problems.length > 0) {
            for (String problem : deployment.problems) {
                logger.debug((Object)("Workflow definition '" + deployment.definition.title + "' problem: " + problem));
            }
        }
        return deployment;
    }

    @Override
    public boolean isDefinitionDeployed(NodeRef workflowDefinition) {
        if (!this.nodeService.getType(workflowDefinition).equals((Object)WorkflowModel.TYPE_WORKFLOW_DEF)) {
            throw new WorkflowException("Node " + workflowDefinition + " is not of type 'bpm:workflowDefinition'");
        }
        String engineId = (String)((Object)this.nodeService.getProperty(workflowDefinition, WorkflowModel.PROP_WORKFLOW_DEF_ENGINE_ID));
        ContentReader contentReader = this.contentService.getReader(workflowDefinition, ContentModel.PROP_CONTENT);
        return this.isDefinitionDeployed(engineId, contentReader.getContentInputStream(), contentReader.getMimetype());
    }

    @Override
    public boolean isDefinitionDeployed(String engineId, InputStream workflowDefinition, String mimetype) {
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.isDefinitionDeployed(workflowDefinition, mimetype);
    }

    @Override
    public WorkflowDeployment deployDefinition(NodeRef definitionContent) {
        if (!this.nodeService.getType(definitionContent).equals((Object)WorkflowModel.TYPE_WORKFLOW_DEF)) {
            throw new WorkflowException("Node " + definitionContent + " is not of type 'bpm:workflowDefinition'");
        }
        String engineId = (String)((Object)this.nodeService.getProperty(definitionContent, WorkflowModel.PROP_WORKFLOW_DEF_ENGINE_ID));
        ContentReader contentReader = this.contentService.getReader(definitionContent, ContentModel.PROP_CONTENT);
        return this.deployDefinition(engineId, contentReader.getContentInputStream(), contentReader.getMimetype());
    }

    @Override
    public void undeployDefinition(String workflowDefinitionId) {
        String engineId = BPMEngineRegistry.getEngineId(workflowDefinitionId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        component.undeployDefinition(workflowDefinitionId);
    }

    @Override
    public List<WorkflowDefinition> getDefinitions() {
        String[] ids;
        ArrayList<WorkflowDefinition> definitions = new ArrayList<WorkflowDefinition>(10);
        for (String id : ids = this.registry.getWorkflowComponents()) {
            WorkflowComponent component = this.registry.getWorkflowComponent(id);
            definitions.addAll(component.getDefinitions());
        }
        return Collections.unmodifiableList(definitions);
    }

    @Override
    public List<WorkflowDefinition> getAllDefinitions() {
        String[] ids;
        ArrayList<WorkflowDefinition> definitions = new ArrayList<WorkflowDefinition>(10);
        for (String id : ids = this.registry.getWorkflowComponents()) {
            WorkflowComponent component = this.registry.getWorkflowComponent(id);
            definitions.addAll(component.getAllDefinitions());
        }
        return Collections.unmodifiableList(definitions);
    }

    @Override
    public WorkflowDefinition getDefinitionById(String workflowDefinitionId) {
        String engineId = BPMEngineRegistry.getEngineId(workflowDefinitionId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.getDefinitionById(workflowDefinitionId);
    }

    @Override
    public WorkflowDefinition getDefinitionByName(String workflowName) {
        String engineId = BPMEngineRegistry.getEngineId(workflowName);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.getDefinitionByName(workflowName);
    }

    @Override
    public List<WorkflowDefinition> getAllDefinitionsByName(String workflowName) {
        String engineId = BPMEngineRegistry.getEngineId(workflowName);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.getAllDefinitionsByName(workflowName);
    }

    @Override
    public byte[] getDefinitionImage(String workflowDefinitionId) {
        String engineId = BPMEngineRegistry.getEngineId(workflowDefinitionId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        byte[] definitionImage = component.getDefinitionImage(workflowDefinitionId);
        if (definitionImage == null) {
            definitionImage = new byte[]{};
        }
        return definitionImage;
    }

    @Override
    public List<WorkflowTaskDefinition> getTaskDefinitions(String workflowDefinitionId) {
        String engineId = BPMEngineRegistry.getEngineId(workflowDefinitionId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.getTaskDefinitions(workflowDefinitionId);
    }

    @Override
    public WorkflowPath startWorkflow(String workflowDefinitionId, Map<QName, Serializable> parameters) {
        String engineId = BPMEngineRegistry.getEngineId(workflowDefinitionId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.startWorkflow(workflowDefinitionId, parameters);
    }

    @Override
    public WorkflowPath startWorkflowFromTemplate(NodeRef templateDefinition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<WorkflowInstance> getActiveWorkflows(String workflowDefinitionId) {
        String engineId = BPMEngineRegistry.getEngineId(workflowDefinitionId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.getActiveWorkflows(workflowDefinitionId);
    }

    @Override
    public List<WorkflowInstance> getCompletedWorkflows(String workflowDefinitionId) {
        String engineId = BPMEngineRegistry.getEngineId(workflowDefinitionId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.getCompletedWorkflows(workflowDefinitionId);
    }

    @Override
    public List<WorkflowInstance> getWorkflows(String workflowDefinitionId) {
        String engineId = BPMEngineRegistry.getEngineId(workflowDefinitionId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.getWorkflows(workflowDefinitionId);
    }

    @Override
    public WorkflowInstance getWorkflowById(String workflowId) {
        String engineId = BPMEngineRegistry.getEngineId(workflowId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.getWorkflowById(workflowId);
    }

    @Override
    public List<WorkflowPath> getWorkflowPaths(String workflowId) {
        String engineId = BPMEngineRegistry.getEngineId(workflowId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.getWorkflowPaths(workflowId);
    }

    @Override
    public Map<QName, Serializable> getPathProperties(String pathId) {
        String engineId = BPMEngineRegistry.getEngineId(pathId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.getPathProperties(pathId);
    }

    @Override
    public WorkflowInstance cancelWorkflow(String workflowId) {
        String engineId = BPMEngineRegistry.getEngineId(workflowId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        WorkflowInstance instance = component.cancelWorkflow(workflowId);
        this.workflowPackageComponent.deletePackage(instance.workflowPackage);
        return instance;
    }

    @Override
    public WorkflowInstance deleteWorkflow(String workflowId) {
        String engineId = BPMEngineRegistry.getEngineId(workflowId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        WorkflowInstance instance = component.deleteWorkflow(workflowId);
        this.workflowPackageComponent.deletePackage(instance.workflowPackage);
        return instance;
    }

    @Override
    public WorkflowPath signal(String pathId, String transition) {
        String engineId = BPMEngineRegistry.getEngineId(pathId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.signal(pathId, transition);
    }

    @Override
    public WorkflowPath fireEvent(String pathId, String event) {
        String engineId = BPMEngineRegistry.getEngineId(pathId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.fireEvent(pathId, event);
    }

    @Override
    public List<WorkflowTimer> getTimers(String workflowId) {
        String engineId = BPMEngineRegistry.getEngineId(workflowId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.getTimers(workflowId);
    }

    @Override
    public List<WorkflowTask> getTasksForWorkflowPath(String pathId) {
        String engineId = BPMEngineRegistry.getEngineId(pathId);
        WorkflowComponent component = this.getWorkflowComponent(engineId);
        return component.getTasksForWorkflowPath(pathId);
    }

    @Override
    public List<WorkflowTask> getAssignedTasks(String authority, WorkflowTaskState state) {
        String[] ids;
        ArrayList<WorkflowTask> tasks = new ArrayList<WorkflowTask>(10);
        for (String id : ids = this.registry.getTaskComponents()) {
            TaskComponent component = this.registry.getTaskComponent(id);
            tasks.addAll(component.getAssignedTasks(authority, state));
        }
        return Collections.unmodifiableList(tasks);
    }

    @Override
    public List<WorkflowTask> getPooledTasks(String authority) {
        String[] ids;
        ArrayList<String> authorities = new ArrayList<String>();
        authorities.add(authority);
        Set<String> parents = this.authorityService.getContainingAuthorities(AuthorityType.GROUP, authority, false);
        authorities.addAll(parents);
        ArrayList<WorkflowTask> tasks = new ArrayList<WorkflowTask>(10);
        for (String id : ids = this.registry.getTaskComponents()) {
            TaskComponent component = this.registry.getTaskComponent(id);
            tasks.addAll(component.getPooledTasks(authorities));
        }
        return Collections.unmodifiableList(tasks);
    }

    @Override
    public List<WorkflowTask> queryTasks(WorkflowTaskQuery query) {
        String[] ids;
        String taskId;
        String engineId = null;
        String processId = query.getProcessId();
        if (processId != null) {
            engineId = BPMEngineRegistry.getEngineId(processId);
        }
        if ((taskId = query.getTaskId()) != null) {
            String taskEngineId = BPMEngineRegistry.getEngineId(taskId);
            if (engineId != null && !engineId.equals(taskEngineId)) {
                throw new WorkflowException("Cannot query for tasks across multiple task components: " + engineId + ", " + taskEngineId);
            }
            engineId = taskEngineId;
        }
        ArrayList<WorkflowTask> tasks = new ArrayList<WorkflowTask>(10);
        for (String id : ids = this.registry.getTaskComponents()) {
            TaskComponent component = this.registry.getTaskComponent(id);
            if (engineId != null && !engineId.equals(id)) continue;
            tasks.addAll(component.queryTasks(query));
        }
        return Collections.unmodifiableList(tasks);
    }

    @Override
    public WorkflowTask updateTask(String taskId, Map<QName, Serializable> properties, Map<QName, List<NodeRef>> add, Map<QName, List<NodeRef>> remove) {
        String engineId = BPMEngineRegistry.getEngineId(taskId);
        TaskComponent component = this.getTaskComponent(engineId);
        return component.updateTask(taskId, properties, add, remove);
    }

    @Override
    public WorkflowTask endTask(String taskId, String transition) {
        String engineId = BPMEngineRegistry.getEngineId(taskId);
        TaskComponent component = this.getTaskComponent(engineId);
        return component.endTask(taskId, transition);
    }

    @Override
    public boolean isTaskEditable(WorkflowTask task, String username) {
        if (task.getState() == WorkflowTaskState.COMPLETED) {
            return false;
        }
        if (this.isUserOwnerOrInitiator(task, username)) {
            return true;
        }
        if (task.getProperties().get(ContentModel.PROP_OWNER) == null) {
            return this.isUserInPooledActors(task, username);
        }
        return false;
    }

    @Override
    public boolean isTaskReassignable(WorkflowTask task, String username) {
        if (task.getState() == WorkflowTaskState.COMPLETED) {
            return false;
        }
        if (task.getProperties().get(ContentModel.PROP_OWNER) == null) {
            return false;
        }
        Map<QName, Serializable> properties = task.getProperties();
        Boolean reassignable = (Boolean)properties.get(WorkflowModel.PROP_REASSIGNABLE);
        if (reassignable != null && !reassignable.booleanValue()) {
            return false;
        }
        Collection actors = (Collection)((Object)properties.get(WorkflowModel.ASSOC_POOLED_ACTORS));
        String owner = (String)((Object)properties.get(ContentModel.PROP_OWNER));
        if (actors != null && !actors.isEmpty() && owner != null) {
            return false;
        }
        return this.isUserOwnerOrInitiator(task, username);
    }

    @Override
    public boolean isTaskClaimable(WorkflowTask task, String username) {
        if (task.getState() == WorkflowTaskState.COMPLETED) {
            return false;
        }
        if (task.getProperties().get(ContentModel.PROP_OWNER) != null) {
            return false;
        }
        return this.isUserInPooledActors(task, username);
    }

    @Override
    public boolean isTaskReleasable(WorkflowTask task, String username) {
        if (task.getState() == WorkflowTaskState.COMPLETED) {
            return false;
        }
        Map<QName, Serializable> properties = task.getProperties();
        Collection actors = (Collection)((Object)properties.get(WorkflowModel.ASSOC_POOLED_ACTORS));
        if (actors == null || actors.isEmpty()) {
            return false;
        }
        String owner = (String)((Object)properties.get(ContentModel.PROP_OWNER));
        if (owner == null) {
            return false;
        }
        return this.isUserOwnerOrInitiator(task, username);
    }

    @Override
    public WorkflowTask getTaskById(String taskId) {
        String engineId = BPMEngineRegistry.getEngineId(taskId);
        TaskComponent component = this.getTaskComponent(engineId);
        return component.getTaskById(taskId);
    }

    @Override
    public NodeRef createPackage(NodeRef container) {
        return this.workflowPackageComponent.createPackage(container);
    }

    @Override
    public List<WorkflowInstance> getWorkflowsForContent(NodeRef packageItem, boolean active) {
        List<String> workflowIds = this.workflowPackageComponent.getWorkflowIdsForContent(packageItem);
        ArrayList<WorkflowInstance> workflowInstances = new ArrayList<WorkflowInstance>(workflowIds.size());
        for (String workflowId : workflowIds) {
            String engineId = BPMEngineRegistry.getEngineId(workflowId);
            WorkflowComponent component = this.getWorkflowComponent(engineId);
            WorkflowInstance instance = component.getWorkflowById(workflowId);
            if (instance == null || instance.active != active) continue;
            workflowInstances.add(instance);
        }
        return workflowInstances;
    }

    private WorkflowComponent getWorkflowComponent(String engineId) {
        WorkflowComponent component = this.registry.getWorkflowComponent(engineId);
        if (component == null) {
            throw new WorkflowException("Workflow Component for engine id '" + engineId + "' is not registered");
        }
        return component;
    }

    private TaskComponent getTaskComponent(String engineId) {
        TaskComponent component = this.registry.getTaskComponent(engineId);
        if (component == null) {
            throw new WorkflowException("Task Component for engine id '" + engineId + "' is not registered");
        }
        return component;
    }

    @Override
    public List<NodeRef> getPackageContents(String taskId) {
        NodeRef workflowPackage = this.getWorkflowPackageIfExists(taskId);
        if (workflowPackage == null) {
            return Collections.emptyList();
        }
        if (workflowPackage.getStoreRef().getProtocol().equals("avm")) {
            return this.getAvmPackageContents(workflowPackage);
        }
        return this.getRepositoryPackageContents(workflowPackage);
    }

    private NodeRef getWorkflowPackageIfExists(String taskId) {
        WorkflowTask workflowTask = this.getTaskById(taskId);
        if (workflowTask != null) {
            return (NodeRef)workflowTask.properties.get(WorkflowModel.ASSOC_PACKAGE);
        }
        return null;
    }

    private List<NodeRef> getRepositoryPackageContents(NodeRef workflowPackage) {
        ArrayList<NodeRef> contents = new ArrayList<NodeRef>();
        List packageAssocs = this.protectedNodeService.getChildAssocs(workflowPackage);
        for (ChildAssociationRef assoc : packageAssocs) {
            NodeRef nodeRef = assoc.getChildRef();
            QName assocType = assoc.getTypeQName();
            if (!this.protectedNodeService.exists(nodeRef)) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Ignoring " + nodeRef + " as it has been removed from the repository"));
                continue;
            }
            if (!ContentModel.ASSOC_CONTAINS.equals((Object)assocType) && !WorkflowModel.ASSOC_PACKAGE_CONTAINS.equals((Object)assocType)) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Ignoring " + nodeRef + " as it has an invalid association type: " + assocType));
                continue;
            }
            if (!this.checkTypeIsInDataDictionary(nodeRef)) continue;
            contents.add(nodeRef);
        }
        return contents;
    }

    private boolean checkTypeIsInDataDictionary(NodeRef nodeRef) {
        QName type = this.protectedNodeService.getType(nodeRef);
        if (this.dictionaryService.getType(type) == null) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Found invalid object in database: id = " + nodeRef + ", type = " + type));
            }
            return false;
        }
        return true;
    }

    private List<NodeRef> getAvmPackageContents(NodeRef workflowPackage) {
        ArrayList<NodeRef> contents = new ArrayList<NodeRef>();
        if (this.protectedNodeService.exists(workflowPackage)) {
            NodeRef stagingNodeRef = (NodeRef)this.protectedNodeService.getProperty(workflowPackage, WCMModel.PROP_AVM_DIR_INDIRECTION);
            String stagingAvmPath = (String)AVMNodeConverter.ToAVMVersionPath(stagingNodeRef).getSecond();
            String packageAvmPath = (String)AVMNodeConverter.ToAVMVersionPath(workflowPackage).getSecond();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("comparing " + packageAvmPath + " with " + stagingAvmPath));
            }
            for (AVMDifference d : this.avmSyncService.compare(-1, packageAvmPath, -1, stagingAvmPath, null)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("got difference " + d));
                }
                if (d.getDifferenceCode() != 0 && d.getDifferenceCode() != 2) continue;
                contents.add(AVMNodeConverter.ToNodeRef(d.getSourceVersion(), d.getSourcePath()));
            }
        }
        return contents;
    }

    private boolean isUserInPooledActors(WorkflowTask task, String username) {
        Collection actors = (Collection)((Object)task.getProperties().get(WorkflowModel.ASSOC_POOLED_ACTORS));
        if (actors != null && !actors.isEmpty()) {
            for (Object actor : actors) {
                Map props = this.nodeService.getProperties((NodeRef)actor);
                String name = (String)props.get(ContentModel.PROP_AUTHORITY_NAME);
                Set<String> users = this.authorityService.getContainedAuthorities(AuthorityType.USER, name, false);
                if (users == null || users.isEmpty() || !users.contains(username)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isUserOwnerOrInitiator(WorkflowTask task, String username) {
        boolean result = false;
        String owner = (String)((Object)task.getProperties().get(ContentModel.PROP_OWNER));
        if (username.equals(owner)) {
            result = true;
        } else if (username.equals(this.getWorkflowInitiatorUsername(task))) {
            result = true;
        }
        return result;
    }

    private String getWorkflowInitiatorUsername(WorkflowTask task) {
        String initiator = null;
        NodeRef initiatorRef = task.getPath().getInstance().getInitiator();
        if (initiatorRef != null && this.nodeService.exists(initiatorRef)) {
            initiator = (String)((Object)this.nodeService.getProperty(initiatorRef, ContentModel.PROP_USERNAME));
        }
        return initiator;
    }
}

