/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jbpm;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipInputStream;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authority.AuthorityDAO;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.workflow.BPMEngine;
import org.alfresco.repo.workflow.TaskComponent;
import org.alfresco.repo.workflow.WorkflowComponent;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.jbpm.JBPMJpdlXmlReader;
import org.alfresco.repo.workflow.jbpm.JBPMNode;
import org.alfresco.repo.workflow.jbpm.JBPMNodeList;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowDeployment;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowNode;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskDefinition;
import org.alfresco.service.cmr.workflow.WorkflowTaskQuery;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.cmr.workflow.WorkflowTimer;
import org.alfresco.service.cmr.workflow.WorkflowTransition;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.hibernate.proxy.HibernateProxy;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.context.exe.TokenVariableMap;
import org.jbpm.context.exe.VariableInstance;
import org.jbpm.db.GraphSession;
import org.jbpm.db.TaskMgmtSession;
import org.jbpm.file.def.FileDefinition;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.Comment;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.node.TaskNode;
import org.jbpm.job.Timer;
import org.jbpm.jpdl.par.ProcessArchive;
import org.jbpm.jpdl.xml.Problem;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.def.TaskMgmtDefinition;
import org.jbpm.taskmgmt.exe.PooledActor;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.springframework.dao.DataAccessException;
import org.springframework.util.StringUtils;
import org.springmodules.workflow.jbpm31.JbpmCallback;
import org.springmodules.workflow.jbpm31.JbpmTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBPMEngine
extends BPMEngine
implements WorkflowComponent,
TaskComponent {
    protected DictionaryService dictionaryService;
    protected NamespaceService namespaceService;
    protected NodeService nodeService;
    private TenantService tenantService;
    private MessageService messageService;
    protected ServiceRegistry serviceRegistry;
    protected PersonService personService;
    protected AuthorityDAO authorityDAO;
    protected JbpmTemplate jbpmTemplate;
    protected SearchService unprotectedSearchService;
    protected StoreRef companyHomeStore;
    protected String companyHomePath;
    private static final String COMPLETED_TASKS_QUERY = "select ti from org.jbpm.taskmgmt.exe.TaskInstance as ti where ti.actorId = :actorId and ti.isOpen = false and ti.end is not null";
    private static final String PROCESS_TIMERS_QUERY = "select timer from org.jbpm.job.Timer timer where timer.processInstance = :process ";
    private static final String WORKFLOW_PATH_SEPERATOR = "-";
    private static final String WORKFLOW_TOKEN_SEPERATOR = "@";
    private static final String TITLE_LABEL = "title";
    private static final String DESC_LABEL = "description";
    private static final String DEFAULT_TRANSITION_LABEL = "bpm_businessprocessmodel.transition";
    private static final String ERR_MANDATORY_TASK_PROPERTIES_MISSING = "Jbpm.engine.mandatory.properties.missing";
    private static final String ERR_DEPLOY_WORKFLOW = "jbpm.engine.deploy.workflow.error";
    private static final String ERR_IS_WORKFLOW_DEPLOYED = "jbpm.engine.is.workflow.deployed.error";
    private static final String ERR_UNDEPLOY_WORKFLOW = "jbpm.engine.undeploy.workflow.error";
    private static final String ERR_GET_WORKFLOW_DEF = "jbpm.engine.get.workflow.definition.error";
    private static final String ERR_GET_WORKFLOW_DEF_BY_ID = "jbpm.engine.get.workflow.definition.by.id.error";
    private static final String ERR_GET_WORKFLOW_DEF_BY_NAME = "jbpm.engine.get.workflow.definition.by.name.error";
    private static final String ERR_GET_ALL_DEFS_BY_NAME = "jbpm.engine.get.all.workflow.definitions.by.name.error";
    private static final String ERR_GET_DEF_IMAGE = "jbpm.engine.get.workflow.definition.image.error";
    private static final String ERR_GET_TASK_DEFS = "jbpm.engine.get.task.definitions.error";
    private static final String ERR_GET_PROCESS_DEF = "jbpm.engine.get.process.definition.error";
    private static final String ERR_START_WORKFLOW = "jbpm.enginestart.workflow.error";
    private static final String ERR_GET_ACTIVE_WORKFLOW_INSTS = "jbpm.engine.get.active.workflows.error";
    private static final String ERR_GET_WORKFLOW_INST_BY_ID = "jbpm.engine.get.workflow.instance.by.id.error";
    private static final String ERR_GET_PROCESS_INSTANCE = "jbpm.engine.get.process.instance.error";
    private static final String ERR_GET_WORKFLOW_PATHS = "jbpm.engine.get.workflow.paths.error";
    private static final String ERR_GET_PATH_PROPERTIES = "jbpm.engine.get.path.properties.error";
    private static final String ERR_CANCEL_WORKFLOW = "jbpm.engine.cancel.workflow.error";
    private static final String ERR_DELETE_WORKFLOW = "jbpm.engine.delete.workflow.error";
    private static final String ERR_SIGNAL_TRANSITION = "jbpm.engine.signal.transition.error";
    protected static final String ERR_INVALID_EVENT = "jbpm.engine.invalid.event";
    private static final String ERR_FIRE_EVENT = "jbpm.engine.fire.event.error";
    private static final String ERR_GET_TASKS_FOR_PATH = "jbpm.engine.get.tasks.for.path.error";
    private static final String ERR_GET_TIMERS = "jbpm.engine.get.timers.error";
    protected static final String ERR_FIND_COMPLETED_TASK_INSTS = "jbpm.engine.find.completed.task.instances.error";
    private static final String ERR_GET_ASSIGNED_TASKS = "jbpm.engine.get.assigned.tasks.error";
    private static final String ERR_GET_POOLED_TASKS = "jbpm.engine.get.pooled.tasks.error";
    private static final String ERR_QUERY_TASKS = "jbpm.engine.query.tasks.error";
    private static final String ERR_GET_TASK_INST = "jbpm.engine.get.task.instance.error";
    private static final String ERR_UPDATE_TASK = "jbpm.engine.update.task.error";
    protected static final String ERR_END_TASK_INVALID_TRANSITION = "jbpm.engine.end.task.invalid.transition";
    private static final String ERR_END_TASK = "jbpm.engine.end.task.error";
    private static final String ERR_GET_TASK_BY_ID = "jbpm.engine.get.task.by.id.error";
    private static final String ERR_COMPILE_PROCESS_DEF_zip = "jbpm.engine.compile.process.definition.zip.error";
    private static final String ERR_COMPILE_PROCESS_DEF_XML = "jbpm.engine.compile.process.definition.xml.error";
    private static final String ERR_COMPILE_PROCESS_DEF_UNSUPPORTED = "jbpm.engine.compile.process.definition.unsupported.error";
    private static final String ERR_GET_TASK_DEF = "jbpm.engine.get.task.definition.error";
    private static final String ERR_GET_JBPM_ID = "jbpm.engine.get.jbpm.id.error";
    private static final String ERR_GET_WORKFLOW_TOKEN_INVALID = "jbpm.engine.get.workflow.token.invalid";
    private static final String ERR_GET_WORKFLOW_TOKEN_NULL = "jbpm.engine.get.workflow.token.is.null";
    private static final String ERR_SET_TASK_PROPS_INVALID_VALUE = "jbpm.engine.set.task.properties.invalid.value";
    private static final String ERR_PACKAGE_ALREADY_ASSOCIATED = "jbpm.engine.package.already.associated.error";
    private static final String ERR_CONVERT_VALUE = "jbpm.engine.convert.value.error";
    private static final String ERR_GET_COMPANY_HOME_INVALID = "jbpm.engine.get.company.home.invalid";
    private static final String ERR_GET_COMPANY_HOME_MULTIPLE = "jbpm.engine.get.company.home.multiple";

    public void setJBPMTemplate(JbpmTemplate jbpmTemplate) {
        this.jbpmTemplate = jbpmTemplate;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setAuthorityDAO(AuthorityDAO authorityDAO) {
        this.authorityDAO = authorityDAO;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setCompanyHomePath(String companyHomePath) {
        this.companyHomePath = companyHomePath;
    }

    public void setCompanyHomeStore(String companyHomeStore) {
        this.companyHomeStore = new StoreRef(companyHomeStore);
    }

    public void setUnprotectedSearchService(SearchService unprotectedSearchService) {
        this.unprotectedSearchService = unprotectedSearchService;
    }

    @Override
    public WorkflowDeployment deployDefinition(final InputStream workflowDefinition, final String mimetype) {
        try {
            return (WorkflowDeployment)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    CompiledProcessDefinition compiledDef = JBPMEngine.this.compileProcessDefinition(workflowDefinition, mimetype);
                    context.deployProcessDefinition(compiledDef.def);
                    WorkflowDeployment workflowDeployment = JBPMEngine.this.createWorkflowDeployment(compiledDef);
                    return workflowDeployment;
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_DEPLOY_WORKFLOW);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public boolean isDefinitionDeployed(final InputStream workflowDefinition, final String mimetype) {
        try {
            return (Boolean)this.jbpmTemplate.execute(new JbpmCallback(){

                public Boolean doInJbpm(JbpmContext context) {
                    CompiledProcessDefinition processDefinition = JBPMEngine.this.compileProcessDefinition(workflowDefinition, mimetype);
                    GraphSession graphSession = context.getGraphSession();
                    ProcessDefinition existingDefinition = graphSession.findLatestProcessDefinition(processDefinition.def.getName());
                    return existingDefinition != null;
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_IS_WORKFLOW_DEPLOYED);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public void undeployDefinition(final String workflowDefinitionId) {
        try {
            this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    GraphSession graphSession = context.getGraphSession();
                    ProcessDefinition processDefinition = JBPMEngine.this.getProcessDefinition(graphSession, workflowDefinitionId);
                    graphSession.deleteProcessDefinition(processDefinition);
                    return null;
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_UNDEPLOY_WORKFLOW, workflowDefinitionId);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public List<WorkflowDefinition> getDefinitions() {
        try {
            return (List)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    GraphSession graphSession = context.getGraphSession();
                    List processDefs = graphSession.findLatestProcessDefinitions();
                    ArrayList<WorkflowDefinition> workflowDefs = new ArrayList<WorkflowDefinition>(processDefs.size());
                    for (ProcessDefinition processDef : processDefs) {
                        if (JBPMEngine.this.tenantService.isEnabled()) {
                            try {
                                JBPMEngine.this.tenantService.checkDomain(processDef.getName());
                            }
                            catch (RuntimeException re) {
                                continue;
                            }
                        }
                        WorkflowDefinition workflowDef = JBPMEngine.this.createWorkflowDefinition(processDef);
                        workflowDefs.add(workflowDef);
                    }
                    return workflowDefs;
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_WORKFLOW_DEF);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public List<WorkflowDefinition> getAllDefinitions() {
        try {
            return (List)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    GraphSession graphSession = context.getGraphSession();
                    List processDefs = graphSession.findAllProcessDefinitions();
                    ArrayList<WorkflowDefinition> workflowDefs = new ArrayList<WorkflowDefinition>(processDefs.size());
                    for (ProcessDefinition processDef : processDefs) {
                        if (JBPMEngine.this.tenantService.isEnabled()) {
                            try {
                                JBPMEngine.this.tenantService.checkDomain(processDef.getName());
                            }
                            catch (RuntimeException re) {
                                continue;
                            }
                        }
                        WorkflowDefinition workflowDef = JBPMEngine.this.createWorkflowDefinition(processDef);
                        workflowDefs.add(workflowDef);
                    }
                    return workflowDefs;
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_WORKFLOW_DEF);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public WorkflowDefinition getDefinitionById(final String workflowDefinitionId) {
        try {
            return (WorkflowDefinition)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    GraphSession graphSession = context.getGraphSession();
                    ProcessDefinition processDefinition = JBPMEngine.this.getProcessDefinition(graphSession, workflowDefinitionId);
                    return processDefinition == null ? null : JBPMEngine.this.createWorkflowDefinition(processDefinition);
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_WORKFLOW_DEF_BY_ID, workflowDefinitionId);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public WorkflowDefinition getDefinitionByName(final String workflowName) {
        try {
            return (WorkflowDefinition)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    GraphSession graphSession = context.getGraphSession();
                    ProcessDefinition processDef = graphSession.findLatestProcessDefinition(JBPMEngine.this.tenantService.getName(JBPMEngine.this.createLocalId(workflowName)));
                    return processDef == null ? null : JBPMEngine.this.createWorkflowDefinition(processDef);
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_WORKFLOW_DEF_BY_NAME, workflowName);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public List<WorkflowDefinition> getAllDefinitionsByName(final String workflowName) {
        try {
            return (List)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    GraphSession graphSession = context.getGraphSession();
                    List processDefs = graphSession.findAllProcessDefinitionVersions(JBPMEngine.this.tenantService.getName(JBPMEngine.this.createLocalId(workflowName)));
                    ArrayList<WorkflowDefinition> workflowDefs = new ArrayList<WorkflowDefinition>(processDefs.size());
                    for (ProcessDefinition processDef : processDefs) {
                        WorkflowDefinition workflowDef = JBPMEngine.this.createWorkflowDefinition(processDef);
                        workflowDefs.add(workflowDef);
                    }
                    return workflowDefs;
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_ALL_DEFS_BY_NAME, workflowName);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public byte[] getDefinitionImage(final String workflowDefinitionId) {
        try {
            return (byte[])this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    GraphSession graphSession = context.getGraphSession();
                    ProcessDefinition processDefinition = JBPMEngine.this.getProcessDefinition(graphSession, workflowDefinitionId);
                    FileDefinition fileDefinition = processDefinition.getFileDefinition();
                    return fileDefinition == null ? null : fileDefinition.getBytes("processimage.jpg");
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_DEF_IMAGE, workflowDefinitionId);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public List<WorkflowTaskDefinition> getTaskDefinitions(final String workflowDefinitionId) {
        try {
            return (List)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    GraphSession graphSession = context.getGraphSession();
                    ProcessDefinition processDefinition = JBPMEngine.this.getProcessDefinition(graphSession, workflowDefinitionId);
                    if (processDefinition == null) {
                        return null;
                    }
                    String processName = processDefinition.getName();
                    if (JBPMEngine.this.tenantService.isEnabled()) {
                        JBPMEngine.this.tenantService.checkDomain(processName);
                    }
                    TaskMgmtDefinition taskMgmtDef = processDefinition.getTaskMgmtDefinition();
                    ArrayList<WorkflowTaskDefinition> workflowTaskDefs = new ArrayList<WorkflowTaskDefinition>();
                    for (Object task : taskMgmtDef.getTasks().values()) {
                        workflowTaskDefs.add(JBPMEngine.this.createWorkflowTaskDefinition((Task)task));
                    }
                    return workflowTaskDefs.size() == 0 ? null : workflowTaskDefs;
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_TASK_DEFS, workflowDefinitionId);
            throw new WorkflowException(msg, e);
        }
    }

    protected ProcessDefinition getProcessDefinition(GraphSession graphSession, String workflowDefinitionId) {
        ProcessDefinition processDefinition = graphSession.getProcessDefinition(this.getJbpmId(workflowDefinitionId));
        if (processDefinition != null && this.tenantService.isEnabled()) {
            try {
                this.tenantService.checkDomain(processDefinition.getName());
            }
            catch (RuntimeException re) {
                processDefinition = null;
            }
        }
        if (processDefinition == null) {
            String msg = this.messageService.getMessage(ERR_GET_PROCESS_DEF, workflowDefinitionId);
            throw new WorkflowException(msg);
        }
        return processDefinition;
    }

    @Override
    public WorkflowPath startWorkflow(final String workflowDefinitionId, final Map<QName, Serializable> parameters) {
        try {
            return (WorkflowPath)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    String currentUserName = AuthenticationUtil.getFullyAuthenticatedUser();
                    context.setActorId(currentUserName);
                    GraphSession graphSession = context.getGraphSession();
                    ProcessDefinition processDefinition = JBPMEngine.this.getProcessDefinition(graphSession, workflowDefinitionId);
                    ProcessInstance processInstance = new ProcessInstance(processDefinition);
                    processInstance.setKey(GUID.generate());
                    ContextInstance processContext = processInstance.getContextInstance();
                    processContext.setVariable("cancelled", (Object)false);
                    NodeRef companyHome = JBPMEngine.this.getCompanyHome();
                    processContext.setVariable("companyhome", (Object)new JBPMNode(companyHome, JBPMEngine.this.serviceRegistry));
                    NodeRef initiatorPerson = JBPMEngine.this.mapNameToPerson(currentUserName);
                    if (initiatorPerson != null) {
                        processContext.setVariable("initiator", (Object)new JBPMNode(initiatorPerson, JBPMEngine.this.serviceRegistry));
                        NodeRef initiatorHome = (NodeRef)JBPMEngine.this.nodeService.getProperty(initiatorPerson, ContentModel.PROP_HOMEFOLDER);
                        if (initiatorHome != null) {
                            processContext.setVariable("initiatorhome", (Object)new JBPMNode(initiatorHome, JBPMEngine.this.serviceRegistry));
                        }
                    }
                    processContext.setVariable("workflowinstanceid", (Object)JBPMEngine.this.createGlobalId(new Long(processInstance.getId()).toString()));
                    Token token = processInstance.getRootToken();
                    Task startTask = processInstance.getTaskMgmtInstance().getTaskMgmtDefinition().getStartTask();
                    if (startTask != null) {
                        TaskInstance taskInstance = processInstance.getTaskMgmtInstance().createStartTaskInstance();
                        JBPMEngine.this.setTaskProperties(taskInstance, parameters);
                        token = taskInstance.getToken();
                    }
                    context.save(processInstance);
                    return JBPMEngine.this.createWorkflowPath(token);
                }
            });
        }
        catch (JbpmException e) {
            throw this.getStartWorkflowException(workflowDefinitionId, (Exception)((Object)e));
        }
        catch (DataAccessException e) {
            throw this.getStartWorkflowException(workflowDefinitionId, (Exception)((Object)e));
        }
    }

    private WorkflowException getStartWorkflowException(String workflowDefinitionId, Exception e) {
        String msg = this.messageService.getMessage(ERR_START_WORKFLOW, workflowDefinitionId);
        return new WorkflowException(msg, e);
    }

    @Override
    public List<WorkflowInstance> getActiveWorkflows(String workflowDefinitionId) {
        return this.getWorkflowsInternal(workflowDefinitionId, true);
    }

    @Override
    public List<WorkflowInstance> getCompletedWorkflows(String workflowDefinitionId) {
        return this.getWorkflowsInternal(workflowDefinitionId, false);
    }

    @Override
    public List<WorkflowInstance> getWorkflows(String workflowDefinitionId) {
        return this.getWorkflowsInternal(workflowDefinitionId, null);
    }

    private List<WorkflowInstance> getWorkflowsInternal(final String workflowDefinitionId, final Boolean active) {
        try {
            return (List)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    GraphSession graphSession = context.getGraphSession();
                    List processInstances = graphSession.findProcessInstances(JBPMEngine.this.getJbpmId(workflowDefinitionId));
                    ArrayList<WorkflowInstance> workflowInstances = new ArrayList<WorkflowInstance>(processInstances.size());
                    for (ProcessInstance processInstance : processInstances) {
                        if (active != null && (active.booleanValue() || !processInstance.hasEnded()) && (!active.booleanValue() || processInstance.hasEnded())) continue;
                        WorkflowInstance workflowInstance = JBPMEngine.this.createWorkflowInstance(processInstance);
                        workflowInstances.add(workflowInstance);
                    }
                    return workflowInstances;
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_ACTIVE_WORKFLOW_INSTS, workflowDefinitionId);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public WorkflowInstance getWorkflowById(final String workflowId) {
        try {
            return (WorkflowInstance)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    GraphSession graphSession = context.getGraphSession();
                    ProcessInstance processInstance = JBPMEngine.this.getProcessInstanceIfExists(graphSession, workflowId);
                    return processInstance == null ? null : JBPMEngine.this.createWorkflowInstance(processInstance);
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_WORKFLOW_INST_BY_ID);
            throw new WorkflowException(msg, e);
        }
    }

    private ProcessInstance getProcessInstanceIfExists(GraphSession graphSession, String workflowId) {
        ProcessInstance processInstance = graphSession.getProcessInstance(this.getJbpmId(workflowId));
        if (processInstance != null && this.tenantService.isEnabled()) {
            try {
                this.tenantService.checkDomain(processInstance.getProcessDefinition().getName());
            }
            catch (RuntimeException re) {
                processInstance = null;
            }
        }
        return processInstance;
    }

    protected ProcessInstance getProcessInstance(GraphSession graphSession, String workflowId) {
        ProcessInstance processInstance = this.getProcessInstanceIfExists(graphSession, workflowId);
        if (processInstance == null) {
            String msg = this.messageService.getMessage(ERR_GET_PROCESS_INSTANCE, workflowId);
            throw new WorkflowException(msg);
        }
        return processInstance;
    }

    @Override
    public List<WorkflowPath> getWorkflowPaths(final String workflowId) {
        try {
            return (List)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    GraphSession graphSession = context.getGraphSession();
                    ProcessInstance processInstance = JBPMEngine.this.getProcessInstance(graphSession, workflowId);
                    List tokens = processInstance.findAllTokens();
                    ArrayList<WorkflowPath> paths = new ArrayList<WorkflowPath>(tokens.size());
                    for (Token token : tokens) {
                        if (token.hasEnded()) continue;
                        WorkflowPath path = JBPMEngine.this.createWorkflowPath(token);
                        paths.add(path);
                    }
                    return paths;
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_WORKFLOW_PATHS, workflowId);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public Map<QName, Serializable> getPathProperties(final String pathId) {
        try {
            return (Map)this.jbpmTemplate.execute(new JbpmCallback(){

                public Map<QName, Serializable> doInJbpm(JbpmContext context) {
                    Token token;
                    GraphSession graphSession = context.getGraphSession();
                    ContextInstance instanceContext = token.getProcessInstance().getContextInstance();
                    HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>(10);
                    for (token = JBPMEngine.this.getWorkflowToken(graphSession, pathId); token != null; token = token.getParent()) {
                        TokenVariableMap varMap = instanceContext.getTokenVariableMap(token);
                        if (varMap == null) continue;
                        Map tokenVars = varMap.getVariablesLocally();
                        for (Map.Entry entry : tokenVars.entrySet()) {
                            String key = (String)entry.getKey();
                            QName qname = JBPMEngine.this.mapNameToQName(key);
                            if (properties.containsKey(key)) continue;
                            Serializable value = JBPMEngine.this.convertValue(entry.getValue());
                            properties.put(qname, value);
                        }
                    }
                    return properties;
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_PATH_PROPERTIES, pathId);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public WorkflowInstance cancelWorkflow(final String workflowId) {
        try {
            return (WorkflowInstance)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    GraphSession graphSession = context.getGraphSession();
                    ProcessInstance processInstance = JBPMEngine.this.getProcessInstance(graphSession, workflowId);
                    processInstance.getContextInstance().setVariable("cancelled", (Object)true);
                    processInstance.end();
                    WorkflowInstance workflowInstance = JBPMEngine.this.createWorkflowInstance(processInstance);
                    graphSession.deleteProcessInstance(processInstance, true, true);
                    return workflowInstance;
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_CANCEL_WORKFLOW, workflowId);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public WorkflowInstance deleteWorkflow(final String workflowId) {
        try {
            return (WorkflowInstance)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    GraphSession graphSession = context.getGraphSession();
                    ProcessInstance processInstance = JBPMEngine.this.getProcessInstance(graphSession, workflowId);
                    WorkflowInstance workflowInstance = JBPMEngine.this.createWorkflowInstance(processInstance);
                    graphSession.deleteProcessInstance(processInstance, true, true);
                    workflowInstance.active = false;
                    workflowInstance.endDate = new Date();
                    return workflowInstance;
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_DELETE_WORKFLOW, workflowId);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public WorkflowPath signal(final String pathId, final String transition) {
        try {
            return (WorkflowPath)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    GraphSession graphSession = context.getGraphSession();
                    Token token = JBPMEngine.this.getWorkflowToken(graphSession, pathId);
                    if (transition == null) {
                        token.signal();
                    } else {
                        Node node = token.getNode();
                        if (!node.hasLeavingTransition(transition)) {
                            throw new WorkflowException("Transition '" + transition + "' is invalid for Workflow path '" + pathId + "'");
                        }
                        token.signal(transition);
                    }
                    ProcessInstance processInstance = token.getProcessInstance();
                    context.save(processInstance);
                    return JBPMEngine.this.createWorkflowPath(token);
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_SIGNAL_TRANSITION, transition, pathId);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public WorkflowPath fireEvent(final String pathId, final String event) {
        try {
            return (WorkflowPath)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    if (event.equals("after-signal") || event.equals("before-signal") || event.equals("node-enter") || event.equals("node-leave") || event.equals("process-end") || event.equals("process-start") || event.equals("subprocess-created") || event.equals("subprocess-end") || event.equals("superstate-enter") || event.equals("superstate-leave") || event.equals("task-assign") || event.equals("task-create") || event.equals("task-end") || event.equals("task-start") || event.equals("timer") || event.equals("transition")) {
                        String msg = JBPMEngine.this.messageService.getMessage(JBPMEngine.ERR_INVALID_EVENT, event);
                        throw new WorkflowException(msg);
                    }
                    GraphSession graphSession = context.getGraphSession();
                    Token token = JBPMEngine.this.getWorkflowToken(graphSession, pathId);
                    ExecutionContext executionContext = new ExecutionContext(token);
                    TaskMgmtSession taskSession = context.getTaskMgmtSession();
                    List tasks = taskSession.findTaskInstancesByToken(token.getId());
                    if (tasks.size() == 0) {
                        Node node = token.getNode();
                        node.fireEvent(event, executionContext);
                    } else {
                        for (TaskInstance task : tasks) {
                            executionContext.setTaskInstance(task);
                            task.getTask().fireEvent(event, executionContext);
                        }
                    }
                    ProcessInstance processInstance = token.getProcessInstance();
                    context.save(processInstance);
                    return JBPMEngine.this.createWorkflowPath(token);
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_FIRE_EVENT, event, pathId);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public List<WorkflowTask> getTasksForWorkflowPath(final String pathId) {
        try {
            return (List)this.jbpmTemplate.execute(new JbpmCallback(){

                public List<WorkflowTask> doInJbpm(JbpmContext context) {
                    GraphSession graphSession = context.getGraphSession();
                    Token token = JBPMEngine.this.getWorkflowToken(graphSession, pathId);
                    TaskMgmtSession taskSession = context.getTaskMgmtSession();
                    List tasks = taskSession.findTaskInstancesByToken(token.getId());
                    return JBPMEngine.this.getWorkflowTasks(tasks);
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_TASKS_FOR_PATH, pathId);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public List<WorkflowTimer> getTimers(final String workflowId) {
        try {
            return (List)this.jbpmTemplate.execute(new JbpmCallback(){

                public List<WorkflowTimer> doInJbpm(JbpmContext context) {
                    GraphSession graphSession = context.getGraphSession();
                    ProcessInstance process = JBPMEngine.this.getProcessInstance(graphSession, workflowId);
                    Session session = context.getSession();
                    Query query = session.createQuery(JBPMEngine.PROCESS_TIMERS_QUERY);
                    query.setEntity("process", (Object)process);
                    List timers = query.list();
                    ArrayList<WorkflowTimer> workflowTimers = new ArrayList<WorkflowTimer>(timers.size());
                    for (Timer timer : timers) {
                        WorkflowTimer workflowTimer = JBPMEngine.this.createWorkflowTimer(timer);
                        workflowTimers.add(workflowTimer);
                    }
                    return workflowTimers;
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_TIMERS, workflowId);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public List<WorkflowTask> getAssignedTasks(final String authority, final WorkflowTaskState state) {
        try {
            return (List)this.jbpmTemplate.execute(new JbpmCallback(){

                public List<WorkflowTask> doInJbpm(JbpmContext context) {
                    List tasks;
                    if (state.equals((Object)WorkflowTaskState.IN_PROGRESS)) {
                        TaskMgmtSession taskSession = context.getTaskMgmtSession();
                        tasks = taskSession.findTaskInstances(authority);
                    } else {
                        tasks = this.findCompletedTaskInstances(context, authority);
                    }
                    return JBPMEngine.this.getWorkflowTasks(tasks);
                }

                private List findCompletedTaskInstances(JbpmContext jbpmContext, String actorId) {
                    List result = null;
                    try {
                        Session session = jbpmContext.getSession();
                        Query query = session.createQuery(JBPMEngine.COMPLETED_TASKS_QUERY);
                        query.setString("actorId", actorId);
                        result = query.list();
                    }
                    catch (Exception e) {
                        String msg = JBPMEngine.this.messageService.getMessage(JBPMEngine.ERR_FIND_COMPLETED_TASK_INSTS, actorId);
                        throw new JbpmException(msg, (Throwable)e);
                    }
                    return result;
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_ASSIGNED_TASKS, new Object[]{authority, state});
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public List<WorkflowTask> getPooledTasks(final List<String> authorities) {
        try {
            return (List)this.jbpmTemplate.execute(new JbpmCallback(){

                public List<WorkflowTask> doInJbpm(JbpmContext context) {
                    TaskMgmtSession taskSession = context.getTaskMgmtSession();
                    List tasks = taskSession.findPooledTaskInstances(authorities);
                    return JBPMEngine.this.getWorkflowTasks(tasks);
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_POOLED_TASKS, authorities);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public List<WorkflowTask> queryTasks(final WorkflowTaskQuery query) {
        try {
            return (List)this.jbpmTemplate.execute(new JbpmCallback(){

                public List<WorkflowTask> doInJbpm(JbpmContext context) {
                    Session session = context.getSession();
                    if (query.getProcessName() != null && JBPMEngine.this.tenantService.isEnabled()) {
                        query.setProcessName(JBPMEngine.this.tenantService.getName(query.getProcessName()));
                    }
                    Criteria criteria = JBPMEngine.this.createTaskQueryCriteria(session, query);
                    List tasks = criteria.list();
                    return JBPMEngine.this.getWorkflowTasks(tasks);
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_QUERY_TASKS, query);
            throw new WorkflowException(msg, e);
        }
    }

    protected List<WorkflowTask> getWorkflowTasks(List<TaskInstance> tasks) {
        ArrayList<WorkflowTask> workflowTasks = new ArrayList<WorkflowTask>(tasks.size());
        for (TaskInstance task : tasks) {
            if (this.tenantService.isEnabled()) {
                try {
                    this.tenantService.checkDomain(task.getTask().getProcessDefinition().getName());
                }
                catch (RuntimeException re) {
                    continue;
                }
            }
            WorkflowTask workflowTask = this.createWorkflowTask(task);
            workflowTasks.add(workflowTask);
        }
        return workflowTasks;
    }

    private Criteria createTaskQueryCriteria(Session session, WorkflowTaskQuery query) {
        Map<QName, Object> props;
        Map<QName, Object> props2;
        Criteria task = session.createCriteria(TaskInstance.class);
        if (query.getTaskId() != null) {
            task.add((Criterion)Restrictions.eq((String)"id", (Object)this.getJbpmId(query.getTaskId())));
        }
        if (query.getTaskState() != null) {
            WorkflowTaskState state = query.getTaskState();
            if (state == WorkflowTaskState.IN_PROGRESS) {
                task.add((Criterion)Restrictions.eq((String)"isOpen", (Object)true));
                task.add(Restrictions.isNull((String)"end"));
            } else if (state == WorkflowTaskState.COMPLETED) {
                task.add((Criterion)Restrictions.eq((String)"isOpen", (Object)false));
                task.add(Restrictions.isNotNull((String)"end"));
            }
        }
        if (query.getTaskName() != null) {
            task.add((Criterion)Restrictions.eq((String)"name", (Object)query.getTaskName().toPrefixString((NamespacePrefixResolver)this.namespaceService)));
        }
        if (query.getActorId() != null) {
            task.add((Criterion)Restrictions.eq((String)"actorId", (Object)query.getActorId()));
        }
        if (query.getTaskCustomProps() != null && (props2 = query.getTaskCustomProps()).size() > 0) {
            Criteria variables = task.createCriteria("variableInstances");
            Disjunction values = Restrictions.disjunction();
            for (Map.Entry<QName, Object> prop : props2.entrySet()) {
                Conjunction value = Restrictions.conjunction();
                value.add((Criterion)Restrictions.eq((String)"name", (Object)this.mapQNameToName(prop.getKey())));
                value.add((Criterion)Restrictions.eq((String)"value", (Object)prop.getValue().toString()));
                values.add((Criterion)value);
            }
            variables.add((Criterion)values);
        }
        Criteria process = this.createProcessCriteria(task, query);
        if (query.getProcessCustomProps() != null && (props = query.getProcessCustomProps()).size() > 0) {
            Criteria variables = session.createCriteria(VariableInstance.class);
            variables.setProjection(Projections.distinct((Projection)Property.forName((String)"processInstance")));
            Disjunction values = Restrictions.disjunction();
            for (Map.Entry<QName, Object> prop : props.entrySet()) {
                Conjunction value = Restrictions.conjunction();
                value.add((Criterion)Restrictions.eq((String)"name", (Object)this.mapQNameToName(prop.getKey())));
                value.add((Criterion)Restrictions.eq((String)"value", (Object)prop.getValue().toString()));
                values.add((Criterion)value);
            }
            variables.add((Criterion)values);
            this.createProcessCriteria(variables, query);
            List processList = variables.list();
            Object[] processIds = this.getProcessIds(processList);
            process = process == null ? task.createCriteria("processInstance") : process;
            process.add(Restrictions.in((String)"id", (Object[])processIds));
        }
        if (query.getOrderBy() != null) {
            WorkflowTaskQuery.OrderBy[] orderBy;
            for (WorkflowTaskQuery.OrderBy orderByPart : orderBy = query.getOrderBy()) {
                if (orderByPart == WorkflowTaskQuery.OrderBy.TaskActor_Asc) {
                    task.addOrder(Order.asc((String)"actorId"));
                    continue;
                }
                if (orderByPart == WorkflowTaskQuery.OrderBy.TaskActor_Desc) {
                    task.addOrder(Order.desc((String)"actorId"));
                    continue;
                }
                if (orderByPart == WorkflowTaskQuery.OrderBy.TaskCreated_Asc) {
                    task.addOrder(Order.asc((String)"create"));
                    continue;
                }
                if (orderByPart == WorkflowTaskQuery.OrderBy.TaskCreated_Desc) {
                    task.addOrder(Order.desc((String)"create"));
                    continue;
                }
                if (orderByPart == WorkflowTaskQuery.OrderBy.TaskDue_Asc) {
                    task.addOrder(Order.asc((String)"dueDate"));
                    continue;
                }
                if (orderByPart == WorkflowTaskQuery.OrderBy.TaskDue_Desc) {
                    task.addOrder(Order.desc((String)"dueDate"));
                    continue;
                }
                if (orderByPart == WorkflowTaskQuery.OrderBy.TaskId_Asc) {
                    task.addOrder(Order.asc((String)"id"));
                    continue;
                }
                if (orderByPart == WorkflowTaskQuery.OrderBy.TaskId_Desc) {
                    task.addOrder(Order.desc((String)"id"));
                    continue;
                }
                if (orderByPart == WorkflowTaskQuery.OrderBy.TaskName_Asc) {
                    task.addOrder(Order.asc((String)"name"));
                    continue;
                }
                if (orderByPart == WorkflowTaskQuery.OrderBy.TaskName_Desc) {
                    task.addOrder(Order.desc((String)"name"));
                    continue;
                }
                if (orderByPart == WorkflowTaskQuery.OrderBy.TaskState_Asc) {
                    task.addOrder(Order.asc((String)"end"));
                    continue;
                }
                if (orderByPart != WorkflowTaskQuery.OrderBy.TaskState_Desc) continue;
                task.addOrder(Order.desc((String)"end"));
            }
        }
        return task;
    }

    private Object[] getProcessIds(List<?> processList) {
        ArrayList<Long> ids = new ArrayList<Long>(processList.size());
        if (processList.isEmpty()) {
            ids.add(new Long(-1L));
        } else {
            for (Object obj : processList) {
                ProcessInstance instance = (ProcessInstance)obj;
                ids.add(instance.getId());
            }
        }
        return ids.toArray();
    }

    private Criteria createProcessCriteria(Criteria root, WorkflowTaskQuery query) {
        Criteria process = null;
        if (query.isActive() != null) {
            Criteria criteria = process = process == null ? root.createCriteria("processInstance") : process;
            if (query.isActive().booleanValue()) {
                process.add(Restrictions.isNull((String)"end"));
            } else {
                process.add(Restrictions.isNotNull((String)"end"));
            }
        }
        if (query.getProcessId() != null) {
            process = process == null ? root.createCriteria("processInstance") : process;
            process.add((Criterion)Restrictions.eq((String)"id", (Object)this.getJbpmId(query.getProcessId())));
        }
        if (query.getProcessName() != null) {
            process = process == null ? root.createCriteria("processInstance") : process;
            Criteria processDef = process.createCriteria("processDefinition");
            String processName = null;
            if (this.tenantService.isEnabled()) {
                QName baseProcessName = this.tenantService.getBaseName(query.getProcessName(), true);
                processName = this.tenantService.getName(baseProcessName.toPrefixString((NamespacePrefixResolver)this.namespaceService));
            } else {
                processName = query.getProcessName().toPrefixString((NamespacePrefixResolver)this.namespaceService);
            }
            processDef.add((Criterion)Restrictions.eq((String)"name", (Object)processName));
        }
        return process;
    }

    protected TaskInstance getTaskInstance(TaskMgmtSession taskSession, String taskId) {
        TaskInstance taskInstance = taskSession.getTaskInstance(this.getJbpmId(taskId));
        if (taskInstance != null && this.tenantService.isEnabled()) {
            try {
                this.tenantService.checkDomain(taskInstance.getTask().getProcessDefinition().getName());
            }
            catch (RuntimeException re) {
                taskInstance = null;
            }
        }
        if (taskInstance == null) {
            String msg = this.messageService.getMessage(ERR_GET_TASK_INST, taskId);
            throw new WorkflowException(msg);
        }
        return taskInstance;
    }

    @Override
    public WorkflowTask updateTask(final String taskId, final Map<QName, Serializable> properties, final Map<QName, List<NodeRef>> add, final Map<QName, List<NodeRef>> remove) {
        try {
            return (WorkflowTask)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    Map newProperties;
                    TaskMgmtSession taskSession = context.getTaskMgmtSession();
                    TaskInstance taskInstance = JBPMEngine.this.getTaskInstance(taskSession, taskId);
                    Map map = newProperties = properties != null ? properties : new HashMap(10);
                    if (add != null || remove != null) {
                        Serializable existingValue;
                        QName key;
                        Map<QName, Serializable> existingProperties = JBPMEngine.this.getTaskProperties(taskInstance, false);
                        if (add != null) {
                            for (Map.Entry toAdd : add.entrySet()) {
                                LinkedList<NodeRef> existingAdd;
                                key = (QName)toAdd.getKey();
                                existingValue = (Serializable)newProperties.get(key);
                                if (existingValue == null) {
                                    existingValue = existingProperties.get(key);
                                }
                                if (existingValue == null) {
                                    newProperties.put(key, (Serializable)toAdd.getValue());
                                    continue;
                                }
                                if (existingValue instanceof List) {
                                    existingAdd = (LinkedList<NodeRef>)existingValue;
                                } else {
                                    existingAdd = new LinkedList<NodeRef>();
                                    existingAdd.add((NodeRef)existingValue);
                                }
                                for (NodeRef nodeRef : (List)toAdd.getValue()) {
                                    if (existingAdd.contains(nodeRef)) continue;
                                    existingAdd.add(nodeRef);
                                }
                                newProperties.put(key, (Serializable)existingAdd);
                            }
                        }
                        if (remove != null) {
                            for (Map.Entry toRemove : remove.entrySet()) {
                                key = (QName)toRemove.getKey();
                                existingValue = (Serializable)newProperties.get(key);
                                if (existingValue == null) {
                                    existingValue = existingProperties.get(key);
                                }
                                if (existingValue == null) continue;
                                if (existingValue instanceof List) {
                                    List existingRemove = (List)((Object)existingValue);
                                    existingRemove.removeAll((Collection)toRemove.getValue());
                                    newProperties.put(key, (Serializable)((Object)existingRemove));
                                    continue;
                                }
                                if (!((List)toRemove.getValue()).contains(existingValue)) continue;
                                newProperties.put(key, new LinkedList());
                            }
                        }
                    }
                    if (!newProperties.isEmpty()) {
                        JBPMEngine.this.setTaskProperties(taskInstance, newProperties);
                        ProcessInstance processInstance = taskInstance.getToken().getProcessInstance();
                        context.save(processInstance);
                    }
                    return JBPMEngine.this.createWorkflowTask(taskInstance);
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_UPDATE_TASK, taskId);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public WorkflowTask startTask(String taskId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WorkflowTask suspendTask(String taskId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WorkflowTask endTask(final String taskId, final String transition) {
        try {
            return (WorkflowTask)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    TaskMgmtSession taskSession = context.getTaskMgmtSession();
                    TaskInstance taskInstance = JBPMEngine.this.getTaskInstance(taskSession, taskId);
                    QName[] missingProps = JBPMEngine.this.getMissingMandatoryTaskProperties(taskInstance);
                    if (missingProps != null && missingProps.length > 0) {
                        String props = "";
                        for (int i = 0; i < missingProps.length; ++i) {
                            props = props + missingProps[i].toString() + (i < missingProps.length - 1 ? "," : "");
                        }
                        String msg = JBPMEngine.this.messageService.getMessage(JBPMEngine.ERR_MANDATORY_TASK_PROPERTIES_MISSING, props);
                        throw new WorkflowException(msg);
                    }
                    if (transition == null) {
                        taskInstance.end();
                    } else {
                        Node node = taskInstance.getToken().getNode();
                        if (node.getLeavingTransition(transition) == null) {
                            String msg = JBPMEngine.this.messageService.getMessage(JBPMEngine.ERR_END_TASK_INVALID_TRANSITION, transition, taskId);
                            throw new WorkflowException(msg);
                        }
                        taskInstance.end(transition);
                    }
                    ProcessInstance processInstance = taskInstance.getToken().getProcessInstance();
                    context.save(processInstance);
                    return JBPMEngine.this.createWorkflowTask(taskInstance);
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_END_TASK, transition, taskId);
            throw new WorkflowException(msg, e);
        }
    }

    @Override
    public WorkflowTask getTaskById(final String taskId) {
        try {
            return (WorkflowTask)this.jbpmTemplate.execute(new JbpmCallback(){

                public Object doInJbpm(JbpmContext context) {
                    TaskMgmtSession taskSession = context.getTaskMgmtSession();
                    TaskInstance taskInstance = JBPMEngine.this.getTaskInstance(taskSession, taskId);
                    return taskInstance == null ? null : JBPMEngine.this.createWorkflowTask(taskInstance);
                }
            });
        }
        catch (JbpmException e) {
            String msg = this.messageService.getMessage(ERR_GET_TASK_BY_ID, taskId);
            throw new WorkflowException(msg, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CompiledProcessDefinition compileProcessDefinition(InputStream definitionStream, String mimetype) {
        CompiledProcessDefinition compiledDef;
        block12: {
            String actualMimetype = mimetype == null ? "application/zip" : mimetype;
            compiledDef = null;
            if (actualMimetype.equals("application/zip")) {
                ZipInputStream zipInputStream = null;
                try {
                    try {
                        zipInputStream = new ZipInputStream(definitionStream);
                        ProcessArchive reader = new ProcessArchive(zipInputStream);
                        ProcessDefinition def = reader.parseProcessDefinition();
                        compiledDef = new CompiledProcessDefinition(def, reader.getProblems());
                    }
                    catch (Exception e) {
                        String msg = this.messageService.getMessage(ERR_COMPILE_PROCESS_DEF_zip);
                        throw new JbpmException(msg, (Throwable)e);
                    }
                    Object var9_15 = null;
                    if (zipInputStream == null) break block12;
                }
                catch (Throwable throwable) {
                    Object var9_16 = null;
                    if (zipInputStream == null) throw throwable;
                    try {
                        zipInputStream.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException e) {}
                zipInputStream.close();
            } else {
                if (!actualMimetype.equals("text/xml")) {
                    String msg = this.messageService.getMessage(ERR_COMPILE_PROCESS_DEF_UNSUPPORTED, mimetype);
                    throw new JbpmException(msg);
                }
                try {
                    JBPMJpdlXmlReader jpdlReader = new JBPMJpdlXmlReader(definitionStream);
                    ProcessDefinition def = jpdlReader.readProcessDefinition();
                    compiledDef = new CompiledProcessDefinition(def, jpdlReader.getProblems());
                }
                catch (Exception e) {
                    String msg = this.messageService.getMessage(ERR_COMPILE_PROCESS_DEF_XML);
                    throw new JbpmException(msg, (Throwable)e);
                }
            }
        }
        if (compiledDef == null) return compiledDef;
        if (!this.tenantService.isEnabled()) return compiledDef;
        compiledDef.def.setName(this.tenantService.getName(compiledDef.def.getName()));
        return compiledDef;
    }

    private TypeDefinition getTaskDefinition(Task task) {
        QName typeName = QName.createQName((String)task.getName(), (NamespacePrefixResolver)this.namespaceService);
        TypeDefinition typeDef = this.dictionaryService.getType(typeName);
        if (typeDef == null && (typeDef = this.dictionaryService.getType(task.getStartState() == null ? WorkflowModel.TYPE_WORKFLOW_TASK : WorkflowModel.TYPE_START_TASK)) == null) {
            String msg = this.messageService.getMessage(ERR_GET_TASK_DEF, WorkflowModel.TYPE_WORKFLOW_TASK);
            throw new WorkflowException(msg);
        }
        return typeDef;
    }

    private TypeDefinition getAnonymousTaskDefinition(TypeDefinition typeDef) {
        List aspects = typeDef.getDefaultAspects();
        ArrayList<QName> aspectNames = new ArrayList<QName>(aspects.size());
        this.getMandatoryAspects((ClassDefinition)typeDef, aspectNames);
        return this.dictionaryService.getAnonymousType(typeDef.getName(), aspectNames);
    }

    private void getMandatoryAspects(ClassDefinition classDef, List<QName> aspects) {
        for (AspectDefinition aspect : classDef.getDefaultAspects()) {
            QName aspectName = aspect.getName();
            if (aspects.contains(aspectName)) continue;
            aspects.add(aspect.getName());
            this.getMandatoryAspects((ClassDefinition)aspect, aspects);
        }
    }

    protected long getJbpmId(String id) {
        try {
            String theLong = this.createLocalId(id);
            return new Long(theLong);
        }
        catch (NumberFormatException e) {
            String msg = this.messageService.getMessage(ERR_GET_JBPM_ID, id);
            throw new WorkflowException(msg, e);
        }
    }

    protected Token getWorkflowToken(GraphSession session, String pathId) {
        String tokenId;
        String[] path = pathId.split(WORKFLOW_PATH_SEPERATOR);
        if (path.length != 2) {
            String msg = this.messageService.getMessage(ERR_GET_WORKFLOW_TOKEN_INVALID, pathId);
            throw new WorkflowException(msg);
        }
        ProcessInstance processInstance = this.getProcessInstance(session, path[0]);
        Token token = processInstance.findToken(tokenId = path[1].replace(WORKFLOW_TOKEN_SEPERATOR, "/"));
        if (token == null) {
            String msg = this.messageService.getMessage(ERR_GET_WORKFLOW_TOKEN_NULL, pathId);
            throw new WorkflowException(msg);
        }
        return token;
    }

    protected Map<QName, Serializable> getTaskProperties(TaskInstance instance, boolean localProperties) {
        Set pooledActors;
        TypeDefinition taskDef = this.getAnonymousTaskDefinition(this.getTaskDefinition(instance.getTask()));
        Map taskProperties = taskDef.getProperties();
        Map taskAssocs = taskDef.getAssociations();
        Map vars = instance.getVariablesLocally();
        if (!localProperties) {
            ContextInstance context = instance.getContextInstance();
            for (Token token = instance.getToken(); token != null; token = token.getParent()) {
                TokenVariableMap varMap = context.getTokenVariableMap(token);
                if (varMap == null) continue;
                Map tokenVars = varMap.getVariablesLocally();
                for (Map.Entry entry : tokenVars.entrySet()) {
                    if (vars.containsKey(entry.getKey())) continue;
                    vars.put(entry.getKey(), entry.getValue());
                }
            }
        }
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>(10);
        for (Map.Entry entry : vars.entrySet()) {
            String key = (String)entry.getKey();
            QName qname = this.mapNameToQName(key);
            boolean isAssoc = taskAssocs.containsKey(qname);
            if (!taskProperties.containsKey(qname) && !isAssoc && !instance.hasVariableLocally(key)) continue;
            Serializable value = this.convertValue(entry.getValue());
            properties.put(qname, value);
        }
        properties.put(WorkflowModel.PROP_TASK_ID, Long.valueOf(instance.getId()));
        properties.put(WorkflowModel.PROP_DESCRIPTION, (Serializable)((Object)instance.getDescription()));
        properties.put(WorkflowModel.PROP_START_DATE, instance.getStart());
        properties.put(WorkflowModel.PROP_DUE_DATE, instance.getDueDate());
        properties.put(WorkflowModel.PROP_COMPLETION_DATE, instance.getEnd());
        properties.put(WorkflowModel.PROP_PRIORITY, Integer.valueOf(instance.getPriority()));
        properties.put(ContentModel.PROP_CREATED, instance.getCreate());
        properties.put(ContentModel.PROP_OWNER, (Serializable)((Object)instance.getActorId()));
        List comments = instance.getComments();
        if (comments != null && comments.size() > 0) {
            properties.put(WorkflowModel.PROP_COMMENT, (Serializable)((Object)((Comment)comments.get(0)).getMessage()));
        }
        if ((pooledActors = instance.getPooledActors()) != null) {
            ArrayList<NodeRef> pooledNodeRefs = new ArrayList<NodeRef>(pooledActors.size());
            for (PooledActor pooledActor : pooledActors) {
                NodeRef pooledNodeRef = null;
                String pooledActorId = pooledActor.getActorId();
                pooledNodeRef = AuthorityType.getAuthorityType((String)pooledActorId) == AuthorityType.GROUP ? this.mapNameToAuthority(pooledActorId) : this.mapNameToPerson(pooledActorId);
                if (pooledNodeRef == null) continue;
                pooledNodeRefs.add(pooledNodeRef);
            }
            properties.put(WorkflowModel.ASSOC_POOLED_ACTORS, pooledNodeRefs);
        }
        return properties;
    }

    protected void setTaskProperties(TaskInstance instance, Map<QName, Serializable> properties) {
        if (properties == null) {
            return;
        }
        TypeDefinition taskDef = this.getAnonymousTaskDefinition(this.getTaskDefinition(instance.getTask()));
        Map taskProperties = taskDef.getProperties();
        Map taskAssocs = taskDef.getAssociations();
        for (Map.Entry<QName, Serializable> entry : properties.entrySet()) {
            QName key = entry.getKey();
            Serializable value = entry.getValue();
            PropertyDefinition propDef = (PropertyDefinition)taskProperties.get(key);
            if (propDef != null) {
                if (propDef.isProtected()) continue;
                value = value instanceof Collection ? (Serializable)((Object)DefaultTypeConverter.INSTANCE.convert(propDef.getDataType(), (Collection)((Object)value))) : (Serializable)DefaultTypeConverter.INSTANCE.convert(propDef.getDataType(), (Object)value);
                DataTypeDefinition dataTypeDef = propDef.getDataType();
                if (dataTypeDef.getName().equals((Object)DataTypeDefinition.NODE_REF)) {
                    value = this.convertNodeRefs(propDef.isMultiValued(), value);
                }
                if (key.equals((Object)WorkflowModel.PROP_DESCRIPTION)) {
                    if (value != null && !(value instanceof String)) {
                        throw this.getInvalidPropertyValueException(key, value);
                    }
                    instance.setDescription((String)((Object)value));
                    continue;
                }
                if (key.equals((Object)WorkflowModel.PROP_DUE_DATE)) {
                    if (value != null && !(value instanceof Date)) {
                        throw this.getInvalidPropertyValueException(key, value);
                    }
                    instance.setDueDate((Date)value);
                    continue;
                }
                if (key.equals((Object)WorkflowModel.PROP_PRIORITY)) {
                    if (!(value instanceof Integer)) {
                        throw this.getInvalidPropertyValueException(key, value);
                    }
                    instance.setPriority(((Integer)value).intValue());
                    continue;
                }
                if (key.equals((Object)WorkflowModel.PROP_COMMENT)) {
                    if (!(value instanceof String)) {
                        throw this.getInvalidPropertyValueException(key, value);
                    }
                    final List comments = instance.getComments();
                    if (comments != null && comments.size() > 0) {
                        this.jbpmTemplate.execute(new JbpmCallback(){

                            public Object doInJbpm(JbpmContext context) {
                                Session session = context.getSession();
                                for (Object obj : comments) {
                                    Comment comment = (Comment)obj;
                                    comment.getToken().getComments().remove(comment);
                                    session.delete((Object)comment);
                                }
                                comments.clear();
                                return null;
                            }
                        });
                    }
                    instance.addComment((String)((Object)value));
                    continue;
                }
                if (key.equals((Object)ContentModel.PROP_OWNER)) {
                    if (value != null && !(value instanceof String)) {
                        throw this.getInvalidPropertyValueException(key, value);
                    }
                    String actorId = (String)((Object)value);
                    String existingActorId = instance.getActorId();
                    if (existingActorId != null && existingActorId.equals(actorId)) continue;
                    instance.setActorId((String)((Object)value), false);
                    continue;
                }
            } else {
                AssociationDefinition assocDef = (AssociationDefinition)taskAssocs.get(key);
                if (assocDef != null) {
                    value = this.convertNodeRefs(assocDef.isTargetMany(), value);
                    if (key.equals((Object)WorkflowModel.ASSOC_POOLED_ACTORS)) {
                        String[] pooledActors = null;
                        if (value instanceof JBPMNodeList) {
                            JBPMNodeList actors = (JBPMNodeList)value;
                            pooledActors = new String[actors.size()];
                            int i = 0;
                            for (JBPMNode actor : actors) {
                                pooledActors[i++] = this.mapAuthorityToName(actor.getNodeRef());
                            }
                        } else if (value instanceof JBPMNode) {
                            JBPMNode node = (JBPMNode)value;
                            pooledActors = new String[]{this.mapAuthorityToName(node.getNodeRef())};
                        } else {
                            throw this.getInvalidPropertyValueException(key, value);
                        }
                        instance.setPooledActors(pooledActors);
                        continue;
                    }
                    if (key.equals((Object)WorkflowModel.ASSOC_PACKAGE)) {
                        ProcessInstance processInstance;
                        String name = this.mapQNameToName(key);
                        JBPMNode existingWorkflowPackage = (JBPMNode)instance.getVariable(name);
                        if (existingWorkflowPackage != null && value != null) {
                            NodeRef newPackageNodeRef = ((JBPMNode)value).getNodeRef();
                            processInstance = instance.getToken().getProcessInstance();
                            String packageInstanceId = (String)((Object)this.nodeService.getProperty(newPackageNodeRef, WorkflowModel.PROP_WORKFLOW_INSTANCE_ID));
                            if (packageInstanceId != null && packageInstanceId.length() > 0 && processInstance.getId() == this.getJbpmId(packageInstanceId)) {
                                String workflowInstanceId = this.createGlobalId(new Long(processInstance.getId()).toString());
                                String msg = this.messageService.getMessage(ERR_PACKAGE_ALREADY_ASSOCIATED, newPackageNodeRef, workflowInstanceId, packageInstanceId);
                                throw new WorkflowException(msg);
                            }
                        }
                        if (existingWorkflowPackage == null && value != null) {
                            NodeRef newPackageNodeRef = ((JBPMNode)value).getNodeRef();
                            processInstance = instance.getToken().getProcessInstance();
                            WorkflowInstance workflowInstance = this.createWorkflowInstance(processInstance);
                            this.nodeService.setProperty(newPackageNodeRef, WorkflowModel.PROP_WORKFLOW_DEFINITION_ID, (Serializable)((Object)workflowInstance.definition.id));
                            this.nodeService.setProperty(newPackageNodeRef, WorkflowModel.PROP_WORKFLOW_DEFINITION_NAME, (Serializable)((Object)workflowInstance.definition.name));
                            this.nodeService.setProperty(newPackageNodeRef, WorkflowModel.PROP_WORKFLOW_INSTANCE_ID, (Serializable)((Object)workflowInstance.id));
                        }
                    }
                } else if (value instanceof NodeRef) {
                    value = new JBPMNode((NodeRef)value, this.serviceRegistry);
                }
            }
            String name = this.mapQNameToName(key);
            instance.setVariableLocally(name, (Object)value);
        }
    }

    private WorkflowException getInvalidPropertyValueException(QName key, Serializable value) {
        String msg = this.messageService.getMessage(ERR_SET_TASK_PROPS_INVALID_VALUE, value, key);
        return new WorkflowException(msg);
    }

    protected void setDefaultTaskProperties(TaskInstance instance) {
        Map<QName, Serializable> existingValues = this.getTaskProperties(instance, true);
        HashMap<QName, Serializable> defaultValues = new HashMap<QName, Serializable>();
        TypeDefinition classDef = this.getAnonymousTaskDefinition(this.getTaskDefinition(instance.getTask()));
        Map propertyDefs = classDef.getProperties();
        for (Map.Entry entry : propertyDefs.entrySet()) {
            String defaultValue = ((PropertyDefinition)entry.getValue()).getDefaultValue();
            if (defaultValue == null || existingValues.get(entry.getKey()) != null) continue;
            defaultValues.put((QName)entry.getKey(), (Serializable)((Object)defaultValue));
        }
        String description = (String)((Object)existingValues.get(WorkflowModel.PROP_DESCRIPTION));
        if (description == null || description.length() == 0) {
            description = (String)instance.getContextInstance().getVariable(this.mapQNameToName(WorkflowModel.PROP_WORKFLOW_DESCRIPTION));
            if (description != null && description.length() > 0) {
                defaultValues.put(WorkflowModel.PROP_DESCRIPTION, (Serializable)((Object)description));
            } else {
                WorkflowTask task = this.createWorkflowTask(instance);
                defaultValues.put(WorkflowModel.PROP_DESCRIPTION, (Serializable)((Object)task.title));
            }
        }
        if (defaultValues.size() > 0) {
            this.setTaskProperties(instance, defaultValues);
        }
    }

    public void setDefaultStartTaskDescription(TaskInstance instance) {
        String description = instance.getTask().getDescription();
        if ((description == null || description.length() == 0) && (description = (String)instance.getContextInstance().getVariable(this.mapQNameToName(WorkflowModel.PROP_WORKFLOW_DESCRIPTION))) != null && description.length() > 0) {
            HashMap<QName, Serializable> defaultValues = new HashMap<QName, Serializable>();
            defaultValues.put(WorkflowModel.PROP_DESCRIPTION, (Serializable)((Object)description));
            this.setTaskProperties(instance, defaultValues);
        }
    }

    protected void setDefaultWorkflowProperties(TaskInstance startTask) {
        String workflowContextName;
        String workflowPackageName;
        String workflowPriorityName;
        String workflowDueDateName;
        String workflowDescriptionName;
        Map<QName, Serializable> taskProperties = this.getTaskProperties(startTask, true);
        ContextInstance processContext = startTask.getContextInstance();
        if (!processContext.hasVariable(workflowDescriptionName = this.mapQNameToName(WorkflowModel.PROP_WORKFLOW_DESCRIPTION))) {
            processContext.setVariable(workflowDescriptionName, (Object)taskProperties.get(WorkflowModel.PROP_WORKFLOW_DESCRIPTION));
        }
        if (!processContext.hasVariable(workflowDueDateName = this.mapQNameToName(WorkflowModel.PROP_WORKFLOW_DUE_DATE))) {
            processContext.setVariable(workflowDueDateName, (Object)taskProperties.get(WorkflowModel.PROP_WORKFLOW_DUE_DATE));
        }
        if (!processContext.hasVariable(workflowPriorityName = this.mapQNameToName(WorkflowModel.PROP_WORKFLOW_PRIORITY))) {
            processContext.setVariable(workflowPriorityName, (Object)taskProperties.get(WorkflowModel.PROP_WORKFLOW_PRIORITY));
        }
        if (!processContext.hasVariable(workflowPackageName = this.mapQNameToName(WorkflowModel.ASSOC_PACKAGE))) {
            Serializable packageNodeRef = taskProperties.get(WorkflowModel.ASSOC_PACKAGE);
            processContext.setVariable(workflowPackageName, (Object)this.convertNodeRefs(packageNodeRef instanceof List, packageNodeRef));
        }
        if (!processContext.hasVariable(workflowContextName = this.mapQNameToName(WorkflowModel.PROP_CONTEXT))) {
            Serializable contextRef = taskProperties.get(WorkflowModel.PROP_CONTEXT);
            processContext.setVariable(workflowContextName, (Object)this.convertNodeRefs(contextRef instanceof List, contextRef));
        }
    }

    protected QName[] getMissingMandatoryTaskProperties(TaskInstance instance) {
        Serializable value;
        boolean isMandatory;
        QName name;
        ArrayList missingProps = null;
        Map<QName, Serializable> existingValues = this.getTaskProperties(instance, false);
        TypeDefinition classDef = this.getAnonymousTaskDefinition(this.getTaskDefinition(instance.getTask()));
        Map propertyDefs = classDef.getProperties();
        Map assocDefs = classDef.getAssociations();
        for (Map.Entry entry : propertyDefs.entrySet()) {
            name = (QName)entry.getKey();
            if (name.getNamespaceURI().equals("http://www.alfresco.org/model/content/1.0") || name.getNamespaceURI().equals("http://www.alfresco.org/model/system/1.0") || !(isMandatory = ((PropertyDefinition)entry.getValue()).isMandatory()) || (value = existingValues.get(entry.getKey())) != null && (!(value instanceof String) || ((String)((Object)value)).length() != 0)) continue;
            if (missingProps == null) {
                missingProps = new ArrayList();
            }
            missingProps.add(entry.getKey());
        }
        for (Map.Entry entry : assocDefs.entrySet()) {
            name = (QName)entry.getKey();
            if (name.getNamespaceURI().equals("http://www.alfresco.org/model/content/1.0") || name.getNamespaceURI().equals("http://www.alfresco.org/model/system/1.0") || !(isMandatory = ((AssociationDefinition)entry.getValue()).isTargetMandatory()) || (value = existingValues.get(entry.getKey())) != null && (!(value instanceof List) || !((List)((Object)value)).isEmpty())) continue;
            if (missingProps == null) {
                missingProps = new ArrayList();
            }
            missingProps.add(entry.getKey());
        }
        return missingProps == null ? null : missingProps.toArray(new QName[missingProps.size()]);
    }

    private Serializable convertValue(Object value) {
        Object alfValue = null;
        if (value != null) {
            if (value instanceof JBPMNode) {
                alfValue = ((JBPMNode)value).getNodeRef();
            } else if (value instanceof JBPMNodeList) {
                JBPMNodeList nodes = (JBPMNodeList)value;
                ArrayList<NodeRef> nodeRefs = new ArrayList<NodeRef>(nodes.size());
                for (JBPMNode node : nodes) {
                    nodeRefs.add(node.getNodeRef());
                }
                alfValue = nodeRefs;
            } else if (value instanceof Serializable) {
                alfValue = (Serializable)value;
            } else {
                String msg = this.messageService.getMessage(ERR_CONVERT_VALUE, value);
                throw new WorkflowException(msg);
            }
        }
        return alfValue;
    }

    private Serializable convertNodeRefs(boolean isMany, Serializable value) {
        if (value instanceof NodeRef) {
            if (isMany) {
                JBPMNodeList values = new JBPMNodeList();
                values.add(new JBPMNode((NodeRef)value, this.serviceRegistry));
                value = values;
            } else {
                value = new JBPMNode((NodeRef)value, this.serviceRegistry);
            }
        } else if (value instanceof List) {
            if (isMany) {
                JBPMNodeList values = new JBPMNodeList();
                for (NodeRef nodeRef : (List)((Object)value)) {
                    values.add(new JBPMNode(nodeRef, this.serviceRegistry));
                }
                value = values;
            } else {
                List nodeRefs = (List)((Object)value);
                value = nodeRefs.size() == 0 ? null : new JBPMNode((NodeRef)nodeRefs.get(0), this.serviceRegistry);
            }
        }
        return value;
    }

    private NodeRef mapNameToPerson(String name) {
        NodeRef authority = null;
        if (name != null && this.personService.personExists(name)) {
            authority = this.personService.getPerson(name);
        }
        return authority;
    }

    private NodeRef mapNameToAuthority(String name) {
        NodeRef authority = null;
        if (name != null && this.authorityDAO.authorityExists(name)) {
            authority = this.authorityDAO.getAuthorityNodeRefOrNull(name);
        }
        return authority;
    }

    private String mapAuthorityToName(NodeRef authority) {
        String name = null;
        QName type = this.nodeService.getType(authority);
        name = this.dictionaryService.isSubClass(type, ContentModel.TYPE_PERSON) ? (String)((Object)this.nodeService.getProperty(authority, ContentModel.PROP_USERNAME)) : this.authorityDAO.getAuthorityName(authority);
        return name;
    }

    private QName mapNameToQName(String name) {
        QName qname = null;
        String qnameStr = name.indexOf(125) == -1 ? name.replaceFirst("_", ":") : name.replace("}", ":");
        try {
            qname = QName.createQName((String)qnameStr, (NamespacePrefixResolver)this.namespaceService);
        }
        catch (NamespaceException e) {
            qname = QName.createQName((String)name, (NamespacePrefixResolver)this.namespaceService);
        }
        return qname;
    }

    private String mapQNameToName(QName name) {
        String nameStr = name.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        if (nameStr.indexOf(95) != -1 && nameStr.indexOf(95) < nameStr.indexOf(58)) {
            return nameStr.replace(':', '}');
        }
        return nameStr.replace(':', '_');
    }

    private String getLabel(String displayId, String labelKey, String defaultLabel) {
        String key = StringUtils.replace((String)displayId, (String)":", (String)"_");
        String label = this.messageService.getMessage(key = key + "." + labelKey);
        return label == null ? defaultLabel : label;
    }

    private NodeRef getCompanyHome() {
        if (this.tenantService.isEnabled()) {
            try {
                return this.tenantService.getRootNode(this.nodeService, this.serviceRegistry.getSearchService(), this.namespaceService, this.companyHomePath, this.nodeService.getRootNode(this.companyHomeStore));
            }
            catch (RuntimeException re) {
                String msg = this.messageService.getMessage(ERR_GET_COMPANY_HOME_INVALID, this.companyHomePath);
                throw new IllegalStateException(msg, re);
            }
        }
        List refs = this.unprotectedSearchService.selectNodes(this.nodeService.getRootNode(this.companyHomeStore), this.companyHomePath, null, (NamespacePrefixResolver)this.namespaceService, false);
        if (refs.size() != 1) {
            String msg = this.messageService.getMessage(ERR_GET_COMPANY_HOME_MULTIPLE, this.companyHomePath, refs.size());
            throw new IllegalStateException(msg);
        }
        return (NodeRef)refs.get(0);
    }

    protected WorkflowPath createWorkflowPath(Token token) {
        WorkflowPath path = new WorkflowPath();
        String tokenId = token.getFullName().replace("/", WORKFLOW_TOKEN_SEPERATOR);
        path.id = this.createGlobalId(token.getProcessInstance().getId() + WORKFLOW_PATH_SEPERATOR + tokenId);
        path.instance = this.createWorkflowInstance(token.getProcessInstance());
        path.node = this.createWorkflowNode(token.getNode());
        path.active = !token.hasEnded();
        return path;
    }

    protected WorkflowNode createWorkflowNode(Node node) {
        String processName = node.getProcessDefinition().getName();
        if (this.tenantService.isEnabled()) {
            this.tenantService.checkDomain(processName);
        }
        WorkflowNode workflowNode = new WorkflowNode();
        workflowNode.name = node.getName();
        workflowNode.title = this.getLabel(processName + ".node." + workflowNode.name, TITLE_LABEL, workflowNode.name);
        workflowNode.description = this.getLabel(processName + ".node." + workflowNode.name, DESC_LABEL, workflowNode.title);
        workflowNode.type = this.getRealNode(node).getClass().getSimpleName();
        workflowNode.isTaskNode = workflowNode.type.equals("TaskNode");
        List transitions = node.getLeavingTransitions();
        workflowNode.transitions = new WorkflowTransition[transitions == null ? 0 : transitions.size()];
        if (transitions != null) {
            int i = 0;
            for (Transition transition : transitions) {
                workflowNode.transitions[i++] = this.createWorkflowTransition(transition);
            }
        }
        return workflowNode;
    }

    protected WorkflowTransition createWorkflowTransition(Transition transition) {
        if (this.tenantService.isEnabled()) {
            this.tenantService.checkDomain(transition.getProcessDefinition().getName());
        }
        WorkflowTransition workflowTransition = new WorkflowTransition();
        workflowTransition.id = transition.getName();
        Node node = transition.getFrom();
        workflowTransition.isDefault = node.getDefaultLeavingTransition().equals((Object)transition);
        if (workflowTransition.id == null || workflowTransition.id.length() == 0) {
            workflowTransition.title = this.getLabel(DEFAULT_TRANSITION_LABEL, TITLE_LABEL, workflowTransition.id);
            workflowTransition.description = this.getLabel(DEFAULT_TRANSITION_LABEL, DESC_LABEL, workflowTransition.title);
        } else {
            String nodeName = node.getName();
            String processName = node.getProcessDefinition().getName();
            workflowTransition.title = this.getLabel(processName + ".node." + nodeName + ".transition." + workflowTransition.id, TITLE_LABEL, workflowTransition.id);
            workflowTransition.description = this.getLabel(processName + ".node." + nodeName + ".transition." + workflowTransition.id, DESC_LABEL, workflowTransition.title);
        }
        return workflowTransition;
    }

    protected WorkflowInstance createWorkflowInstance(ProcessInstance instance) {
        JBPMNode workflowPackage;
        JBPMNode context;
        if (this.tenantService.isEnabled()) {
            this.tenantService.checkDomain(instance.getProcessDefinition().getName());
        }
        WorkflowInstance workflowInstance = new WorkflowInstance();
        workflowInstance.id = this.createGlobalId(new Long(instance.getId()).toString());
        workflowInstance.description = (String)instance.getContextInstance().getVariable(this.mapQNameToName(WorkflowModel.PROP_WORKFLOW_DESCRIPTION));
        workflowInstance.priority = (Integer)instance.getContextInstance().getVariable(this.mapQNameToName(WorkflowModel.PROP_WORKFLOW_PRIORITY));
        workflowInstance.dueDate = (Date)instance.getContextInstance().getVariable(this.mapQNameToName(WorkflowModel.PROP_WORKFLOW_DUE_DATE));
        workflowInstance.definition = this.createWorkflowDefinition(instance.getProcessDefinition());
        workflowInstance.active = !instance.hasEnded();
        JBPMNode initiator = (JBPMNode)instance.getContextInstance().getVariable("initiator");
        if (initiator != null) {
            workflowInstance.initiator = initiator.getNodeRef();
        }
        if ((context = (JBPMNode)instance.getContextInstance().getVariable(this.mapQNameToName(WorkflowModel.PROP_CONTEXT))) != null) {
            workflowInstance.context = context.getNodeRef();
        }
        if ((workflowPackage = (JBPMNode)instance.getContextInstance().getVariable(this.mapQNameToName(WorkflowModel.ASSOC_PACKAGE))) != null) {
            workflowInstance.workflowPackage = workflowPackage.getNodeRef();
        }
        workflowInstance.startDate = instance.getStart();
        workflowInstance.endDate = instance.getEnd();
        return workflowInstance;
    }

    protected WorkflowDefinition createWorkflowDefinition(ProcessDefinition definition) {
        if (this.tenantService.isEnabled()) {
            this.tenantService.checkDomain(definition.getName());
        }
        Task startTask = definition.getTaskMgmtDefinition().getStartTask();
        String name = this.tenantService.getBaseName(definition.getName());
        String title = this.getLabel(name + ".workflow", TITLE_LABEL, name);
        String description = this.getLabel(name + ".workflow", DESC_LABEL, title);
        return new WorkflowDefinition(this.createGlobalId(new Long(definition.getId()).toString()), this.createGlobalId(name), new Integer(definition.getVersion()).toString(), title, description, startTask != null ? this.createWorkflowTaskDefinition(startTask) : null);
    }

    protected WorkflowTask createWorkflowTask(TaskInstance task) {
        String processName = task.getTask().getProcessDefinition().getName();
        if (this.tenantService.isEnabled()) {
            this.tenantService.checkDomain(processName);
        }
        WorkflowTask workflowTask = new WorkflowTask();
        workflowTask.id = this.createGlobalId(new Long(task.getId()).toString());
        workflowTask.name = task.getName();
        workflowTask.path = this.createWorkflowPath(task.getToken());
        workflowTask.state = this.getWorkflowTaskState(task);
        workflowTask.definition = this.createWorkflowTaskDefinition(task.getTask());
        workflowTask.properties = this.getTaskProperties(task, false);
        workflowTask.title = this.getLabel(processName + ".task." + workflowTask.name, TITLE_LABEL, null);
        if (workflowTask.title == null) {
            workflowTask.title = workflowTask.definition.metadata.getTitle();
            if (workflowTask.title == null) {
                workflowTask.title = workflowTask.name;
            }
        }
        workflowTask.description = this.getLabel(processName + ".task." + workflowTask.name, DESC_LABEL, null);
        if (workflowTask.description == null) {
            String description = workflowTask.definition.metadata.getDescription();
            workflowTask.description = description == null ? workflowTask.title : description;
        }
        return workflowTask;
    }

    protected WorkflowTaskDefinition createWorkflowTaskDefinition(Task task) {
        WorkflowTaskDefinition taskDef = new WorkflowTaskDefinition();
        taskDef.id = task.getName();
        TaskNode node = task.getStartState() == null ? task.getTaskNode() : task.getStartState();
        taskDef.node = this.createWorkflowNode((Node)node);
        taskDef.metadata = this.getTaskDefinition(task);
        return taskDef;
    }

    protected WorkflowDeployment createWorkflowDeployment(CompiledProcessDefinition compiledDef) {
        WorkflowDeployment deployment = new WorkflowDeployment();
        deployment.definition = this.createWorkflowDefinition(compiledDef.def);
        deployment.problems = compiledDef.problems;
        return deployment;
    }

    protected WorkflowTimer createWorkflowTimer(Timer timer) {
        WorkflowTimer workflowTimer = new WorkflowTimer();
        workflowTimer.id = this.createGlobalId(new Long(timer.getId()).toString());
        workflowTimer.name = timer.getName();
        workflowTimer.error = timer.getException();
        workflowTimer.dueDate = timer.getDueDate();
        workflowTimer.path = this.createWorkflowPath(timer.getToken());
        TaskInstance taskInstance = timer.getTaskInstance();
        if (taskInstance != null) {
            workflowTimer.task = this.createWorkflowTask(taskInstance);
        }
        return workflowTimer;
    }

    protected WorkflowTaskState getWorkflowTaskState(TaskInstance task) {
        if (task.hasEnded()) {
            return WorkflowTaskState.COMPLETED;
        }
        return WorkflowTaskState.IN_PROGRESS;
    }

    private Node getRealNode(Node node) {
        if (node instanceof HibernateProxy) {
            Node realNode = (Node)((HibernateProxy)node).getHibernateLazyInitializer().getImplementation();
            return realNode;
        }
        return node;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompiledProcessDefinition {
        protected ProcessDefinition def;
        protected String[] problems;

        public CompiledProcessDefinition(ProcessDefinition def, List<Problem> problems) {
            this.def = def;
            this.problems = new String[problems.size()];
            int i = 0;
            for (Problem problem : problems) {
                this.problems[i++] = problem.toString();
            }
        }
    }
}

