/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jscript;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.jscript.ValueConverter;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.jscript.JscriptWorkflowInstance;
import org.alfresco.repo.workflow.jscript.JscriptWorkflowPath;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JscriptWorkflowDefinition
implements Serializable {
    static final long serialVersionUID = 1641614201321129544L;
    private ServiceRegistry serviceRegistry;
    private final String id;
    private final String name;
    private final String version;
    private final String title;
    private final String description;
    private final Scriptable scope;
    private ValueConverter converter = null;

    public JscriptWorkflowDefinition(WorkflowDefinition cmrWorkflowDefinition, ServiceRegistry serviceRegistry, Scriptable scope) {
        this.id = cmrWorkflowDefinition.id;
        this.name = cmrWorkflowDefinition.name;
        this.version = cmrWorkflowDefinition.version;
        this.title = cmrWorkflowDefinition.title;
        this.description = cmrWorkflowDefinition.description;
        this.serviceRegistry = serviceRegistry;
        this.scope = scope;
    }

    public JscriptWorkflowDefinition(String id, String name, String version, String title, String description, ServiceRegistry serviceRegistry, Scriptable scope) {
        this.id = id;
        this.name = name;
        this.version = version;
        this.title = title;
        this.description = description;
        this.serviceRegistry = serviceRegistry;
        this.scope = scope;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getTitle() {
        return this.title;
    }

    protected ValueConverter getValueConverter() {
        if (this.converter == null) {
            this.converter = new ValueConverter();
        }
        return this.converter;
    }

    public String getDescription() {
        return this.description;
    }

    public JscriptWorkflowPath startWorkflow(Object properties) {
        return this.startWorkflow(null, properties);
    }

    public JscriptWorkflowPath startWorkflow(ScriptNode workflowPackage, Object properties) {
        Serializable context;
        WorkflowService workflowService = this.serviceRegistry.getWorkflowService();
        HashMap<QName, Serializable> workflowParameters = null;
        if (properties instanceof ScriptableObject) {
            ScriptableObject scriptableProps = (ScriptableObject)properties;
            workflowParameters = new HashMap(scriptableProps.getIds().length);
            this.extractScriptablePropertiesToMap(scriptableProps, workflowParameters);
        }
        if (workflowPackage != null) {
            if (workflowParameters == null) {
                workflowParameters = new HashMap<QName, Serializable>(1);
            }
            workflowParameters.put(WorkflowModel.ASSOC_PACKAGE, this.getValueConverter().convertValueForRepo(workflowPackage));
        }
        if ((context = (Serializable)workflowParameters.get(WorkflowModel.PROP_CONTEXT)) == null) {
            workflowParameters.put(WorkflowModel.PROP_CONTEXT, (Serializable)workflowPackage.getNodeRef());
        }
        WorkflowPath cmrWorkflowPath = workflowService.startWorkflow(this.id, workflowParameters);
        return new JscriptWorkflowPath(cmrWorkflowPath, this.serviceRegistry, this.scope);
    }

    public synchronized Scriptable getActiveInstances() {
        WorkflowService workflowService = this.serviceRegistry.getWorkflowService();
        List<WorkflowInstance> cmrWorkflowInstances = workflowService.getActiveWorkflows(this.id);
        ArrayList<JscriptWorkflowInstance> activeInstances = new ArrayList<JscriptWorkflowInstance>();
        for (WorkflowInstance cmrWorkflowInstance : cmrWorkflowInstances) {
            activeInstances.add(new JscriptWorkflowInstance(cmrWorkflowInstance, this.serviceRegistry, this.scope));
        }
        Scriptable activeInstancesScriptable = (Scriptable)this.getValueConverter().convertValueForScript(this.serviceRegistry, this.scope, null, activeInstances);
        return activeInstancesScriptable;
    }

    private QName createQName(String s) {
        QName qname = s.indexOf("{") != -1 ? QName.createQName((String)s) : QName.createQName((String)s, (NamespacePrefixResolver)this.serviceRegistry.getNamespaceService());
        return qname;
    }

    private void extractScriptablePropertiesToMap(ScriptableObject scriptable, Map<QName, Serializable> map) {
        Object[] propIds = scriptable.getIds();
        for (int i = 0; i < propIds.length; ++i) {
            String key;
            Object value;
            Object propId = propIds[i];
            if (!(propId instanceof String) || !((value = scriptable.get(key = (String)propId, (Scriptable)scriptable)) instanceof Serializable)) continue;
            value = this.getValueConverter().convertValueForRepo((Serializable)value);
            map.put(this.createQName(key), (Serializable)value);
        }
    }
}

