/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.avm;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.cmr.avm.LayeringDescriptor;
import org.alfresco.service.cmr.avm.VersionDescriptor;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface AVMService {
    public InputStream getFileInputStream(int var1, String var2);

    public InputStream getFileInputStream(AVMNodeDescriptor var1);

    public OutputStream getFileOutputStream(String var1);

    public SortedMap<String, AVMNodeDescriptor> getDirectoryListing(int var1, String var2);

    public SortedMap<String, AVMNodeDescriptor> getDirectoryListingDirect(int var1, String var2);

    public SortedMap<String, AVMNodeDescriptor> getDirectoryListing(AVMNodeDescriptor var1);

    public SortedMap<String, AVMNodeDescriptor> getDirectoryListing(AVMNodeDescriptor var1, String var2);

    public List<String> getDeleted(int var1, String var2);

    public OutputStream createFile(String var1, String var2);

    public void createDirectory(String var1, String var2);

    public void createLayeredFile(String var1, String var2, String var3);

    public void createLayeredDirectory(String var1, String var2, String var3);

    public void retargetLayeredDirectory(String var1, String var2);

    public void createStore(String var1);

    public void createStore(String var1, Map<QName, PropertyValue> var2);

    public void createBranch(int var1, String var2, String var3, String var4);

    public void removeNode(String var1, String var2);

    public void rename(String var1, String var2, String var3, String var4);

    public void uncover(String var1, String var2);

    public int getNextVersionID(String var1);

    public int getLatestSnapshotID(String var1);

    public Map<String, Integer> createSnapshot(String var1, String var2, String var3);

    public List<VersionDescriptor> getStoreVersions(String var1);

    public List<VersionDescriptor> getStoreVersions(String var1, Date var2, Date var3);

    public List<AVMStoreDescriptor> getStores();

    public AVMStoreDescriptor getStore(String var1);

    public AVMNodeDescriptor getStoreRoot(int var1, String var2);

    public AVMNodeDescriptor lookup(int var1, String var2);

    public AVMNodeDescriptor lookup(int var1, String var2, boolean var3);

    public AVMNodeDescriptor lookup(AVMNodeDescriptor var1, String var2);

    public AVMNodeDescriptor lookup(AVMNodeDescriptor var1, String var2, boolean var3);

    public Pair<Integer, String> getAPath(AVMNodeDescriptor var1);

    public String getIndirectionPath(int var1, String var2);

    public void purgeStore(String var1);

    public void purgeVersion(int var1, String var2);

    public void makePrimary(String var1);

    public List<AVMNodeDescriptor> getHistory(AVMNodeDescriptor var1, int var2);

    public void setOpacity(String var1, boolean var2);

    public AVMNodeDescriptor getCommonAncestor(AVMNodeDescriptor var1, AVMNodeDescriptor var2);

    public LayeringDescriptor getLayeringInfo(int var1, String var2);

    public void setNodeProperty(String var1, QName var2, PropertyValue var3);

    public void setNodeProperties(String var1, Map<QName, PropertyValue> var2);

    public PropertyValue getNodeProperty(int var1, String var2, QName var3);

    public Map<QName, PropertyValue> getNodeProperties(int var1, String var2);

    public void deleteNodeProperty(String var1, QName var2);

    public void deleteNodeProperties(String var1);

    public void setStoreProperty(String var1, QName var2, PropertyValue var3);

    public void setStoreProperties(String var1, Map<QName, PropertyValue> var2);

    public PropertyValue getStoreProperty(String var1, QName var2);

    public Map<QName, PropertyValue> getStoreProperties(String var1);

    public Map<QName, PropertyValue> queryStorePropertyKey(String var1, QName var2);

    public void deleteStoreProperty(String var1, QName var2);

    public void addAspect(String var1, QName var2);

    public Set<QName> getAspects(int var1, String var2);

    public void removeAspect(String var1, QName var2);

    public boolean hasAspect(int var1, String var2, QName var3);

    public void renameStore(String var1, String var2);

    public void revert(String var1, AVMNodeDescriptor var2);

    public void setGuid(String var1, String var2);

    public void setMimeType(String var1, String var2);

    public void setEncoding(String var1, String var2);

    public Map<String, Map<QName, PropertyValue>> queryStoresPropertyKeys(QName var1);

    public void createDirectory(String var1, String var2, List<QName> var3, Map<QName, PropertyValue> var4);

    public void createFile(String var1, String var2, InputStream var3);

    public void createFile(String var1, String var2, InputStream var3, List<QName> var4, Map<QName, PropertyValue> var5);

    public SortedMap<String, AVMNodeDescriptor> getDirectoryListing(AVMNodeDescriptor var1, boolean var2);

    public AVMNodeDescriptor[] getDirectoryListingArray(AVMNodeDescriptor var1, boolean var2);

    public SortedMap<String, AVMNodeDescriptor> getDirectoryListingDirect(int var1, String var2, boolean var3);

    public AVMNodeDescriptor[] getDirectoryListingArray(int var1, String var2, boolean var3);

    public SortedMap<String, AVMNodeDescriptor> getDirectoryListingDirect(AVMNodeDescriptor var1, boolean var2);

    public SortedMap<String, AVMNodeDescriptor> getDirectoryListing(int var1, String var2, boolean var3);

    public void removeNode(String var1);

    public void makeTransparent(String var1, String var2);

    public AVMStoreDescriptor getSystemStore();

    public void setMetaDataFrom(String var1, AVMNodeDescriptor var2);

    public void link(String var1, String var2, AVMNodeDescriptor var3);

    public void updateLink(String var1, String var2, AVMNodeDescriptor var3);

    public AVMNodeDescriptor forceCopy(String var1);

    public void copy(int var1, String var2, String var3, String var4);

    public List<Pair<Integer, String>> getPaths(AVMNodeDescriptor var1);

    public List<Pair<Integer, String>> getHeadPaths(AVMNodeDescriptor var1);

    public List<Pair<Integer, String>> getPathsInStoreHead(AVMNodeDescriptor var1, String var2);

    public List<String> getPathsInStoreVersion(AVMNodeDescriptor var1, String var2, int var3);

    public Map<QName, PropertyValue> getNodeProperties(AVMNodeDescriptor var1);

    public Set<QName> getAspects(AVMNodeDescriptor var1);

    public ContentReader getContentReader(int var1, String var2);

    public ContentWriter getContentWriter(String var1, boolean var2);

    public ContentData getContentDataForRead(int var1, String var2);

    public ContentData getContentDataForRead(AVMNodeDescriptor var1);

    public ContentData getContentDataForWrite(String var1);

    public void setContentData(String var1, ContentData var2);

    public List<VersionDescriptor> getStoreVersionsFrom(String var1, int var2);

    public List<VersionDescriptor> getStoreVersionsTo(String var1, int var2);

    public List<VersionDescriptor> getStoreVersionsBetween(String var1, int var2, int var3);
}

