/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.model;

import java.util.List;
import org.alfresco.service.Auditable;
import org.alfresco.service.PublicService;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderServiceType;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.model.SubFolderFilter;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicService
public interface FileFolderService {
    @Auditable(parameters={"contextNodeRef"})
    public List<FileInfo> list(NodeRef var1);

    @Auditable(parameters={"folderNodeRef"})
    public List<FileInfo> listFiles(NodeRef var1);

    @Auditable(parameters={"contextNodeRef"})
    public List<FileInfo> listFolders(NodeRef var1);

    @Auditable(parameters={"contextNodeRef"})
    public List<FileInfo> listDeepFolders(NodeRef var1, SubFolderFilter var2);

    @Auditable(parameters={"contextNodeRef", "name"})
    public NodeRef searchSimple(NodeRef var1, String var2);

    @Auditable(parameters={"contextNodeRef", "namePattern", "includeSubFolders"})
    public List<FileInfo> search(NodeRef var1, String var2, boolean var3);

    @Auditable(parameters={"contextNodeRef", "namePattern", "fileSearch", "folderSearch", "includeSubFolders"})
    public List<FileInfo> search(NodeRef var1, String var2, boolean var3, boolean var4, boolean var5);

    @Auditable(parameters={"fileFolderRef", "newName"})
    public FileInfo rename(NodeRef var1, String var2) throws FileExistsException, FileNotFoundException;

    @Auditable(parameters={"sourceNodeRef", "targetParentRef", "newName"})
    public FileInfo move(NodeRef var1, NodeRef var2, String var3) throws FileExistsException, FileNotFoundException;

    @Auditable(parameters={"sourceNodeRef", "targetParentRef", "newName"})
    public FileInfo copy(NodeRef var1, NodeRef var2, String var3) throws FileExistsException, FileNotFoundException;

    @Auditable(parameters={"parentNodeRef", "name", "typeQName"})
    public FileInfo create(NodeRef var1, String var2, QName var3) throws FileExistsException;

    @Auditable(parameters={"parentNodeRef", "name", "typeQName"})
    public FileInfo create(NodeRef var1, String var2, QName var3, QName var4) throws FileExistsException;

    @Auditable(parameters={"nodeRef"})
    public void delete(NodeRef var1);

    @Auditable(parameters={"rootNodeRef", "nodeRef"})
    public List<FileInfo> getNamePath(NodeRef var1, NodeRef var2) throws FileNotFoundException;

    @Auditable(parameters={"rootNodeRef", "pathElements"})
    public FileInfo resolveNamePath(NodeRef var1, List<String> var2) throws FileNotFoundException;

    @Auditable(parameters={"nodeRef"})
    public FileInfo getFileInfo(NodeRef var1);

    @Auditable(parameters={"nodeRef"})
    public ContentReader getReader(NodeRef var1);

    @Auditable(parameters={"nodeRef"})
    public ContentWriter getWriter(NodeRef var1);

    @Auditable(parameters={"nodeRef"})
    public boolean exists(NodeRef var1);

    @Auditable(parameters={"typeQName"})
    public FileFolderServiceType getType(QName var1);
}

