/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.security;

import java.util.Collection;
import java.util.Set;
import org.alfresco.service.Auditable;
import org.alfresco.service.NotAuditable;
import org.alfresco.service.PublicService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthorityType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicService
public interface AuthorityService {
    public static final String ZONE_APP_DEFAULT = "APP.DEFAULT";
    public static final String ZONE_APP_WCM = "APP.WCM";
    public static final String ZONE_APP_SHARE = "APP.SHARE";
    public static final String ZONE_AUTH_ALFRESCO = "AUTH.ALF";
    public static final String ZONE_AUTH_EXT_PREFIX = "AUTH.EXT.";

    @Auditable
    public boolean hasAdminAuthority();

    @Auditable(parameters={"authorityName"})
    public boolean isAdminAuthority(String var1);

    @Auditable
    public boolean hasGuestAuthority();

    @Auditable(parameters={"authorityName"})
    public boolean isGuestAuthority(String var1);

    @Auditable
    public Set<String> getAuthorities();

    @Auditable(parameters={"userName"})
    public Set<String> getAuthoritiesForUser(String var1);

    @Auditable(parameters={"type"})
    public Set<String> getAllAuthorities(AuthorityType var1);

    @Auditable(parameters={"type"})
    public Set<String> getAllRootAuthorities(AuthorityType var1);

    @Auditable(parameters={"type", "shortName"})
    public String createAuthority(AuthorityType var1, String var2);

    @Auditable(parameters={"type", "shortName", "authorityDisplayName", "authorityZones"})
    public String createAuthority(AuthorityType var1, String var2, String var3, Set<String> var4);

    @Auditable(parameters={"parentName", "childName"})
    public void addAuthority(String var1, String var2);

    @Auditable(parameters={"parentNames", "childName"})
    public void addAuthority(Collection<String> var1, String var2);

    @Auditable(parameters={"parentName", "childName"})
    public void removeAuthority(String var1, String var2);

    @Auditable(parameters={"name"})
    public void deleteAuthority(String var1);

    @Auditable(parameters={"name", "cascade"})
    public void deleteAuthority(String var1, boolean var2);

    @Auditable(parameters={"type", "name", "immediate"})
    public Set<String> getContainedAuthorities(AuthorityType var1, String var2, boolean var3);

    @Auditable(parameters={"type", "name", "immediate"})
    public Set<String> getContainingAuthorities(AuthorityType var1, String var2, boolean var3);

    @Auditable(parameters={"name"})
    public String getShortName(String var1);

    @Auditable(parameters={"type", "shortName"})
    public String getName(AuthorityType var1, String var2);

    @Auditable(parameters={"name"})
    public boolean authorityExists(String var1);

    @Auditable(parameters={"name"})
    public String getAuthorityDisplayName(String var1);

    @Auditable(parameters={"authorityName", "authorityDisplayName"})
    public void setAuthorityDisplayName(String var1, String var2);

    @Auditable(parameters={"zoneName"})
    public NodeRef getOrCreateZone(String var1);

    @Auditable(parameters={"zoneName"})
    public NodeRef getZone(String var1);

    @Auditable(parameters={"name"})
    public Set<String> getAuthorityZones(String var1);

    @Auditable(parameters={"zoneName", "type"})
    public Set<String> getAllAuthoritiesInZone(String var1, AuthorityType var2);

    @Auditable(parameters={"zoneName", "type"})
    public Set<String> getAllRootAuthoritiesInZone(String var1, AuthorityType var2);

    @Auditable(parameters={"authorityName", "zones"})
    public void addAuthorityToZones(String var1, Set<String> var2);

    @Auditable(parameters={"authorityName", "zones"})
    public void removeAuthorityFromZones(String var1, Set<String> var2);

    @NotAuditable
    public Set<String> getDefaultZones();

    @Auditable(parameters={"type"})
    public Set<String> findAuthorities(AuthorityType var1, String var2, boolean var3, String var4, String var5);
}

