/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.HashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.namespace.QName;

public abstract class TestWithUserUtils {
    public static void createUser(String userName, String password, NodeRef rootNodeRef, NodeService nodeService, MutableAuthenticationService authenticationService) {
        if (authenticationService.authenticationExists(userName)) {
            return;
        }
        QName children = ContentModel.ASSOC_CHILDREN;
        QName system = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"system");
        QName container = ContentModel.TYPE_CONTAINER;
        QName types = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"people");
        NodeRef systemNodeRef = nodeService.createNode(rootNodeRef, children, system, container).getChildRef();
        NodeRef typesNodeRef = nodeService.createNode(systemNodeRef, children, types, container).getChildRef();
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(ContentModel.PROP_USERNAME, userName);
        nodeService.createNode(typesNodeRef, children, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)userName), container, properties);
        authenticationService.createAuthentication(userName, password.toCharArray());
    }

    public static void authenticateUser(String userName, String password, NodeRef rootNodeRef, AuthenticationService authenticationService) {
        authenticationService.authenticate(userName, password.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void authenticateUser(String userName, String password, MutableAuthenticationService authenticationService, AuthenticationComponent authenticationComponent) {
        try {
            authenticationComponent.setSystemUserAsCurrentUser();
            if (!authenticationService.authenticationExists(userName)) {
                authenticationService.createAuthentication(userName, password.toCharArray());
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            authenticationComponent.clearCurrentSecurityContext();
            throw throwable;
        }
        authenticationComponent.clearCurrentSecurityContext();
        authenticationService.authenticate(userName, password.toCharArray());
    }

    public static String getCurrentUser(AuthenticationService authenticationService) {
        String un = authenticationService.getCurrentUserName();
        if (un != null) {
            return un;
        }
        throw new RuntimeException("The current user could not be retrieved.");
    }

    public static void deleteUser(String user_name, String pwd, NodeRef ref, NodeService service, MutableAuthenticationService service2) {
        service2.deleteAuthentication(user_name);
    }
}

