/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.perf;

import java.text.DecimalFormat;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractPerformanceMonitor {
    private static final Log methodSummaryLogger = LogFactory.getLog((String)"performance.summary.method");
    private static final Log vmSummaryLogger = LogFactory.getLog((String)"performance.summary.vm");
    private final String entityName;
    private SortedMap<String, MethodStats> stats;

    public static boolean isDebugEnabled() {
        return vmSummaryLogger.isDebugEnabled() || methodSummaryLogger.isDebugEnabled();
    }

    public AbstractPerformanceMonitor(String entityName) {
        this.entityName = entityName;
        this.stats = new TreeMap<String, MethodStats>();
        if (vmSummaryLogger.isDebugEnabled()) {
            ShutdownThread hook = new ShutdownThread();
            Runtime.getRuntime().addShutdownHook(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordStats(String methodName, double delayMs) {
        Log methodLogger = LogFactory.getLog((String)("performance." + this.entityName + "." + methodName));
        if (!methodLogger.isDebugEnabled()) {
            return;
        }
        DecimalFormat format = new DecimalFormat();
        format.setMinimumFractionDigits(3);
        format.setMaximumFractionDigits(3);
        if (methodSummaryLogger.isDebugEnabled()) {
            methodLogger.debug((Object)("Executed " + this.entityName + "#" + methodName + " in " + format.format(delayMs) + "ms"));
        }
        if (vmSummaryLogger.isDebugEnabled()) {
            AbstractPerformanceMonitor abstractPerformanceMonitor = this;
            synchronized (abstractPerformanceMonitor) {
                MethodStats methodStats = (MethodStats)this.stats.get(methodName);
                if (methodStats == null) {
                    methodStats = new MethodStats();
                    this.stats.put(methodName, methodStats);
                }
                methodStats.record(delayMs);
            }
        }
    }

    private class ShutdownThread
    extends Thread {
        private ShutdownThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String beanName = AbstractPerformanceMonitor.this.entityName;
            Class<ShutdownThread> clazz = ShutdownThread.class;
            synchronized (ShutdownThread.class) {
                vmSummaryLogger.debug((Object)("\n==================== " + beanName.toUpperCase() + " ==================="));
                Set methodNames = AbstractPerformanceMonitor.this.stats.keySet();
                for (String methodName : methodNames) {
                    vmSummaryLogger.debug((Object)("\nMethod performance summary: \n   Bean: " + AbstractPerformanceMonitor.this.entityName + "\n" + "   Method: " + methodName + "\n" + "   Statistics: " + AbstractPerformanceMonitor.this.stats.get(methodName)));
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }

    private class MethodStats {
        private int count;
        private double totalTimeMs;

        private MethodStats() {
        }

        public void record(double delayMs) {
            ++this.count;
            this.totalTimeMs += delayMs;
        }

        public String toString() {
            DecimalFormat format = new DecimalFormat();
            format.setMinimumFractionDigits(3);
            format.setMaximumFractionDigits(3);
            double averageMs = this.totalTimeMs / (double)this.count;
            return "Executed " + this.count + " times, averaging " + format.format(averageMs) + "ms per call";
        }
    }
}

