/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.webproject;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.avm.AVMExistsException;
import org.alfresco.service.cmr.avm.AVMNotFoundException;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.DuplicateChildNodeNameException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.wcm.AbstractWCMServiceImplTest;
import org.alfresco.wcm.asset.AssetInfo;
import org.alfresco.wcm.sandbox.SandboxInfo;
import org.alfresco.wcm.webproject.WebProjectInfo;
import org.alfresco.wcm.webproject.WebProjectInfoImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebProjectServiceImplTest
extends AbstractWCMServiceImplTest {
    private static final String TEST_WEBAPP = "myWebApp";
    private static final String TEST_WEBAPP1 = "myWebApp-AppOne";
    private static final String TEST_WEBAPP2 = "myWebApp-AppTwo";
    private static final String TEST_WEBAPP3 = "myWebApp-AppThree";
    private static final String TEST_GROUP = "testWebGroup-" + TEST_RUN;
    private static final String USER_FIVE = TEST_USER + "-Five";
    private static final String USER_SIX = TEST_USER + "-Six";
    private static final String GROUP_ONE = TEST_GROUP + "-One";
    private static final int SCALE_USERS = 5;
    private static final int SCALE_WEBPROJECTS = 5;
    private static final int SCALE_WEBAPPS = 5;
    private FileFolderService fileFolderService;
    private AuthorityService authorityService;
    private PermissionService permissionService;
    private AVMService avmService;
    private NodeService nodeService;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.fileFolderService = (FileFolderService)ctx.getBean("FileFolderService");
        this.authorityService = (AuthorityService)ctx.getBean("AuthorityService");
        this.permissionService = (PermissionService)ctx.getBean("PermissionService");
        this.avmService = (AVMService)ctx.getBean("AVMService");
        this.nodeService = (NodeService)ctx.getBean("NodeService");
        this.createUser(USER_FIVE);
        this.createUser(USER_SIX);
        HashSet<String> userNames = new HashSet<String>(2);
        userNames.add(USER_ONE);
        userNames.add(USER_TWO);
        this.createSimpleGroup(GROUP_ONE, userNames);
    }

    @Override
    protected void tearDown() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.deleteGroup(GROUP_ONE);
        this.deleteUser(USER_FIVE);
        this.deleteUser(USER_SIX);
        super.tearDown();
    }

    private void createSimpleGroup(String shortName, Set<String> userNames) {
        String groupName = this.authorityService.getName(AuthorityType.GROUP, shortName);
        if (!this.authorityService.authorityExists(groupName)) {
            this.authorityService.createAuthority(AuthorityType.GROUP, shortName);
            for (String userName : userNames) {
                this.authorityService.addAuthority(groupName, userName);
            }
        }
    }

    private void deleteGroup(String shortName) {
        String groupName = this.authorityService.getName(AuthorityType.GROUP, shortName);
        if (this.authorityService.authorityExists(groupName)) {
            this.authorityService.deleteAuthority(groupName);
        }
    }

    public void testHasWebProjectsRoot() {
        WebProjectServiceImplTest.assertTrue((boolean)this.wpService.hasWebProjectsRoot());
    }

    public void testCreateWebProjectSimple() {
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-webProjSimple", TEST_WEBPROJ_NAME + "-webProjSimple", "This is my title", "This is my description");
        WebProjectServiceImplTest.assertNotNull((Object)wpInfo);
    }

    public void testCreateWebProject() {
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-create", TEST_WEBPROJ_NAME + "-create", "This is my title", "This is my description", "ROOT", true, null);
        this.checkWebProjectInfo(wpInfo, TEST_WEBPROJ_DNS + "-create", TEST_WEBPROJ_NAME + "-create", "This is my title", "This is my description", "ROOT", true);
        try {
            this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-create", TEST_WEBPROJ_NAME + "-x", "This is my titlex", "This is my descriptionx", "ROOTx", true, null);
            WebProjectServiceImplTest.fail((String)"Shouldn't allow duplicate web project dns/store name");
        }
        catch (AlfrescoRuntimeException exception) {
            // empty catch block
        }
        try {
            this.wpService.createWebProject(TEST_WEBPROJ_DNS + "x", TEST_WEBPROJ_NAME + "-create", "This is my titlex", "This is my descriptionx", "ROOTx", true, null);
            WebProjectServiceImplTest.fail((String)"Shouldn't allow duplicate web project folder/name");
        }
        catch (DuplicateChildNodeNameException exception) {
            // empty catch block
        }
        String dnsName = TEST_WEBPROJ_DNS + "-a.b.c";
        String name = dnsName + " name";
        String mangledDnsName = TEST_WEBPROJ_DNS + "-a-b-c";
        wpInfo = this.wpService.createWebProject(dnsName, name, "This is my title", "This is my description", "ROOT", true, null);
        this.checkWebProjectInfo(wpInfo, mangledDnsName, name, "This is my title", "This is my description", "ROOT", true);
        wpInfo = this.wpService.getWebProject(mangledDnsName);
        this.checkWebProjectInfo(wpInfo, mangledDnsName, name, "This is my title", "This is my description", "ROOT", true);
        dnsName = TEST_WEBPROJ_DNS + "-0\u00e91\u00ed2\u00f33\u00fa4";
        mangledDnsName = TEST_WEBPROJ_DNS + "-0-1-2-3-4";
        name = dnsName + " name";
        wpInfo = this.wpService.createWebProject(dnsName, name, "This is my title", "This is my description", "ROOT", true, null);
        this.checkWebProjectInfo(wpInfo, mangledDnsName, name, "This is my title", "This is my description", "ROOT", true);
        wpInfo = this.wpService.getWebProject(mangledDnsName);
        this.checkWebProjectInfo(wpInfo, mangledDnsName, name, "This is my title", "This is my description", "ROOT", true);
        dnsName = "my--dns";
        name = dnsName + " name";
        try {
            wpInfo = this.wpService.createWebProject(dnsName, name, "This is my title", "This is my description", "ROOT", true, null);
            WebProjectServiceImplTest.fail((String)"Shouldn't be able to create web project with '--'");
        }
        catch (IllegalArgumentException exception) {
            // empty catch block
        }
        dnsName = "!\u00a3$%^&*()_+=-[]{}";
        name = dnsName + " name";
        try {
            wpInfo = this.wpService.createWebProject(dnsName, name, "This is my title", "This is my description", "ROOT", true, null);
            WebProjectServiceImplTest.fail((String)"Shouldn't be able to create web project with '--'");
        }
        catch (IllegalArgumentException exception) {
            // empty catch block
        }
    }

    public void testCreateWebProjectAsNonAdmin() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        try {
            this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-createAsNonAdmin", TEST_WEBPROJ_NAME + "-createAsNonAdmin", "This is my title", "This is my description", "ROOT", true, null);
            WebProjectServiceImplTest.fail((String)"Shouldn't allow anyone to create web project by default");
        }
        catch (AccessDeniedException exception) {
            // empty catch block
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        NodeRef wpRootNodeRef = this.wpService.getWebProjectsRoot();
        this.permissionService.setPermission(wpRootNodeRef, USER_ONE, "AddChildren", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-createAsNonAdmin", TEST_WEBPROJ_NAME + "-createAsNonAdmin", "This is my title", "This is my description", "ROOT", true, null);
        this.checkWebProjectInfo(wpInfo, TEST_WEBPROJ_DNS + "-createAsNonAdmin", TEST_WEBPROJ_NAME + "-createAsNonAdmin", "This is my title", "This is my description", "ROOT", true);
        WebProjectServiceImplTest.assertEquals((int)1, (int)this.wpService.listWebUsers(wpInfo.getStoreId()).size());
        WebProjectServiceImplTest.assertEquals((String)"ContentManager", (String)this.wpService.listWebUsers(wpInfo.getStoreId()).get(USER_ONE));
        this.wpService.inviteWebUser(wpInfo.getStoreId(), USER_TWO, "ContentPublisher");
        WebProjectServiceImplTest.assertEquals((int)2, (int)this.wpService.listWebUsers(wpInfo.getStoreId()).size());
        WebProjectServiceImplTest.assertEquals((String)"ContentPublisher", (String)this.wpService.listWebUsers(wpInfo.getStoreId()).get(USER_TWO));
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.permissionService.setPermission(wpRootNodeRef, USER_TWO, "Editor", true);
        this.permissionService.setPermission(wpRootNodeRef, USER_THREE, "Consumer", true);
        this.permissionService.setPermission(wpRootNodeRef, USER_FOUR, "Coordinator", true);
        this.permissionService.setPermission(wpRootNodeRef, USER_FIVE, "Contributor", true);
        this.permissionService.setPermission(wpRootNodeRef, USER_SIX, "Collaborator", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        try {
            this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-ano", TEST_WEBPROJ_NAME + "-ano", "This is my title", "This is my description", "ROOT", true, null);
            WebProjectServiceImplTest.fail((String)"Shouldn't allow anyone to create web project by default");
        }
        catch (AccessDeniedException exception) {
            // empty catch block
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_THREE);
        try {
            this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-ano", TEST_WEBPROJ_NAME + "-ano", "This is my title", "This is my description", "ROOT", true, null);
            WebProjectServiceImplTest.fail((String)"Shouldn't allow anyone to create web project by default");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_FOUR);
        wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-createAsCoordinator", TEST_WEBPROJ_NAME + "-createAsCoordinator", "This is my title", "This is my description", "ROOT", true, null);
        this.checkWebProjectInfo(wpInfo, TEST_WEBPROJ_DNS + "-createAsCoordinator", TEST_WEBPROJ_NAME + "-createAsCoordinator", "This is my title", "This is my description", "ROOT", true);
    }

    private void checkWebProjectInfo(WebProjectInfo wpInfo, String expectedStoreId, String expectedName, String expectedTitle, String expectedDescription, String expectedDefaultWebApp, boolean expectedUseAsTemplate) {
        WebProjectServiceImplTest.assertNotNull((Object)wpInfo);
        WebProjectServiceImplTest.assertEquals((String)expectedStoreId, (String)wpInfo.getStoreId());
        WebProjectServiceImplTest.assertEquals((String)expectedName, (String)wpInfo.getName());
        WebProjectServiceImplTest.assertEquals((String)expectedTitle, (String)wpInfo.getTitle());
        WebProjectServiceImplTest.assertEquals((String)expectedDescription, (String)wpInfo.getDescription());
        WebProjectServiceImplTest.assertEquals((String)expectedDefaultWebApp, (String)wpInfo.getDefaultWebApp());
        WebProjectServiceImplTest.assertEquals((boolean)expectedUseAsTemplate, (boolean)wpInfo.isTemplate());
        WebProjectServiceImplTest.assertNotNull((Object)wpInfo.getNodeRef());
    }

    public void testListWebProjects() throws Exception {
        String wpStoreId;
        List<WebProjectInfo> webProjects = this.wpService.listWebProjects();
        WebProjectServiceImplTest.assertNotNull(webProjects);
        int cnt = webProjects.size();
        this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-list1", TEST_WEBPROJ_NAME + " list1", "This is my title", "This is my description");
        this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-list2", TEST_WEBPROJ_NAME + " list2", "This is my title", "This is my description", "ROOT", true, null);
        this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-list3", TEST_WEBPROJ_NAME + " list3", "This is my title", "This is my description");
        this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-list4", TEST_WEBPROJ_NAME + " list4", "This is my title", "This is my description", "ROOT", true, null);
        webProjects = this.wpService.listWebProjects();
        WebProjectServiceImplTest.assertNotNull(webProjects);
        WebProjectServiceImplTest.assertEquals((int)(cnt + 4), (int)webProjects.size());
        for (WebProjectInfo wpInfo : webProjects) {
            wpStoreId = wpInfo.getStoreId();
            if (wpStoreId.equals(TEST_WEBPROJ_DNS + "-list1")) {
                this.checkWebProjectInfo(wpInfo, TEST_WEBPROJ_DNS + "-list1", TEST_WEBPROJ_NAME + " list1", "This is my title", "This is my description", "ROOT", false);
                continue;
            }
            if (wpStoreId.equals(TEST_WEBPROJ_DNS + "-list2")) {
                this.checkWebProjectInfo(wpInfo, TEST_WEBPROJ_DNS + "-list2", TEST_WEBPROJ_NAME + " list2", "This is my title", "This is my description", "ROOT", true);
                continue;
            }
            if (wpStoreId.equals(TEST_WEBPROJ_DNS + "-list3")) {
                this.checkWebProjectInfo(wpInfo, TEST_WEBPROJ_DNS + "-list3", TEST_WEBPROJ_NAME + " list3", "This is my title", "This is my description", "ROOT", false);
                continue;
            }
            if (wpStoreId.equals(TEST_WEBPROJ_DNS + "-list4")) {
                this.checkWebProjectInfo(wpInfo, TEST_WEBPROJ_DNS + "-list4", TEST_WEBPROJ_NAME + " list4", "This is my title", "This is my description", "ROOT", true);
                continue;
            }
            System.out.println("The web project store id " + wpStoreId + " is not recognised");
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        webProjects = this.wpService.listWebProjects();
        WebProjectServiceImplTest.assertNotNull(webProjects);
        if (!webProjects.isEmpty()) {
            for (WebProjectInfo wpInfo : webProjects) {
                wpStoreId = wpInfo.getStoreId();
                if (wpStoreId.equals(TEST_WEBPROJ_DNS + "-list-1")) {
                    WebProjectServiceImplTest.fail((String)("User should not see " + TEST_WEBPROJ_DNS + "-list-1"));
                    continue;
                }
                if (wpStoreId.equals(TEST_WEBPROJ_DNS + "-list-2")) {
                    WebProjectServiceImplTest.fail((String)("User should not see " + TEST_WEBPROJ_DNS + "-list-2"));
                    continue;
                }
                if (wpStoreId.equals(TEST_WEBPROJ_DNS + "-list-3")) {
                    WebProjectServiceImplTest.fail((String)("User should not see " + TEST_WEBPROJ_DNS + "-list-3"));
                    continue;
                }
                if (!wpStoreId.equals(TEST_WEBPROJ_DNS + "-list-4")) continue;
                WebProjectServiceImplTest.fail((String)("User should not see " + TEST_WEBPROJ_DNS + "-list-4"));
            }
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        webProjects = this.wpService.listWebProjects();
        cnt = webProjects.size();
        NodeRef wpRoot = this.wpService.getWebProjectsRoot();
        this.fileFolderService.create(wpRoot, "a folder " + TEST_RUN, ContentModel.TYPE_FOLDER);
        this.fileFolderService.create(wpRoot, "some content " + TEST_RUN, ContentModel.TYPE_CONTENT);
        webProjects = this.wpService.listWebProjects();
        WebProjectServiceImplTest.assertEquals((int)cnt, (int)webProjects.size());
    }

    public void testGetWebProject() {
        WebProjectInfo wpInfo = this.wpService.getWebProject(TEST_WEBPROJ_DNS + "-get");
        WebProjectServiceImplTest.assertNull((Object)wpInfo);
        wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-get", TEST_WEBPROJ_NAME + "-get", "This is my title", "This is my description", "ROOT", true, null);
        wpInfo = this.wpService.getWebProject(wpInfo.getStoreId());
        WebProjectServiceImplTest.assertNotNull((Object)wpInfo);
        this.checkWebProjectInfo(wpInfo, TEST_WEBPROJ_DNS + "-get", TEST_WEBPROJ_NAME + "-get", "This is my title", "This is my description", "ROOT", true);
        wpInfo = this.wpService.getWebProject(wpInfo.getNodeRef());
        WebProjectServiceImplTest.assertNotNull((Object)wpInfo);
        this.checkWebProjectInfo(wpInfo, TEST_WEBPROJ_DNS + "-get", TEST_WEBPROJ_NAME + "-get", "This is my title", "This is my description", "ROOT", true);
    }

    public void testUpdateWebProject() {
        WebProjectInfo wpInfo = new WebProjectInfoImpl(TEST_WEBPROJ_DNS + "-update", TEST_WEBPROJ_NAME + "-update", "This is my title", "This is my description", "ROOT", false, null, null);
        try {
            this.wpService.updateWebProject(wpInfo);
            WebProjectServiceImplTest.fail((String)"Shouldn't be able to update a web project that does not exist");
        }
        catch (AlfrescoRuntimeException alfrescoRuntimeException) {
            // empty catch block
        }
        wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-update", TEST_WEBPROJ_NAME + "-update", "This is my title", "This is my description", "ROOT", true, null);
        wpInfo.setName("changedName" + TEST_RUN);
        wpInfo.setTitle("changedTitle");
        wpInfo.setDescription("changedDescription");
        wpInfo.setIsTemplate(false);
        this.wpService.updateWebProject(wpInfo);
        wpInfo = this.wpService.getWebProject(wpInfo.getStoreId());
        this.checkWebProjectInfo(wpInfo, TEST_WEBPROJ_DNS + "-update", "changedName" + TEST_RUN, "changedTitle", "changedDescription", "ROOT", false);
    }

    public void testDeleteWebProject() {
        String relPath;
        int i;
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-delete", TEST_WEBPROJ_NAME + "-delete", "This is my title", "This is my description", "ROOT", true, null);
        String wpStoreId = wpInfo.getStoreId();
        WebProjectServiceImplTest.assertNotNull((Object)this.wpService.getWebProject(wpStoreId));
        WebProjectInfo wpAnoInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-delete ano", TEST_WEBPROJ_NAME + "-delete ano", "This is my title", "This is my description", "ROOT", true, null);
        String wpStoreAnoId = wpAnoInfo.getStoreId();
        WebProjectServiceImplTest.assertEquals((int)2, (int)this.sbService.listSandboxes(wpStoreId).size());
        WebProjectServiceImplTest.assertEquals((int)2, (int)this.sbService.listSandboxes(wpStoreAnoId).size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        try {
            this.wpService.deleteWebProject(wpStoreId);
            WebProjectServiceImplTest.fail((String)"Shouldn't be able to delete the web project since not a content manager");
        }
        catch (AccessDeniedException exception) {
            // empty catch block
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        try {
            this.wpService.deleteWebProject(wpStoreId);
            WebProjectServiceImplTest.fail((String)"Shouldn't be able to delete the web project since not a content manager");
        }
        catch (AccessDeniedException exception) {
            // empty catch block
        }
        String adminUser = AuthenticationUtil.getAdminUserName();
        AuthenticationUtil.setFullyAuthenticatedUser((String)adminUser);
        String defaultWebApp = wpInfo.getDefaultWebApp();
        SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpStoreId);
        String authorSandboxId = sbInfo.getSandboxId();
        String authorSandboxPath = sbInfo.getSandboxRootPath() + "/" + defaultWebApp;
        for (i = 1; i <= 10; ++i) {
            this.assetService.createFile(authorSandboxId, authorSandboxPath, "myFile-" + i, null);
            relPath = authorSandboxPath + "/" + "myFile-" + i;
            WebProjectServiceImplTest.assertEquals((String)adminUser, (String)this.avmLockingService.getLockOwner(wpStoreId, relPath));
        }
        this.wpService.deleteWebProject(wpStoreId);
        WebProjectServiceImplTest.assertNull((Object)this.wpService.getWebProject(wpStoreId));
        for (i = 1; i <= 10; ++i) {
            relPath = authorSandboxPath + "/" + "myFile-" + i;
            WebProjectServiceImplTest.assertNull((String)("Lock still exists: " + relPath), (Object)this.avmLockingService.getLockOwner(wpStoreId, relPath));
        }
        WebProjectServiceImplTest.assertEquals((int)0, (int)this.sbService.listSandboxes(wpStoreId).size());
        WebProjectServiceImplTest.assertEquals((int)2, (int)this.sbService.listSandboxes(wpStoreAnoId).size());
        try {
            this.wpService.deleteWebProject("someRandomWebProject");
            WebProjectServiceImplTest.fail((String)"Shouldn't be able to delete the web project since it does not exist (or is not visible to current user)");
        }
        catch (AccessDeniedException exception) {
            // empty catch block
        }
        wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-delete2", TEST_WEBPROJ_NAME + "-delete2", "This is my title", "This is my description", "ROOT", true, null);
        WebProjectServiceImplTest.assertNotNull((Object)this.wpService.getWebProject(wpInfo.getStoreId()));
        this.wpService.inviteWebUser(wpInfo.getNodeRef(), USER_ONE, "ContentManager", false);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        try {
            this.wpService.deleteWebProject(TEST_WEBPROJ_DNS + "-delete2");
            WebProjectServiceImplTest.fail((String)"Shouldn't be able to delete the web project since it does not exist (or is not visible to current user)");
        }
        catch (AccessDeniedException exception) {
            // empty catch block
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        this.wpService.deleteWebProject(TEST_WEBPROJ_DNS + "-delete2");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-delete3", TEST_WEBPROJ_NAME + "-delete3", "This is my title", "This is my description", "ROOT", true, null);
        wpStoreId = wpInfo.getStoreId();
        NodeRef wpNodeRef = wpInfo.getNodeRef();
        defaultWebApp = wpInfo.getDefaultWebApp();
        sbInfo = this.sbService.getAuthorSandbox(wpStoreId);
        authorSandboxId = sbInfo.getSandboxId();
        List<AssetInfo> assets = this.sbService.listChangedAll(authorSandboxId, true);
        WebProjectServiceImplTest.assertEquals((int)0, (int)assets.size());
        authorSandboxPath = sbInfo.getSandboxRootPath() + "/" + defaultWebApp;
        for (int i2 = 1; i2 <= 100; ++i2) {
            this.assetService.createFile(authorSandboxId, authorSandboxPath, "myFile-" + i2, null);
        }
        this.sbService.submitAll(authorSandboxId, "s1", "s2");
        this.wpService.deleteWebProject(wpStoreId);
        List<AVMStoreDescriptor> avmStores = this.avmService.getStores();
        for (AVMStoreDescriptor avmStore : avmStores) {
            WebProjectServiceImplTest.assertFalse((String)("Unexpected store: " + avmStore.getName()), (boolean)avmStore.getName().startsWith(wpStoreId));
        }
        NodeRef wpArchiveNodeRef = new NodeRef(this.nodeService.getStoreArchiveNode(wpNodeRef.getStoreRef()).getStoreRef(), wpNodeRef.getId());
        WebProjectServiceImplTest.assertFalse((boolean)this.nodeService.exists(wpArchiveNodeRef));
    }

    public void testCreateWebApp() {
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-createWebApp", TEST_WEBPROJ_NAME + "-createWebApp", "This is my title", "This is my description", TEST_WEBAPP1, true, null);
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        try {
            this.wpService.createWebApp(wpInfo.getStoreId(), TEST_WEBAPP2, "This is my description");
            WebProjectServiceImplTest.fail((String)"Shouldn't be able to create a webapp since not a content manager");
        }
        catch (AccessDeniedException exception) {
            // empty catch block
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.wpService.createWebApp(wpInfo.getStoreId(), TEST_WEBAPP2, "This is my description");
        try {
            this.wpService.createWebApp(wpInfo.getStoreId(), TEST_WEBAPP2, "This is my description");
            WebProjectServiceImplTest.fail((String)"Shouldn't allow duplicate webapp name");
        }
        catch (AVMExistsException aVMExistsException) {
            // empty catch block
        }
        this.wpService.createWebApp(wpInfo.getNodeRef(), TEST_WEBAPP3, "This is my description");
    }

    public void testListWebApps() {
        try {
            this.wpService.listWebApps(new NodeRef("dummy://dummy/dummy"));
            WebProjectServiceImplTest.fail((String)"Shouldn't be able to list webapps for a non-existent web project");
        }
        catch (IllegalArgumentException exception) {
            // empty catch block
        }
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-listWebApps", TEST_WEBPROJ_NAME + "-listWebApps", "This is my title", "This is my description");
        NodeRef wpNodeRef = wpInfo.getNodeRef();
        List<String> webAppNames = this.wpService.listWebApps(wpInfo.getStoreId());
        WebProjectServiceImplTest.assertNotNull(webAppNames);
        WebProjectServiceImplTest.assertEquals((int)1, (int)webAppNames.size());
        WebProjectServiceImplTest.assertTrue((boolean)webAppNames.contains("ROOT"));
        webAppNames = this.wpService.listWebApps(wpNodeRef);
        WebProjectServiceImplTest.assertNotNull(webAppNames);
        WebProjectServiceImplTest.assertEquals((int)1, (int)webAppNames.size());
        WebProjectServiceImplTest.assertTrue((boolean)webAppNames.contains("ROOT"));
        this.wpService.createWebApp(wpNodeRef, TEST_WEBAPP1, "This is my description");
        this.wpService.createWebApp(wpNodeRef, TEST_WEBAPP2, "This is my description");
        this.wpService.createWebApp(wpNodeRef, TEST_WEBAPP3, "This is my description");
        webAppNames = this.wpService.listWebApps(wpNodeRef);
        WebProjectServiceImplTest.assertEquals((int)4, (int)webAppNames.size());
        WebProjectServiceImplTest.assertTrue((boolean)webAppNames.contains("ROOT"));
        WebProjectServiceImplTest.assertTrue((boolean)webAppNames.contains(TEST_WEBAPP1));
        WebProjectServiceImplTest.assertTrue((boolean)webAppNames.contains(TEST_WEBAPP2));
        WebProjectServiceImplTest.assertTrue((boolean)webAppNames.contains(TEST_WEBAPP3));
        this.wpService.deleteWebApp(wpNodeRef, TEST_WEBAPP1);
        this.wpService.deleteWebApp(wpNodeRef, TEST_WEBAPP2);
        webAppNames = this.wpService.listWebApps(wpNodeRef);
        WebProjectServiceImplTest.assertEquals((int)2, (int)webAppNames.size());
        WebProjectServiceImplTest.assertTrue((boolean)webAppNames.contains("ROOT"));
        WebProjectServiceImplTest.assertTrue((boolean)webAppNames.contains(TEST_WEBAPP3));
    }

    public void testDeleteWebApp() {
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-deleteWebApp", TEST_WEBPROJ_NAME + "-deleteWebApp", "This is my title", "This is my description", TEST_WEBAPP1, true, null);
        String wpStoreId = wpInfo.getStoreId();
        NodeRef wpNodeRef = wpInfo.getNodeRef();
        this.wpService.createWebApp(wpNodeRef, TEST_WEBAPP2, "This is my description");
        this.wpService.createWebApp(wpNodeRef, TEST_WEBAPP3, "This is my description");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        try {
            this.wpService.deleteWebApp(wpNodeRef, TEST_WEBAPP2);
            WebProjectServiceImplTest.fail((String)"Shouldn't be able to delete the webapp since not a content manager");
        }
        catch (AccessDeniedException exception) {
            // empty catch block
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        try {
            this.wpService.deleteWebApp(wpNodeRef, TEST_WEBAPP1);
            WebProjectServiceImplTest.fail((String)"Shouldn't be able to delete the default webapp");
        }
        catch (AlfrescoRuntimeException exception) {
            // empty catch block
        }
        wpInfo = this.wpService.getWebProject(wpNodeRef);
        wpInfo.setDefaultWebApp(TEST_WEBAPP3);
        this.wpService.updateWebProject(wpInfo);
        this.wpService.deleteWebApp(wpStoreId, TEST_WEBAPP1);
        this.wpService.deleteWebApp(wpNodeRef, TEST_WEBAPP2);
        try {
            this.wpService.deleteWebApp(wpNodeRef, TEST_WEBAPP3);
            WebProjectServiceImplTest.fail((String)"Shouldn't be able to delete the default webapp");
        }
        catch (AlfrescoRuntimeException exception) {
            // empty catch block
        }
        try {
            this.wpService.deleteWebApp(wpNodeRef, "someRandomWebApp");
            WebProjectServiceImplTest.fail((String)"Shouldn't be able to delete the webapp since it does not exist");
        }
        catch (AVMNotFoundException exception) {
            // empty catch block
        }
    }

    public void testMultiInviteAndListWebUsers() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        List<WebProjectInfo> webProjects = this.wpService.listWebProjects();
        WebProjectServiceImplTest.assertNotNull(webProjects);
        int userOneWebProjectCount = webProjects.size();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-inviteWebUsers", TEST_WEBPROJ_NAME + "-inviteWebUsers", "This is my title", "This is my description");
        NodeRef wpNodeRef = wpInfo.getNodeRef();
        WebProjectServiceImplTest.assertEquals((int)1, (int)this.wpService.listWebUsers(wpNodeRef).size());
        WebProjectServiceImplTest.assertEquals((String)"ContentManager", (String)this.wpService.listWebUsers(wpNodeRef).get(AuthenticationUtil.getAdminUserName()));
        HashMap<String, String> userGroupRoles = new HashMap<String, String>();
        userGroupRoles.put(USER_ONE, "ContentManager");
        userGroupRoles.put(USER_TWO, "ContentPublisher");
        this.wpService.inviteWebUsersGroups(wpInfo.getStoreId(), userGroupRoles);
        userGroupRoles = new HashMap();
        userGroupRoles.put(USER_THREE, "ContentReviewer");
        this.wpService.inviteWebUsersGroups(wpNodeRef, userGroupRoles, false);
        WebProjectServiceImplTest.assertEquals((int)4, (int)this.wpService.listWebUsers(wpNodeRef).size());
        WebProjectServiceImplTest.assertEquals((String)"ContentManager", (String)this.wpService.listWebUsers(wpNodeRef).get(AuthenticationUtil.getAdminUserName()));
        WebProjectServiceImplTest.assertEquals((String)"ContentManager", (String)this.wpService.listWebUsers(wpNodeRef).get(USER_ONE));
        WebProjectServiceImplTest.assertEquals((String)"ContentPublisher", (String)this.wpService.listWebUsers(wpNodeRef).get(USER_TWO));
        WebProjectServiceImplTest.assertEquals((String)"ContentReviewer", (String)this.wpService.listWebUsers(wpNodeRef).get(USER_THREE));
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        webProjects = this.wpService.listWebProjects();
        WebProjectServiceImplTest.assertEquals((int)(userOneWebProjectCount + 1), (int)webProjects.size());
        userGroupRoles = new HashMap();
        userGroupRoles.put(USER_FIVE, "ContentContributor");
        this.wpService.inviteWebUsersGroups(wpNodeRef, userGroupRoles, false);
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-inviteWebUsers2", TEST_WEBPROJ_NAME + "-inviteWebUsers2", "This is my title", "This is my description");
        wpNodeRef = wpInfo.getNodeRef();
        WebProjectServiceImplTest.assertEquals((int)1, (int)this.wpService.listWebUsers(wpNodeRef).size());
        WebProjectServiceImplTest.assertEquals((String)"ContentManager", (String)this.wpService.listWebUsers(wpNodeRef).get(AuthenticationUtil.getAdminUserName()));
        userGroupRoles = new HashMap();
        userGroupRoles.put(this.authorityService.getName(AuthorityType.GROUP, GROUP_ONE), "ContentPublisher");
        this.wpService.inviteWebUsersGroups(wpInfo.getStoreId(), userGroupRoles);
        WebProjectServiceImplTest.assertEquals((int)3, (int)this.wpService.listWebUsers(wpNodeRef).size());
        WebProjectServiceImplTest.assertEquals((String)"ContentManager", (String)this.wpService.listWebUsers(wpNodeRef).get(AuthenticationUtil.getAdminUserName()));
        WebProjectServiceImplTest.assertEquals((String)"ContentPublisher", (String)this.wpService.listWebUsers(wpNodeRef).get(USER_ONE));
        WebProjectServiceImplTest.assertEquals((String)"ContentPublisher", (String)this.wpService.listWebUsers(wpNodeRef).get(USER_TWO));
    }

    public void testInviteAndListWebUsers() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        List<WebProjectInfo> webProjects = this.wpService.listWebProjects();
        WebProjectServiceImplTest.assertNotNull(webProjects);
        int userOneWebProjectCount = webProjects.size();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-inviteWebUser1", TEST_WEBPROJ_NAME + "-inviteWebUser1", "This is my title", "This is my description");
        NodeRef wpNodeRef = wpInfo.getNodeRef();
        WebProjectServiceImplTest.assertTrue((boolean)this.wpService.isWebUser(wpNodeRef, AuthenticationUtil.getAdminUserName()));
        WebProjectServiceImplTest.assertFalse((boolean)this.wpService.isWebUser(wpNodeRef, USER_ONE));
        WebProjectServiceImplTest.assertEquals((int)1, (int)this.wpService.listWebUsers(wpNodeRef).size());
        WebProjectServiceImplTest.assertEquals((String)"ContentManager", (String)this.wpService.listWebUsers(wpNodeRef).get(AuthenticationUtil.getAdminUserName()));
        this.wpService.inviteWebUser(wpInfo.getStoreId(), USER_ONE, "ContentPublisher");
        this.wpService.inviteWebUser(wpNodeRef, USER_TWO, "ContentManager", true);
        WebProjectServiceImplTest.assertEquals((int)3, (int)this.wpService.listWebUsers(wpNodeRef).size());
        WebProjectServiceImplTest.assertEquals((String)"ContentPublisher", (String)this.wpService.listWebUsers(wpNodeRef).get(USER_ONE));
        WebProjectServiceImplTest.assertEquals((String)"ContentManager", (String)this.wpService.listWebUsers(wpNodeRef).get(USER_TWO));
        WebProjectServiceImplTest.assertTrue((boolean)this.wpService.isWebUser(wpInfo.getStoreId(), USER_ONE));
        WebProjectServiceImplTest.assertTrue((boolean)this.wpService.isWebUser(wpNodeRef, USER_TWO));
        wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-inviteWebUser2", TEST_WEBPROJ_NAME + "-inviteWebUser2", "This is my title", "This is my description");
        NodeRef wpNodeRef2 = wpInfo.getNodeRef();
        WebProjectServiceImplTest.assertEquals((int)1, (int)this.wpService.listWebUsers(wpNodeRef2).size());
        WebProjectServiceImplTest.assertEquals((String)"ContentManager", (String)this.wpService.listWebUsers(wpNodeRef2).get(AuthenticationUtil.getAdminUserName()));
        WebProjectServiceImplTest.assertFalse((boolean)this.wpService.isWebUser(wpInfo.getStoreId(), USER_ONE));
        WebProjectServiceImplTest.assertFalse((boolean)this.wpService.isWebUser(wpNodeRef2, USER_TWO));
        this.wpService.inviteWebUser(wpNodeRef2, USER_TWO, "ContentPublisher", false);
        this.wpService.inviteWebUser(wpNodeRef2, USER_ONE, "ContentManager", false);
        WebProjectServiceImplTest.assertEquals((int)3, (int)this.wpService.listWebUsers(wpNodeRef2).size());
        WebProjectServiceImplTest.assertEquals((String)"ContentPublisher", (String)this.wpService.listWebUsers(wpNodeRef2).get(USER_TWO));
        WebProjectServiceImplTest.assertEquals((String)"ContentManager", (String)this.wpService.listWebUsers(wpNodeRef2).get(USER_ONE));
        WebProjectServiceImplTest.assertTrue((boolean)this.wpService.isWebUser(wpInfo.getStoreId(), USER_ONE));
        WebProjectServiceImplTest.assertTrue((boolean)this.wpService.isWebUser(wpNodeRef2, USER_TWO));
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        webProjects = this.wpService.listWebProjects();
        WebProjectServiceImplTest.assertEquals((int)(userOneWebProjectCount + 2), (int)webProjects.size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        try {
            this.wpService.inviteWebUser(wpNodeRef2, USER_THREE, "ContentReviewer", false);
            WebProjectServiceImplTest.fail((String)"Shouldn't be able to invite web user since not a content manager");
        }
        catch (AccessDeniedException exception) {
            // empty catch block
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        WebProjectServiceImplTest.assertFalse((boolean)this.wpService.isWebUser(wpNodeRef2, USER_THREE));
        this.wpService.inviteWebUser(wpNodeRef2, USER_THREE, "ContentReviewer", false);
        WebProjectServiceImplTest.assertTrue((boolean)this.wpService.isWebUser(wpNodeRef2, USER_THREE));
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        WebProjectServiceImplTest.assertEquals((int)4, (int)this.wpService.listWebUsers(wpNodeRef2).size());
        WebProjectServiceImplTest.assertEquals((String)"ContentReviewer", (String)this.wpService.listWebUsers(wpNodeRef2).get(USER_THREE));
    }

    public void testUninviteAndListWebUsers() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_FOUR);
        List<WebProjectInfo> webProjects = this.wpService.listWebProjects();
        WebProjectServiceImplTest.assertNotNull(webProjects);
        int userFourWebProjectCount = webProjects.size();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-uninviteWebUser", TEST_WEBPROJ_NAME + "-uninviteWebUser", "This is my title", "This is my description");
        NodeRef wpNodeRef = wpInfo.getNodeRef();
        WebProjectServiceImplTest.assertEquals((int)1, (int)this.wpService.listWebUsers(wpNodeRef).size());
        WebProjectServiceImplTest.assertEquals((String)"ContentManager", (String)this.wpService.listWebUsers(wpNodeRef).get(AuthenticationUtil.getAdminUserName()));
        WebProjectServiceImplTest.assertTrue((boolean)this.wpService.isWebUser(wpNodeRef, AuthenticationUtil.getAdminUserName()));
        WebProjectServiceImplTest.assertFalse((boolean)this.wpService.isWebUser(wpNodeRef, USER_FOUR));
        WebProjectServiceImplTest.assertFalse((boolean)this.wpService.isWebUser(wpNodeRef, USER_ONE));
        this.wpService.inviteWebUser(wpNodeRef, USER_FOUR, "ContentContributor", false);
        WebProjectServiceImplTest.assertEquals((int)2, (int)this.wpService.listWebUsers(wpNodeRef).size());
        WebProjectServiceImplTest.assertEquals((String)"ContentContributor", (String)this.wpService.listWebUsers(wpNodeRef).get(USER_FOUR));
        WebProjectServiceImplTest.assertTrue((boolean)this.wpService.isWebUser(wpNodeRef, USER_FOUR));
        this.wpService.inviteWebUser(wpNodeRef, USER_ONE, "ContentManager", false);
        WebProjectServiceImplTest.assertEquals((int)3, (int)this.wpService.listWebUsers(wpNodeRef).size());
        WebProjectServiceImplTest.assertEquals((String)"ContentManager", (String)this.wpService.listWebUsers(wpNodeRef).get(USER_ONE));
        WebProjectServiceImplTest.assertTrue((boolean)this.wpService.isWebUser(wpNodeRef, USER_ONE));
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_FOUR);
        webProjects = this.wpService.listWebProjects();
        WebProjectServiceImplTest.assertEquals((int)(userFourWebProjectCount + 1), (int)webProjects.size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        try {
            this.wpService.uninviteWebUser(wpNodeRef, USER_FOUR, false);
            WebProjectServiceImplTest.fail((String)"Shouldn't be able to uninvite web user since not a content manager");
        }
        catch (AccessDeniedException exception) {
            // empty catch block
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        try {
            this.wpService.uninviteWebUser(wpNodeRef, USER_FOUR, false);
            WebProjectServiceImplTest.fail((String)"Shouldn't be able to uninvite web user since not a content manager");
        }
        catch (AccessDeniedException exception) {
            // empty catch block
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.wpService.uninviteWebUser(wpInfo.getStoreId(), USER_FOUR);
        WebProjectServiceImplTest.assertEquals((int)2, (int)this.wpService.listWebUsers(wpNodeRef).size());
        WebProjectServiceImplTest.assertEquals(null, (String)this.wpService.listWebUsers(wpNodeRef).get(USER_FOUR));
        WebProjectServiceImplTest.assertFalse((boolean)this.wpService.isWebUser(wpNodeRef, USER_FOUR));
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_FOUR);
        webProjects = this.wpService.listWebProjects();
        WebProjectServiceImplTest.assertEquals((int)userFourWebProjectCount, (int)webProjects.size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.wpService.uninviteWebUser(wpNodeRef, AuthenticationUtil.getAdminUserName(), false);
        WebProjectServiceImplTest.assertEquals((int)1, (int)this.wpService.listWebUsers(wpNodeRef).size());
        WebProjectServiceImplTest.assertEquals(null, (String)this.wpService.listWebUsers(wpNodeRef).get(AuthenticationUtil.getAdminUserName()));
        WebProjectServiceImplTest.assertTrue((boolean)this.wpService.isWebUser(wpNodeRef, AuthenticationUtil.getAdminUserName()));
        WebProjectServiceImplTest.assertTrue((boolean)this.wpService.isContentManager(wpNodeRef, AuthenticationUtil.getAdminUserName()));
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        WebProjectServiceImplTest.assertEquals((int)1, (int)this.wpService.listWebUsers(wpNodeRef).size());
        WebProjectServiceImplTest.assertEquals((String)"ContentManager", (String)this.wpService.listWebUsers(wpNodeRef).get(USER_ONE));
        this.wpService.uninviteWebUser(wpNodeRef, USER_ONE, false);
        WebProjectServiceImplTest.assertFalse((boolean)this.wpService.isWebUser(wpNodeRef, USER_ONE));
        try {
            this.wpService.deleteWebProject(wpNodeRef);
            WebProjectServiceImplTest.fail((String)"Shouldn't be able to delete the web project since not a content manager");
        }
        catch (AccessDeniedException exception) {
            // empty catch block
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        WebProjectServiceImplTest.assertEquals((int)0, (int)this.wpService.listWebUsers(wpNodeRef).size());
        WebProjectServiceImplTest.assertTrue((boolean)this.wpService.isWebUser(wpNodeRef, AuthenticationUtil.getAdminUserName()));
        WebProjectServiceImplTest.assertTrue((boolean)this.wpService.isContentManager(wpInfo.getStoreId(), AuthenticationUtil.getAdminUserName()));
        this.wpService.deleteWebProject(wpNodeRef);
    }

    public void testPseudoScaleTest() {
        WebProjectInfo wpInfo;
        int i;
        long start;
        long split = start = System.currentTimeMillis();
        for (i = 1; i <= 5; ++i) {
            this.createUser(TEST_USER + "-" + i);
        }
        System.out.println("testPseudoScaleTest: created 5 users in " + (System.currentTimeMillis() - split) + " msecs");
        split = System.currentTimeMillis();
        for (i = 1; i <= 5; ++i) {
            this.wpService.createWebProject(TEST_WEBPROJ_DNS + "-" + i, TEST_WEBPROJ_NAME + "-" + i, "This is my title", "This is my description");
        }
        System.out.println("testPseudoScaleTest: created 5 web projects in " + (System.currentTimeMillis() - split) + " msecs");
        split = System.currentTimeMillis();
        for (i = 1; i <= 5; ++i) {
            wpInfo = this.wpService.getWebProject(TEST_WEBPROJ_DNS + "-" + i);
            for (int j = 1; j <= 5; ++j) {
                this.wpService.createWebApp(wpInfo.getNodeRef(), "myWebApp-" + j, "myWebApp-" + j);
            }
        }
        System.out.println("testPseudoScaleTest: created additional 5 web apps in each of 5 web projects in " + (System.currentTimeMillis() - split) + " msecs");
        split = System.currentTimeMillis();
        for (i = 1; i <= 5; ++i) {
            wpInfo = this.wpService.getWebProject(TEST_WEBPROJ_DNS + "-" + i);
            HashMap<String, String> userRoles = new HashMap<String, String>(5);
            for (int j = 1; j <= 5; ++j) {
                userRoles.put(TEST_USER + "-" + j, "ContentManager");
            }
            this.wpService.inviteWebUsersGroups(wpInfo.getNodeRef(), userRoles, false);
        }
        System.out.println("testPseudoScaleTest: invited 5 content managers to each of 5 web projects in " + (System.currentTimeMillis() - split) + " msecs");
        split = System.currentTimeMillis();
        for (i = 1; i <= 5; ++i) {
            WebProjectServiceImplTest.assertEquals((int)5, (int)this.wpService.listWebProjects(TEST_USER + "-" + i).size());
        }
        System.out.println("testPseudoScaleTest: list web projects for 5 content managers in " + (System.currentTimeMillis() - split) + " msecs");
        split = System.currentTimeMillis();
        for (i = 1; i <= 5; ++i) {
            wpInfo = this.wpService.getWebProject(TEST_WEBPROJ_DNS + "-" + i);
            this.wpService.deleteWebProject(wpInfo.getNodeRef());
        }
        System.out.println("testPseudoScaleTest: deleted 5 web projects in " + (System.currentTimeMillis() - split) + " msecs");
        split = System.currentTimeMillis();
        for (i = 1; i <= 5; ++i) {
            this.deleteUser(TEST_USER + "-" + i);
        }
        System.out.println("testPseudoScaleTest: deleted 5 users in " + (System.currentTimeMillis() - split) + " msecs");
    }
}

