/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.analysis;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.StringTokenizer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public class AlfrescoStandardFilter
extends TokenFilter {
    private static final String APOSTROPHE_TYPE = StandardTokenizer.TOKEN_TYPES[1];
    private static final String ACRONYM_TYPE = StandardTokenizer.TOKEN_TYPES[2];
    private static final String HOST_TYPE = StandardTokenizer.TOKEN_TYPES[5];
    private static final String ALPHANUM_TYPE = StandardTokenizer.TOKEN_TYPES[0];
    private Queue<Token> hostTokens = null;

    public AlfrescoStandardFilter(TokenStream in) {
        super(in);
    }

    public final Token next() throws IOException {
        if (this.hostTokens == null) {
            Token t = this.input.next();
            if (t == null) {
                return null;
            }
            String text = t.termText();
            String type = t.type();
            if (type == APOSTROPHE_TYPE && (text.endsWith("'s") || text.endsWith("'S"))) {
                return new Token(text.substring(0, text.length() - 2), t.startOffset(), t.endOffset(), type);
            }
            if (type == ACRONYM_TYPE) {
                StringBuffer trimmed = new StringBuffer();
                for (int i = 0; i < text.length(); ++i) {
                    char c = text.charAt(i);
                    if (c == '.') continue;
                    trimmed.append(c);
                }
                return new Token(trimmed.toString(), t.startOffset(), t.endOffset(), type);
            }
            if (type == HOST_TYPE) {
                this.hostTokens = new LinkedList<Token>();
                StringTokenizer tokeniser = new StringTokenizer(text, ".");
                int start = t.startOffset();
                while (tokeniser.hasMoreTokens()) {
                    String token = tokeniser.nextToken();
                    int end = start + token.length();
                    this.hostTokens.offer(new Token(token, start, end, ALPHANUM_TYPE));
                    start = end + 1;
                }
                if (text.length() == this.hostTokens.size() * 2 - 1) {
                    this.hostTokens = null;
                    StringBuffer trimmed = new StringBuffer();
                    for (int i = 0; i < text.length(); ++i) {
                        char c = text.charAt(i);
                        if (c == '.') continue;
                        trimmed.append(c);
                    }
                    return new Token(trimmed.toString(), t.startOffset(), t.endOffset(), ALPHANUM_TYPE);
                }
                return this.hostTokens.remove();
            }
            return t;
        }
        Token token = this.hostTokens.remove();
        if (this.hostTokens.isEmpty()) {
            this.hostTokens = null;
        }
        return token;
    }
}

