/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import org.alfresco.util.CachingDateFormat;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WhitespaceTokenizer;

public class DateTimeTokenFilter
extends Tokenizer {
    Tokenizer baseTokeniser;
    Iterator<Token> tokenIterator = null;

    public DateTimeTokenFilter(Reader in) {
        super(in);
        this.baseTokeniser = new WhitespaceTokenizer(in);
    }

    public Token next() throws IOException {
        if (this.tokenIterator == null) {
            this.buildIterator();
        }
        if (this.tokenIterator.hasNext()) {
            return this.tokenIterator.next();
        }
        return null;
    }

    public void buildIterator() throws IOException {
        Token candidate;
        ArrayList<Token> tokens = new ArrayList<Token>();
        while ((candidate = this.baseTokeniser.next()) != null) {
            Calendar cal;
            Date date;
            if (candidate.termText().equalsIgnoreCase("now")) {
                date = new Date();
            } else if (candidate.termText().equalsIgnoreCase("today")) {
                date = new Date();
                cal = Calendar.getInstance();
                cal.setTime(date);
                cal.set(11, cal.getMinimum(11));
                cal.set(12, cal.getMinimum(12));
                cal.set(13, cal.getMinimum(13));
                cal.set(14, cal.getMinimum(14));
            } else {
                try {
                    date = CachingDateFormat.lenientParse((String)candidate.termText());
                }
                catch (ParseException e) {
                    continue;
                }
            }
            cal = Calendar.getInstance();
            cal.setTime(date);
            Token token = new Token("YE" + cal.get(1), candidate.startOffset(), candidate.startOffset(), candidate.type());
            tokens.add(token);
            int month = cal.get(2);
            if (month < 10) {
                token = new Token("MO0" + month, candidate.startOffset(), candidate.startOffset(), candidate.type());
                tokens.add(token);
            } else {
                token = new Token("MO" + month, candidate.startOffset(), candidate.startOffset(), candidate.type());
                tokens.add(token);
            }
            int day = cal.get(5);
            if (day < 10) {
                token = new Token("DA0" + day, candidate.startOffset(), candidate.startOffset(), candidate.type());
                tokens.add(token);
            } else {
                token = new Token("DA" + day, candidate.startOffset(), candidate.startOffset(), candidate.type());
                tokens.add(token);
            }
            int hour = cal.get(11);
            if (hour < 10) {
                token = new Token("HO0" + hour, candidate.startOffset(), candidate.startOffset(), candidate.type());
                tokens.add(token);
            } else {
                token = new Token("HO" + hour, candidate.startOffset(), candidate.startOffset(), candidate.type());
                tokens.add(token);
            }
            int minute = cal.get(12);
            if (minute < 10) {
                token = new Token("MI0" + minute, candidate.startOffset(), candidate.startOffset(), candidate.type());
                tokens.add(token);
            } else {
                token = new Token("MI" + minute, candidate.startOffset(), candidate.startOffset(), candidate.type());
                tokens.add(token);
            }
            int second = cal.get(13);
            if (second < 10) {
                token = new Token("SE0" + second, candidate.startOffset(), candidate.startOffset(), candidate.type());
                tokens.add(token);
            } else {
                token = new Token("SE" + second, candidate.startOffset(), candidate.startOffset(), candidate.type());
                tokens.add(token);
            }
            int millis = cal.get(14);
            if (millis < 10) {
                token = new Token("MS00" + millis, candidate.startOffset(), candidate.startOffset(), candidate.type());
                tokens.add(token);
                break;
            }
            if (millis < 100) {
                token = new Token("MS0" + millis, candidate.startOffset(), candidate.startOffset(), candidate.type());
                tokens.add(token);
                break;
            }
            token = new Token("MS" + millis, candidate.startOffset(), candidate.startOffset(), candidate.type());
            tokens.add(token);
            break;
        }
        this.tokenIterator = tokens.iterator();
    }
}

