/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.analysis;

import junit.framework.TestCase;
import org.alfresco.repo.search.impl.lucene.analysis.NumericEncoder;

public class NumericEncodingTest
extends TestCase {
    public NumericEncodingTest() {
    }

    public NumericEncodingTest(String arg0) {
        super(arg0);
    }

    public void xtestAllIntegerEncodings() {
        String lastString = null;
        String nextString = null;
        for (long i = Integer.MIN_VALUE; i <= Integer.MAX_VALUE; ++i) {
            nextString = NumericEncoder.encode((int)i);
            if (lastString != null) {
                NumericEncodingTest.assertFalse((lastString.compareTo(nextString) > 0 ? 1 : 0) != 0);
            }
            lastString = nextString;
        }
    }

    public void xtestAllFloatEncodings() {
        Float last = null;
        Float next = null;
        String lastString = null;
        String nextString = null;
        for (int sign = 1; sign >= 0; --sign) {
            int bitPattern;
            int mantissa;
            int exponent;
            if (sign == 0) {
                for (exponent = 0; exponent <= 255; ++exponent) {
                    for (mantissa = 0; mantissa <= 0x7FFFFF; ++mantissa) {
                        bitPattern = sign << 31 | exponent << 23 | mantissa;
                        next = Float.valueOf(Float.intBitsToFloat(bitPattern));
                        if (!next.equals(Float.valueOf(Float.NaN)) && last != null && last.compareTo(next) > 0) {
                            System.err.println(last + " > " + next);
                        }
                        if (!next.equals(Float.valueOf(Float.NaN))) {
                            nextString = NumericEncoder.encode(next.floatValue());
                            if (lastString != null && lastString.compareTo(nextString) > 0) {
                                System.err.println(lastString + " > " + nextString);
                            }
                            lastString = nextString;
                        }
                        last = next;
                    }
                }
                continue;
            }
            for (exponent = 255; exponent >= 0; --exponent) {
                for (mantissa = 0x7FFFFF; mantissa >= 0; --mantissa) {
                    bitPattern = sign << 31 | exponent << 23 | mantissa;
                    next = Float.valueOf(Float.intBitsToFloat(bitPattern));
                    if (!next.equals(Float.valueOf(Float.NaN)) && last != null && last.compareTo(next) > 0) {
                        System.err.println(last + " > " + next);
                    }
                    if (!next.equals(Float.valueOf(Float.NaN))) {
                        nextString = NumericEncoder.encode(next.floatValue());
                        if (lastString != null && lastString.compareTo(nextString) > 0) {
                            System.err.println(lastString + " > " + nextString);
                        }
                        lastString = nextString;
                    }
                    last = next;
                }
            }
        }
    }

    public void testIntegerEncoding() {
        NumericEncodingTest.assertEquals((String)"00000000", (String)NumericEncoder.encode(Integer.MIN_VALUE));
        NumericEncodingTest.assertEquals((String)"00000001", (String)NumericEncoder.encode(-2147483647));
        NumericEncodingTest.assertEquals((String)"7fffffff", (String)NumericEncoder.encode(-1));
        NumericEncodingTest.assertEquals((String)"80000000", (String)NumericEncoder.encode(0));
        NumericEncodingTest.assertEquals((String)"80000001", (String)NumericEncoder.encode(1));
        NumericEncodingTest.assertEquals((String)"fffffffe", (String)NumericEncoder.encode(0x7FFFFFFE));
        NumericEncodingTest.assertEquals((String)"ffffffff", (String)NumericEncoder.encode(Integer.MAX_VALUE));
    }

    public void testLongEncoding() {
        NumericEncodingTest.assertEquals((String)"0000000000000000", (String)NumericEncoder.encode(Long.MIN_VALUE));
        NumericEncodingTest.assertEquals((String)"0000000000000001", (String)NumericEncoder.encode(-9223372036854775807L));
        NumericEncodingTest.assertEquals((String)"7fffffffffffffff", (String)NumericEncoder.encode(-1L));
        NumericEncodingTest.assertEquals((String)"8000000000000000", (String)NumericEncoder.encode(0L));
        NumericEncodingTest.assertEquals((String)"8000000000000001", (String)NumericEncoder.encode(1L));
        NumericEncodingTest.assertEquals((String)"fffffffffffffffe", (String)NumericEncoder.encode(0x7FFFFFFFFFFFFFFEL));
        NumericEncodingTest.assertEquals((String)"ffffffffffffffff", (String)NumericEncoder.encode(Long.MAX_VALUE));
        NumericEncodingTest.assertEquals((long)NumericEncoder.decodeLong(NumericEncoder.encode(Long.MIN_VALUE)), (long)Long.MIN_VALUE);
        NumericEncodingTest.assertEquals((long)NumericEncoder.decodeLong(NumericEncoder.encode(-9223372036854775807L)), (long)-9223372036854775807L);
        NumericEncodingTest.assertEquals((long)NumericEncoder.decodeLong(NumericEncoder.encode(-1L)), (long)-1L);
        NumericEncodingTest.assertEquals((long)NumericEncoder.decodeLong(NumericEncoder.encode(0L)), (long)0L);
        NumericEncodingTest.assertEquals((long)NumericEncoder.decodeLong(NumericEncoder.encode(1L)), (long)1L);
        NumericEncodingTest.assertEquals((long)NumericEncoder.decodeLong(NumericEncoder.encode(0x7FFFFFFFFFFFFFFEL)), (long)0x7FFFFFFFFFFFFFFEL);
        NumericEncodingTest.assertEquals((long)NumericEncoder.decodeLong(NumericEncoder.encode(Long.MAX_VALUE)), (long)Long.MAX_VALUE);
    }

    public void testFloatEncoding() {
        NumericEncodingTest.assertEquals((String)"007fffff", (String)NumericEncoder.encode(Float.NEGATIVE_INFINITY));
        NumericEncodingTest.assertEquals((String)"00800000", (String)NumericEncoder.encode(-3.4028235E38f));
        NumericEncodingTest.assertEquals((String)"7ffffffe", (String)NumericEncoder.encode(-1.4E-45f));
        NumericEncodingTest.assertEquals((String)"7fffffff", (String)NumericEncoder.encode(-0.0f));
        NumericEncodingTest.assertEquals((String)"80000000", (String)NumericEncoder.encode(0.0f));
        NumericEncodingTest.assertEquals((String)"80000001", (String)NumericEncoder.encode(Float.MIN_VALUE));
        NumericEncodingTest.assertEquals((String)"ff7fffff", (String)NumericEncoder.encode(Float.MAX_VALUE));
        NumericEncodingTest.assertEquals((String)"ff800000", (String)NumericEncoder.encode(Float.POSITIVE_INFINITY));
        NumericEncodingTest.assertEquals((String)"ffc00000", (String)NumericEncoder.encode(Float.NaN));
    }

    public void testDoubleEncoding() {
        NumericEncodingTest.assertEquals((String)"000fffffffffffff", (String)NumericEncoder.encode(Double.NEGATIVE_INFINITY));
        NumericEncodingTest.assertEquals((String)"0010000000000000", (String)NumericEncoder.encode(-1.7976931348623157E308));
        NumericEncodingTest.assertEquals((String)"7ffffffffffffffe", (String)NumericEncoder.encode(-4.9E-324));
        NumericEncodingTest.assertEquals((String)"7fffffffffffffff", (String)NumericEncoder.encode(-0.0));
        NumericEncodingTest.assertEquals((String)"8000000000000000", (String)NumericEncoder.encode(0.0));
        NumericEncodingTest.assertEquals((String)"8000000000000001", (String)NumericEncoder.encode(Double.MIN_VALUE));
        NumericEncodingTest.assertEquals((String)"ffefffffffffffff", (String)NumericEncoder.encode(Double.MAX_VALUE));
        NumericEncodingTest.assertEquals((String)"fff0000000000000", (String)NumericEncoder.encode(Double.POSITIVE_INFINITY));
        NumericEncodingTest.assertEquals((String)"fff8000000000000", (String)NumericEncoder.encode(Double.NaN));
        NumericEncodingTest.assertTrue((NumericEncoder.encode(-0.9).compareTo(NumericEncoder.encode(0.88)) < 0 ? 1 : 0) != 0);
        NumericEncodingTest.assertTrue((NumericEncoder.encode(-0.9).compareTo(NumericEncoder.encode(0.91)) < 0 ? 1 : 0) != 0);
        NumericEncodingTest.assertTrue((NumericEncoder.encode(0.88).compareTo(NumericEncoder.encode(0.91)) < 0 ? 1 : 0) != 0);
    }
}

