/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.lucene;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.Constraint;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.impl.BaseConjunction;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderComponent;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneConjunction
extends BaseConjunction
implements LuceneQueryBuilderComponent {
    public LuceneConjunction(List<Constraint> constraints) {
        super(constraints);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Query addComponent(Set<String> selectors, Map<String, Argument> functionArgs, LuceneQueryBuilderContext luceneContext, FunctionEvaluationContext functionContext) throws ParseException {
        BooleanQuery query = new BooleanQuery();
        boolean must = false;
        boolean should = false;
        boolean must_not = false;
        for (Constraint constraint : this.getConstraints()) {
            if (!(constraint instanceof LuceneQueryBuilderComponent)) throw new UnsupportedOperationException();
            LuceneQueryBuilderComponent luceneQueryBuilderComponent = (LuceneQueryBuilderComponent)((Object)constraint);
            Query constraintQuery = luceneQueryBuilderComponent.addComponent(selectors, functionArgs, luceneContext, functionContext);
            constraintQuery.setBoost(constraint.getBoost());
            if (constraintQuery == null) throw new UnsupportedOperationException();
            switch (constraint.getOccur()) {
                case DEFAULT: 
                case MANDATORY: {
                    query.add(constraintQuery, BooleanClause.Occur.MUST);
                    must = true;
                    break;
                }
                case OPTIONAL: {
                    query.add(constraintQuery, BooleanClause.Occur.SHOULD);
                    should = true;
                    break;
                }
                case EXCLUDE: {
                    query.add(constraintQuery, BooleanClause.Occur.MUST_NOT);
                    must_not = true;
                }
            }
            if (must || !must_not) continue;
            query.add((Query)new TermQuery(new Term("ISNODE", "T")), BooleanClause.Occur.MUST);
        }
        return query;
    }
}

