/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.auth;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jgroups.Message;
import org.jgroups.annotations.Property;
import org.jgroups.auth.AuthToken;
import org.jgroups.util.Util;

public class FixedMembershipToken
extends AuthToken {
    private List<String> memberList = null;
    private String token = "emptyToken";
    @Property
    private String fixed_members_seperator = ",";

    public String getName() {
        return "org.jgroups.auth.FixedMembershipToken";
    }

    public boolean authenticate(AuthToken token, Message msg) {
        if (token != null && token instanceof FixedMembershipToken && this.memberList != null) {
            FixedMembershipToken serverToken = (FixedMembershipToken)token;
            String sourceAddressWithPort = msg.getSrc().toString();
            String sourceAddressWithoutPort = sourceAddressWithPort.substring(0, sourceAddressWithPort.indexOf(":"));
            if (this.log.isDebugEnabled()) {
                this.log.debug("AUTHToken received from " + sourceAddressWithPort);
            }
            if (this.memberList.contains(sourceAddressWithPort) || this.memberList.contains(sourceAddressWithoutPort)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("FixedMembershipToken match");
                }
                return true;
            }
            return false;
        }
        if (this.log.isWarnEnabled()) {
            this.log.warn("Invalid AuthToken instance - wrong type or null");
        }
        return false;
    }

    @Property(name="fixed_members_value")
    public void setMemberList(String list) {
        this.memberList = new ArrayList<String>();
        StringTokenizer memberListTokenizer = new StringTokenizer(list, this.fixed_members_seperator);
        while (memberListTokenizer.hasMoreTokens()) {
            this.memberList.add(memberListTokenizer.nextToken().replace('/', ':'));
        }
    }

    public void writeTo(DataOutputStream out) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("SimpleToken writeTo()");
        }
        Util.writeString(this.token, out);
    }

    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("SimpleToken readFrom()");
        }
        this.token = Util.readString(in);
    }
}

