/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelFactory;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.ExtendedReceiver;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.annotations.Unsupported;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.blocks.ReplicatedMap;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.persistence.PersistenceFactory;
import org.jgroups.persistence.PersistenceManager;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Unsupported(comment="Use JBossCache instead")
public class ReplicatedHashMap<K extends Serializable, V extends Serializable>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
ExtendedReceiver,
ReplicatedMap<K, V> {
    private static final short PUT = 1;
    private static final short PUT_IF_ABSENT = 2;
    private static final short PUT_ALL = 3;
    private static final short REMOVE = 4;
    private static final short REMOVE_IF_EQUALS = 5;
    private static final short REPLACE_IF_EXISTS = 6;
    private static final short REPLACE_IF_EQUALS = 7;
    private static final short CLEAR = 8;
    protected static Map<Short, Method> methods;
    private Channel channel;
    protected RpcDispatcher disp = null;
    private String cluster_name = null;
    private final Set<Notification> notifs = new CopyOnWriteArraySet<Notification>();
    private final Vector<Address> members = new Vector();
    private boolean persistent = false;
    private PersistenceManager persistence_mgr = null;
    private volatile boolean send_message = false;
    protected final Promise<Boolean> state_promise = new Promise();
    protected int update_mode = 6;
    protected long timeout = 5000L;
    protected final Log log = LogFactory.getLog(this.getClass());
    protected ConcurrentMap<K, V> map = null;

    public ReplicatedHashMap(String clustername, ChannelFactory factory, String properties, long state_timeout) throws ChannelException {
        this(clustername, factory, properties, false, state_timeout);
    }

    public ReplicatedHashMap(String clustername, ChannelFactory factory, String properties, boolean persistent, long state_timeout) throws ChannelException {
        this(ReplicatedHashMap.createChannel(clustername, factory, properties), persistent);
        this.channel.connect(clustername);
        this.start(state_timeout);
    }

    private static Channel createChannel(String clustername, ChannelFactory factory, String properties) throws ChannelException {
        Channel channel = factory != null ? (properties != null ? factory.createChannel((Object)properties) : factory.createChannel()) : new JChannel(properties);
        return channel;
    }

    public ReplicatedHashMap(Channel channel) {
        this(channel, false);
    }

    public ReplicatedHashMap(Channel channel, boolean persistent) {
        this(new ConcurrentHashMap(), channel, persistent);
    }

    public ReplicatedHashMap(ConcurrentMap<K, V> map, Channel channel, boolean persistent) {
        if (channel == null) {
            throw new IllegalArgumentException("Cannot create ReplicatedHashMap with null channel");
        }
        if (map == null) {
            throw new IllegalArgumentException("Cannot create ReplicatedHashMap with null map");
        }
        this.map = map;
        this.cluster_name = channel.getClusterName();
        this.channel = channel;
        this.persistent = persistent;
        this.init();
    }

    protected final void init() {
        this.disp = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, (Object)this);
        this.disp.setMethodLookup(new MethodLookup(){

            public Method findMethod(short id) {
                return methods.get(id);
            }
        });
    }

    public boolean isBlockingUpdates() {
        return this.update_mode == 2;
    }

    public void setBlockingUpdates(boolean blocking_updates) {
        this.update_mode = blocking_updates ? 2 : 6;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public final void start(long state_timeout) throws ChannelClosedException, ChannelNotConnectedException {
        if (!this.channel.isConnected()) {
            throw new ChannelNotConnectedException();
        }
        if (!this.channel.isOpen()) {
            throw new ChannelClosedException();
        }
        boolean bl = this.send_message = this.channel.getView().size() > 1;
        if (this.persistent) {
            if (this.log.isInfoEnabled()) {
                this.log.info("fetching state from database");
            }
            try {
                this.persistence_mgr = PersistenceFactory.getInstance().createManager();
            }
            catch (Throwable ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("failed creating PersistenceManager, turning persistency off. Exception: " + Util.printStackTrace(ex));
                }
                this.persistent = false;
            }
        }
        this.state_promise.reset();
        boolean rc = this.channel.getState(null, state_timeout);
        if (rc) {
            Boolean result;
            if (this.log.isInfoEnabled()) {
                this.log.info("state was retrieved successfully, waiting for setState()");
            }
            if ((result = this.state_promise.getResult(state_timeout)) == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("setState() never got called");
                }
            } else if (this.log.isInfoEnabled()) {
                this.log.info("setState() was called");
            }
        } else {
            if (this.log.isInfoEnabled()) {
                this.log.info("state could not be retrieved (first member)");
            }
            if (this.persistent) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("fetching state from database");
                }
                try {
                    Map m = this.persistence_mgr.retrieveAll();
                    if (m != null) {
                        for (Map.Entry entry : m.entrySet()) {
                            Serializable key = (Serializable)entry.getKey();
                            Serializable val = (Serializable)entry.getValue();
                            if (this.log.isTraceEnabled()) {
                                this.log.trace("inserting " + key + " --> " + val);
                            }
                            this.put((K)key, (V)val);
                        }
                    }
                }
                catch (Throwable ex) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error("failed creating PersistenceManager, turning persistency off. Exception: " + Util.printStackTrace(ex));
                    }
                    this.persistent = false;
                }
            }
        }
    }

    public Address getLocalAddress() {
        return this.channel != null ? this.channel.getAddress() : null;
    }

    public String getClusterName() {
        return this.cluster_name;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public boolean getPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean p) {
        this.persistent = p;
    }

    public void setDeadlockDetection(boolean flag) {
        if (this.disp != null) {
            this.disp.setDeadlockDetection(flag);
        }
    }

    public void addNotifier(Notification n) {
        if (n != null) {
            this.notifs.add(n);
        }
    }

    public void removeNotifier(Notification n) {
        if (n != null) {
            this.notifs.remove(n);
        }
    }

    public void stop() {
        if (this.disp != null) {
            this.disp.stop();
            this.disp = null;
        }
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    @Override
    public V put(K key, V value) {
        Object prev_val = this.get(key);
        if (this.send_message) {
            try {
                MethodCall call = new MethodCall(1, new Object[]{key, value});
                this.disp.callRemoteMethods(null, call, this.update_mode, this.timeout);
            }
            catch (Exception e) {
                throw new RuntimeException("put(" + key + ", " + value + ") failed", e);
            }
        } else {
            return this._put(key, value);
        }
        return (V)prev_val;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        Object prev_val = this.get(key);
        if (this.send_message) {
            try {
                MethodCall call = new MethodCall(2, new Object[]{key, value});
                this.disp.callRemoteMethods(null, call, this.update_mode, this.timeout);
            }
            catch (Exception e) {
                throw new RuntimeException("putIfAbsent(" + key + ", " + value + ") failed", e);
            }
        } else {
            return this._putIfAbsent(key, value);
        }
        return (V)prev_val;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (this.send_message) {
            try {
                MethodCall call = new MethodCall(3, new Object[]{m});
                this.disp.callRemoteMethods(null, call, this.update_mode, this.timeout);
            }
            catch (Throwable t) {
                throw new RuntimeException("putAll() failed", t);
            }
        } else {
            this._putAll(m);
        }
    }

    @Override
    public void clear() {
        if (this.send_message) {
            try {
                MethodCall call = new MethodCall(8, null);
                this.disp.callRemoteMethods(null, call, this.update_mode, this.timeout);
            }
            catch (Exception e) {
                throw new RuntimeException("clear() failed", e);
            }
        } else {
            this._clear();
        }
    }

    @Override
    public V remove(Object key) {
        Object retval = this.get(key);
        if (this.send_message) {
            try {
                MethodCall call = new MethodCall(4, new Object[]{key});
                this.disp.callRemoteMethods(null, call, this.update_mode, this.timeout);
            }
            catch (Exception e) {
                throw new RuntimeException("remove(" + key + ") failed", e);
            }
        } else {
            return this._remove(key);
        }
        return (V)retval;
    }

    @Override
    public boolean remove(Object key, Object value) {
        boolean removed;
        Object val = this.get(key);
        boolean bl = removed = val != null && value != null && val.equals(value);
        if (this.send_message) {
            try {
                MethodCall call = new MethodCall(5, new Object[]{key, value});
                this.disp.callRemoteMethods(null, call, this.update_mode, this.timeout);
            }
            catch (Exception e) {
                throw new RuntimeException("remove(" + key + ", " + value + ") failed", e);
            }
        } else {
            return this._remove(key, value);
        }
        return removed;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        boolean replaced;
        Object val = this.get(key);
        boolean bl = replaced = val != null && oldValue != null && val.equals(oldValue);
        if (this.send_message) {
            try {
                MethodCall call = new MethodCall(7, new Object[]{key, oldValue, newValue});
                this.disp.callRemoteMethods(null, call, this.update_mode, this.timeout);
            }
            catch (Exception e) {
                throw new RuntimeException("replace(" + key + ", " + oldValue + ", " + newValue + ") failed", e);
            }
        } else {
            return this._replace(key, oldValue, newValue);
        }
        return replaced;
    }

    @Override
    public V replace(K key, V value) {
        Object retval = this.get(key);
        if (this.send_message) {
            try {
                MethodCall call = new MethodCall(6, new Object[]{key, value});
                this.disp.callRemoteMethods(null, call, this.update_mode, this.timeout);
            }
            catch (Exception e) {
                throw new RuntimeException("replace(" + key + ", " + value + ") failed", e);
            }
        } else {
            return this._replace(key, value);
        }
        return (V)retval;
    }

    @Override
    public V _put(K key, V value) {
        Serializable retval;
        block4: {
            retval = (Serializable)this.map.put(key, value);
            if (this.persistent) {
                try {
                    this.persistence_mgr.save((Serializable)key, (Serializable)value);
                }
                catch (Throwable t) {
                    if (!this.log.isErrorEnabled()) break block4;
                    this.log.error("failed persisting " + key + " + " + value, t);
                }
            }
        }
        for (Notification notif : this.notifs) {
            notif.entrySet(key, value);
        }
        return (V)retval;
    }

    @Override
    public V _putIfAbsent(K key, V value) {
        Serializable retval;
        block4: {
            retval = (Serializable)this.map.putIfAbsent(key, value);
            if (this.persistent) {
                try {
                    this.persistence_mgr.save((Serializable)key, (Serializable)value);
                }
                catch (Throwable t) {
                    if (!this.log.isErrorEnabled()) break block4;
                    this.log.error("failed persisting " + key + " + " + value, t);
                }
            }
        }
        for (Notification notif : this.notifs) {
            notif.entrySet(key, value);
        }
        return (V)retval;
    }

    @Override
    public void _putAll(Map<? extends K, ? extends V> map) {
        block7: {
            if (map == null) {
                return;
            }
            for (Map.Entry<K, V> entry : map.entrySet()) {
                this.map.put(entry.getKey(), entry.getValue());
            }
            if (this.persistent && !map.isEmpty()) {
                try {
                    this.persistence_mgr.saveAll(map);
                }
                catch (Throwable t) {
                    if (!this.log.isErrorEnabled()) break block7;
                    this.log.error("failed persisting contents", t);
                }
            }
        }
        if (!map.isEmpty()) {
            for (Notification notif : this.notifs) {
                notif.contentsSet(map);
            }
        }
    }

    @Override
    public void _clear() {
        block4: {
            this.map.clear();
            if (this.persistent) {
                try {
                    this.persistence_mgr.clear();
                }
                catch (Throwable t) {
                    if (!this.log.isErrorEnabled()) break block4;
                    this.log.error("failed clearing contents", t);
                }
            }
        }
        for (Notification notif : this.notifs) {
            notif.contentsCleared();
        }
    }

    @Override
    public V _remove(Object key) {
        Serializable retval;
        block5: {
            retval = (Serializable)this.map.remove(key);
            if (this.persistent && retval != null) {
                try {
                    this.persistence_mgr.remove((Serializable)key);
                }
                catch (Throwable t) {
                    if (!this.log.isErrorEnabled()) break block5;
                    this.log.error("failed removing " + key, t);
                }
            }
        }
        if (retval != null) {
            for (Notification notif : this.notifs) {
                notif.entryRemoved((Serializable)key);
            }
        }
        return (V)retval;
    }

    @Override
    public boolean _remove(Object key, Object value) {
        boolean removed;
        block5: {
            removed = this.map.remove(key, value);
            if (this.persistent && removed) {
                try {
                    this.persistence_mgr.remove((Serializable)key);
                }
                catch (Throwable t) {
                    if (!this.log.isErrorEnabled()) break block5;
                    this.log.error("failed removing " + key, t);
                }
            }
        }
        if (removed) {
            for (Notification notif : this.notifs) {
                notif.entryRemoved((Serializable)key);
            }
        }
        return removed;
    }

    @Override
    public boolean _replace(K key, V oldValue, V newValue) {
        boolean replaced;
        block5: {
            replaced = this.map.replace(key, oldValue, newValue);
            if (this.persistent && replaced) {
                try {
                    this.persistence_mgr.save((Serializable)key, (Serializable)newValue);
                }
                catch (Throwable t) {
                    if (!this.log.isErrorEnabled()) break block5;
                    this.log.error("failed saving " + key + ", " + newValue, t);
                }
            }
        }
        if (replaced) {
            for (Notification notif : this.notifs) {
                notif.entrySet(key, newValue);
            }
        }
        return replaced;
    }

    @Override
    public V _replace(K key, V value) {
        Serializable retval;
        block4: {
            retval = (Serializable)this.map.replace(key, value);
            if (this.persistent) {
                try {
                    this.persistence_mgr.save((Serializable)key, (Serializable)value);
                }
                catch (Throwable t) {
                    if (!this.log.isErrorEnabled()) break block4;
                    this.log.error("failed saving " + key + ", " + value, t);
                }
            }
        }
        for (Notification notif : this.notifs) {
            notif.entrySet(key, value);
        }
        return (V)retval;
    }

    @Override
    public void receive(Message msg) {
    }

    @Override
    public byte[] getState() {
        HashMap<Serializable, Serializable> copy = new HashMap<Serializable, Serializable>();
        for (Map.Entry<K, V> entry : this.entrySet()) {
            Serializable key = (Serializable)entry.getKey();
            Serializable val = (Serializable)entry.getValue();
            copy.put(key, val);
        }
        try {
            return Util.objectToByteBuffer(copy);
        }
        catch (Throwable ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error("exception marshalling state: " + ex);
            }
            return null;
        }
    }

    @Override
    public void setState(byte[] new_state) {
        HashMap new_copy;
        try {
            new_copy = (HashMap)Util.objectFromByteBuffer(new_state);
            if (new_copy == null) {
                return;
            }
        }
        catch (Throwable ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error("exception unmarshalling state: " + ex);
            }
            return;
        }
        this._putAll(new_copy);
        this.state_promise.setResult(Boolean.TRUE);
    }

    @Override
    public void viewAccepted(View new_view) {
        Vector<Address> new_mbrs = new_view.getMembers();
        if (new_mbrs != null) {
            this.sendViewChangeNotifications(new_view, new_mbrs, new Vector<Address>(this.members));
            this.members.clear();
            this.members.addAll(new_mbrs);
        }
        this.send_message = this.members.size() > 1;
    }

    @Override
    public void suspect(Address suspected_mbr) {
    }

    @Override
    public void block() {
    }

    void sendViewChangeNotifications(View view, Vector<Address> new_mbrs, Vector<Address> old_mbrs) {
        if (this.notifs.isEmpty() || old_mbrs == null || new_mbrs == null || old_mbrs.isEmpty() || new_mbrs.isEmpty()) {
            return;
        }
        Vector<Address> joined = new Vector<Address>();
        for (Address mbr : new_mbrs) {
            if (old_mbrs.contains(mbr)) continue;
            joined.addElement(mbr);
        }
        Vector<Address> left = new Vector<Address>();
        for (Address mbr : old_mbrs) {
            if (new_mbrs.contains(mbr)) continue;
            left.addElement(mbr);
        }
        for (Notification notif : this.notifs) {
            notif.viewChange(view, joined, left);
        }
    }

    @Override
    public byte[] getState(String state_id) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getState(OutputStream ostream) {
        HashMap<Serializable, Serializable> copy = new HashMap<Serializable, Serializable>();
        ObjectOutputStream oos = null;
        for (Map.Entry<K, V> entry : this.entrySet()) {
            Serializable key = (Serializable)entry.getKey();
            Serializable val = (Serializable)entry.getValue();
            copy.put(key, val);
        }
        try {
            oos = new ObjectOutputStream(ostream);
            oos.writeObject(copy);
        }
        catch (Throwable ex) {
            block5: {
                try {
                    if (!this.log.isErrorEnabled()) break block5;
                    this.log.error("exception marshalling state: " + ex);
                }
                catch (Throwable throwable) {
                    Util.close(oos);
                    throw throwable;
                }
            }
            Util.close(oos);
        }
        Util.close(oos);
    }

    @Override
    public void getState(String state_id, OutputStream ostream) {
    }

    @Override
    public void setState(String state_id, byte[] state) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setState(InputStream istream) {
        HashMap new_copy = null;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(istream);
            new_copy = (HashMap)ois.readObject();
            ois.close();
        }
        catch (Throwable e) {
            block5: {
                try {
                    e.printStackTrace();
                    if (!this.log.isErrorEnabled()) break block5;
                    this.log.error("exception marshalling state: " + e);
                }
                catch (Throwable throwable) {
                    Util.close(ois);
                    throw throwable;
                }
            }
            Util.close(ois);
        }
        Util.close(ois);
        if (new_copy != null) {
            this._putAll(new_copy);
        }
        this.state_promise.setResult(Boolean.TRUE);
    }

    @Override
    public void setState(String state_id, InputStream istream) {
    }

    @Override
    public void unblock() {
    }

    public static <K extends Serializable, V extends Serializable> ReplicatedMap<K, V> synchronizedMap(ReplicatedMap<K, V> map) {
        return new SynchronizedReplicatedMap(map);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public V get(Object key) {
        return (V)((Serializable)this.map.get(key));
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    public Enumeration<K> keys() {
        return Collections.enumeration(this.keySet());
    }

    public Enumeration<V> elements() {
        return Collections.enumeration(this.values());
    }

    static {
        try {
            methods = new HashMap<Short, Method>(8);
            methods.put((short)1, ReplicatedHashMap.class.getMethod("_put", Serializable.class, Serializable.class));
            methods.put((short)2, ReplicatedHashMap.class.getMethod("_putIfAbsent", Serializable.class, Serializable.class));
            methods.put((short)3, ReplicatedHashMap.class.getMethod("_putAll", Map.class));
            methods.put((short)4, ReplicatedHashMap.class.getMethod("_remove", Object.class));
            methods.put((short)5, ReplicatedHashMap.class.getMethod("_remove", Object.class, Object.class));
            methods.put((short)6, ReplicatedHashMap.class.getMethod("_replace", Serializable.class, Serializable.class));
            methods.put((short)7, ReplicatedHashMap.class.getMethod("_replace", Serializable.class, Serializable.class, Serializable.class));
            methods.put((short)8, ReplicatedHashMap.class.getMethod("_clear", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SynchronizedReplicatedMap<K extends Serializable, V extends Serializable>
    implements ReplicatedMap<K, V> {
        private final ReplicatedMap<K, V> map;
        private final Object mutex;
        private Set<K> keySet = null;
        private Set<Map.Entry<K, V>> entrySet = null;
        private Collection<V> values = null;

        private SynchronizedReplicatedMap(ReplicatedMap<K, V> map) {
            this.map = map;
            this.mutex = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.containsKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return (V)((Serializable)this.map.get(key));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V put(K key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                return (V)((Serializable)this.map.put(key, value));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            Object object = this.mutex;
            synchronized (object) {
                this.map.putAll(m);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.map.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V putIfAbsent(K key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                return (V)((Serializable)this.map.putIfAbsent(key, value));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object key, Object value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.remove(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.replace(key, oldValue, newValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V replace(K key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                return (V)((Serializable)this.map.replace(key, value));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<K> keySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.keySet == null) {
                    this.keySet = Collections.synchronizedSet(this.map.keySet());
                }
                return this.keySet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> values() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.values == null) {
                    this.values = Collections.synchronizedCollection(this.map.values());
                }
                return this.values;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.entrySet == null) {
                    this.entrySet = Collections.synchronizedSet(this.map.entrySet());
                }
                return this.entrySet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V remove(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return (V)((Serializable)this.map.remove(key));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V _put(K key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map._put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void _putAll(Map<? extends K, ? extends V> map) {
            Object object = this.mutex;
            synchronized (object) {
                this.map._putAll(map);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void _clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.map._clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V _remove(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map._remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V _putIfAbsent(K key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map._putIfAbsent(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean _remove(Object key, Object value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map._remove(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean _replace(K key, V oldValue, V newValue) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map._replace(key, oldValue, newValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V _replace(K key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map._replace(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object obj) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.equals(obj);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Notification<K extends Serializable, V extends Serializable> {
        public void entrySet(K var1, V var2);

        public void entryRemoved(K var1);

        public void viewChange(View var1, Vector<Address> var2, Vector<Address> var3);

        public void contentsSet(Map<K, V> var1);

        public void contentsCleared();
    }
}

