/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Version;
import org.jgroups.blocks.AbstractConnectionMap;
import org.jgroups.blocks.Connection;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCPConnectionMap {
    private final Mapper mapper;
    private final InetAddress bind_addr;
    private final Address local_addr;
    private final ThreadGroup thread_group = new ThreadGroup(Util.getGlobalThreadGroup(), "ConnectionTable");
    private final ServerSocket srv_sock;
    private final Receiver receiver;
    private final long conn_expire_time;
    private final Log log = LogFactory.getLog(this.getClass());
    private int recv_buf_size = 120000;
    private int send_buf_size = 60000;
    private int send_queue_size = 0;
    private int sock_conn_timeout = 1000;
    private boolean tcp_nodelay = false;
    private int linger = -1;
    private final Thread acceptor;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private volatile boolean use_send_queues = false;

    public TCPConnectionMap(ThreadFactory f, Receiver r, InetAddress bind_addr, InetAddress external_addr, int srv_port, int max_port) throws Exception {
        this(f, r, bind_addr, external_addr, srv_port, max_port, 0L, 0L);
    }

    public TCPConnectionMap(ThreadFactory f, Receiver r, InetAddress bind_addr, InetAddress external_addr, int srv_port, int max_port, long reaper_interval, long conn_expire_time) throws Exception {
        this.mapper = new Mapper(f, reaper_interval);
        this.receiver = r;
        this.bind_addr = bind_addr;
        this.conn_expire_time = conn_expire_time;
        this.srv_sock = this.createServerSocket(srv_port, max_port);
        this.local_addr = external_addr != null ? new IpAddress(external_addr, this.srv_sock.getLocalPort()) : (bind_addr != null ? new IpAddress(bind_addr, this.srv_sock.getLocalPort()) : new IpAddress(this.srv_sock.getLocalPort()));
        this.acceptor = f.newThread(this.thread_group, new ConnectionAcceptor(), "ConnectionTable.Acceptor");
    }

    public Address getLocalAddress() {
        return this.local_addr;
    }

    public void receive(Address sender, byte[] data, int offset, int length) {
        this.receiver.receive(sender, data, offset, length);
    }

    public void send(Address dest, byte[] data, int offset, int length) throws Exception {
        TCPConnection conn;
        if (dest == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("destination is null");
            }
            return;
        }
        if (data == null) {
            this.log.warn("data is null; discarding packet");
            return;
        }
        if (!this.running.get()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("connection table is not running, discarding message to " + dest);
            }
            return;
        }
        if (dest.equals(this.local_addr)) {
            this.receive(this.local_addr, data, offset, length);
            return;
        }
        try {
            conn = this.mapper.getConnection(dest);
        }
        catch (Throwable ex) {
            throw new Exception("connection to " + dest + " could not be established", ex);
        }
        try {
            conn.send(data, offset, length);
        }
        catch (Exception ex) {
            this.mapper.removeConnection(dest);
            throw ex;
        }
    }

    public void start() throws Exception {
        if (this.running.compareAndSet(false, true)) {
            this.acceptor.start();
            this.mapper.start();
        }
    }

    public void stop() {
        if (this.running.compareAndSet(true, false)) {
            Util.close(this.srv_sock);
            Util.interruptAndWaitToDie(this.acceptor);
            this.mapper.stop();
        }
    }

    protected ServerSocket createServerSocket(int start_port, int end_port) throws Exception {
        ServerSocket ret = null;
        while (true) {
            try {
                if (this.bind_addr == null) {
                    ret = new ServerSocket(start_port);
                    break;
                }
                ret = new ServerSocket(start_port, 20, this.bind_addr);
            }
            catch (BindException bind_ex) {
                NetworkInterface nic;
                if (start_port == end_port) {
                    throw new BindException("No available port to bind to");
                }
                if (this.bind_addr != null && (nic = NetworkInterface.getByInetAddress(this.bind_addr)) == null) {
                    this.log.warn("bind_addr " + this.bind_addr + " is not a valid interface: " + bind_ex);
                }
                ++start_port;
                continue;
            }
            catch (IOException io_ex) {
                if (!this.log.isErrorEnabled()) break;
                this.log.error("exception is " + io_ex);
            }
            break;
        }
        return ret;
    }

    private void setSocketParameters(Socket client_sock) throws SocketException {
        block8: {
            block7: {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("[" + this.local_addr + "] accepted connection from " + client_sock.getInetAddress() + ":" + client_sock.getPort());
                }
                try {
                    client_sock.setSendBufferSize(this.send_buf_size);
                }
                catch (IllegalArgumentException ex) {
                    if (!this.log.isErrorEnabled()) break block7;
                    this.log.error("exception setting send buffer size to " + this.send_buf_size + " bytes", ex);
                }
            }
            try {
                client_sock.setReceiveBufferSize(this.recv_buf_size);
            }
            catch (IllegalArgumentException ex) {
                if (!this.log.isErrorEnabled()) break block8;
                this.log.error("exception setting receive buffer size to " + this.send_buf_size + " bytes", ex);
            }
        }
        client_sock.setKeepAlive(true);
        client_sock.setTcpNoDelay(this.tcp_nodelay);
        if (this.linger > 0) {
            client_sock.setSoLinger(true, this.linger);
        } else {
            client_sock.setSoLinger(false, -1);
        }
    }

    public void setReceiveBufferSize(int recv_buf_size) {
        this.recv_buf_size = recv_buf_size;
    }

    public void setSocketConnectionTimeout(int sock_conn_timeout) {
        this.sock_conn_timeout = sock_conn_timeout;
    }

    public void setSendBufferSize(int send_buf_size) {
        this.send_buf_size = send_buf_size;
    }

    public void setLinger(int linger) {
        this.linger = linger;
    }

    public void setTcpNodelay(boolean tcp_nodelay) {
        this.tcp_nodelay = tcp_nodelay;
    }

    public void setSendQueueSize(int send_queue_size) {
        this.send_queue_size = send_queue_size;
    }

    public void setUseSendQueues(boolean use_send_queues) {
        this.use_send_queues = use_send_queues;
    }

    public int getNumConnections() {
        return this.mapper.getNumConnections();
    }

    public void retainAll(Collection<Address> members) {
        this.mapper.retainAll(members);
    }

    public long getConnectionExpiryTimeout() {
        return this.conn_expire_time;
    }

    public int getSenderQueueSize() {
        return this.send_queue_size;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Mapper
    extends AbstractConnectionMap<TCPConnection> {
        public Mapper(ThreadFactory factory) {
            super(factory);
        }

        public Mapper(ThreadFactory factory, long reaper_interval) {
            super(factory, reaper_interval);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TCPConnection getConnection(Address dest) throws Exception {
            TCPConnection conn = null;
            this.getLock().lock();
            try {
                conn = (TCPConnection)this.conns.get(dest);
                if (conn == null) {
                    conn = new TCPConnection(dest);
                    conn.start(this.getThreadFactory());
                    this.addConnection(dest, conn);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("created socket to " + dest);
                    }
                }
            }
            finally {
                this.getLock().unlock();
            }
            return conn;
        }
    }

    private class TCPConnection
    implements Connection {
        private final Socket sock;
        private final Lock send_lock = new ReentrantLock();
        private final Log log = LogFactory.getLog(this.getClass());
        private final byte[] cookie = new byte[]{98, 101, 108, 97};
        private final DataOutputStream out;
        private final DataInputStream in;
        private final Address peer_addr;
        private final int peer_addr_read_timeout = 2000;
        private long last_access = System.currentTimeMillis();
        private Sender sender;

        TCPConnection(Address peer_addr) throws Exception {
            if (peer_addr == null) {
                throw new IllegalArgumentException("Invalid parameter peer_addr=" + peer_addr);
            }
            InetSocketAddress destAddr = new InetSocketAddress(((IpAddress)peer_addr).getIpAddress(), ((IpAddress)peer_addr).getPort());
            this.sock = new Socket();
            this.sock.bind(new InetSocketAddress(TCPConnectionMap.this.bind_addr, 0));
            this.sock.connect(destAddr, TCPConnectionMap.this.sock_conn_timeout);
            TCPConnectionMap.this.setSocketParameters(this.sock);
            this.out = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
            this.in = new DataInputStream(new BufferedInputStream(this.sock.getInputStream()));
            this.sendLocalAddress(TCPConnectionMap.this.getLocalAddress());
            this.peer_addr = peer_addr;
        }

        TCPConnection(Socket s) throws Exception {
            if (s == null) {
                throw new IllegalArgumentException("Invalid parameter s=" + s);
            }
            TCPConnectionMap.this.setSocketParameters(s);
            this.out = new DataOutputStream(new BufferedOutputStream(s.getOutputStream()));
            this.in = new DataInputStream(new BufferedInputStream(s.getInputStream()));
            this.peer_addr = this.readPeerAddress(s);
            this.sock = s;
        }

        private Address getPeerAddress() {
            return this.peer_addr;
        }

        private void updateLastAccessed() {
            this.last_access = System.currentTimeMillis();
        }

        private void start(ThreadFactory f) {
            Thread t = f.newThread(new ConnectionPeerReceiver(), "Connection.Receiver [" + this.getSockAddress() + "]");
            t.start();
            if (this.isSenderUsed()) {
                this.sender = new Sender(f, TCPConnectionMap.this.getSenderQueueSize());
                this.sender.start();
            }
        }

        private boolean isSenderUsed() {
            return TCPConnectionMap.this.getSenderQueueSize() > 0 && TCPConnectionMap.this.use_send_queues;
        }

        private String getSockAddress() {
            StringBuilder sb = new StringBuilder();
            if (this.sock != null) {
                sb.append(this.sock.getLocalAddress().getHostAddress()).append(':').append(this.sock.getLocalPort());
                sb.append(" - ").append(this.sock.getInetAddress().getHostAddress()).append(':').append(this.sock.getPort());
            }
            return sb.toString();
        }

        private void send(byte[] data, int offset, int length) throws Exception {
            if (this.isSenderUsed()) {
                try {
                    byte[] tmp = new byte[length];
                    System.arraycopy(data, offset, tmp, 0, length);
                    this.sender.getQueue().put(tmp);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            } else {
                this._send(data, offset, length, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void _send(byte[] data, int offset, int length, boolean acquire_lock) throws Exception {
            if (acquire_lock) {
                this.send_lock.lock();
            }
            try {
                this.doSend(data, offset, length);
                this.updateLastAccessed();
            }
            catch (InterruptedException iex) {
                Thread.currentThread().interrupt();
            }
            finally {
                if (acquire_lock) {
                    this.send_lock.unlock();
                }
            }
        }

        private void doSend(byte[] data, int offset, int length) throws Exception {
            this.out.writeInt(length);
            Util.doubleWrite(data, offset, length, this.out);
            this.out.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Address readPeerAddress(Socket client_sock) throws Exception {
            int timeout = client_sock.getSoTimeout();
            client_sock.setSoTimeout(2000);
            try {
                byte[] input_cookie = new byte[this.cookie.length];
                this.in.read(input_cookie, 0, input_cookie.length);
                if (!this.matchCookie(input_cookie)) {
                    throw new SocketException("ConnectionTable.Connection.readPeerAddress(): cookie read by " + TCPConnectionMap.this.getLocalAddress() + " does not match own cookie; terminating connection");
                }
                short version = this.in.readShort();
                if (!Version.isBinaryCompatible(version) && this.log.isWarnEnabled()) {
                    this.log.warn("packet from " + client_sock.getInetAddress() + ':' + client_sock.getPort() + " has different version (" + Version.print(version) + ") from ours (" + Version.printVersion() + "). This may cause problems");
                }
                IpAddress client_peer_addr = new IpAddress();
                client_peer_addr.readFrom(this.in);
                this.updateLastAccessed();
                IpAddress ipAddress = client_peer_addr;
                return ipAddress;
            }
            finally {
                client_sock.setSoTimeout(timeout);
            }
        }

        private void sendLocalAddress(Address local_addr) throws IOException {
            this.out.write(this.cookie, 0, this.cookie.length);
            this.out.writeShort(Version.version);
            local_addr.writeTo(this.out);
            this.out.flush();
            this.updateLastAccessed();
        }

        private boolean matchCookie(byte[] input) {
            if (input == null || input.length < this.cookie.length) {
                return false;
            }
            for (int i = 0; i < this.cookie.length; ++i) {
                if (this.cookie[i] == input[i]) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder ret = new StringBuilder();
            InetAddress local = null;
            InetAddress remote = null;
            Socket tmp_sock = this.sock;
            if (tmp_sock == null) {
                ret.append("<null socket>");
            } else {
                local = tmp_sock.getLocalAddress();
                remote = tmp_sock.getInetAddress();
                String local_str = local != null ? Util.shortName(local) : "<null>";
                String remote_str = remote != null ? Util.shortName(remote) : "<null>";
                ret.append('<' + local_str + ':' + tmp_sock.getLocalPort() + " --> " + remote_str + ':' + tmp_sock.getPort() + "> (" + (System.currentTimeMillis() - this.last_access) / 1000L + " secs old)");
            }
            tmp_sock = null;
            return ret.toString();
        }

        public boolean isExpired(long now) {
            if (TCPConnectionMap.this.getConnectionExpiryTimeout() > 0L) {
                return now - this.last_access >= TCPConnectionMap.this.getConnectionExpiryTimeout();
            }
            return false;
        }

        public boolean isOpen() {
            return !this.sock.isClosed() && this.sock.isConnected();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            this.send_lock.lock();
            try {
                Util.close(this.sock);
                Util.close(this.out);
                Util.close(this.in);
                if (this.isSenderUsed()) {
                    this.sender.stop();
                }
            }
            finally {
                this.send_lock.unlock();
            }
            TCPConnectionMap.this.mapper.notifyConnectionClosed(this.peer_addr);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class Sender
        implements Runnable {
            final BlockingQueue<byte[]> send_queue;
            final Thread runner;

            public Sender(ThreadFactory tf, int send_queue_size) {
                this.runner = tf.newThread(this, "Connection.Sender [" + TCPConnection.this.getSockAddress() + "]");
                this.send_queue = new LinkedBlockingQueue<byte[]>(send_queue_size);
            }

            public BlockingQueue<byte[]> getQueue() {
                return this.send_queue;
            }

            public void start() {
                this.runner.start();
            }

            public void stop() {
                this.runner.interrupt();
            }

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted() && TCPConnection.this.isOpen()) {
                    byte[] data = null;
                    try {
                        data = this.send_queue.take();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                    if (data == null) continue;
                    try {
                        TCPConnection.this._send(data, 0, data.length, false);
                    }
                    catch (Exception exception) {}
                }
                if (TCPConnection.this.log.isTraceEnabled()) {
                    TCPConnection.this.log.trace("ConnectionTable.Connection.Sender thread terminated");
                }
            }
        }

        private class ConnectionPeerReceiver
        implements Runnable {
            private ConnectionPeerReceiver() {
            }

            public void run() {
                byte[] buf = new byte[256];
                int len = 0;
                while (TCPConnection.this.isOpen()) {
                    try {
                        len = TCPConnection.this.in.readInt();
                        if (len > buf.length) {
                            buf = new byte[len];
                        }
                        TCPConnection.this.in.readFully(buf, 0, len);
                        TCPConnection.this.updateLastAccessed();
                        TCPConnectionMap.this.receiver.receive(TCPConnection.this.peer_addr, buf, 0, len);
                    }
                    catch (OutOfMemoryError mem_ex) {
                        break;
                    }
                    catch (IOException io_ex) {
                        break;
                    }
                    catch (Throwable throwable) {
                    }
                }
                Util.close(TCPConnection.this);
            }
        }
    }

    private class ConnectionAcceptor
    implements Runnable {
        private ConnectionAcceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!TCPConnectionMap.this.srv_sock.isClosed() && !Thread.currentThread().isInterrupted()) {
                TCPConnection conn = null;
                Socket client_sock = null;
                try {
                    client_sock = TCPConnectionMap.this.srv_sock.accept();
                    conn = new TCPConnection(client_sock);
                    Address peer_addr = conn.getPeerAddress();
                    TCPConnectionMap.this.mapper.getLock().lock();
                    try {
                        boolean currentConnectionOpen = TCPConnectionMap.this.mapper.hasOpenConnection(peer_addr);
                        boolean replaceWithNewConnection = false;
                        if (currentConnectionOpen) {
                            boolean bl = replaceWithNewConnection = peer_addr.compareTo(TCPConnectionMap.this.local_addr) > 0;
                        }
                        if (!currentConnectionOpen || replaceWithNewConnection) {
                            TCPConnectionMap.this.mapper.removeConnection(peer_addr);
                            TCPConnectionMap.this.mapper.addConnection(peer_addr, conn);
                            conn.start(TCPConnectionMap.this.mapper.getThreadFactory());
                            continue;
                        }
                        Util.close(conn);
                    }
                    finally {
                        TCPConnectionMap.this.mapper.getLock().unlock();
                    }
                }
                catch (SocketException se) {
                    boolean threadExiting;
                    boolean bl = threadExiting = TCPConnectionMap.this.srv_sock.isClosed() || Thread.currentThread().isInterrupted();
                    if (threadExiting) break;
                    if (TCPConnectionMap.this.log.isWarnEnabled()) {
                        TCPConnectionMap.this.log.warn("Could not accept connection from peer ", se);
                    }
                    Util.close(conn);
                    Util.close(client_sock);
                }
                catch (Exception ex) {
                    if (TCPConnectionMap.this.log.isWarnEnabled()) {
                        TCPConnectionMap.this.log.warn("Could not read accept connection from peer " + ex);
                    }
                    Util.close(conn);
                    Util.close(client_sock);
                }
            }
            if (TCPConnectionMap.this.log.isTraceEnabled()) {
                TCPConnectionMap.this.log.trace(Thread.currentThread().getName() + " terminated");
            }
        }
    }

    public static interface Receiver {
        public void receive(Address var1, byte[] var2, int var3, int var4);
    }
}

