/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.debug;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jgroups.Address;
import org.jgroups.ChannelException;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.Queue;
import org.jgroups.util.QueueClosedException;
import org.jgroups.util.TimeScheduler;

public class Simulator {
    private Protocol[] protStack = null;
    private ProtocolAdapter ad = new ProtocolAdapter();
    private ProtocolStack prot_stack = null;
    private Receiver r = null;
    private Protocol top = null;
    private Protocol bottom = null;
    private Queue send_queue = new Queue();
    private Thread send_thread;
    private Queue recv_queue = new Queue();
    private Thread recv_thread;
    private final HashMap<Address, Simulator> addrTable = new HashMap();
    private Address local_addr = null;
    private View view;
    private boolean crashFailureEnabled = false;
    private boolean partitionEnabled = false;
    private Set<Address> partition = new HashSet<Address>();
    private boolean slowProcessEnabled = false;
    private long delay = 0L;
    private boolean droppedMessagesEnabled = false;
    private Set<DropMessage> droppedMessages = new HashSet<DropMessage>();

    public ProtocolStack getProtocolStack() {
        return this.prot_stack;
    }

    public void setProtocolStack(Protocol[] stack) {
        this.protStack = stack;
        this.protStack[0].setUpProtocol(this.ad);
        this.protStack[this.protStack.length - 1].setDownProtocol(this.ad);
        this.top = this.protStack[0];
        this.bottom = this.protStack[this.protStack.length - 1];
        try {
            this.prot_stack = new ProtocolStack();
        }
        catch (ChannelException e) {
            e.printStackTrace();
        }
        if (this.protStack.length > 1) {
            for (int i = 0; i < this.protStack.length; ++i) {
                Protocol p2;
                Protocol p1 = this.protStack[i];
                p1.setProtocolStack(this.prot_stack);
                Protocol protocol = p2 = i + 1 >= this.protStack.length ? null : this.protStack[i + 1];
                if (p2 == null) continue;
                p1.setDownProtocol(p2);
                p2.setUpProtocol(p1);
            }
        }
    }

    public String dumpStats() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.protStack.length; ++i) {
            Protocol p1 = this.protStack[i];
            sb.append(p1.getName()).append(":\n").append(p1.dumpStats()).append("\n");
        }
        return sb.toString();
    }

    public void addMember(Address addr) {
        this.addMember(addr, this);
    }

    public void addMember(Address addr, Simulator s) {
        this.addrTable.put(addr, s);
    }

    public void setLocalAddress(Address addr) {
        this.local_addr = addr;
    }

    public Address getLocalAddress() {
        return this.local_addr;
    }

    public void setView(View v) {
        this.view = v;
    }

    public void setReceiver(Receiver r) {
        this.r = r;
    }

    public Receiver getReceiver() {
        return this.r;
    }

    public Object send(Event evt) {
        return this.top.down(evt);
    }

    public void receive(Event evt) {
        try {
            Event copy = evt.getType() == 1 && evt.getArg() != null ? new Event(1, ((Message)evt.getArg()).copy()) : evt;
            this.recv_queue.add(copy);
        }
        catch (QueueClosedException queueClosedException) {
            // empty catch block
        }
    }

    public void start() throws Exception {
        Protocol p;
        int i;
        if (this.local_addr == null) {
            throw new Exception("local_addr has to be non-null");
        }
        if (this.protStack == null) {
            throw new Exception("protocol stack is null");
        }
        for (i = 0; i < this.protStack.length; ++i) {
            p = this.protStack[i];
            p.setProtocolStack(this.prot_stack);
        }
        for (i = 0; i < this.protStack.length; ++i) {
            p = this.protStack[i];
            p.init();
        }
        this.protStack[0].down(new Event(8, this.local_addr));
        for (i = 0; i < this.protStack.length; ++i) {
            p = this.protStack[i];
            p.start();
        }
        if (this.view != null) {
            Event view_evt = new Event(6, this.view);
            this.bottom.up(view_evt);
            this.top.down(view_evt);
        }
        this.send_thread = new SendThread();
        this.send_thread.start();
        this.recv_thread = new ReceiveThread();
        this.recv_thread.start();
    }

    public void stop() {
        this.recv_thread = null;
        this.recv_queue.close(false);
        this.send_thread = null;
        this.send_queue.close(false);
        if (this.ad != null) {
            try {
                this.ad.getTimer().stop();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void simulateCrashFailure() {
        this.crashFailureEnabled = true;
        System.out.println("CRASH! at peer " + this.getLocalAddress());
    }

    public void simulateSlowProcess(long delay) {
        this.slowProcessEnabled = true;
        this.delay = delay;
    }

    public void simulatePartition(Address[] partition) {
        this.partitionEnabled = true;
        this.partition.clear();
        for (int i = 0; i < partition.length; ++i) {
            this.partition.add(partition[i]);
        }
    }

    public void simulateMerge() {
        if (!this.partitionEnabled) {
            return;
        }
        this.partitionEnabled = false;
        this.partition.clear();
    }

    public void registerDropMessage(DropMessage d) {
        if (d != null) {
            this.droppedMessagesEnabled = true;
            this.droppedMessages.add(d);
        }
    }

    public void deRegisterDropMessage(DropMessage d) {
        if (d != null) {
            this.droppedMessages.remove(d);
            if (this.droppedMessages.size() == 0) {
                this.droppedMessagesEnabled = false;
            }
        }
    }

    public boolean checkForDropMessage(Message msg, Address dest) {
        Address src = this.getLocalAddress();
        for (DropMessage d : this.droppedMessages) {
            if (!d.drop(msg, dest)) continue;
            return true;
        }
        return false;
    }

    public boolean senderDropFault(Message msg, Address dest) {
        Address a = this.getLocalAddress();
        if (this.crashFailureEnabled) {
            return true;
        }
        if (this.partitionEnabled && !this.partition.contains(dest)) {
            return true;
        }
        return this.droppedMessagesEnabled && this.checkForDropMessage(msg, dest);
    }

    public boolean receiverDropFault(Message msg, Address src) {
        Address a = this.getLocalAddress();
        if (this.crashFailureEnabled) {
            return true;
        }
        if (this.slowProcessEnabled) {
            try {
                Thread.sleep(this.delay);
                return false;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return this.partitionEnabled && !this.partition.contains(src);
    }

    public static interface DropMessage {
        public boolean drop(Message var1, Address var2);
    }

    class ReceiveThread
    extends Thread {
        ReceiveThread() {
        }

        public void run() {
            while (Simulator.this.recv_thread != null) {
                try {
                    Event evt = (Event)Simulator.this.recv_queue.remove();
                    Message msg = (Message)evt.getArg();
                    Address dst = msg.getDest();
                    Address src = msg.getSrc();
                    if (Simulator.this.receiverDropFault(msg, src)) continue;
                    Simulator.this.bottom.up(evt);
                }
                catch (QueueClosedException e) {
                    Simulator.this.recv_thread = null;
                    break;
                }
            }
        }
    }

    class SendThread
    extends Thread {
        public void run() {
            while (Simulator.this.send_thread != null) {
                try {
                    Simulator s2;
                    Event evt = (Event)Simulator.this.send_queue.remove();
                    if (evt.getType() != 1) continue;
                    Message msg = (Message)evt.getArg();
                    Address dst = msg.getDest();
                    Address src = msg.getSrc();
                    if (src == null) {
                        ((Message)evt.getArg()).setSrc(Simulator.this.local_addr);
                    }
                    if (dst == null) {
                        for (Simulator s2 : Simulator.this.addrTable.values()) {
                            Address d = s2.getLocalAddress();
                            if (Simulator.this.senderDropFault(msg, d)) continue;
                            s2.receive(evt);
                        }
                        continue;
                    }
                    s2 = (Simulator)Simulator.this.addrTable.get(dst);
                    if (s2 == null || Simulator.this.senderDropFault(msg, dst)) continue;
                    s2.receive(evt);
                }
                catch (QueueClosedException e) {
                    Simulator.this.send_thread = null;
                    break;
                }
            }
        }
    }

    class ProtocolAdapter
    extends TP {
        ProtocolAdapter() {
            this.timer = new TimeScheduler();
        }

        public TimeScheduler getTimer() {
            return this.timer;
        }

        public void setTimer(TimeScheduler timer) {
            this.timer = timer;
        }

        public String getName() {
            return "ProtocolAdapter";
        }

        public void sendMulticast(byte[] data, int offset, int length) throws Exception {
        }

        public void sendUnicast(PhysicalAddress dest, byte[] data, int offset, int length) throws Exception {
        }

        public String getInfo() {
            return null;
        }

        protected PhysicalAddress getPhysicalAddress() {
            throw new UnsupportedOperationException("not implemented");
        }

        public void init() throws Exception {
            super.init();
        }

        public Object up(Event evt) {
            if (Simulator.this.r != null) {
                Simulator.this.r.receive(evt);
            }
            return null;
        }

        public Object down(Event evt) {
            try {
                Simulator.this.send_queue.add(evt);
            }
            catch (QueueClosedException queueClosedException) {
                // empty catch block
            }
            return null;
        }
    }

    public static interface Receiver {
        public void receive(Event var1);
    }
}

