/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.InterruptedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Promise;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Tuple;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MBean
public abstract class Discovery
extends Protocol {
    @Property(description="Timeout to wait for the initial members. Default is 3000 msec")
    @ManagedAttribute(description="Timeout (ms) to wait for the initial members", writable=true)
    long timeout = 3000L;
    @Property(description="Minimum number of initial members to get a response from. Default is 2")
    @ManagedAttribute(description="Minimum number of initial members to get a response from", writable=true)
    int num_initial_members = 2;
    @Property(description="Minimum number of server responses (PingData.isServer()=true). If this value is greater than 0, we'll ignore num_initial_members")
    @ManagedAttribute(writable=true, description="Minimum number of server responses (PingData.isServer()=true). If this value is greater than 0, we'll ignore num_initial_members")
    int num_initial_srv_members = 0;
    @Property(description="Return from the discovery phase as soon as we have 1 coordinator response")
    @ManagedAttribute(writable=true, description="Return from the discovery phase as soon as we have 1 coordinator response")
    boolean break_on_coord_rsp = true;
    @Property(description="Number of discovery requests to be sent distributed over timeout. Default is 2")
    @ManagedAttribute(description="Number of discovery requests to be sent (min=1), distributed over timeout ms", writable=true)
    int num_ping_requests = 2;
    @Property(description="Whether or not to return the entire logical-physical address cache mappings on a discovery request, or not. Default is false, except for TCPPING")
    boolean return_entire_cache = false;
    @ManagedAttribute(description="Total number of discovery requests sent ")
    int num_discovery_requests = 0;
    private volatile boolean is_server = false;
    protected TimeScheduler timer = null;
    protected View view;
    protected final Vector<Address> members = new Vector(11);
    protected Address local_addr = null;
    protected String group_addr = null;
    protected final Set<Responses> ping_responses = new HashSet<Responses>();
    private final PingSenderTask sender = new PingSenderTask();

    @Override
    public void init() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer cannot be retrieved from protocol stack");
        }
    }

    public abstract void sendGetMembersRequest(String var1, Promise var2) throws Exception;

    public void handleDisconnect() {
    }

    public void handleConnect() {
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public int getNumInitialMembers() {
        return this.num_initial_members;
    }

    public void setNumInitialMembers(int num_initial_members) {
        this.num_initial_members = num_initial_members;
    }

    public int getNumPingRequests() {
        return this.num_ping_requests;
    }

    public void setNumPingRequests(int num_ping_requests) {
        this.num_ping_requests = num_ping_requests;
    }

    public int getNumberOfDiscoveryRequestsSent() {
        return this.num_discovery_requests;
    }

    @Override
    public Vector<Integer> providedUpServices() {
        Vector<Integer> ret = new Vector<Integer>(1);
        ret.addElement(new Integer(12));
        return ret;
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_discovery_requests = 0;
    }

    @Override
    public void start() throws Exception {
        super.start();
    }

    @Override
    public void stop() {
        this.is_server = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PingData> findInitialMembers(Promise<JoinRsp> promise) {
        ++this.num_discovery_requests;
        Responses rsps = new Responses(this.num_initial_members, this.num_initial_srv_members, this.break_on_coord_rsp, promise);
        Collection<Object> collection = this.ping_responses;
        synchronized (collection) {
            this.ping_responses.add(rsps);
        }
        this.sender.start(this.group_addr, promise);
        try {
            collection = rsps.get(this.timeout);
            return collection;
        }
        catch (Exception e) {
            LinkedList<PingData> linkedList = new LinkedList<PingData>();
            return linkedList;
        }
        finally {
            this.sender.stop();
            Set<Responses> set = this.ping_responses;
            synchronized (set) {
                this.ping_responses.remove(rsps);
            }
        }
    }

    public String findInitialMembersAsString() {
        List<PingData> results = this.findInitialMembers(null);
        if (results == null || results.isEmpty()) {
            return "<empty>";
        }
        StringBuilder sb = new StringBuilder();
        for (PingData rsp : results) {
            sb.append(rsp).append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                PingHeader hdr = (PingHeader)msg.getHeader(this.getName());
                if (hdr == null) {
                    return this.up_prot.up(evt);
                }
                switch (hdr.type) {
                    case 1: {
                        Address coord;
                        Collection<Address> physical_addrs;
                        if (this.local_addr != null && msg.getSrc() != null && this.local_addr.equals(msg.getSrc())) {
                            return null;
                        }
                        if (this.group_addr == null || hdr.cluster_name == null) {
                            if (this.log.isWarnEnabled()) {
                                this.log.warn("group_addr (" + this.group_addr + ") or cluster_name of header (" + hdr.cluster_name + ") is null; passing up discovery request from " + msg.getSrc() + ", but this should not" + " be the case");
                            }
                        } else if (!this.group_addr.equals(hdr.cluster_name)) {
                            if (!this.log.isWarnEnabled()) return null;
                            this.log.warn("discarding discovery request for cluster '" + hdr.cluster_name + "' from " + msg.getSrc() + "; our cluster name is '" + this.group_addr + "'. " + "Please separate your clusters cleanly.");
                            return null;
                        }
                        if (hdr.arg != null) {
                            PhysicalAddress physical_addr;
                            Address logical_addr = hdr.arg.getAddress();
                            if (logical_addr == null) {
                                logical_addr = msg.getSrc();
                            }
                            PhysicalAddress physicalAddress = physical_addr = (physical_addrs = hdr.arg.getPhysicalAddrs()) != null && !physical_addrs.isEmpty() ? (PhysicalAddress)physical_addrs.iterator().next() : null;
                            if (logical_addr != null && physical_addr != null) {
                                this.down(new Event(89, new Tuple<Address, PhysicalAddress>(logical_addr, physical_addr)));
                            }
                            if (logical_addr != null && hdr.arg.getLogicalName() != null) {
                                UUID.add((UUID)logical_addr, hdr.arg.getLogicalName());
                            }
                        }
                        physical_addrs = this.members;
                        synchronized (physical_addrs) {
                            coord = !this.members.isEmpty() ? this.members.firstElement() : this.local_addr;
                        }
                        if (this.return_entire_cache) {
                            Map cache = (Map)this.down(new Event(88));
                            if (cache == null) return null;
                            for (Map.Entry entry : cache.entrySet()) {
                                Address logical_addr = (Address)entry.getKey();
                                PhysicalAddress physical_addr = (PhysicalAddress)entry.getValue();
                                this.sendDiscoveryResponse(logical_addr, Arrays.asList(physical_addr), coord, this.is_server, UUID.get(logical_addr), msg.getSrc());
                            }
                            return null;
                        } else {
                            PhysicalAddress physical_addr = (PhysicalAddress)this.down(new Event(87, this.local_addr));
                            this.sendDiscoveryResponse(this.local_addr, Arrays.asList(physical_addr), coord, this.is_server, UUID.get(this.local_addr), msg.getSrc());
                        }
                        return null;
                    }
                    case 2: {
                        Collection<PhysicalAddress> physical_addrs;
                        PhysicalAddress physical_addr;
                        PingData rsp = hdr.arg;
                        if (rsp == null) return null;
                        Address response_sender = msg.getSrc();
                        Address logical_addr = rsp.getAddress();
                        if (logical_addr == null) {
                            logical_addr = msg.getSrc();
                        }
                        PhysicalAddress physicalAddress = physical_addr = (physical_addrs = rsp.getPhysicalAddrs()) != null && !physical_addrs.isEmpty() ? physical_addrs.iterator().next() : null;
                        if (logical_addr != null && physical_addr != null) {
                            this.down(new Event(89, new Tuple<Address, PhysicalAddress>(logical_addr, physical_addr)));
                        }
                        if (logical_addr != null && rsp.getLogicalName() != null) {
                            UUID.add((UUID)logical_addr, rsp.getLogicalName());
                        }
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("received GET_MBRS_RSP from " + response_sender + ": " + rsp);
                        }
                        Set<Responses> set = this.ping_responses;
                        synchronized (set) {
                            for (Responses rsps : this.ping_responses) {
                                boolean overwrite = logical_addr.equals(response_sender);
                                rsps.addResponse(rsp, overwrite);
                            }
                            return null;
                        }
                    }
                }
                if (!this.log.isWarnEnabled()) return null;
                this.log.warn("got PING header with unknown type (" + hdr.type + ')');
                return null;
            }
            case 87: {
                try {
                    this.sendGetMembersRequest(this.group_addr, null);
                    return null;
                }
                catch (InterruptedIOException ie) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn("Discovery request for cluster " + this.group_addr + " interrupted");
                    }
                    Thread.currentThread().interrupt();
                    return null;
                }
                catch (Exception ex) {
                    if (!this.log.isErrorEnabled()) return null;
                    this.log.error("failed sending discovery request", ex);
                }
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 12: {
                long start = System.currentTimeMillis();
                List<PingData> rsps = this.findInitialMembers((Promise)evt.getArg());
                long diff = System.currentTimeMillis() - start;
                if (this.log.isTraceEnabled()) {
                    this.log.trace("discovery took " + diff + " ms: responses: " + Util.printPingData(rsps));
                }
                return rsps;
            }
            case 6: 
            case 15: {
                this.view = (View)evt.getArg();
                Vector<Address> tmp = this.view.getMembers();
                if (tmp != null) {
                    Vector<Address> vector = this.members;
                    synchronized (vector) {
                        this.members.clear();
                        this.members.addAll(tmp);
                    }
                }
                return this.down_prot.down(evt);
            }
            case 16: {
                this.down_prot.down(evt);
                this.is_server = true;
                return null;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                return this.down_prot.down(evt);
            }
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                this.group_addr = (String)evt.getArg();
                Object ret = this.down_prot.down(evt);
                this.handleConnect();
                return ret;
            }
            case 4: {
                this.handleDisconnect();
                return this.down_prot.down(evt);
            }
        }
        return this.down_prot.down(evt);
    }

    protected final View makeView(Vector<Address> mbrs) {
        return new View(new ViewId(this.local_addr), mbrs);
    }

    private void sendDiscoveryResponse(Address logical_addr, List<PhysicalAddress> physical_addrs, Address coord, boolean is_server, String logical_name, Address sender) {
        PingData ping_rsp = new PingData(logical_addr, this.view, is_server, logical_name, physical_addrs);
        Message rsp_msg = new Message(sender, null, null);
        rsp_msg.setFlag((byte)1);
        PingHeader rsp_hdr = new PingHeader(2, ping_rsp);
        rsp_msg.putHeader(this.getName(), rsp_hdr);
        if (this.log.isTraceEnabled()) {
            this.log.trace("received GET_MBRS_REQ from " + sender + ", sending response " + rsp_hdr);
        }
        this.down_prot.down(new Event(1, rsp_msg));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Responses {
        final Promise<JoinRsp> promise;
        final List<PingData> ping_rsps = new LinkedList<PingData>();
        final int num_expected_rsps;
        final int num_expected_srv_rsps;
        final boolean break_on_coord_rsp;

        public Responses(int num_expected_rsps, int num_expected_srv_rsps, boolean break_on_coord_rsp, Promise<JoinRsp> promise) {
            this.num_expected_rsps = num_expected_rsps;
            this.num_expected_srv_rsps = num_expected_srv_rsps;
            this.break_on_coord_rsp = break_on_coord_rsp;
            this.promise = promise != null ? promise : new Promise();
        }

        public void addResponse(PingData rsp) {
            this.addResponse(rsp, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addResponse(PingData rsp, boolean overwrite) {
            if (rsp == null) {
                return;
            }
            this.promise.getLock().lock();
            try {
                if (!this.ping_rsps.contains(rsp) || overwrite) {
                    this.ping_rsps.add(rsp);
                    this.promise.getCond().signalAll();
                }
            }
            finally {
                this.promise.getLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<PingData> get(long timeout) throws InterruptedException {
            long start_time = System.currentTimeMillis();
            long time_to_wait = timeout;
            this.promise.getLock().lock();
            try {
                while (time_to_wait > 0L && !this.promise.hasResult()) {
                    if (this.num_expected_srv_rsps > 0) {
                        int received_srv_rsps = Responses.getNumServerResponses(this.ping_rsps);
                        if (received_srv_rsps >= this.num_expected_srv_rsps) {
                            LinkedList<PingData> linkedList = new LinkedList<PingData>(this.ping_rsps);
                            return linkedList;
                        }
                    } else if (this.ping_rsps.size() >= this.num_expected_rsps) {
                        LinkedList<PingData> linkedList = new LinkedList<PingData>(this.ping_rsps);
                        return linkedList;
                    }
                    if (this.break_on_coord_rsp && Responses.containsCoordinatorResponse(this.ping_rsps)) {
                        LinkedList<PingData> linkedList = new LinkedList<PingData>(this.ping_rsps);
                        return linkedList;
                    }
                    this.promise.getCond().await(time_to_wait, TimeUnit.MILLISECONDS);
                    time_to_wait = timeout - (System.currentTimeMillis() - start_time);
                }
                LinkedList<PingData> linkedList = new LinkedList<PingData>(this.ping_rsps);
                return linkedList;
            }
            finally {
                this.promise.getLock().unlock();
            }
        }

        private static int getNumServerResponses(List<PingData> rsps) {
            int cnt = 0;
            for (PingData rsp : rsps) {
                if (!rsp.isServer()) continue;
                ++cnt;
            }
            return cnt;
        }

        private static boolean containsCoordinatorResponse(List<PingData> rsps) {
            if (rsps == null || rsps.isEmpty()) {
                return false;
            }
            for (PingData rsp : rsps) {
                if (!rsp.isCoord()) continue;
                return true;
            }
            return false;
        }
    }

    class PingSenderTask {
        private Future<?> senderFuture;

        public synchronized void start(final String cluster_name, final Promise promise) {
            long delay = (long)((double)Discovery.this.timeout / (double)Discovery.this.num_ping_requests);
            if (this.senderFuture == null || this.senderFuture.isDone()) {
                this.senderFuture = Discovery.this.timer.scheduleWithFixedDelay(new Runnable(){

                    public void run() {
                        block4: {
                            try {
                                Discovery.this.sendGetMembersRequest(cluster_name, promise);
                            }
                            catch (InterruptedIOException ie) {
                                if (Discovery.this.log.isWarnEnabled()) {
                                    Discovery.this.log.warn("Discovery request for cluster " + cluster_name + " interrupted");
                                }
                                Thread.currentThread().interrupt();
                            }
                            catch (Exception ex) {
                                if (!Discovery.this.log.isErrorEnabled()) break block4;
                                Discovery.this.log.error("failed sending discovery request", ex);
                            }
                        }
                    }
                }, 0L, delay, TimeUnit.MILLISECONDS);
            }
        }

        public synchronized void stop() {
            if (this.senderFuture != null) {
                this.senderFuture.cancel(true);
                this.senderFuture = null;
            }
        }
    }
}

