/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.DeprecatedProperty;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.StateTransferInfo;
import org.jgroups.util.Digest;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MBean(description="State transfer protocol based on byte array transfer")
@DeprecatedProperty(names={"use_flush", "flush_timeout"})
public class STATE_TRANSFER
extends Protocol {
    private static final String name = "STATE_TRANSFER";
    private long start;
    private long stop;
    private final AtomicInteger num_state_reqs = new AtomicInteger(0);
    private final AtomicLong num_bytes_sent = new AtomicLong(0L);
    private volatile double avg_state_size = 0.0;
    private Address local_addr = null;
    private final Vector<Address> members = new Vector();
    private final Map<String, Set<Address>> state_requesters = new HashMap<String, Set<Address>>();
    private boolean waiting_for_state_response = false;
    private boolean flushProtocolInStack = false;

    @Override
    public String getName() {
        return name;
    }

    @ManagedAttribute
    public int getNumberOfStateRequests() {
        return this.num_state_reqs.get();
    }

    @ManagedAttribute
    public long getNumberOfStateBytesSent() {
        return this.num_bytes_sent.get();
    }

    @ManagedAttribute
    public double getAverageStateSize() {
        return this.avg_state_size;
    }

    @Override
    public Vector<Integer> requiredDownServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(new Integer(39));
        retval.addElement(new Integer(41));
        return retval;
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_state_reqs.set(0);
        this.num_bytes_sent.set(0L);
        this.avg_state_size = 0.0;
    }

    @Override
    public void init() throws Exception {
    }

    @Override
    public void start() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("state_transfer", Boolean.TRUE);
        map.put("protocol_class", this.getClass().getName());
        this.up_prot.up(new Event(56, map));
    }

    @Override
    public void stop() {
        super.stop();
        this.waiting_for_state_response = false;
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                StateHeader hdr = (StateHeader)msg.getHeader(this.getName());
                if (hdr == null) break;
                switch (hdr.type) {
                    case 1: {
                        this.handleStateReq(hdr);
                        break;
                    }
                    case 2: {
                        this.handleStateRsp(hdr, msg.getBuffer());
                        break;
                    }
                    default: {
                        if (!this.log.isErrorEnabled()) break;
                        this.log.error("type " + hdr.type + " not known in StateHeader");
                    }
                }
                return null;
            }
            case 6: 
            case 15: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 56: {
                Map config = (Map)evt.getArg();
                if (config == null || !config.containsKey("state_transfer")) break;
                this.log.error("Protocol stack cannot contain two state transfer protocols. Remove either one of them");
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 19: {
                Address target;
                StateTransferInfo info = (StateTransferInfo)evt.getArg();
                if (info.target == null) {
                    target = this.determineCoordinator();
                } else {
                    target = info.target;
                    if (target.equals(this.local_addr)) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error("GET_STATE: cannot fetch state from myself !");
                        }
                        target = null;
                    }
                }
                if (target == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("GET_STATE: first member (no state)");
                    }
                    this.up_prot.up(new Event(20, new StateTransferInfo()));
                } else {
                    Message state_req = new Message(target, null, null);
                    state_req.putHeader(this.getName(), new StateHeader(1, this.local_addr, System.currentTimeMillis(), null, info.state_id));
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("GET_STATE: asking " + target + " for state");
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("passing down a SUSPEND_STABLE event");
                    }
                    this.down_prot.down(new Event(65, new Long(info.timeout)));
                    this.waiting_for_state_response = true;
                    this.start = System.currentTimeMillis();
                    this.down_prot.down(new Event(1, state_req));
                }
                return null;
            }
            case 56: {
                Map config = (Map)evt.getArg();
                if (config == null || !config.containsKey("flush_supported")) break;
                this.flushProtocolInStack = true;
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    private boolean isDigestNeeded() {
        return !this.flushProtocolInStack;
    }

    private void requestApplicationStates(Address requester, Digest digest, boolean open_barrier) {
        HashSet<String> appl_ids = new HashSet<String>(this.state_requesters.keySet());
        LinkedList<StateTransferInfo> responses = new LinkedList<StateTransferInfo>();
        for (String id : appl_ids) {
            StateTransferInfo info = new StateTransferInfo(requester, id, 0L, null);
            StateTransferInfo rsp = (StateTransferInfo)this.up_prot.up(new Event(17, info));
            responses.add(rsp);
        }
        if (open_barrier) {
            this.down_prot.down(new Event(77));
        }
        for (StateTransferInfo rsp : responses) {
            this.sendApplicationStateResponse(rsp, digest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendApplicationStateResponse(StateTransferInfo rsp, Digest digest) {
        byte[] state = rsp.state;
        String id = rsp.state_id;
        LinkedList<Message> responses = null;
        Map<String, Set<Address>> map = this.state_requesters;
        synchronized (map) {
            Set<Address> requesters;
            if (this.state_requesters.isEmpty()) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn("GET_APPLSTATE_OK: received application state, but there are no requesters !");
                }
                return;
            }
            if (this.stats) {
                this.num_state_reqs.incrementAndGet();
                if (state != null) {
                    this.num_bytes_sent.addAndGet(state.length);
                }
                this.avg_state_size = this.num_bytes_sent.doubleValue() / this.num_state_reqs.doubleValue();
            }
            if ((requesters = this.state_requesters.get(id)) == null || requesters.isEmpty()) {
                this.log.warn("received state for id=" + id + ", but there are no requesters for this ID");
            } else {
                responses = new LinkedList<Message>();
                for (Address requester : requesters) {
                    Message state_rsp = new Message(requester, null, state);
                    StateHeader hdr = new StateHeader(2, this.local_addr, 0L, digest, id);
                    state_rsp.putHeader(this.getName(), hdr);
                    responses.add(state_rsp);
                }
                this.state_requesters.remove(id);
            }
        }
        if (responses != null && !responses.isEmpty()) {
            for (Message state_rsp : responses) {
                if (this.log.isTraceEnabled()) {
                    int length = state != null ? state.length : 0;
                    this.log.trace("sending state for ID=" + id + " to " + state_rsp.getDest() + " (" + length + " bytes)");
                }
                this.down_prot.down(new Event(1, state_rsp));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Address determineCoordinator() {
        Vector<Address> vector = this.members;
        synchronized (vector) {
            for (Address member : this.members) {
                if (this.local_addr.equals(member)) continue;
                return member;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleViewChange(View v) {
        Address old_coord;
        Vector<Address> new_members = v.getMembers();
        boolean send_up_null_state_rsp = false;
        Vector<Address> vector = this.members;
        synchronized (vector) {
            old_coord = !this.members.isEmpty() ? this.members.firstElement() : null;
            this.members.clear();
            this.members.addAll(new_members);
            if (this.waiting_for_state_response && old_coord != null && !this.members.contains(old_coord)) {
                send_up_null_state_rsp = true;
            }
        }
        if (send_up_null_state_rsp) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("discovered that the state provider (" + old_coord + ") crashed; will return null state to application");
            }
            StateHeader hdr = new StateHeader(2, this.local_addr, 0L, null, null);
            this.handleStateRsp(hdr, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStateReq(StateHeader hdr) {
        Address sender = hdr.sender;
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("sender is null !");
            }
            return;
        }
        String id = hdr.state_id;
        Map<String, Set<Address>> map = this.state_requesters;
        synchronized (map) {
            block14: {
                boolean empty = this.state_requesters.isEmpty();
                Set<Address> requesters = this.state_requesters.get(id);
                if (requesters == null) {
                    requesters = new HashSet<Address>();
                    this.state_requesters.put(id, requesters);
                }
                requesters.add(sender);
                if (!this.isDigestNeeded()) {
                    this.requestApplicationStates(sender, null, false);
                } else if (empty) {
                    if (!this.flushProtocolInStack) {
                        this.down_prot.down(new Event(76));
                    }
                    Digest digest = (Digest)this.down_prot.down(new Event(39));
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("digest is " + digest + ", getting application state");
                    }
                    try {
                        this.requestApplicationStates(sender, digest, !this.flushProtocolInStack);
                    }
                    catch (Throwable t) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error("failed getting state from application", t);
                        }
                        if (this.flushProtocolInStack) break block14;
                        this.down_prot.down(new Event(77));
                    }
                }
            }
        }
    }

    void handleStateRsp(StateHeader hdr, byte[] state) {
        Address sender = hdr.sender;
        Digest tmp_digest = hdr.my_digest;
        String id = hdr.state_id;
        Address state_sender = hdr.sender;
        this.waiting_for_state_response = false;
        if (this.isDigestNeeded()) {
            if (tmp_digest == null) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn("digest received from " + sender + " is null, skipping setting digest !");
                }
            } else {
                this.down_prot.down(new Event(41, tmp_digest));
            }
        }
        this.stop = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug("passing down a RESUME_STABLE event");
        }
        this.down_prot.down(new Event(66));
        if (state == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("state received from " + sender + " is null, will return null state to application");
            }
        } else {
            this.log.debug("received state, size=" + state.length + " bytes. Time=" + (this.stop - this.start) + " milliseconds");
        }
        StateTransferInfo info = new StateTransferInfo(state_sender, id, 0L, state);
        this.up_prot.up(new Event(20, info));
    }

    public static class StateHeader
    extends Header
    implements Streamable {
        public static final byte STATE_REQ = 1;
        public static final byte STATE_RSP = 2;
        long id = 0L;
        byte type = 0;
        Address sender;
        Digest my_digest = null;
        String state_id = null;
        private static final long serialVersionUID = 4457830093491204405L;

        public StateHeader() {
        }

        public StateHeader(byte type, Address sender, long id, Digest digest) {
            this.type = type;
            this.sender = sender;
            this.id = id;
            this.my_digest = digest;
        }

        public StateHeader(byte type, Address sender, long id, Digest digest, String state_id) {
            this.type = type;
            this.sender = sender;
            this.id = id;
            this.my_digest = digest;
            this.state_id = state_id;
        }

        public int getType() {
            return this.type;
        }

        public Digest getDigest() {
            return this.my_digest;
        }

        public String getStateId() {
            return this.state_id;
        }

        public boolean equals(Object o) {
            if (this.sender != null && o != null) {
                if (!(o instanceof StateHeader)) {
                    return false;
                }
                StateHeader other = (StateHeader)o;
                return this.sender.equals(other.sender) && this.id == other.id;
            }
            return false;
        }

        public int hashCode() {
            if (this.sender != null) {
                return this.sender.hashCode() + (int)this.id;
            }
            return (int)this.id;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("type=").append(StateHeader.type2Str(this.type));
            if (this.sender != null) {
                sb.append(", sender=").append(this.sender).append(" id=").append(this.id);
            }
            if (this.my_digest != null) {
                sb.append(", digest=").append(this.my_digest);
            }
            if (this.state_id != null) {
                sb.append(", state_id=").append(this.state_id);
            }
            return sb.toString();
        }

        static String type2Str(int t) {
            switch (t) {
                case 1: {
                    return "STATE_REQ";
                }
                case 2: {
                    return "STATE_RSP";
                }
            }
            return "<unknown>";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.sender);
            out.writeLong(this.id);
            out.writeByte(this.type);
            out.writeObject(this.my_digest);
            if (this.state_id == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(this.state_id);
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.sender = (Address)in.readObject();
            this.id = in.readLong();
            this.type = in.readByte();
            this.my_digest = (Digest)in.readObject();
            if (in.readBoolean()) {
                this.state_id = in.readUTF();
            }
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.id);
            Util.writeAddress(this.sender, out);
            Util.writeStreamable(this.my_digest, out);
            Util.writeString(this.state_id, out);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            this.id = in.readLong();
            this.sender = Util.readAddress(in);
            this.my_digest = (Digest)Util.readStreamable(Digest.class, in);
            this.state_id = Util.readString(in);
        }

        public int size() {
            int retval = 9;
            retval += Util.size(this.sender);
            ++retval;
            if (this.my_digest != null) {
                retval = (int)((long)retval + this.my_digest.serializedSize());
            }
            ++retval;
            if (this.state_id != null) {
                retval += this.state_id.length() + 2;
            }
            return retval;
        }
    }
}

