/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.stack.GossipRouter;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GossipData
implements Streamable {
    byte type = 0;
    String group = null;
    Address addr = null;
    List<Address> mbrs = null;

    public GossipData() {
    }

    public GossipData(byte type) {
        this.type = type;
    }

    public GossipData(byte type, String group, Address addr, List<Address> mbrs) {
        this.type = type;
        this.group = group;
        this.addr = addr;
        this.mbrs = mbrs;
    }

    public byte getType() {
        return this.type;
    }

    public String getGroup() {
        return this.group;
    }

    public Address getAddress() {
        return this.addr;
    }

    public List<Address> getMembers() {
        return this.mbrs;
    }

    public void setMembers(List<Address> mbrs) {
        this.mbrs = mbrs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GossipRouter.type2String(this.type)).append("(").append("group=").append(this.group).append(", addr=").append(this.addr);
        sb.append(", mbrs=").append(this.mbrs);
        return sb.toString();
    }

    @Override
    public void writeTo(DataOutputStream out) throws IOException {
        out.writeByte(this.type);
        Util.writeString(this.group, out);
        Util.writeAddress(this.addr, out);
        Util.writeAddresses(this.mbrs, out);
    }

    @Override
    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        this.type = in.readByte();
        this.group = Util.readString(in);
        this.addr = Util.readAddress(in);
        this.mbrs = (List)Util.readAddresses(in, LinkedList.class);
    }
}

