/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jgroups.Event;
import org.jgroups.annotations.DeprecatedProperty;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.TP;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.ThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DeprecatedProperty(names={"down_thread", "down_thread_prio", "up_thread", "up_thread_prio"})
public abstract class Protocol {
    protected Protocol up_prot = null;
    protected Protocol down_prot = null;
    protected ProtocolStack stack = null;
    @Property(description="Determines whether to collect statistics (and expose them via JMX). Default is true")
    protected boolean stats = true;
    protected final Log log = LogFactory.getLog(this.getClass());

    @ManagedAttribute(name="level", description="Sets the logger level (see javadocs)")
    public void setLevel(String level) {
        this.log.setLevel(level);
    }

    @ManagedAttribute(name="level", writable=true)
    public String getLevel() {
        return this.log.getLevel();
    }

    protected boolean setProperties(Properties props) {
        throw new UnsupportedOperationException("deprecated; use a setter instead");
    }

    public void setProperty(String key, String val) {
        throw new UnsupportedOperationException("deprecated; use a setter instead");
    }

    public boolean setPropertiesInternal(Properties props) {
        throw new UnsupportedOperationException("use a setter instead");
    }

    public Properties getProperties() {
        if (this.log.isWarnEnabled()) {
            this.log.warn("deprecated feature: please use a setter instead");
        }
        return new Properties();
    }

    public ProtocolStack getProtocolStack() {
        return this.stack;
    }

    protected List<Object> getConfigurableObjects() {
        return null;
    }

    protected TP getTransport() {
        Protocol retval = this;
        while (retval != null && retval.down_prot != null) {
            retval = retval.down_prot;
        }
        return (TP)retval;
    }

    public ThreadFactory getThreadFactory() {
        return this.down_prot != null ? this.down_prot.getThreadFactory() : null;
    }

    public boolean upThreadEnabled() {
        return false;
    }

    public boolean downThreadEnabled() {
        return false;
    }

    public boolean statsEnabled() {
        return this.stats;
    }

    public void enableStats(boolean flag) {
        this.stats = flag;
    }

    public void resetStats() {
    }

    public String printStats() {
        return null;
    }

    public Map<String, Object> dumpStats() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Class<?> clazz = this.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Method[] methods;
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(ManagedAttribute.class)) continue;
                String attributeName = field.getName();
                try {
                    field.setAccessible(true);
                    Object value = field.get(this);
                    if (value != null) {
                        map.put(attributeName, value.toString());
                        continue;
                    }
                    map.put(attributeName, null);
                }
                catch (Exception e) {
                    this.log.warn("Could not retrieve value of attribute (field) " + attributeName, e);
                }
            }
            for (Method method : methods = this.getClass().getMethods()) {
                ManagedAttribute annotation;
                if (!method.isAnnotationPresent(ManagedAttribute.class) || (annotation = method.getAnnotation(ManagedAttribute.class)).writable() || !method.getName().startsWith("is") && !method.getName().startsWith("get")) continue;
                Object value = null;
                try {
                    value = method.invoke((Object)this, new Object[0]);
                    String attributeName = this.methodNameToAttributeName(method.getName());
                    if (value != null) {
                        map.put(attributeName, value.toString());
                        continue;
                    }
                    map.put(attributeName, null);
                }
                catch (Exception e) {
                    this.log.warn("Could not retrieve value of attribute (method) " + method.getName(), e);
                }
            }
        }
        return map;
    }

    private String methodNameToAttributeName(String methodName) {
        methodName = methodName.startsWith("get") || methodName.startsWith("set") ? methodName.substring(3) : methodName;
        methodName = methodName.startsWith("is") ? methodName.substring(2) : methodName;
        Pattern p = Pattern.compile("[A-Z]");
        Matcher m = p.matcher(methodName.substring(1));
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "_" + methodName.substring(m.end(), m.end() + 1).toLowerCase());
        }
        m.appendTail(sb);
        sb.insert(0, methodName.substring(0, 1).toLowerCase());
        return sb.toString();
    }

    public void init() throws Exception {
    }

    public void start() throws Exception {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public Vector<Integer> requiredUpServices() {
        return null;
    }

    public Vector<Integer> requiredDownServices() {
        return null;
    }

    public Vector<Integer> providedUpServices() {
        return null;
    }

    public Vector<Integer> providedDownServices() {
        return null;
    }

    public abstract String getName();

    public Protocol getUpProtocol() {
        return this.up_prot;
    }

    public Protocol getDownProtocol() {
        return this.down_prot;
    }

    public void setUpProtocol(Protocol up_prot) {
        this.up_prot = up_prot;
    }

    public void setDownProtocol(Protocol down_prot) {
        this.down_prot = down_prot;
    }

    public void setProtocolStack(ProtocolStack stack) {
        this.stack = stack;
    }

    public Object up(Event evt) {
        return this.up_prot.up(evt);
    }

    public Object down(Event evt) {
        return this.down_prot.down(evt);
    }
}

