/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.Property;
import org.jgroups.annotations.Unsupported;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.Protocol;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLSchemaGenerator {
    public static void main(String[] args) {
        String outputDir = "./";
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!"-o".equals(arg)) {
                System.out.println("XMLSchemaGenerator -o <path to newly created xsd schema file>");
                return;
            }
            outputDir = args[++i];
        }
        File f = new File(outputDir, "JGroups-2.8.xsd");
        try {
            FileWriter fw = new FileWriter(f, false);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation impl = builder.getDOMImplementation();
            Document xmldoc = impl.createDocument("http://www.w3.org/2001/XMLSchema", "xs:schema", null);
            xmldoc.getDocumentElement().setAttribute("targetNamespace", "urn:org:jgroups");
            xmldoc.getDocumentElement().setAttribute("elementFormDefault", "qualified");
            Element xsElement = xmldoc.createElement("xs:element");
            xsElement.setAttribute("name", "config");
            xmldoc.getDocumentElement().appendChild(xsElement);
            Element complexType = xmldoc.createElement("xs:complexType");
            xsElement.appendChild(complexType);
            Element allType = xmldoc.createElement("xs:choice");
            allType.setAttribute("maxOccurs", "unbounded");
            complexType.appendChild(allType);
            Set<Class<?>> classes = XMLSchemaGenerator.getClasses("org.jgroups.protocols", Protocol.class);
            for (Class<?> clazz : classes) {
                XMLSchemaGenerator.classToXML(xmldoc, allType, clazz, "");
            }
            classes = XMLSchemaGenerator.getClasses("org.jgroups.protocols.pbcast", Protocol.class);
            for (Class<?> clazz : classes) {
                XMLSchemaGenerator.classToXML(xmldoc, allType, clazz, "pbcast.");
            }
            DOMSource domSource = new DOMSource(xmldoc);
            StreamResult streamResult = new StreamResult(fw);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer serializer = tf.newTransformer();
            serializer.setOutputProperty("method", "xml");
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "1");
            serializer.transform(domSource, streamResult);
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Set<Class<?>> getClasses(String packageName, Class<?> assignableFrom) throws IOException, ClassNotFoundException {
        String filePath;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        HashSet classes = new HashSet();
        String path = packageName.replace('.', '/');
        URL resource = loader.getResource(path);
        if (resource != null && (filePath = resource.getFile()) != null && new File(filePath).isDirectory()) {
            for (String file : new File(filePath).list()) {
                String name;
                Class<?> clazz;
                if (!file.endsWith(".class") || !assignableFrom.isAssignableFrom(clazz = Class.forName(name = packageName + '.' + file.substring(0, file.indexOf(".class"))))) continue;
                classes.add(clazz);
            }
        }
        return classes;
    }

    private static void classToXML(Document xmldoc, Element parent, Class<?> clazz, String preAppendToSimpleClassName) throws Exception {
        boolean isConcreteClass = (clazz.getModifiers() & 0x400) == 0;
        boolean isExperimental = clazz.isAnnotationPresent(Experimental.class);
        boolean isUnsupported = clazz.isAnnotationPresent(Unsupported.class);
        if (isConcreteClass && !isExperimental && !isUnsupported) {
            parent.appendChild(XMLSchemaGenerator.createXMLTree(xmldoc, clazz, preAppendToSimpleClassName));
        }
    }

    private static Element createXMLTree(Document xmldoc, Class<?> clazz, String preAppendToSimpleClassName) throws Exception {
        Method[] methods;
        Element classElement = xmldoc.createElement("xs:element");
        classElement.setAttribute("name", preAppendToSimpleClassName + clazz.getSimpleName());
        Element complexType = xmldoc.createElement("xs:complexType");
        classElement.appendChild(complexType);
        for (Class<?> clazzInLoop = clazz; clazzInLoop != null; clazzInLoop = clazzInLoop.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazzInLoop.getDeclaredFields()) {
                boolean annotationRedefinesName;
                if (!field.isAnnotationPresent(Property.class)) continue;
                String property = field.getName();
                Property annotation = field.getAnnotation(Property.class);
                boolean bl = annotationRedefinesName = annotation.name().length() > 0;
                if (annotationRedefinesName) {
                    property = annotation.name();
                }
                Element attributeElement = xmldoc.createElement("xs:attribute");
                attributeElement.setAttribute("name", property);
                attributeElement.setAttribute("type", "xs:string");
                complexType.appendChild(attributeElement);
                Element annotationElement = xmldoc.createElement("xs:annotation");
                attributeElement.appendChild(annotationElement);
                Element documentationElement = xmldoc.createElement("xs:documentation");
                documentationElement.setTextContent(annotation.description());
                annotationElement.appendChild(documentationElement);
            }
        }
        for (Method method : methods = clazz.getMethods()) {
            if (!method.isAnnotationPresent(Property.class) || !method.getName().startsWith("set")) continue;
            Property annotation = method.getAnnotation(Property.class);
            String name = annotation.name();
            if (name.length() < 1) {
                name = Configurator.renameFromJavaCodingConvention(method.getName().substring(3));
            }
            Element attributeElement = xmldoc.createElement("xs:attribute");
            attributeElement.setAttribute("name", name);
            attributeElement.setAttribute("type", "xs:string");
            complexType.appendChild(attributeElement);
            String desc = annotation.description();
            if (desc.length() <= 0) continue;
            Element annotationElement = xmldoc.createElement("xs:annotation");
            attributeElement.appendChild(annotationElement);
            Element documentationElement = xmldoc.createElement("xs:documentation");
            documentationElement.setTextContent(annotation.description());
            annotationElement.appendChild(documentationElement);
        }
        return classElement;
    }

    private static String fieldToXMLSchemaAttributeType(Field f) {
        Class<?> propertyFieldType = f.getType();
        if (Boolean.TYPE.equals(propertyFieldType)) {
            return "xs:boolean";
        }
        if (Integer.TYPE.equals(propertyFieldType)) {
            return "xs:integer";
        }
        if (Long.TYPE.equals(propertyFieldType)) {
            return "xs:long";
        }
        if (Byte.TYPE.equals(propertyFieldType)) {
            return "xs:byte";
        }
        if (Double.TYPE.equals(propertyFieldType)) {
            return "xs:double";
        }
        if (Short.TYPE.equals(propertyFieldType)) {
            return "xs:short";
        }
        if (Float.TYPE.equals(propertyFieldType)) {
            return "xs:float";
        }
        return "xs:string";
    }
}

