/*
 * Decompiled with CFR 0.152.
 */
package marquee.xmlrpc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import marquee.xmlrpc.XmlRpcCallback;
import marquee.xmlrpc.XmlRpcClientConnection;
import marquee.xmlrpc.XmlRpcClientConnectionFactory;
import marquee.xmlrpc.XmlRpcException;
import marquee.xmlrpc.XmlRpcInvocationHandler;
import marquee.xmlrpc.XmlRpcParser;
import marquee.xmlrpc.XmlRpcSerializer;
import marquee.xmlrpc.connections.SocketConnectionFactory;
import marquee.xmlrpc.connections.URLConnectionFactory;
import marquee.xmlrpc.util.Log;
import marquee.xmlrpc.util.ServerInputStream;
import marquee.xmlrpc.util.Trace;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class XmlRpcClient
extends XmlRpcParser
implements XmlRpcInvocationHandler {
    private XmlRpcClientConnectionFactory connectionFactory;
    private XmlRpcClientConnection connection;
    private BufferedInputStream input;
    private BufferedOutputStream output;
    private Object returnValue;
    private StringBuffer xmlBuffer = new StringBuffer(2048);
    private boolean keepAlive;
    private boolean zipStream;
    private boolean isFaultResponse;

    public XmlRpcClient(String host, int port, String path) {
        this.connectionFactory = new SocketConnectionFactory(host, port, path);
    }

    public XmlRpcClient(URL url) {
        this.connectionFactory = new URLConnectionFactory(url);
    }

    public boolean isFaultResponse() {
        return this.isFaultResponse;
    }

    public synchronized Object invoke(String method, Collection arguments) throws XmlRpcException {
        this.beginCall(method);
        if (arguments != null) {
            Iterator argIter = arguments.iterator();
            while (argIter.hasNext()) {
                this.xmlBuffer.append("<param>");
                XmlRpcSerializer.serialize(argIter.next(), this.xmlBuffer);
                this.xmlBuffer.append("</param>");
            }
        }
        return this.endCall();
    }

    public synchronized Object invoke(String method, Object[] arguments) throws XmlRpcException {
        this.beginCall(method);
        if (arguments != null) {
            for (int i = 0; i < arguments.length; ++i) {
                this.xmlBuffer.append("<param>");
                XmlRpcSerializer.serialize(arguments[i], this.xmlBuffer);
                this.xmlBuffer.append("</param>");
            }
        }
        return this.endCall();
    }

    public void invokeAsynchronously(final String method, final Object arguments, final XmlRpcCallback callback) {
        if (callback == null) {
            new Thread(){

                public void run() {
                    try {
                        if (arguments instanceof Object[]) {
                            XmlRpcClient.this.invoke(method, (Object[])arguments);
                        } else {
                            XmlRpcClient.this.invoke(method, (Collection)arguments);
                        }
                    }
                    catch (XmlRpcException xmlRpcException) {
                        // empty catch block
                    }
                }
            }.start();
        } else {
            new Thread(){

                public void run() {
                    try {
                        Object result = arguments instanceof Object[] ? XmlRpcClient.this.invoke(method, (Object[])arguments) : XmlRpcClient.this.invoke(method, (Collection)arguments);
                        if (XmlRpcClient.this.isFaultResponse()) {
                            Map fault = (Map)result;
                            callback.onFault((Integer)fault.get("faultCode"), (String)fault.get("faultString"));
                        } else {
                            callback.onResult(result);
                        }
                    }
                    catch (XmlRpcException e) {
                        callback.onException(e);
                    }
                }
            }.start();
        }
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setZipStream(boolean zipStream) {
        this.zipStream = zipStream;
    }

    private void beginCall(String method) {
        this.xmlBuffer.setLength(0);
        this.xmlBuffer.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>").append("<methodCall><methodName>").append(method).append("</methodName><params>");
        this.isFaultResponse = false;
    }

    private Object endCall() throws XmlRpcException {
        this.xmlBuffer.append("</params>").append("</methodCall>");
        if (Trace.Debugs) {
            Log.append(Trace.Debug, "Call: ".concat(String.valueOf(String.valueOf(this.xmlBuffer))));
        }
        try {
            GZIPOutputStream zippedStream = null;
            ByteArrayOutputStream byteStream = null;
            if (this.connection == null) {
                this.connection = this.connectionFactory.createConnection();
            }
            if (this.zipStream) {
                byteStream = new ByteArrayOutputStream();
                zippedStream = new GZIPOutputStream(byteStream);
                zippedStream.write(this.xmlBuffer.toString().getBytes());
                zippedStream.finish();
                ((FilterOutputStream)zippedStream).flush();
            }
            this.connection.setOutputContentLength(this.zipStream ? byteStream.size() : this.xmlBuffer.length());
            this.connection.setKeepAlive(this.keepAlive);
            this.connection.setGzip(this.zipStream);
            OutputStream os = this.connection.getOutputStream();
            BufferedOutputStream bufferedOutputStream = this.output = os instanceof BufferedOutputStream ? (BufferedOutputStream)os : new BufferedOutputStream(os);
            if (this.zipStream) {
                this.output.write(byteStream.toByteArray());
            } else {
                this.output.write(this.xmlBuffer.toString().getBytes());
                this.output.flush();
            }
            InputStream is = this.connection.getInputStream();
            this.input = is instanceof BufferedInputStream ? (BufferedInputStream)is : new BufferedInputStream(is);
            this.handleResponse(this.input);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new XmlRpcException(ioe.getMessage());
        }
        return this.returnValue;
    }

    private void handleResponse(InputStream input) throws IOException {
        int contentLength = this.connection.getInputContentLength();
        boolean serverKeepAlive = this.connection.isServerKeepAlive();
        boolean serverStreamZipped = this.connection.isInputGzipped();
        try {
            this.parse(serverStreamZipped ? new GZIPInputStream(new ServerInputStream(input, contentLength)) : new ServerInputStream(input, contentLength));
        }
        catch (Exception e) {
            throw new IOException("The XML-RPC response could not be parsed: ".concat(String.valueOf(String.valueOf(e.toString()))));
        }
        if (!serverKeepAlive || !this.keepAlive) {
            this.connection.close();
            this.connection = null;
        }
    }

    public void startElement(String name, AttributeList attributes) throws SAXException {
        if (name.equals("fault")) {
            this.isFaultResponse = true;
        } else {
            super.startElement(name, attributes);
        }
    }

    protected void handleParsedValue(Object value) {
        this.returnValue = value;
    }
}

