/*
 * Decompiled with CFR 0.152.
 */
package marquee.xmlrpc;

import java.io.InputStream;
import java.util.Stack;
import marquee.xmlrpc.XmlRpcValue;
import marquee.xmlrpc.util.Log;
import marquee.xmlrpc.util.Trace;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public abstract class XmlRpcParser
implements DocumentHandler {
    public static final int VALUE = 111972721;
    public static final int STRING = -891985903;
    public static final int I4 = 3307;
    public static final int INT = 104431;
    public static final int BOOLEAN = 64711720;
    public static final int DOUBLE = -1325958191;
    public static final int DATE = -586971087;
    public static final int BASE64 = -1396204209;
    public static final int STRUCT = -891974699;
    public static final int ARRAY = 93090393;
    public static final int MEMBER = -1077769574;
    public static final int NAME = 3373707;
    private Stack values = new Stack();
    private XmlRpcValue currentValue;
    private boolean shallProcessCharData;
    private StringBuffer charData = new StringBuffer(128);
    private static Class driver;
    private static Stack parsers;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setDriver(String driverName) {
        if (driverName == null) throw new IllegalArgumentException("SAX driver name is null.");
        try {
            driver = Class.forName(driverName);
            if (!Trace.Debugs) return;
            Log.append(Trace.Debug, "Using SAX Driver: ".concat(String.valueOf(String.valueOf(driverName))));
            return;
        }
        catch (ClassNotFoundException cnfe) {
            if (!Trace.Errors) throw new IllegalArgumentException("Invalid SAX driver set.");
            Log.append(Trace.Error, "Invalid SAX Driver set.");
            throw new IllegalArgumentException("Invalid SAX driver set.");
        }
    }

    public static void setDriver(Class _driver) {
        if (_driver == null) {
            if (Trace.Errors) {
                Log.append(Trace.Error, "Invalid SAX Driver set.");
            }
            throw new IllegalArgumentException("Invalid SAX driver set.");
        }
        driver = _driver;
    }

    protected abstract void handleParsedValue(Object var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(InputStream is) throws Exception {
        Parser parser;
        block11: {
            parser = null;
            Stack stack = parsers;
            synchronized (stack) {
                if (parsers.empty()) {
                    if (driver == null) {
                        this.setDefaultDriver();
                    }
                    if (Trace.Debugs) {
                        Log.append(Trace.Debug, "Instantiating new SAX parser.");
                    }
                    parser = (Parser)driver.newInstance();
                } else {
                    if (Trace.Debugs) {
                        Log.append(Trace.Debug, "Acquiring pooled SAX parser.");
                    }
                    parser = (Parser)parsers.pop();
                }
            }
            parser.setDocumentHandler(this);
            try {
                parser.parse(new InputSource(is));
                Object var5_4 = null;
                if (!Trace.Debugs) break block11;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (Trace.Debugs) {
                    Log.append(Trace.Debug, String.valueOf(String.valueOf(new StringBuffer("Returning SAX parser to pool. Pool size is ").append(parsers.size() + 1))));
                }
                parsers.push(parser);
                throw throwable;
            }
            Log.append(Trace.Debug, String.valueOf(String.valueOf(new StringBuffer("Returning SAX parser to pool. Pool size is ").append(parsers.size() + 1))));
        }
        parsers.push(parser);
    }

    public void startElement(String name, AttributeList attributes) throws SAXException {
        int element = XmlRpcParser.hashCode(name);
        if (Trace.Elements) {
            Log.append(Trace.Element, "Beginning: ".concat(String.valueOf(String.valueOf(name))));
        }
        switch (element) {
            case 111972721: {
                if (this.currentValue != null) {
                    this.values.push(this.currentValue);
                }
                this.currentValue = new XmlRpcValue();
                this.shallProcessCharData = true;
                break;
            }
            case -1396204209: 
            case -1325958191: 
            case -891985903: 
            case -891974699: 
            case -586971087: 
            case 3307: 
            case 104431: 
            case 64711720: 
            case 93090393: {
                this.currentValue.setType(element);
            }
            case 3373707: {
                this.shallProcessCharData = true;
            }
        }
    }

    public void endElement(String name) throws SAXException {
        if (Trace.Elements) {
            Log.append(Trace.Element, "Ending: ".concat(String.valueOf(String.valueOf(name))));
        }
        if (this.currentValue != null && this.shallProcessCharData) {
            this.currentValue.processCharacterData(this.consumeCharData());
        } else {
            this.charData.setLength(0);
        }
        switch (XmlRpcParser.hashCode(name)) {
            case 111972721: {
                int depth = this.values.size();
                if (depth == 0) {
                    this.handleParsedValue(this.currentValue.value);
                    this.currentValue = null;
                    break;
                }
                if (this.values.elementAt(depth - 1).hashCode() == -891974699) break;
                XmlRpcValue v = this.currentValue;
                this.currentValue = (XmlRpcValue)this.values.pop();
                this.currentValue.addChildValue(v);
                break;
            }
            case -1077769574: {
                XmlRpcValue v = this.currentValue;
                this.currentValue = (XmlRpcValue)this.values.pop();
                this.currentValue.addChildValue(v);
                break;
            }
        }
    }

    public void characters(char[] data, int start, int length) {
        this.charData.append(data, start, length);
    }

    protected String consumeCharData() {
        String data = this.charData.toString().trim();
        this.charData.setLength(0);
        this.shallProcessCharData = false;
        return data;
    }

    private void setDefaultDriver() throws Exception {
        try {
            driver = Class.forName(System.getProperty("marquee.xmlrpc.saxdriver", "uk.co.wilson.xml.MinML"));
        }
        catch (ClassNotFoundException e) {
            throw new Exception("Could not set default SAX driver.");
        }
    }

    private static int hashCode(String string) {
        int hash = 0;
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            hash = 31 * hash + string.charAt(i);
        }
        return hash;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() {
    }

    public void endDocument() throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    static {
        VALUE = 111972721;
        STRING = -891985903;
        I4 = 3307;
        INT = 104431;
        BOOLEAN = 64711720;
        DOUBLE = -1325958191;
        DATE = -586971087;
        BASE64 = -1396204209;
        STRUCT = -891974699;
        ARRAY = 93090393;
        MEMBER = -1077769574;
        NAME = 3373707;
        parsers = new Stack();
    }
}

