/*
 * Decompiled with CFR 0.152.
 */
package marquee.xmlrpc.connections;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import marquee.xmlrpc.XmlRpcClientConnection;
import marquee.xmlrpc.XmlRpcClientConnectionFactory;
import marquee.xmlrpc.XmlRpcServerConnection;
import marquee.xmlrpc.util.Log;
import marquee.xmlrpc.util.Trace;

public class SocketConnectionFactory
implements XmlRpcClientConnectionFactory {
    private final String host;
    private final int port;
    private final String path;

    public SocketConnectionFactory(String host, int port, String path) {
        this.host = host;
        this.port = port;
        this.path = path;
    }

    public XmlRpcClientConnection createConnection() throws IOException {
        return new SocketConnectionImpl();
    }

    private class SocketConnectionImpl
    implements XmlRpcClientConnection {
        private Socket socket;
        private BufferedInputStream input;
        private BufferedOutputStream output;
        private boolean keepAlive;
        private boolean gzip;
        private boolean isFaultResponse;
        private int inputContentLength;
        private int outputContentLength;
        private boolean serverKeepAlive;
        private boolean serverStreamZipped;
        private StringBuffer httpBuffer = new StringBuffer(512);
        private byte[] responseBuffer = new byte[256];

        private SocketConnectionImpl() throws IOException {
            if (Trace.Debugs) {
                Log.append(Trace.Debug, "Creating socket.");
            }
            this.socket = new Socket(SocketConnectionFactory.this.host, SocketConnectionFactory.this.port);
            this.output = new BufferedOutputStream(this.socket.getOutputStream());
            this.input = new BufferedInputStream(this.socket.getInputStream());
        }

        public void setOutputContentLength(int contentLength) {
            this.outputContentLength = contentLength;
        }

        public void setKeepAlive(boolean keepAlive) {
            this.keepAlive = keepAlive;
        }

        public void setGzip(boolean gzip) {
            this.gzip = gzip;
        }

        public OutputStream getOutputStream() throws IOException {
            this.httpBuffer.setLength(0);
            this.httpBuffer.append("POST ").append(SocketConnectionFactory.this.path).append(" HTTP/1.0").append("\r\nUser-Agent: Marquee XML-RPC 1.2").append("\r\nHost: ").append(SocketConnectionFactory.this.host).append("\r\nContent-Type: text/xml").append(this.gzip ? "\r\nAccept-Encoding: gzip" : "").append(this.keepAlive ? "\r\nConnection: keep-alive" : "\r\nConnection: close").append("\r\nContent-Length: ").append(this.outputContentLength).append("\r\n\r\n");
            if (Trace.Debugs) {
                Log.append(Trace.Debug, "HTTP header:\n".concat(String.valueOf(String.valueOf(this.httpBuffer.toString()))));
            }
            this.output.write(this.httpBuffer.toString().getBytes());
            return this.output;
        }

        public InputStream getInputStream() throws IOException {
            String httpHeader = XmlRpcServerConnection.readHttpHeader(this.input, this.responseBuffer);
            if (httpHeader.indexOf("200") > -1) {
                while (!(httpHeader = XmlRpcServerConnection.readHttpHeader(this.input, this.responseBuffer)).equals("")) {
                    if (httpHeader.startsWith("connection")) {
                        this.serverKeepAlive = httpHeader.equals("connection: keep-alive");
                        continue;
                    }
                    if (httpHeader.startsWith("content-length")) {
                        this.inputContentLength = Integer.parseInt(httpHeader.substring(16));
                        continue;
                    }
                    if (!httpHeader.startsWith("content-encoding")) continue;
                    this.serverStreamZipped = httpHeader.equals("content-encoding: gzip");
                }
            } else {
                if (Trace.Errors) {
                    String line;
                    Log.append(Trace.Error, "Error from server: ".concat(String.valueOf(String.valueOf(httpHeader))));
                    BufferedReader reader = new BufferedReader(new InputStreamReader(this.input));
                    while ((line = reader.readLine()) != null) {
                        Log.append(Trace.Error, line);
                    }
                }
                throw new IOException("The server responded with an error: ".concat(String.valueOf(String.valueOf(httpHeader))));
            }
            return this.input;
        }

        public int getInputContentLength() {
            return this.inputContentLength;
        }

        public boolean isServerKeepAlive() {
            return this.serverKeepAlive;
        }

        public boolean isInputGzipped() {
            return this.serverStreamZipped;
        }

        public void close() throws IOException {
            this.socket.close();
            this.socket = null;
        }
    }
}

