/*
 * Decompiled with CFR 0.152.
 */
package marquee.xmlrpc.objectcomm;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import marquee.xmlrpc.XmlRpcCustomSerializer;
import marquee.xmlrpc.XmlRpcException;
import marquee.xmlrpc.XmlRpcSerializer;

public class Serializer
implements XmlRpcCustomSerializer {
    static final String OBJECT_TYPE = "#Type";
    private static Hashtable registries;
    private static boolean requireSerializeable;
    static Class class$java$util$LinkedList;
    static Class class$java$util$Hashtable;
    static Class class$java$lang$Short;
    static Class class$java$io$Serializable;
    static Class class$java$util$Map;
    static Class class$java$lang$Long;
    static Class class$java$util$Collection;
    static Class class$java$util$TreeSet;
    static Class class$java$lang$Object;
    static Class class$java$lang$Character;
    static Class class$java$lang$Byte;
    static Class class$java$util$TreeMap;
    static Class class$java$util$HashSet;
    static Class class$java$lang$Double;
    static Class class$java$lang$Integer;
    static Class class$java$util$ArrayList;
    static Class class$java$util$WeakHashMap;
    static Class class$java$util$Vector;
    static Class class$java$lang$Float;
    static Class class$java$lang$Boolean;
    static Class class$java$util$HashMap;

    public Class getSupportedClass() {
        Class clazz = requireSerializeable ? (class$java$io$Serializable == null ? (class$java$io$Serializable = Serializer.class$("java.io.Serializable")) : class$java$io$Serializable) : (class$java$lang$Object == null ? (class$java$lang$Object = Serializer.class$("java.lang.Object")) : class$java$lang$Object);
        return clazz;
    }

    public static void setRequireSerializeable(boolean requireSerializeable) {
        Serializer.requireSerializeable = requireSerializeable;
    }

    public void serialize(Object value, StringBuffer output) throws XmlRpcException {
        int hierarchyLevel = 0;
        ObjectRegistry reg = Serializer.getObjectRegistry();
        try {
            try {
                Constructor<?> constructor = value.getClass().getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException exc) {
                throw new XmlRpcException("No default constructor defined in object to be serialized: ".concat(String.valueOf(String.valueOf(value))));
            }
            boolean isAlreadySent = reg.objectRegistered(value);
            output.append("<struct>");
            output.append("<member><name>");
            output.append(OBJECT_TYPE);
            output.append("</name><value><string>");
            output.append(value.getClass().getName());
            output.append(",");
            output.append(reg.getObjectId(value));
            output.append("</string></value>");
            output.append("</member>");
            if (!isAlreadySent) {
                Class<?> cl = value.getClass();
                while (!cl.isAssignableFrom(class$java$lang$Object == null ? Serializer.class$("java.lang.Object") : class$java$lang$Object)) {
                    Field[] fields = cl.getDeclaredFields();
                    for (int i = 0; i < fields.length; ++i) {
                        Object fieldValue;
                        Field f = fields[i];
                        ((AccessibleObject)f).setAccessible(true);
                        if (Modifier.isTransient(f.getModifiers()) || Modifier.isFinal(f.getModifiers())) continue;
                        try {
                            fieldValue = fields[i].get(value);
                        }
                        catch (IllegalAccessException e) {
                            throw new XmlRpcException(String.valueOf(String.valueOf(new StringBuffer("Field ").append(f.getName()).append(" cannot be accessed by the object serializer."))));
                        }
                        if (fieldValue == null) continue;
                        output.append("<member><name>");
                        if (hierarchyLevel != 0) {
                            output.append(hierarchyLevel);
                            output.append(":");
                        }
                        output.append(f.getName());
                        output.append("</name>");
                        XmlRpcSerializer.serialize(fieldValue, output);
                        output.append("</member>");
                    }
                    cl = cl.getSuperclass();
                    ++hierarchyLevel;
                }
            }
            output.append("</struct>");
            Object var13_14 = null;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            Serializer.freeObjectRegistry(reg);
            throw throwable;
        }
        Serializer.freeObjectRegistry(reg);
    }

    static Object buildObject(Hashtable ht, Class expectedType) throws XmlRpcException {
        Object o;
        ObjectRegistry reg = Serializer.getObjectRegistry();
        try {
            block5: {
                try {
                    String className = (String)ht.remove(OBJECT_TYPE);
                    int oid = Integer.parseInt(className.substring(className.indexOf(",") + 1));
                    o = reg.getObject(oid);
                    if (o != null) break block5;
                    Class<?> cl = Class.forName(className = className.substring(0, className.indexOf(",")));
                    if (!expectedType.isAssignableFrom(cl)) {
                        throw new XmlRpcException(String.valueOf(String.valueOf(new StringBuffer("Field type does not match. Cannot convert ").append(cl.getName()).append(" into ").append(expectedType.getName()))));
                    }
                    Constructor<?> constructor = cl.getConstructor(new Class[0]);
                    ((AccessibleObject)constructor).setAccessible(true);
                    o = constructor.newInstance(new Object[0]);
                    reg.registerObject(o, oid);
                    Serializer.populateObject(ht, o);
                }
                catch (Exception e) {
                    throw new XmlRpcException(String.valueOf(String.valueOf(new StringBuffer("Unable to reconstruct object: ").append(e.getClass().getName()).append(": ").append(e.getMessage()))));
                }
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            Serializer.freeObjectRegistry(reg);
            throw throwable;
        }
        Serializer.freeObjectRegistry(reg);
        return o;
    }

    private static void populateObject(Hashtable ht, Object o) throws Exception {
        Field f;
        ArrayList<Class> hierarchy = new ArrayList<Class>();
        ArrayList<Field> definedFields = new ArrayList<Field>();
        Class cl = o.getClass();
        while (!cl.isAssignableFrom(class$java$lang$Object == null ? Serializer.class$("java.lang.Object") : class$java$lang$Object)) {
            hierarchy.add(cl);
            definedFields.addAll(Arrays.asList(cl.getDeclaredFields()));
            cl = cl.getSuperclass();
        }
        Iterator<Object> it = ht.keySet().iterator();
        while (it.hasNext()) {
            String fieldName;
            String key = (String)it.next();
            int pos = key.indexOf(":");
            if (pos < 0) {
                cl = (Class)hierarchy.get(0);
                fieldName = key;
            } else if (pos > 0 && pos < key.length() - 1) {
                cl = (Class)hierarchy.get(Integer.parseInt(key.substring(0, pos)));
                fieldName = key.substring(pos + 1);
            } else {
                throw new XmlRpcException("Invalid field name format: ".concat(String.valueOf(String.valueOf(key))));
            }
            f = cl.getDeclaredField(fieldName);
            ((AccessibleObject)f).setAccessible(true);
            definedFields.remove(f);
            if (Modifier.isTransient(f.getModifiers()) || Modifier.isFinal(f.getModifiers())) continue;
            Object value = ht.get(key);
            value = Serializer.checkType(f.getType(), value);
            f.set(o, value);
        }
        it = definedFields.iterator();
        while (it.hasNext()) {
            f = (Field)it.next();
            ((AccessibleObject)f).setAccessible(true);
            if (Modifier.isTransient(f.getModifiers()) || Modifier.isFinal(f.getModifiers())) continue;
            f.set(o, null);
        }
    }

    static Object checkType(Class expectedType, Object value) throws XmlRpcException {
        if (value instanceof Boolean && (Boolean.TYPE.isAssignableFrom(expectedType) || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Serializer.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(expectedType))) {
            return value;
        }
        if (value instanceof Integer) {
            if (Integer.TYPE.isAssignableFrom(expectedType) || (class$java$lang$Integer == null ? (class$java$lang$Integer = Serializer.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(expectedType)) {
                return value;
            }
            if (Byte.TYPE.isAssignableFrom(expectedType) || (class$java$lang$Byte == null ? (class$java$lang$Byte = Serializer.class$("java.lang.Byte")) : class$java$lang$Byte).isAssignableFrom(expectedType)) {
                return new Byte((byte)((Integer)value).intValue());
            }
            if (Long.TYPE.isAssignableFrom(expectedType) || (class$java$lang$Long == null ? (class$java$lang$Long = Serializer.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(expectedType)) {
                return new Long(((Integer)value).intValue());
            }
            if (Short.TYPE.isAssignableFrom(expectedType) || (class$java$lang$Short == null ? (class$java$lang$Short = Serializer.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(expectedType)) {
                return new Short((short)((Integer)value).intValue());
            }
        } else if (value instanceof Double) {
            if (Float.TYPE.isAssignableFrom(expectedType) || (class$java$lang$Float == null ? (class$java$lang$Float = Serializer.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(expectedType)) {
                Float tmp = new Float((Double)value);
                return tmp;
            }
            if (Double.TYPE.isAssignableFrom(expectedType) || (class$java$lang$Double == null ? (class$java$lang$Double = Serializer.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(expectedType)) {
                return value;
            }
        } else if (value instanceof String) {
            if (Character.TYPE.isAssignableFrom(expectedType) || (class$java$lang$Character == null ? (class$java$lang$Character = Serializer.class$("java.lang.Character")) : class$java$lang$Character).isAssignableFrom(expectedType)) {
                return new Character(((String)value).charAt(0));
            }
        } else if (value instanceof Hashtable) {
            if (Serializer.containsObject(value)) {
                return Serializer.buildObject((Hashtable)value, expectedType);
            }
            if ((class$java$util$Hashtable == null ? (class$java$util$Hashtable = Serializer.class$("java.util.Hashtable")) : class$java$util$Hashtable).isAssignableFrom(expectedType)) {
                Serializer.checkForContainedObjects((Map)value);
                return value;
            }
            if ((class$java$util$Map == null ? (class$java$util$Map = Serializer.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(expectedType)) {
                Serializer.checkForContainedObjects((Map)value);
                if (expectedType.isAssignableFrom(class$java$util$HashMap == null ? (class$java$util$HashMap = Serializer.class$("java.util.HashMap")) : class$java$util$HashMap)) {
                    return new HashMap((Map)value);
                }
                if (expectedType.isAssignableFrom(class$java$util$WeakHashMap == null ? (class$java$util$WeakHashMap = Serializer.class$("java.util.WeakHashMap")) : class$java$util$WeakHashMap)) {
                    return new WeakHashMap((Map)value);
                }
                if (expectedType.isAssignableFrom(class$java$util$TreeMap == null ? (class$java$util$TreeMap = Serializer.class$("java.util.TreeMap")) : class$java$util$TreeMap)) {
                    return new TreeMap((Map)value);
                }
            }
        } else if (value instanceof Vector) {
            if (expectedType.isAssignableFrom(class$java$util$Vector == null ? (class$java$util$Vector = Serializer.class$("java.util.Vector")) : class$java$util$Vector)) {
                Serializer.checkForContainedObjects((Vector)value);
                return value;
            }
            if ((class$java$util$Collection == null ? (class$java$util$Collection = Serializer.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(expectedType)) {
                Serializer.checkForContainedObjects((Vector)value);
                if (expectedType.isAssignableFrom(class$java$util$LinkedList == null ? (class$java$util$LinkedList = Serializer.class$("java.util.LinkedList")) : class$java$util$LinkedList)) {
                    return new LinkedList((Collection)value);
                }
                if (expectedType.isAssignableFrom(class$java$util$ArrayList == null ? (class$java$util$ArrayList = Serializer.class$("java.util.ArrayList")) : class$java$util$ArrayList)) {
                    return new ArrayList((Collection)value);
                }
                if (expectedType.isAssignableFrom(class$java$util$HashSet == null ? (class$java$util$HashSet = Serializer.class$("java.util.HashSet")) : class$java$util$HashSet)) {
                    return new HashSet((Collection)value);
                }
                if (expectedType.isAssignableFrom(class$java$util$TreeSet == null ? (class$java$util$TreeSet = Serializer.class$("java.util.TreeSet")) : class$java$util$TreeSet)) {
                    return new TreeSet((Collection)value);
                }
            } else if (expectedType.isArray()) {
                Vector v = (Vector)value;
                Object array = Array.newInstance(expectedType.getComponentType(), v.size());
                for (int i = 0; i < v.size(); ++i) {
                    Array.set(array, i, v.elementAt(i));
                }
                value = array;
            }
        }
        if (value == null || expectedType.isInstance(value)) {
            return value;
        }
        throw new XmlRpcException(String.valueOf(String.valueOf(new StringBuffer("Field type does not match. Cannot convert ").append(value.getClass().getName()).append(" into ").append(expectedType.getName()))));
    }

    private static void checkForContainedObjects(Map orig) throws XmlRpcException {
        HashMap m = new HashMap(orig);
        orig.clear();
        Iterator it = m.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object value = m.get(key);
            if (Serializer.containsObject(value)) {
                value = Serializer.buildObject((Hashtable)value, class$java$lang$Object == null ? Serializer.class$("java.lang.Object") : class$java$lang$Object);
            }
            orig.put(key, value);
        }
    }

    private static void checkForContainedObjects(List orig) throws XmlRpcException {
        ArrayList l = new ArrayList(orig);
        orig.clear();
        Iterator it = l.iterator();
        while (it.hasNext()) {
            Object value = it.next();
            if (Serializer.containsObject(value)) {
                value = Serializer.buildObject((Hashtable)value, class$java$lang$Object == null ? Serializer.class$("java.lang.Object") : class$java$lang$Object);
            }
            orig.add(value);
        }
    }

    static boolean containsObject(Object o) {
        return o instanceof Hashtable && ((Hashtable)o).containsKey(OBJECT_TYPE);
    }

    private static synchronized ObjectRegistry getObjectRegistry() {
        ObjectRegistry reg = (ObjectRegistry)registries.get(Thread.currentThread());
        if (reg == null) {
            reg = new ObjectRegistry();
            registries.put(Thread.currentThread(), reg);
        }
        reg.increaseUsage();
        return reg;
    }

    private static synchronized void freeObjectRegistry(ObjectRegistry reg) {
        if (reg.decreaseUsage()) {
            registries.remove(Thread.currentThread());
        }
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    static {
        OBJECT_TYPE = OBJECT_TYPE;
        registries = new Hashtable();
    }

    private static class ObjectRegistry {
        private int usage;
        private int seq = 0;
        private Hashtable i2o = new Hashtable();
        private Hashtable o2i = new Hashtable();

        private ObjectRegistry() {
        }

        public void increaseUsage() {
            ++this.usage;
        }

        public boolean decreaseUsage() {
            return --this.usage == 0;
        }

        public int getObjectId(Object o) {
            if (o == null) {
                return 0;
            }
            if (!this.o2i.containsKey(o)) {
                this.registerObject(o, ++this.seq);
                return this.seq;
            }
            Integer key = (Integer)this.o2i.get(o);
            return key;
        }

        public Object getObject(int oid) {
            return this.i2o.get(new Integer(oid));
        }

        public void registerObject(Object o, int oid) {
            Integer key = new Integer(oid);
            this.i2o.put(key, o);
            this.o2i.put(o, key);
        }

        public boolean objectRegistered(Object o) {
            return this.o2i.containsKey(o);
        }
    }
}

