/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.pop3.commands;

import com.icegreen.greenmail.mail.MailException;
import com.icegreen.greenmail.pop3.Pop3Connection;
import com.icegreen.greenmail.pop3.Pop3State;
import com.icegreen.greenmail.pop3.commands.Pop3Command;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.store.SimpleStoredMessage;
import java.util.List;
import javax.mail.MessagingException;

public class StatCommand
extends Pop3Command {
    public boolean isValidForState(Pop3State state) {
        return state.isAuthenticated();
    }

    public void execute(Pop3Connection conn, Pop3State state, String cmd) {
        try {
            MailFolder inbox = state.getFolder();
            List messages = inbox.getNonDeletedMessages();
            long size = this.sumMessageSizes(messages);
            conn.println("+OK " + messages.size() + " " + size);
        }
        catch (Exception me) {
            conn.println("-ERR " + me);
        }
    }

    long sumMessageSizes(List messages) throws MailException {
        long total = 0L;
        for (SimpleStoredMessage msg : messages) {
            try {
                total += (long)msg.getMimeMessage().getSize();
            }
            catch (MessagingException e) {
                throw new RuntimeException(e);
            }
        }
        return total;
    }
}

