/*
 * Decompiled with CFR 0.152.
 */
package marquee.xmlrpc;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import marquee.xmlrpc.util.Base64;

class XmlRpcValue {
    Object value;
    int type = -891985903;
    String memberName;
    static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");

    XmlRpcValue() {
    }

    void setType(int type) {
        this.type = type;
        if (type == 93090393) {
            this.value = new ArrayList();
        } else if (type == -891974699) {
            this.value = new HashMap();
        }
    }

    void processCharacterData(String charData) {
        switch (this.type) {
            case -891985903: {
                this.value = charData;
                break;
            }
            case 3307: 
            case 104431: {
                this.value = new Integer(charData);
                break;
            }
            case 64711720: {
                this.value = new Boolean(Integer.parseInt(charData) == 1);
                break;
            }
            case -1325958191: {
                this.value = new Double(charData);
                break;
            }
            case -586971087: {
                try {
                    this.value = dateFormatter.parse(charData);
                }
                catch (ParseException parseException) {}
                break;
            }
            case -1396204209: {
                this.value = Base64.decode(charData.getBytes());
                break;
            }
            case -891974699: {
                this.memberName = charData;
                break;
            }
        }
    }

    void addChildValue(XmlRpcValue v) {
        if (this.type == 93090393) {
            ((List)this.value).add(v.value);
        } else if (this.type == -891974699) {
            ((Map)this.value).put(this.memberName, v.value);
        }
    }

    public int hashCode() {
        return this.type;
    }
}

