/*
 * Decompiled with CFR 0.152.
 */
package marquee.xmlrpc.processors;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import marquee.xmlrpc.XmlRpcInvocationProcessor;
import marquee.xmlrpc.processors.Session;
import marquee.xmlrpc.util.Log;
import marquee.xmlrpc.util.Trace;

public class SessionInvocationProcessor
implements XmlRpcInvocationProcessor {
    private static Map sessions = new HashMap();
    private static HashMap threads = new HashMap();
    private static long timeout;
    private static Thread houseKeeper;

    public static Map getSession() {
        String callerIp = (String)threads.get(Thread.currentThread().getName());
        Session session = (Session)sessions.get(callerIp);
        if (session == null) {
            session = new Session(callerIp);
            sessions.put(callerIp, session);
        }
        return session;
    }

    public static void setSessionTimeout(int timeout_) {
        if (timeout_ == 0 && houseKeeper != null) {
            houseKeeper.interrupt();
            houseKeeper = null;
            timeout = 0L;
        } else {
            timeout = timeout_ * 60 * 1000;
            if (houseKeeper == null) {
                SessionInvocationProcessor.startHouseKeeper();
            }
        }
    }

    public boolean preProcess(int callId, String callerIp, String handler, String method, List arguments) {
        threads.put(Thread.currentThread().getName(), callerIp);
        Session session = (Session)sessions.get(callerIp);
        if (session != null) {
            session.touch();
        }
        return true;
    }

    public Object postProcess(int callId, String callerIp, String handler, String method, List arguments, Object returnValue) {
        return returnValue;
    }

    public void onException(int callId, String callerIp, String handler, String method, List arguments, Throwable exception) {
    }

    private static void startHouseKeeper() {
        houseKeeper = new Thread(){

            public void run() {
                do {
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    long now = System.currentTimeMillis();
                    Iterator iter = sessions.values().iterator();
                    while (iter.hasNext()) {
                        Session session = (Session)iter.next();
                        if (now - session.getLastUsed() <= timeout) continue;
                        if (Trace.Messages) {
                            Log.append(Trace.Message, String.valueOf(String.valueOf(session.get("$owner"))).concat("'s session timed out."));
                        }
                        if (Trace.Debugs) {
                            Log.append(Trace.Debug, session.toString());
                        }
                        sessions.remove(session.get("$owner"));
                    }
                } while (!houseKeeper.isInterrupted());
            }
        };
        houseKeeper.start();
    }
}

