/*
 * Decompiled with CFR 0.152.
 */
package marquee.xmlrpc.testing;

import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import marquee.xmlrpc.XmlRpcParser;
import marquee.xmlrpc.XmlRpcSerializer;
import marquee.xmlrpc.XmlRpcServer;
import marquee.xmlrpc.handlers.ReflectiveInvocationHandler;
import marquee.xmlrpc.processors.SessionInvocationProcessor;
import marquee.xmlrpc.serializers.VectorSerializer;

public class SessionExampleServer {
    public static void main(String[] args) {
        try {
            XmlRpcParser.setDriver("uk.co.wilson.xml.MinML");
            XmlRpcSerializer.registerCustomSerializer(new VectorSerializer());
            SessionInvocationProcessor.setSessionTimeout(1);
            XmlRpcServer server = new XmlRpcServer();
            server.registerInvocationProcessor(new SessionInvocationProcessor());
            server.registerInvocationHandler("sessionTest", new SessionExampleHandler());
            server.runAsService(8080);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class SessionExampleHandler
    extends ReflectiveInvocationHandler {
        public void doCall(String someText) {
            Map session = SessionInvocationProcessor.getSession();
            Vector<String> history = (Vector<String>)((Hashtable)session).get("history");
            if (history == null) {
                history = new Vector<String>();
                ((Hashtable)session).put("history", history);
            }
            history.addElement(someText);
        }

        public Vector getHistory() {
            Map session = SessionInvocationProcessor.getSession();
            Vector history = (Vector)((Hashtable)session).get("history");
            return history != null ? history : new Vector();
        }
    }
}

