/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jooreports.openoffice.converter;

import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.XComponent;
import com.sun.star.ucb.XFileIdentifierConverter;
import com.sun.star.uno.UnoRuntime;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.jooreports.converter.DocumentFormat;
import net.sf.jooreports.converter.DocumentFormatRegistry;
import net.sf.jooreports.openoffice.connection.OpenOfficeConnection;
import net.sf.jooreports.openoffice.connection.OpenOfficeException;
import net.sf.jooreports.openoffice.converter.AbstractOpenOfficeDocumentConverter;
import org.apache.commons.io.IOUtils;

public class OpenOfficeDocumentConverter
extends AbstractOpenOfficeDocumentConverter {
    static /* synthetic */ Class class$com$sun$star$frame$XStorable;

    public OpenOfficeDocumentConverter(OpenOfficeConnection connection) {
        super(connection);
    }

    public OpenOfficeDocumentConverter(OpenOfficeConnection connection, DocumentFormatRegistry formatRegistry) {
        super(connection, formatRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void convertInternal(InputStream inputStream, DocumentFormat inputFormat, OutputStream outputStream, DocumentFormat outputFormat) {
        File inputFile = null;
        File outputFile = null;
        try {
            block9: {
                try {
                    inputFile = File.createTempFile("document", "." + inputFormat.getFileExtension());
                    FileOutputStream inputFileStream = null;
                    try {
                        inputFileStream = new FileOutputStream(inputFile);
                        IOUtils.copy((InputStream)inputStream, (OutputStream)inputFileStream);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inputFileStream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)inputFileStream);
                    outputFile = File.createTempFile("document", "." + outputFormat.getFileExtension());
                    this.convert(inputFile, inputFormat, outputFile, outputFormat);
                    FileInputStream outputFileStream = null;
                    try {}
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(outputFileStream);
                        throw throwable;
                    }
                    {
                        outputFileStream = new FileInputStream(outputFile);
                        IOUtils.copy((InputStream)outputFileStream, (OutputStream)outputStream);
                    }
                    IOUtils.closeQuietly((InputStream)outputFileStream);
                    Object var11_12 = null;
                    if (inputFile == null) break block9;
                    inputFile.delete();
                }
                catch (IOException ioException) {
                    throw new OpenOfficeException("conversion failed", ioException);
                }
            }
            if (outputFile == null) return;
            outputFile.delete();
            return;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (inputFile != null) {
                inputFile.delete();
            }
            if (outputFile == null) throw throwable;
            outputFile.delete();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void convertInternal(File inputFile, DocumentFormat inputFormat, File outputFile, DocumentFormat outputFormat) {
        OpenOfficeConnection openOfficeConnection = this.openOfficeConnection;
        synchronized (openOfficeConnection) {
            XFileIdentifierConverter fileContentProvider = this.openOfficeConnection.getFileContentProvider();
            String inputUrl = fileContentProvider.getFileURLFromSystemPath("", inputFile.getAbsolutePath());
            String outputUrl = fileContentProvider.getFileURLFromSystemPath("", outputFile.getAbsolutePath());
            PropertyValue[] exportProperties = new PropertyValue[]{OpenOfficeDocumentConverter.property("FilterName", outputFormat.getExportFilter(inputFormat.getFamily())), OpenOfficeDocumentConverter.property("FilterData", OpenOfficeDocumentConverter.toPropertyValues(outputFormat.getExportOptions()))};
            try {
                this.loadAndExport(inputUrl, outputUrl, exportProperties);
            }
            catch (Throwable throwable) {
                throw new OpenOfficeException("conversion failed", throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAndExport(String inputUrl, String outputUrl, PropertyValue[] exportProperties) throws Exception {
        XComponentLoader desktop = this.openOfficeConnection.getDesktop();
        XComponent document = desktop.loadComponentFromURL(inputUrl, "_blank", 0, new PropertyValue[]{OpenOfficeDocumentConverter.property("ReadOnly", Boolean.TRUE), OpenOfficeDocumentConverter.property("Hidden", Boolean.TRUE)});
        this.refreshDocument(document);
        try {
            XStorable storable = (XStorable)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XStorable == null ? (class$com$sun$star$frame$XStorable = OpenOfficeDocumentConverter.class$("com.sun.star.frame.XStorable")) : class$com$sun$star$frame$XStorable), (Object)document);
            storable.storeToURL(outputUrl, exportProperties);
        }
        finally {
            document.dispose();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

