/*
 * Decompiled with CFR 0.152.
 */
package magick.util;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import magick.MagickImage;
import magick.MagickProducer;

public class MagickCanvas
extends Canvas {
    private Image image = null;
    private int width = 0;
    private int height = 0;

    public void setImage(MagickImage magickImage) {
        this.image = this.createImage(new MagickProducer(magickImage));
        ImageNotification notify = new ImageNotification();
        this.width = this.image.getWidth(notify);
        this.height = this.image.getHeight(notify);
        if (this.width > 0 && this.height > 0) {
            this.setSize(this.width, this.height);
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        if (this.image != null) {
            g.drawImage(this.image, 0, 0, this);
        } else {
            super.paint(g);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    private class ImageNotification
    implements ImageObserver {
        ImageNotification() {
        }

        public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
            MagickCanvas.this.width = w;
            MagickCanvas.this.height = h;
            MagickCanvas.this.setSize(w, h);
            MagickCanvas.this.repaint();
            return false;
        }
    }
}

