/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import org.apache.poi.hwpf.model.GenericPropertyNode;
import org.apache.poi.hwpf.model.PlexOfCps;
import org.apache.poi.hwpf.model.SEPX;
import org.apache.poi.hwpf.model.SectionDescriptor;
import org.apache.poi.hwpf.model.SectionTable;
import org.apache.poi.hwpf.model.TextPieceTable;
import org.apache.poi.util.LittleEndian;

public final class OldSectionTable
extends SectionTable {
    public OldSectionTable(byte[] documentStream, int offset, int size, int fcMin, TextPieceTable tpt) {
        PlexOfCps sedPlex = new PlexOfCps(documentStream, offset, size, 12);
        int length = sedPlex.length();
        for (int x = 0; x < length; ++x) {
            GenericPropertyNode node = sedPlex.getProperty(x);
            SectionDescriptor sed = new SectionDescriptor(node.getBytes(), 0);
            int fileOffset = sed.getFc();
            int startAt = node.getStart();
            int endAt = node.getEnd();
            if (fileOffset == -1) {
                this._sections.add(new SEPX(sed, startAt, endAt, tpt, new byte[0]));
                continue;
            }
            short sepxSize = LittleEndian.getShort((byte[])documentStream, (int)fileOffset);
            byte[] buf = new byte[sepxSize];
            System.arraycopy(documentStream, fileOffset += 2, buf, 0, buf.length);
            this._sections.add(new SEPX(sed, startAt, endAt, tpt, buf));
        }
    }
}

