/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.fixture;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.abdera.model.Entry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryTree {
    public Entry parent;
    public Entry entry;
    public String type;
    public List<EntryTree> children;

    public EntryTree() {
    }

    public EntryTree(EntryTree tree) throws Exception {
        this(tree, -1, true);
    }

    public EntryTree(EntryTree tree, int depth) throws Exception {
        this(tree, depth, true);
    }

    public EntryTree(EntryTree tree, int depth, boolean includeDocs) throws Exception {
        this.parent = tree.parent;
        this.entry = tree.entry;
        this.type = tree.type;
        this.children = this.copyChildren(tree.children, depth, includeDocs);
    }

    private List<EntryTree> copyChildren(List<EntryTree> children, int depth, boolean includeDocs) throws Exception {
        if (children == null) {
            return null;
        }
        ArrayList<EntryTree> childrenCopy = new ArrayList<EntryTree>();
        if (depth == 0) {
            return childrenCopy;
        }
        for (EntryTree child : children) {
            if (!includeDocs && !child.type.equals("cmis:folder")) continue;
            EntryTree childCopy = new EntryTree(child, depth - 1, includeDocs);
            childrenCopy.add(childCopy);
        }
        return childrenCopy;
    }

    public boolean equalsTree(EntryTree tree) {
        int treeChildrenSize;
        if (this.parent == null && tree.parent != null) {
            return false;
        }
        if (this.parent != null && tree.parent == null) {
            return false;
        }
        if (!this.parent.getId().equals((Object)tree.parent.getId())) {
            return false;
        }
        if (!this.entry.getId().equals((Object)tree.entry.getId())) {
            return false;
        }
        if (!this.type.equals(tree.type)) {
            return false;
        }
        if (this.children == null && tree.children != null && tree.children.size() != 0) {
            return false;
        }
        if (this.children != null && this.children.size() != 0 && tree.children == null) {
            return false;
        }
        if (this.children == null) {
            return true;
        }
        int childrenSize = this.children == null ? 0 : this.children.size();
        int n = treeChildrenSize = tree.children == null ? 0 : tree.children.size();
        if (childrenSize != treeChildrenSize) {
            return false;
        }
        if (childrenSize == 0) {
            return true;
        }
        Collections.sort(this.children, new EntryTypeComparator());
        Collections.sort(tree.children, new EntryTypeComparator());
        int i = 0;
        while (i < this.children.size()) {
            if (!this.children.get(i).equalsTree(tree.children.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void walkTree(TreeVisitor visitor) throws Exception {
        this.walkEntry(this, visitor);
    }

    public void walkChildren(TreeVisitor visitor) throws Exception {
        this.walkChildren(this, visitor);
    }

    private void walkEntry(EntryTree entryTree, TreeVisitor visitor) throws Exception {
        visitor.visit(entryTree);
        this.walkChildren(entryTree, visitor);
    }

    private void walkChildren(EntryTree entryTree, TreeVisitor visitor) throws Exception {
        if (entryTree.children != null) {
            for (EntryTree child : entryTree.children) {
                this.walkEntry(child, visitor);
            }
        }
    }

    public int getEntryCount() {
        int count = 1;
        if (this.children != null) {
            for (EntryTree entry : this.children) {
                count += entry.getEntryCount();
            }
        }
        return count;
    }

    public String toString() {
        return "EntryTree: " + this.entry.getId() + ", count=" + this.getEntryCount();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryTypeComparator
    implements Comparator<EntryTree> {
        private EntryTypeComparator() {
        }

        @Override
        public int compare(EntryTree o1, EntryTree o2) {
            return o1.entry.getId().toString().compareTo(o2.entry.getId().toString());
        }
    }

    public static interface TreeVisitor {
        public void visit(EntryTree var1) throws Exception;
    }
}

