/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.http.httpclient;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.chemistry.tck.atompub.http.Response;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;

public class HttpClientResponse
implements Response {
    private HttpMethod method;

    public HttpClientResponse(HttpMethod method) {
        this.method = method;
    }

    public byte[] getContentAsByteArray() {
        try {
            return this.method.getResponseBody();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getContentAsString() throws UnsupportedEncodingException {
        try {
            return this.method.getResponseBodyAsString();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public int getContentLength() {
        try {
            return this.method.getResponseBody().length;
        }
        catch (IOException e) {
            return 0;
        }
    }

    public String getHeader(String name) {
        Header header = this.method.getResponseHeader(name);
        return header != null ? header.getValue() : null;
    }

    public int getStatus() {
        return this.method.getStatusCode();
    }
}

