/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.test.spec;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.chemistry.abdera.ext.CMISAllowableActions;
import org.apache.chemistry.abdera.ext.CMISCapabilities;
import org.apache.chemistry.abdera.ext.CMISConstants;
import org.apache.chemistry.abdera.ext.CMISObject;
import org.apache.chemistry.tck.atompub.TCKSkipCapabilityException;
import org.apache.chemistry.tck.atompub.TCKTest;
import org.apache.chemistry.tck.atompub.fixture.CMISTree;
import org.apache.chemistry.tck.atompub.fixture.EntryTree;
import org.apache.chemistry.tck.atompub.fixture.GatherRenditionsVisitor;
import org.apache.chemistry.tck.atompub.http.PostRequest;
import org.apache.chemistry.tck.atompub.http.Response;
import org.apache.chemistry.tck.atompub.test.spec.AllowableActionsTest;
import org.junit.Assert;

public class QueryTest
extends TCKTest {
    private EntryTree folder;
    private CMISObject folderObject;
    private EntryTree document1;
    private CMISObject document1Object;
    private EntryTree document2;
    private CMISObject document2Object;
    private EntryTree document3;
    private CMISObject document3Object;

    public void setUp() {
        super.setUp();
        try {
            this.folder = new EntryTree();
            this.folder.entry = this.fixture.getTestCaseFolder();
            this.folder.type = "cmis:folder";
            this.folder.children = new LinkedList<EntryTree>();
            this.folderObject = (CMISObject)this.folder.entry.getExtension(CMISConstants.OBJECT);
            this.document1 = new EntryTree();
            this.folder.children.add(this.document1);
            this.document1.parent = this.folder.entry;
            this.document1.entry = this.fixture.createTestDocument("apple1");
            this.document1.type = "cmis:document";
            this.document1Object = (CMISObject)this.document1.entry.getExtension(CMISConstants.OBJECT);
            String doc2name = "name" + System.currentTimeMillis();
            this.document2 = new EntryTree();
            this.folder.children.add(this.document2);
            this.document2.parent = this.folder.entry;
            this.document2.entry = this.fixture.createTestDocument(doc2name);
            this.document2.type = "cmis:document";
            this.document2Object = (CMISObject)this.document2.entry.getExtension(CMISConstants.OBJECT);
            this.document3 = new EntryTree();
            this.folder.children.add(this.document3);
            this.document3.parent = this.folder.entry;
            this.document3.entry = this.fixture.createTestDocument("banana1");
            this.document3.type = "cmis:document";
            this.document3Object = (CMISObject)this.document3.entry.getExtension(CMISConstants.OBJECT);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void testQueryFolderMetaData() throws Exception {
        CMISCapabilities capabilities = this.client.getCapabilities();
        String capability = capabilities.getQuery();
        if (!(capability.equals("metadataonly") || capability.equals("bothseperate") || capability.equals("bothcombined"))) {
            throw new TCKSkipCapabilityException("query", "metadataonly or bothseparate or bothcombined", capability);
        }
        IRI queryHREF = this.client.getQueryCollection(this.client.getWorkspace());
        String queryDoc = this.templates.load("query.cmisquery.xml");
        String query = "SELECT * FROM cmis:folder WHERE cmis:objectId = '" + this.folderObject.getObjectId().getStringValue() + "'";
        String queryReq = queryDoc.replace("${STATEMENT}", query);
        queryReq = queryReq.replace("${SKIPCOUNT}", "0");
        queryReq = queryReq.replace("${MAXITEMS}", "5");
        queryReq = queryReq.replace("${RENDITIONFILTER}", "cmis:none");
        PostRequest postReq = new PostRequest(queryHREF.toString(), queryReq, "application/cmisquery+xml");
        Response queryRes = this.client.executeRequest(postReq, 201);
        Assert.assertNotNull((Object)queryRes);
        Feed queryFeed = this.model.parseFeed((Reader)new StringReader(queryRes.getContentAsString()), null);
        Assert.assertNotNull((Object)queryFeed);
        Assert.assertEquals((long)1L, (long)queryFeed.getEntries().size());
        Assert.assertNotNull((Object)queryFeed.getEntry(this.folder.entry.getId().toString()));
        CMISObject result1 = (CMISObject)queryFeed.getEntry(this.folder.entry.getId().toString()).getExtension(CMISConstants.OBJECT);
        Assert.assertEquals((Object)this.folderObject.getName().getStringValue(), (Object)result1.getName().getStringValue());
        Assert.assertEquals((Object)this.folderObject.getObjectId().getStringValue(), (Object)result1.getObjectId().getStringValue());
        Assert.assertEquals((Object)this.folderObject.getObjectTypeId().getStringValue(), (Object)result1.getObjectTypeId().getStringValue());
    }

    public void testQueryDocumentMetaData() throws Exception {
        CMISCapabilities capabilities = this.client.getCapabilities();
        String capability = capabilities.getQuery();
        if (!(capability.equals("metadataonly") || capability.equals("bothseperate") || capability.equals("bothcombined"))) {
            throw new TCKSkipCapabilityException("query", "metadataonly or bothseparate or bothcombined", capability);
        }
        IRI queryHREF = this.client.getQueryCollection(this.client.getWorkspace());
        String queryDoc = this.templates.load("query.cmisquery.xml");
        String query = "SELECT * FROM cmis:document WHERE IN_FOLDER('" + this.folderObject.getObjectId().getStringValue() + "') " + "AND cmis:name = 'apple1'";
        String queryReq = queryDoc.replace("${STATEMENT}", query);
        queryReq = queryReq.replace("${SKIPCOUNT}", "0");
        queryReq = queryReq.replace("${MAXITEMS}", "5");
        queryReq = queryReq.replace("${RENDITIONFILTER}", "cmis:none");
        PostRequest postReq = new PostRequest(queryHREF.toString(), queryReq, "application/cmisquery+xml");
        Response queryRes = this.client.executeRequest(postReq, 201);
        Assert.assertNotNull((Object)queryRes);
        Feed queryFeed = this.model.parseFeed((Reader)new StringReader(queryRes.getContentAsString()), null);
        Assert.assertNotNull((Object)queryFeed);
        Assert.assertEquals((long)1L, (long)queryFeed.getEntries().size());
        Assert.assertNotNull((Object)queryFeed.getEntry(this.document1.entry.getId().toString()));
        CMISObject result1 = (CMISObject)queryFeed.getEntry(this.document1.entry.getId().toString()).getExtension(CMISConstants.OBJECT);
        Assert.assertEquals((Object)this.document1Object.getName().getStringValue(), (Object)result1.getName().getStringValue());
        Assert.assertEquals((Object)this.document1Object.getObjectId().getStringValue(), (Object)result1.getObjectId().getStringValue());
        Assert.assertEquals((Object)this.document1Object.getObjectTypeId().getStringValue(), (Object)result1.getObjectTypeId().getStringValue());
    }

    public void testQueryDocumentFullText() throws Exception {
        CMISCapabilities capabilities = this.client.getCapabilities();
        String capability = capabilities.getQuery();
        if (!(capability.equals("fulltextonly") || capability.equals("bothseperate") || capability.equals("bothcombined"))) {
            throw new TCKSkipCapabilityException("query", "fulltextonly or bothseparate or bothcombined", capability);
        }
        IRI queryHREF = this.client.getQueryCollection(this.client.getWorkspace());
        String queryDoc = this.templates.load("query.cmisquery.xml");
        String fullText = this.document2Object.getName().getStringValue();
        String query = "SELECT cmis:objectId, cmis:objectTypeId, cmis:name FROM cmis:document WHERE CONTAINS('" + fullText + "')";
        String queryReq = queryDoc.replace("${STATEMENT}", query);
        queryReq = queryReq.replace("${SKIPCOUNT}", "0");
        queryReq = queryReq.replace("${MAXITEMS}", "5");
        queryReq = queryReq.replace("${RENDITIONFILTER}", "cmis:none");
        PostRequest postReq = new PostRequest(queryHREF.toString(), queryReq, "application/cmisquery+xml");
        Response queryRes = this.client.executeRequest(postReq, 201);
        Assert.assertNotNull((Object)queryRes);
        Feed queryFeed = this.model.parseFeed((Reader)new StringReader(queryRes.getContentAsString()), null);
        Assert.assertNotNull((Object)queryFeed);
        Assert.assertEquals((long)1L, (long)queryFeed.getEntries().size());
        Assert.assertNotNull((Object)queryFeed.getEntry(this.document2.entry.getId().toString()));
        CMISObject result1 = (CMISObject)queryFeed.getEntry(this.document2.entry.getId().toString()).getExtension(CMISConstants.OBJECT);
        Assert.assertEquals((Object)this.document2Object.getName().getStringValue(), (Object)result1.getName().getStringValue());
        Assert.assertEquals((Object)this.document2Object.getObjectId().getStringValue(), (Object)result1.getObjectId().getStringValue());
        Assert.assertEquals((Object)this.document2Object.getObjectTypeId().getStringValue(), (Object)result1.getObjectTypeId().getStringValue());
    }

    public void testQueryDocumentMetaDataAndFullText() throws Exception {
        CMISCapabilities capabilities = this.client.getCapabilities();
        String capability = capabilities.getQuery();
        if (!capability.equals("bothcombined")) {
            throw new TCKSkipCapabilityException("query", "bothcombined", capability);
        }
        IRI queryHREF = this.client.getQueryCollection(this.client.getWorkspace());
        String queryDoc = this.templates.load("query.cmisquery.xml");
        String query = "SELECT cmis:objectId, cmis:objectTypeId, cmis:name FROM cmis:document WHERE IN_FOLDER('" + this.folderObject.getObjectId().getStringValue() + "') " + "AND cmis:name = 'apple1' " + "AND CONTAINS('apple1')";
        String queryReq = queryDoc.replace("${STATEMENT}", query);
        queryReq = queryReq.replace("${SKIPCOUNT}", "0");
        queryReq = queryReq.replace("${MAXITEMS}", "5");
        queryReq = queryReq.replace("${RENDITIONFILTER}", "cmis:none");
        PostRequest postReq = new PostRequest(queryHREF.toString(), queryReq, "application/cmisquery+xml");
        Response queryRes = this.client.executeRequest(postReq, 201);
        Assert.assertNotNull((Object)queryRes);
        Feed queryFeed = this.model.parseFeed((Reader)new StringReader(queryRes.getContentAsString()), null);
        Assert.assertNotNull((Object)queryFeed);
        Assert.assertEquals((long)1L, (long)queryFeed.getEntries().size());
        Assert.assertNotNull((Object)queryFeed.getEntry(this.document1.entry.getId().toString()));
        CMISObject result1 = (CMISObject)queryFeed.getEntry(this.document1.entry.getId().toString()).getExtension(CMISConstants.OBJECT);
        Assert.assertEquals((Object)this.document1Object.getName().getStringValue(), (Object)result1.getName().getStringValue());
        Assert.assertEquals((Object)this.document1Object.getObjectId().getStringValue(), (Object)result1.getObjectId().getStringValue());
        Assert.assertEquals((Object)this.document1Object.getObjectTypeId().getStringValue(), (Object)result1.getObjectTypeId().getStringValue());
    }

    public void testQueryDocumentRenditions() throws Exception {
        CMISCapabilities capabilities = this.client.getCapabilities();
        String capability = capabilities.getQuery();
        if (!capability.equals("bothcombined")) {
            throw new TCKSkipCapabilityException("query", "bothcombined", capability);
        }
        final IRI queryHREF = this.client.getQueryCollection(this.client.getWorkspace());
        final String queryDoc = this.templates.load("query.cmisquery.xml");
        final String query = "SELECT cmis:objectId, cmis:objectTypeId, cmis:name FROM cmis:document WHERE IN_FOLDER('" + this.folderObject.getObjectId().getStringValue() + "') " + "AND cmis:name = 'apple1' " + "AND CONTAINS('apple1')";
        GatherRenditionsVisitor visitor = new GatherRenditionsVisitor(this.client);
        visitor.testRenditions(this.folder, new GatherRenditionsVisitor.EntryGenerator(){

            public EntryTree getEntries(String renditionFilter) throws Exception {
                String queryReq = queryDoc.replace("${STATEMENT}", query);
                queryReq = queryReq.replace("${SKIPCOUNT}", "0");
                queryReq = queryReq.replace("${MAXITEMS}", "5");
                queryReq = queryReq.replace("${RENDITIONFILTER}", renditionFilter);
                PostRequest postReq = new PostRequest(queryHREF.toString(), queryReq, "application/cmisquery+xml");
                Response queryRes = QueryTest.this.client.executeRequest(postReq, 201);
                Assert.assertNotNull((Object)queryRes);
                Feed queryFeed = QueryTest.this.model.parseFeed((Reader)new StringReader(queryRes.getContentAsString()), null);
                Assert.assertNotNull((Object)queryFeed);
                Assert.assertEquals((long)1L, (long)queryFeed.getEntries().size());
                Assert.assertNotNull((Object)queryFeed.getEntry(((QueryTest)QueryTest.this).document1.entry.getId().toString()));
                CMISObject result1 = (CMISObject)queryFeed.getEntry(((QueryTest)QueryTest.this).document1.entry.getId().toString()).getExtension(CMISConstants.OBJECT);
                Assert.assertEquals((Object)QueryTest.this.document1Object.getName().getStringValue(), (Object)result1.getName().getStringValue());
                Assert.assertEquals((Object)QueryTest.this.document1Object.getObjectId().getStringValue(), (Object)result1.getObjectId().getStringValue());
                Assert.assertEquals((Object)QueryTest.this.document1Object.getObjectTypeId().getStringValue(), (Object)result1.getObjectTypeId().getStringValue());
                return new CMISTree(QueryTest.this.folder, queryFeed);
            }
        });
    }

    public void testQueryAllowableActions() throws Exception {
        CMISCapabilities capabilities = this.client.getCapabilities();
        String capability = capabilities.getQuery();
        if (capability.equals("none")) {
            throw new TCKSkipCapabilityException("query", "anything other than none", capability);
        }
        IRI queryHREF = this.client.getQueryCollection(this.client.getWorkspace());
        String queryDoc = this.templates.load("queryallowableactions.cmisquery.xml");
        String query = "SELECT * FROM cmis:document WHERE IN_FOLDER('" + this.folderObject.getObjectId().getStringValue() + "') ";
        String queryReq = queryDoc.replace("${STATEMENT}", query);
        queryReq = queryReq.replace("${INCLUDEALLOWABLEACTIONS}", "true");
        queryReq = queryReq.replace("${SKIPCOUNT}", "0");
        queryReq = queryReq.replace("${MAXITEMS}", "5");
        queryReq = queryReq.replace("${RENDITIONFILTER}", "cmis:none");
        PostRequest postReq = new PostRequest(queryHREF.toString(), queryReq, "application/cmisquery+xml");
        Response queryRes = this.client.executeRequest(postReq, 201);
        Assert.assertNotNull((Object)queryRes);
        Feed queryFeed = this.model.parseFeed((Reader)new StringReader(queryRes.getContentAsString()), null);
        Assert.assertNotNull((Object)queryFeed);
        Assert.assertEquals((long)3L, (long)queryFeed.getEntries().size());
        for (Entry child : queryFeed.getEntries()) {
            CMISObject childObject = (CMISObject)child.getExtension(CMISConstants.OBJECT);
            Assert.assertNotNull((Object)childObject);
            CMISAllowableActions childAllowableActions = (CMISAllowableActions)childObject.getExtension(CMISConstants.ALLOWABLE_ACTIONS);
            Assert.assertNotNull((Object)childAllowableActions);
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("includeAllowableActions", "true");
            Entry entry = this.client.getEntry(child.getSelfLink().getHref(), args);
            CMISObject entryObject = (CMISObject)entry.getExtension(CMISConstants.OBJECT);
            Assert.assertNotNull((Object)entryObject);
            CMISAllowableActions entryAllowableActions = (CMISAllowableActions)entryObject.getExtension(CMISConstants.ALLOWABLE_ACTIONS);
            AllowableActionsTest.compareAllowableActions(childAllowableActions, entryAllowableActions);
        }
    }
}

