/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.test.spec;

import java.util.HashMap;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.chemistry.abdera.ext.CMISConstants;
import org.apache.chemistry.abdera.ext.CMISObject;
import org.apache.chemistry.abdera.ext.CMISTypeDefinition;
import org.apache.chemistry.abdera.ext.CMISUriTemplate;
import org.apache.chemistry.tck.atompub.TCKSkipCapabilityException;
import org.apache.chemistry.tck.atompub.TCKTest;
import org.apache.chemistry.tck.atompub.http.DeleteRequest;
import org.apache.chemistry.tck.atompub.http.Response;
import org.junit.Assert;

public class RelationshipsTest
extends TCKTest {
    public static final String ARG_INCLUDE_SUB_RELATIONSHIP_TYPES = "includeSubRelationshipTypes";
    public static final String ARG_RELATIONSHIP_TYPE_ID = "typeId";

    public void setUp() {
        super.setUp();
        try {
            boolean relSupported = false;
            IRI typesHREF = this.client.getTypesChildrenCollection(this.client.getWorkspace());
            Feed types = this.client.getFeed(typesHREF);
            Assert.assertNotNull((Object)types);
            for (Entry type : types.getEntries()) {
                CMISTypeDefinition typeDef = (CMISTypeDefinition)type.getExtension(CMISConstants.TYPE_DEFINITION);
                if (!typeDef.getId().equals("cmis:relationship")) continue;
                relSupported = true;
                break;
            }
            if (!relSupported) {
                throw new TCKSkipCapabilityException("relationships", "cmis:relationship type", "none");
            }
            CMISUriTemplate typeByIdTemplate = this.client.getTypeByIdUriTemplate(this.client.getWorkspace());
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("id", this.options.getRelationshipType());
            IRI typeByIdRequest = typeByIdTemplate.generateUri(variables);
            Entry typeById = this.client.getEntry(typeByIdRequest);
            CMISTypeDefinition relType = (CMISTypeDefinition)typeById.getExtension(CMISConstants.TYPE_DEFINITION);
            RelationshipsTest.assertNotNull((Object)relType);
            RelationshipsTest.assertTrue((boolean)relType.getCreatable());
        }
        catch (Exception e) {
            RelationshipsTest.fail((String)e.toString());
        }
    }

    public void testCreateRelationship() throws Exception {
        Entry testFolder = this.fixture.getTestCaseFolder();
        Link childrenLink = this.client.getChildrenLink(testFolder);
        RelationshipsTest.assertNotNull((Object)childrenLink);
        Feed children = this.client.getFeed(childrenLink.getHref());
        RelationshipsTest.assertNotNull((Object)children);
        Entry source = this.client.createDocument(children.getSelfLink().getHref(), null, "testSource");
        RelationshipsTest.assertNotNull((Object)source);
        Entry target = this.client.createDocument(children.getSelfLink().getHref(), null, "testTarget");
        RelationshipsTest.assertNotNull((Object)target);
        Link relsLink = source.getLink("http://docs.oasis-open.org/ns/cmis/link/200908/relationships");
        RelationshipsTest.assertNotNull((Object)relsLink);
        Feed relsBefore = this.client.getFeed(relsLink.getHref());
        RelationshipsTest.assertNotNull((Object)relsBefore);
        RelationshipsTest.assertEquals((int)0, (int)relsBefore.getEntries().size());
        CMISObject sourceObject = (CMISObject)source.getExtension(CMISConstants.OBJECT);
        RelationshipsTest.assertNotNull((Object)sourceObject);
        String sourceId = sourceObject.getObjectId().getStringValue();
        RelationshipsTest.assertNotNull((Object)sourceId);
        CMISObject targetObject = (CMISObject)target.getExtension(CMISConstants.OBJECT);
        RelationshipsTest.assertNotNull((Object)targetObject);
        String targetId = targetObject.getObjectId().getStringValue();
        RelationshipsTest.assertNotNull((Object)targetId);
        Entry rel = this.client.createRelationship(relsLink.getHref(), this.options.getRelationshipType(), sourceId, targetId);
        RelationshipsTest.assertNotNull((Object)rel);
        CMISObject relObject = (CMISObject)rel.getExtension(CMISConstants.OBJECT);
        RelationshipsTest.assertNotNull((Object)relObject);
        RelationshipsTest.assertEquals((String)this.options.getRelationshipType(), (String)relObject.getObjectTypeId().getStringValue());
        RelationshipsTest.assertEquals((String)sourceId, (String)relObject.getSourceId().getStringValue());
        RelationshipsTest.assertEquals((String)targetId, (String)relObject.getTargetId().getStringValue());
        RelationshipsTest.assertEquals((Object)source.getSelfLink().getHref(), (Object)rel.getLink("http://docs.oasis-open.org/ns/cmis/link/200908/source").getHref());
        RelationshipsTest.assertEquals((Object)target.getSelfLink().getHref(), (Object)rel.getLink("http://docs.oasis-open.org/ns/cmis/link/200908/target").getHref());
        HashMap<String, String> args = new HashMap<String, String>();
        args.put(ARG_INCLUDE_SUB_RELATIONSHIP_TYPES, "true");
        Feed relsAfter = this.client.getFeed(relsLink.getHref(), args);
        RelationshipsTest.assertNotNull((Object)relsAfter);
        RelationshipsTest.assertEquals((int)1, (int)relsAfter.getEntries().size());
    }

    public void testGetRelationship() throws Exception {
        Entry testFolder = this.fixture.getTestCaseFolder();
        Link childrenLink = this.client.getChildrenLink(testFolder);
        RelationshipsTest.assertNotNull((Object)childrenLink);
        Feed children = this.client.getFeed(childrenLink.getHref());
        RelationshipsTest.assertNotNull((Object)children);
        Entry source = this.client.createDocument(children.getSelfLink().getHref(), null, "testSource");
        RelationshipsTest.assertNotNull((Object)source);
        Entry target = this.client.createDocument(children.getSelfLink().getHref(), null, "testTarget");
        RelationshipsTest.assertNotNull((Object)target);
        Link relsLink = source.getLink("http://docs.oasis-open.org/ns/cmis/link/200908/relationships");
        RelationshipsTest.assertNotNull((Object)relsLink);
        HashMap<String, String> args = new HashMap<String, String>();
        args.put(ARG_INCLUDE_SUB_RELATIONSHIP_TYPES, "true");
        Feed relsBeforeCreate = this.client.getFeed(relsLink.getHref(), args);
        RelationshipsTest.assertNotNull((Object)relsBeforeCreate);
        RelationshipsTest.assertEquals((int)0, (int)relsBeforeCreate.getEntries().size());
        CMISObject sourceObject = (CMISObject)source.getExtension(CMISConstants.OBJECT);
        RelationshipsTest.assertNotNull((Object)sourceObject);
        String sourceId = sourceObject.getObjectId().getStringValue();
        RelationshipsTest.assertNotNull((Object)sourceId);
        CMISObject targetObject = (CMISObject)target.getExtension(CMISConstants.OBJECT);
        RelationshipsTest.assertNotNull((Object)targetObject);
        String targetId = targetObject.getObjectId().getStringValue();
        RelationshipsTest.assertNotNull((Object)targetId);
        Entry rel = this.client.createRelationship(relsLink.getHref(), this.options.getRelationshipType(), sourceId, targetId);
        RelationshipsTest.assertNotNull((Object)rel);
        args.put(ARG_RELATIONSHIP_TYPE_ID, this.options.getRelationshipType());
        Feed relsAfterCreate = this.client.getFeed(relsLink.getHref(), args);
        RelationshipsTest.assertNotNull((Object)relsAfterCreate);
        RelationshipsTest.assertEquals((int)1, (int)relsAfterCreate.getEntries().size());
        Entry relEntry = this.client.getEntry(rel.getSelfLink().getHref());
        CMISObject relEntryObject = (CMISObject)rel.getExtension(CMISConstants.OBJECT);
        CMISObject relObject = (CMISObject)rel.getExtension(CMISConstants.OBJECT);
        RelationshipsTest.assertNotNull((Object)relObject);
        RelationshipsTest.assertEquals((String)relObject.getObjectTypeId().getStringValue(), (String)relEntryObject.getObjectTypeId().getStringValue());
        RelationshipsTest.assertEquals((String)relObject.getSourceId().getStringValue(), (String)relEntryObject.getSourceId().getStringValue());
        RelationshipsTest.assertEquals((String)relObject.getTargetId().getStringValue(), (String)relEntryObject.getTargetId().getStringValue());
        RelationshipsTest.assertEquals((Object)source.getSelfLink().getHref(), (Object)relEntry.getLink("http://docs.oasis-open.org/ns/cmis/link/200908/source").getHref());
        RelationshipsTest.assertEquals((Object)target.getSelfLink().getHref(), (Object)relEntry.getLink("http://docs.oasis-open.org/ns/cmis/link/200908/target").getHref());
    }

    public void testDeleteRelationship() throws Exception {
        Entry testFolder = this.fixture.getTestCaseFolder();
        Link childrenLink = this.client.getChildrenLink(testFolder);
        RelationshipsTest.assertNotNull((Object)childrenLink);
        Feed children = this.client.getFeed(childrenLink.getHref());
        RelationshipsTest.assertNotNull((Object)children);
        Entry source = this.client.createDocument(children.getSelfLink().getHref(), null, "testSource");
        RelationshipsTest.assertNotNull((Object)source);
        Entry target = this.client.createDocument(children.getSelfLink().getHref(), null, "testTarget");
        RelationshipsTest.assertNotNull((Object)target);
        Link relsLink = source.getLink("http://docs.oasis-open.org/ns/cmis/link/200908/relationships");
        RelationshipsTest.assertNotNull((Object)relsLink);
        Feed relsBefore = this.client.getFeed(relsLink.getHref());
        RelationshipsTest.assertNotNull((Object)relsBefore);
        RelationshipsTest.assertEquals((int)0, (int)relsBefore.getEntries().size());
        CMISObject sourceObject = (CMISObject)source.getExtension(CMISConstants.OBJECT);
        RelationshipsTest.assertNotNull((Object)sourceObject);
        String sourceId = sourceObject.getObjectId().getStringValue();
        RelationshipsTest.assertNotNull((Object)sourceId);
        CMISObject targetObject = (CMISObject)target.getExtension(CMISConstants.OBJECT);
        RelationshipsTest.assertNotNull((Object)targetObject);
        String targetId = targetObject.getObjectId().getStringValue();
        RelationshipsTest.assertNotNull((Object)targetId);
        Entry rel = this.client.createRelationship(relsLink.getHref(), this.options.getRelationshipType(), sourceId, targetId);
        RelationshipsTest.assertNotNull((Object)rel);
        HashMap<String, String> args = new HashMap<String, String>();
        args.put(ARG_INCLUDE_SUB_RELATIONSHIP_TYPES, "true");
        Feed relsAfterCreate = this.client.getFeed(relsLink.getHref(), args);
        RelationshipsTest.assertNotNull((Object)relsAfterCreate);
        RelationshipsTest.assertEquals((int)1, (int)relsAfterCreate.getEntries().size());
        Response deleteRes = this.client.executeRequest(new DeleteRequest(rel.getSelfLink().getHref().toString()), 204);
        RelationshipsTest.assertNotNull((Object)deleteRes);
        Feed relsAfterDelete = this.client.getFeed(relsLink.getHref(), args);
        RelationshipsTest.assertNotNull((Object)relsAfterDelete);
        RelationshipsTest.assertEquals((int)0, (int)relsAfterDelete.getEntries().size());
    }
}

