/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;

public class ResourceLoader {
    private String basePath;

    public ResourceLoader() {
        this(null);
    }

    public ResourceLoader(String basePath) {
        this.basePath = basePath;
    }

    public String load(String path) throws IOException {
        String fullPath = this.basePath == null ? path : String.valueOf(this.basePath) + path;
        InputStream input = this.getClass().getResourceAsStream(fullPath);
        if (input == null) {
            throw new IOException(String.valueOf(fullPath) + " not found.");
        }
        InputStreamReader reader = new InputStreamReader(input, "UTF-8");
        StringWriter writer = new StringWriter();
        try {
            char[] buffer = new char[4096];
            int bytesRead = -1;
            while ((bytesRead = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, bytesRead);
            }
            writer.flush();
        }
        finally {
            reader.close();
            writer.close();
        }
        return writer.toString();
    }
}

