/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.provider.AbstractJAXBProvider;
import org.apache.cxf.jaxrs.utils.schemas.SchemaHandler;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.MappedNamespaceConvention;
import org.codehaus.jettison.mapped.MappedXMLInputFactory;
import org.codehaus.jettison.mapped.MappedXMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Provider
public class JSONProvider
extends AbstractJAXBProvider {
    private static final String JAXB_DEFAULT_NAMESPACE = "##default";
    private static final String JAXB_DEFAULT_NAME = "##default";
    private Map<String, String> namespaceMap = new HashMap<String, String>();
    private boolean serializeAsArray;
    private List<String> arrayKeys;

    @Context
    public void setMessageContext(MessageContext mc) {
        super.setContext(mc);
    }

    @Override
    public void setEnableBuffering(boolean enableBuf) {
        super.setEnableBuffering(enableBuf);
    }

    @Override
    public void setConsumeMediaTypes(List<String> types) {
        super.setConsumeMediaTypes(types);
    }

    @Override
    public void setProduceMediaTypes(List<String> types) {
        super.setProduceMediaTypes(types);
    }

    public void setSchemas(List<String> locations) {
        super.setSchemaLocations(locations);
    }

    public void setSchemaHandler(SchemaHandler handler) {
        super.setSchema(handler.getSchema());
    }

    public void setSerializeAsArray(boolean asArray) {
        this.serializeAsArray = asArray;
    }

    public void setArrayKeys(List<String> keys) {
        this.arrayKeys = keys;
    }

    public void setNamespaceMap(Map<String, String> namespaceMap) {
        this.namespaceMap = namespaceMap;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] anns, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        try {
            Class<?> theType = this.getActualType(type, genericType, anns);
            Unmarshaller unmarshaller = this.createUnmarshaller(theType, genericType);
            MappedXMLInputFactory factory = new MappedXMLInputFactory(this.namespaceMap);
            XMLStreamReader xsw = factory.createXMLStreamReader(is);
            Object response = null;
            response = JAXBElement.class.isAssignableFrom(type) ? unmarshaller.unmarshal(xsw, theType) : unmarshaller.unmarshal(xsw);
            response = this.checkAdapter(response, anns, false);
            return response;
        }
        catch (JAXBException e) {
            JSONProvider.handleJAXBException(e);
        }
        catch (XMLStreamException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
        return null;
    }

    public void writeTo(Object obj, Class<?> cls, Type genericType, Annotation[] anns, MediaType m, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        try {
            String encoding;
            Object actualObject = this.checkAdapter(obj, anns, true);
            Class<?> actualClass = actualObject.getClass();
            if (cls == genericType) {
                genericType = actualClass;
            }
            if ((encoding = this.getEncoding(m, headers)) == null) {
                encoding = "UTF-8";
            }
            Marshaller ms = this.createMarshaller(actualObject, actualClass, genericType, encoding);
            Configuration c = new Configuration(this.namespaceMap);
            MappedNamespaceConvention convention = new MappedNamespaceConvention(c);
            MappedXMLStreamWriter xsw = new MappedXMLStreamWriter(convention, (Writer)new OutputStreamWriter(os, encoding));
            if (this.serializeAsArray) {
                if (this.arrayKeys != null) {
                    for (String key : this.arrayKeys) {
                        xsw.seriliazeAsArray(key);
                    }
                } else {
                    String key = this.getKey(convention, cls);
                    xsw.seriliazeAsArray(key);
                }
            }
            ms.marshal(actualObject, (XMLStreamWriter)xsw);
            xsw.close();
        }
        catch (JAXBException e) {
            JSONProvider.handleJAXBException(e);
        }
        catch (XMLStreamException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    private String getKey(MappedNamespaceConvention convention, Class<?> cls) {
        String key = null;
        XmlRootElement root = cls.getAnnotation(XmlRootElement.class);
        if (root != null) {
            String name;
            String prefix;
            String namespace = root.namespace();
            if ("##default".equals(namespace)) {
                namespace = "";
            }
            if ((prefix = this.namespaceMap.get(namespace)) == null) {
                prefix = "";
            }
            if ("##default".equals(name = root.name())) {
                name = cls.getSimpleName();
            }
            key = convention.createKey(prefix, namespace, name);
        } else {
            key = convention.createKey("", "", cls.getSimpleName());
        }
        return key;
    }
}

