/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.config;

import org.dom4j.Element;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.ServerConfigElement;
import org.springframework.extensions.config.xml.elementreader.ConfigElementReader;

public class ServerElementReader
implements ConfigElementReader {
    public static final String ELEMENT_SCHEME = "scheme";
    public static final String ELEMENT_HOSTNAME = "hostname";
    public static final String ELEMENT_PORT = "port";

    public ConfigElement parse(Element element) {
        ServerConfigElement configElement = new ServerConfigElement();
        if (element != null) {
            Element portElem;
            Element hostnameElem;
            if (!"server".equals(element.getName())) {
                throw new ConfigException("ServerElementReader can only parse config elements of type 'server'");
            }
            Element schemeElem = element.element(ELEMENT_SCHEME);
            if (schemeElem != null) {
                configElement.setScheme(schemeElem.getTextTrim());
            }
            if ((hostnameElem = element.element(ELEMENT_HOSTNAME)) != null) {
                configElement.setHostName(hostnameElem.getTextTrim());
            }
            if ((portElem = element.element(ELEMENT_PORT)) != null) {
                try {
                    Integer port = new Integer(portElem.getTextTrim());
                    configElement.setPort(port);
                }
                catch (NumberFormatException e) {
                    throw new ConfigException("Server port is not a number", (Throwable)e);
                }
            }
        }
        return configElement;
    }
}

