/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;
import org.springframework.extensions.webscripts.AbstractBaseDescriptionDocument;
import org.springframework.extensions.webscripts.ArgumentTypeDescription;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.MediaType;
import org.springframework.extensions.webscripts.NegotiatedFormat;
import org.springframework.extensions.webscripts.Path;
import org.springframework.extensions.webscripts.TransactionParameters;
import org.springframework.extensions.webscripts.TypeDescription;
import org.springframework.extensions.webscripts.WebScriptException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptionImpl
extends AbstractBaseDescriptionDocument
implements Description {
    public static final String ROOT_ELEMENT_NAME = "webscript";
    public static final String DESC_NAME_POSTFIX = "desc.xml";
    public static final String DESC_NAME_PATTERN = "*.desc.xml";
    private String scriptPath;
    private Path scriptPackage;
    private String kind;
    private Description.Lifecycle lifecycle;
    private Set<String> familys;
    private Description.RequiredAuthentication requiredAuthentication;
    private String runAs;
    private Description.RequiredTransactionParameters transactionParameters;
    private Description.RequiredCache requiredCache;
    private Description.FormatStyle formatStyle;
    private String httpMethod;
    private String[] uris;
    private String defaultFormat;
    private NegotiatedFormat[] negotiatedFormats;
    private Map<String, Serializable> extensions;
    private boolean multipartProcessing;
    private ArgumentTypeDescription[] arguments;
    private TypeDescription[] requestTypes;
    private TypeDescription[] responseTypes;

    @Override
    public ArgumentTypeDescription[] getArguments() {
        return this.arguments;
    }

    public void setArguments(ArgumentTypeDescription[] arguments) {
        this.arguments = arguments;
    }

    @Override
    public TypeDescription[] getRequestTypes() {
        return this.requestTypes;
    }

    public void setRequestTypes(TypeDescription[] requestTypes) {
        this.requestTypes = requestTypes;
    }

    @Override
    public TypeDescription[] getResponseTypes() {
        return this.responseTypes;
    }

    public void setResponseTypes(TypeDescription[] responseTypes) {
        this.responseTypes = responseTypes;
    }

    public void setScriptPath(String scriptPath) {
        this.scriptPath = scriptPath;
    }

    @Override
    public String getScriptPath() {
        return this.scriptPath;
    }

    public void setPackage(Path scriptPackage) {
        this.scriptPackage = scriptPackage;
    }

    @Override
    public Path getPackage() {
        return this.scriptPackage;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    public void setFamilys(Set<String> familys) {
        this.familys = familys;
    }

    @Override
    public Set<String> getFamilys() {
        return this.familys;
    }

    public void setRequiredAuthentication(Description.RequiredAuthentication requiredAuthentication) {
        this.requiredAuthentication = requiredAuthentication;
    }

    @Override
    public Description.RequiredAuthentication getRequiredAuthentication() {
        return this.requiredAuthentication;
    }

    public void setRunAs(String runAs) {
        this.runAs = runAs;
    }

    @Override
    public String getRunAs() {
        return this.runAs;
    }

    @Override
    public Description.RequiredTransaction getRequiredTransaction() {
        return this.transactionParameters.getRequired();
    }

    public void setRequiredTransactionParameters(Description.RequiredTransactionParameters transactionParameters) {
        this.transactionParameters = transactionParameters;
    }

    @Override
    public Description.RequiredTransactionParameters getRequiredTransactionParameters() {
        return this.transactionParameters;
    }

    public void setRequiredCache(Description.RequiredCache requiredCache) {
        this.requiredCache = requiredCache;
    }

    @Override
    public Description.RequiredCache getRequiredCache() {
        return this.requiredCache;
    }

    public void setFormatStyle(Description.FormatStyle formatStyle) {
        this.formatStyle = formatStyle;
    }

    @Override
    public Description.FormatStyle getFormatStyle() {
        return this.formatStyle;
    }

    public void setMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    @Override
    public String getMethod() {
        return this.httpMethod;
    }

    public void setUris(String[] uris) {
        this.uris = uris;
    }

    @Override
    public String[] getURIs() {
        return this.uris;
    }

    public void setDefaultFormat(String defaultFormat) {
        this.defaultFormat = defaultFormat;
    }

    @Override
    public String getDefaultFormat() {
        return this.defaultFormat;
    }

    public void setNegotiatedFormats(NegotiatedFormat[] negotiatedFormats) {
        this.negotiatedFormats = negotiatedFormats;
    }

    @Override
    public NegotiatedFormat[] getNegotiatedFormats() {
        return this.negotiatedFormats;
    }

    public void setExtensions(Map<String, Serializable> extensions) {
        this.extensions = extensions;
    }

    @Override
    public Map<String, Serializable> getExtensions() {
        return this.extensions;
    }

    @Override
    public Description.Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    public void setLifecycle(Description.Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    @Override
    public boolean getMultipartProcessing() {
        return this.multipartProcessing;
    }

    @Override
    public void setMultipartProcessing(boolean multipartProcessing) {
        this.multipartProcessing = multipartProcessing;
    }

    @Override
    public void parse(Element elem) {
        if (this.validateRootElement(elem, ROOT_ELEMENT_NAME)) {
            List urlElements;
            super.parse(elem);
            String shortName = this.getShortName();
            if (shortName == null || shortName.length() == 0) {
                throw new WebScriptException("Expected <shortname> value");
            }
            String kind = null;
            String attrKindValue = elem.attributeValue("kind");
            if (attrKindValue != null) {
                kind = attrKindValue.trim();
            }
            TreeSet<String> familys = new TreeSet<String>();
            List familyElements = elem.elements("family");
            if (familyElements == null || familyElements.size() > 0) {
                for (Element familyElement : familyElements) {
                    String family = familyElement.getTextTrim();
                    familys.add(family);
                }
            }
            if ((urlElements = elem.elements("url")) == null || urlElements.size() == 0) {
                throw new WebScriptException("Expected at least one <url> element");
            }
            ArrayList<String> uris = new ArrayList<String>(4);
            for (Element urlElement : urlElements) {
                String template = urlElement.getTextTrim();
                if (!(template != null && template.length() != 0 || (template = urlElement.attributeValue("template")) != null && template.length() != 0)) {
                    throw new WebScriptException("Expected <url> element value");
                }
                uris.add(template);
            }
            Description.RequiredAuthentication reqAuth = Description.RequiredAuthentication.none;
            String runAs = null;
            Element authElement = elem.element("authentication");
            if (authElement != null) {
                String reqAuthStr = authElement.getTextTrim();
                if (reqAuthStr == null || reqAuthStr.length() == 0) {
                    throw new WebScriptException("Expected <authentication> value");
                }
                try {
                    reqAuth = Description.RequiredAuthentication.valueOf(reqAuthStr);
                }
                catch (IllegalArgumentException e) {
                    throw new WebScriptException("Authentication '" + reqAuthStr + "' is not a valid value");
                }
                String runAsStr = authElement.attributeValue("runas");
                if (runAsStr != null && (runAsStr = runAsStr.trim()).length() != 0) {
                    if (!this.getStore().isSecure()) {
                        throw new WebScriptException("runas user declared for script in insecure store");
                    }
                    runAs = runAsStr;
                }
            }
            TransactionParameters trxParams = new TransactionParameters();
            Description.RequiredTransaction reqTrx = reqAuth == Description.RequiredAuthentication.none ? Description.RequiredTransaction.none : Description.RequiredTransaction.required;
            Description.TransactionCapability trxCapability = Description.TransactionCapability.readwrite;
            int bufferSize = 4096;
            Element trxElement = elem.element("transaction");
            if (trxElement != null) {
                String bufferSizeStr;
                String capabilityStr;
                String reqTrxStr = trxElement.getTextTrim();
                if (reqTrxStr != null && reqTrxStr.length() > 0) {
                    try {
                        reqTrx = Description.RequiredTransaction.valueOf(reqTrxStr);
                    }
                    catch (IllegalArgumentException e) {
                        throw new WebScriptException("Transaction '" + reqTrxStr + "' is not a valid value");
                    }
                }
                if ((capabilityStr = trxElement.attributeValue("allow")) != null) {
                    try {
                        trxCapability = Description.TransactionCapability.valueOf(capabilityStr);
                    }
                    catch (IllegalArgumentException e) {
                        throw new WebScriptException("Transaction allow '" + capabilityStr + "' is not a valid value");
                    }
                }
                if ((bufferSizeStr = trxElement.attributeValue("buffersize")) != null) {
                    try {
                        bufferSize = new Integer(bufferSizeStr);
                    }
                    catch (NumberFormatException e) {
                        throw new WebScriptException("Buffer size '" + bufferSizeStr + "' is not a valid integer");
                    }
                }
            }
            trxParams.setRequired(reqTrx);
            trxParams.setCapability(trxCapability);
            trxParams.setBufferSize(bufferSize);
            Description.Lifecycle lifecycle = Description.Lifecycle.none;
            Element lifecycleElement = elem.element("lifecycle");
            if (lifecycleElement != null) {
                String reqLifeStr = lifecycleElement.getTextTrim();
                if (reqLifeStr == null || reqLifeStr.length() == 0) {
                    throw new WebScriptException("Expected <lifecycle> value");
                }
                try {
                    lifecycle = Description.Lifecycle.valueOf(reqLifeStr);
                }
                catch (IllegalArgumentException e) {
                    throw new WebScriptException("Lifecycle '" + reqLifeStr + "' is not a valid value");
                }
            }
            String defaultFormat = "html";
            String defaultFormatMimetype = null;
            Description.FormatStyle formatStyle = Description.FormatStyle.any;
            Element formatElement = elem.element("format");
            if (formatElement != null) {
                String formatStyleStr;
                String attrDefaultValue = formatElement.attributeValue("default");
                if (attrDefaultValue != null) {
                    String string = defaultFormat = attrDefaultValue.length() == 0 ? null : attrDefaultValue;
                }
                if ((formatStyleStr = formatElement.getTextTrim()) != null && formatStyleStr.length() > 0) {
                    try {
                        formatStyle = Description.FormatStyle.valueOf(formatStyleStr);
                    }
                    catch (IllegalArgumentException e) {
                        throw new WebScriptException("Format Style '" + (Object)((Object)formatStyle) + "' is not a valid value");
                    }
                }
            }
            NegotiatedFormat[] negotiatedFormats = null;
            List negotiateElements = elem.elements("negotiate");
            if (negotiateElements.size() > 0) {
                negotiatedFormats = new NegotiatedFormat[negotiateElements.size() + (defaultFormatMimetype == null ? 0 : 1)];
                int iNegotiate = 0;
                for (Element negotiateElement : negotiateElements) {
                    String accept = negotiateElement.attributeValue("accept");
                    if (accept == null || accept.length() == 0) {
                        throw new WebScriptException("Expected 'accept' attribute on <negotiate> element");
                    }
                    String format = negotiateElement.getTextTrim();
                    if (format == null || format.length() == 0) {
                        throw new WebScriptException("Expected <negotiate> value");
                    }
                    negotiatedFormats[iNegotiate++] = new NegotiatedFormat(new MediaType(accept), format);
                }
                if (defaultFormatMimetype != null) {
                    negotiatedFormats[iNegotiate++] = new NegotiatedFormat(new MediaType(defaultFormatMimetype), defaultFormat);
                }
            }
            Cache cache = new Cache();
            Element cacheElement = elem.element("cache");
            if (cacheElement != null) {
                Element revalidateElement;
                Element publicElement;
                Element neverElement = cacheElement.element("never");
                if (neverElement != null) {
                    String neverStr = neverElement.getTextTrim();
                    boolean neverBool = neverStr == null || neverStr.length() == 0 ? true : Boolean.valueOf(neverStr);
                    cache.setNeverCache(neverBool);
                }
                if ((publicElement = cacheElement.element("public")) != null) {
                    String publicStr = publicElement.getTextTrim();
                    boolean publicBool = publicStr == null || publicStr.length() == 0 ? true : Boolean.valueOf(publicStr);
                    cache.setIsPublic(publicBool);
                }
                if ((revalidateElement = cacheElement.element("mustrevalidate")) != null) {
                    String revalidateStr = revalidateElement.getTextTrim();
                    boolean revalidateBool = revalidateStr == null || revalidateStr.length() == 0 ? true : Boolean.valueOf(revalidateStr);
                    cache.setMustRevalidate(revalidateBool);
                }
            }
            boolean multipartProcessing = true;
            Element formdataElement = elem.element("formdata");
            if (formdataElement != null) {
                String strProcessing = formdataElement.attributeValue("multipart-processing");
                if (strProcessing == null || strProcessing.length() == 0) {
                    throw new WebScriptException("Expected 'multipart-processing' attribute on <formdata> value");
                }
                multipartProcessing = Boolean.parseBoolean(strProcessing);
            }
            ArgumentTypeDescription[] arguments = null;
            Element argsElement = elem.element("args");
            if (argsElement != null) {
                List argElements = argsElement.elements("arg");
                arguments = new ArgumentTypeDescription[argElements.size()];
                int iArg = 0;
                for (Element argElement : argElements) {
                    ArgumentTypeDescription argument = new ArgumentTypeDescription();
                    argument.parse(argElement);
                    argument.setRequired(true);
                    Pattern p = Pattern.compile(argument.getShortName() + "=\\{[a-zA-Z0-9]*\\?\\}");
                    for (String uriStr : uris) {
                        Matcher m = p.matcher(uriStr);
                        if (!m.find()) continue;
                        argument.setRequired(false);
                    }
                    arguments[iArg++] = argument;
                }
            }
            TypeDescription[] requestTypes = null;
            Element requestsElement = elem.element("requests");
            if (requestsElement != null) {
                List requestElements = requestsElement.elements("request");
                requestTypes = new TypeDescription[requestElements.size()];
                int iRequest = 0;
                for (Element requestElement : requestElements) {
                    if (requestElement.attribute("type") != null) {
                        String refTypeId = requestElement.attribute("type").getText();
                        TypeDescription requestType = new TypeDescription();
                        requestType.setId(refTypeId);
                        requestTypes[iRequest++] = requestType;
                        continue;
                    }
                    if (requestElement.element("type") == null) continue;
                    TypeDescription requestType = new TypeDescription();
                    requestType.parse(requestElement.element("type"));
                    requestTypes[iRequest++] = requestType;
                }
            }
            TypeDescription[] responseTypes = null;
            Element responsesElement = elem.element("responses");
            if (responsesElement != null) {
                List responseElements = responsesElement.elements("response");
                responseTypes = new TypeDescription[responseElements.size()];
                int iResponse = 0;
                for (Element responseElement : responseElements) {
                    if (responseElement.attribute("type") != null) {
                        String refTypeId = responseElement.attribute("type").getText();
                        TypeDescription responseType = new TypeDescription();
                        responseType.setId(refTypeId);
                        responseTypes[iResponse++] = responseType;
                        continue;
                    }
                    if (responseElement.element("type") == null) continue;
                    TypeDescription responseType = new TypeDescription();
                    responseType.parse(responseElement.element("type"));
                    responseTypes[iResponse++] = responseType;
                }
            }
            this.setScriptPath(this.scriptPath);
            this.setKind(kind);
            this.setLifecycle(lifecycle);
            this.setShortName(shortName);
            this.setFamilys(familys);
            this.setRequiredAuthentication(reqAuth);
            this.setRunAs(runAs);
            this.setRequiredTransactionParameters(trxParams);
            this.setRequiredCache(cache);
            this.setUris(uris.toArray(new String[uris.size()]));
            this.setDefaultFormat(defaultFormat);
            this.setNegotiatedFormats(negotiatedFormats);
            this.setFormatStyle(formatStyle);
            this.setMultipartProcessing(multipartProcessing);
            this.setArguments(arguments);
            this.setRequestTypes(requestTypes);
            this.setResponseTypes(responseTypes);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("\n");
        sb.append("<").append(ROOT_ELEMENT_NAME).append(" ").append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"http://www.springsurf.org/schemas/DescriptionXMLSchema.xsd\"");
        if (this.getKind() != null && !this.getKind().equals("")) {
            sb.append(" ").append("kind=\"").append(this.getKind()).append("\"");
        }
        sb.append(">").append("\n");
        sb.append("    ").append("<shortname>").append(this.getShortName()).append("</shortname>").append("\n");
        sb.append("    ").append("<description>").append(this.getDescription()).append("</description>").append("\n");
        for (String string : this.getURIs()) {
            sb.append("    ").append("<url>").append(string).append("</url>").append("\n");
        }
        if (this.getFormatStyle() != null) {
            sb.append("    ").append("<format");
            if (this.getDefaultFormat() != null && !this.getDefaultFormat().equals("")) {
                sb.append(" ").append("default=\"").append(this.getDefaultFormat()).append("\"");
            }
            sb.append(">").append(this.getFormatStyle().toString()).append("</format>").append("\n");
        }
        if (this.getLifecycle() != null) {
            sb.append("    ").append("<lifecycle>").append(this.getLifecycle().toString()).append("</lifecycle>").append("\n");
        }
        if (this.getRequiredAuthentication() != null) {
            sb.append("    ").append("<authentication");
            if (this.getRunAs() != null && !this.getRunAs().equals("")) {
                sb.append(" ").append("runas=\"").append(this.getRunAs()).append("\"");
            }
            sb.append(">").append(this.getRequiredAuthentication().toString()).append("</authentication>").append("\n");
        }
        if (this.getRequiredTransactionParameters() != null) {
            sb.append("    ").append("<transaction");
            if (this.getRequiredTransactionParameters() != null && this.getRequiredTransactionParameters().getCapability() != null) {
                sb.append(" ").append("allow=\"").append(this.getRequiredTransactionParameters().getCapability().toString()).append("\"");
            }
            if (this.getRequiredTransactionParameters() != null && this.getRequiredTransactionParameters().getBufferSize() != 4096) {
                sb.append(" ").append("buffersize=\"").append(this.getRequiredTransactionParameters().getBufferSize()).append("\"");
            }
            sb.append(">").append(this.getRequiredTransaction().toString()).append("</transaction>").append("\n");
        }
        if (this.getFamilys() != null) {
            for (String family : this.getFamilys()) {
                sb.append("    ").append("<family>").append(family).append("</family>").append("\n");
            }
        }
        if (this.getRequiredCache() != null) {
            sb.append("    ").append("<cache>").append("\n");
            sb.append("    ").append("    ").append("<never>").append(this.getRequiredCache().getNeverCache()).append("</never>").append("\n");
            sb.append("    ").append("    ").append("<public>").append(this.getRequiredCache().getIsPublic()).append("</public>").append("\n");
            sb.append("    ").append("    ").append("<mustrevalidate>").append(this.getRequiredCache().getMustRevalidate()).append("</mustrevalidate>").append("\n");
            sb.append("    ").append("</cache>").append("\n");
        }
        if (this.getNegotiatedFormats() != null) {
            for (NegotiatedFormat negotiatedFormat : this.getNegotiatedFormats()) {
                sb.append("    ").append("<negotiate");
                sb.append(" ").append("accept=\"").append(negotiatedFormat.getMediaType().getType() + "/" + negotiatedFormat.getMediaType().getSubtype()).append("\">");
                sb.append(negotiatedFormat.getFormat()).append("</negotiate>").append("\n");
            }
        }
        sb.append("    ").append("<formdata multipart-processing=\"").append(this.getMultipartProcessing());
        sb.append("\"/>").append("\n");
        if (this.getArguments() != null && this.getArguments().length > 0) {
            sb.append("    ").append("<args>").append("\n");
            for (ArgumentTypeDescription argumentTypeDescription : this.getArguments()) {
                sb.append(argumentTypeDescription.toString()).append("\n");
            }
            sb.append("    ").append("</args>").append("\n");
        }
        if (this.getRequestTypes() != null && this.getRequestTypes().length > 0) {
            sb.append("    ").append("<requests>").append("\n");
            for (TypeDescription typeDescription : this.getRequestTypes()) {
                if (typeDescription.getId() != null && !typeDescription.getId().equals("")) {
                    sb.append("    ").append("    ").append("<request type=\"");
                    sb.append(typeDescription.getId().toString()).append("\"/>").append("\n");
                    continue;
                }
                sb.append("    ").append("    ").append("<request>").append("\n");
                sb.append(typeDescription.toString()).append("\n");
                sb.append("    ").append("    ").append("</request>").append("\n");
            }
            sb.append("    ").append("</requests>").append("\n");
        }
        if (this.getResponseTypes() != null && this.getResponseTypes().length > 0) {
            sb.append("    ").append("<responses>").append("\n");
            for (TypeDescription typeDescription : this.getResponseTypes()) {
                if (typeDescription.getId() != null && !typeDescription.getId().equals("")) {
                    sb.append("    ").append("    ").append("<response type=\"");
                    sb.append(typeDescription.getId().toString()).append("\"/>").append("\n");
                    continue;
                }
                sb.append("    ").append("    ").append("<response>").append("\n");
                sb.append(typeDescription.toString()).append("\n");
                sb.append("    ").append("    ").append("</response>").append("\n");
            }
            sb.append("    ").append("</responses>").append("\n");
        }
        sb.append("</").append(ROOT_ELEMENT_NAME).append(">");
        return sb.toString();
    }

    public static DescriptionImpl newInstance() {
        DescriptionImpl newDescriptionImpl = new DescriptionImpl("", "shortname", "description", "/url");
        return newDescriptionImpl;
    }

    public DescriptionImpl(String id, String shortName, String description, String url) {
        super(id, shortName, description);
        this.setUris(new String[]{url});
    }

    public DescriptionImpl() {
    }
}

