/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.util.Collections;
import java.util.Map;
import org.springframework.extensions.webscripts.WebScript;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Match {
    private final String templatePath;
    private final Map<String, String> templateVars;
    private final String matchPath;
    private final WebScript script;
    private final Kind kind;

    public Match(String templatePath, Map<String, String> templateVars, String matchPath, WebScript script) {
        this.kind = Kind.FULL;
        this.templatePath = templatePath;
        this.templateVars = Collections.unmodifiableMap(templateVars);
        this.matchPath = matchPath;
        this.script = script;
    }

    public Match(String templatePath, Map<String, String> templateVars, String matchPath) {
        this.kind = Kind.URI;
        this.templatePath = templatePath;
        this.templateVars = Collections.unmodifiableMap(templateVars);
        this.matchPath = matchPath;
        this.script = null;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getTemplate() {
        return this.templatePath;
    }

    public Map<String, String> getTemplateVars() {
        return this.templateVars;
    }

    public String getPath() {
        return this.matchPath;
    }

    public WebScript getWebScript() {
        return this.script;
    }

    public String toString() {
        return this.templatePath;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        URI,
        FULL;

    }
}

