/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.UriIndex;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.extensions.webscripts.WebScriptException;

public class PrefixTemplateUriIndex
implements UriIndex {
    private Map<String, IndexEntry> index = new TreeMap(Collections.reverseOrder());

    public void clear() {
        this.index.clear();
    }

    public int getSize() {
        return this.index.size();
    }

    public void registerUri(WebScript script, String uri) {
        String uriIdx;
        int tokenIdx;
        Description desc = script.getDescription();
        boolean wildcard = false;
        boolean extension = true;
        int queryArgIdx = uri.indexOf(63);
        if (queryArgIdx != -1) {
            uri = uri.substring(0, queryArgIdx);
        }
        if ((tokenIdx = uri.indexOf(123)) != -1) {
            uri = uri.substring(0, tokenIdx);
            wildcard = true;
        }
        if (desc.getFormatStyle() != Description.FormatStyle.argument) {
            int extIdx = uri.lastIndexOf(".");
            if (extIdx != -1) {
                uri = uri.substring(0, extIdx);
            }
            extension = false;
        }
        if (this.index.containsKey(uriIdx = desc.getMethod() + ":" + uri)) {
            IndexEntry urlIndex = this.index.get(uriIdx);
            WebScript existingService = urlIndex.script;
            if (!existingService.getDescription().getId().equals(desc.getId())) {
                String msg = "Web Script document " + desc.getDescPath() + " is attempting to define the url '" + uriIdx + "' already defined by " + existingService.getDescription().getDescPath();
                throw new WebScriptException(msg);
            }
        } else {
            IndexEntry urlIndex = new IndexEntry(uri, wildcard, extension, script);
            this.index.put(uriIdx, urlIndex);
        }
    }

    public Match findWebScript(String method, String uri) {
        String matchedPath = null;
        Match scriptMatch = null;
        String match = method.toUpperCase() + ":" + uri;
        String matchNoExt = method.toUpperCase() + ":" + (uri.indexOf(46) != -1 ? uri.substring(0, uri.indexOf(46)) : uri);
        for (Map.Entry<String, IndexEntry> entry : this.index.entrySet()) {
            String test;
            IndexEntry urlIndex = entry.getValue();
            String index = entry.getKey();
            String string = test = urlIndex.includeExtension ? match : matchNoExt;
            if (urlIndex.wildcardPath && test.startsWith(index) || !urlIndex.wildcardPath && test.equals(index)) {
                scriptMatch = new Match(urlIndex.path, null, urlIndex.path, urlIndex.script);
                break;
            }
            if ((!urlIndex.wildcardPath || !uri.startsWith(urlIndex.path)) && (urlIndex.wildcardPath || !uri.equals(urlIndex.path))) continue;
            matchedPath = urlIndex.path;
        }
        if (scriptMatch == null && matchedPath != null) {
            scriptMatch = new Match(matchedPath, null, matchedPath);
        }
        return scriptMatch;
    }

    private static class IndexEntry {
        private String path;
        private boolean wildcardPath;
        private boolean includeExtension;
        private WebScript script;

        private IndexEntry(String path, boolean wildcardPath, boolean includeExtension, WebScript script) {
            this.path = path;
            this.wildcardPath = wildcardPath;
            this.includeExtension = includeExtension;
            this.script = script;
        }
    }
}

