/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.webscripts.ScriptProcessor;
import org.springframework.extensions.webscripts.ScriptProcessorFactory;
import org.springframework.extensions.webscripts.ScriptProcessorRegistry;
import org.springframework.extensions.webscripts.SearchPath;
import org.springframework.extensions.webscripts.processor.AbstractScriptProcessor;

public class ScriptProcessorRegistrar
implements ApplicationContextAware {
    private static final String WEBSCRIPTS_SCRIPT_REGISTRY_ID = "webscripts.web.scriptregistry";
    private static final String WEBSCRIPTS_SEARCHPATH_ID = "webscripts.searchpath";
    private ApplicationContext applicationContext;
    private ScriptProcessorRegistry registry;
    private ScriptProcessorFactory factory;
    private SearchPath searchPath;
    private String name;
    private String extension;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setRegistry(ScriptProcessorRegistry registry) {
        this.registry = registry;
    }

    public void setFactory(ScriptProcessorFactory factory) {
        this.factory = factory;
    }

    public void setSearchPath(SearchPath searchPath) {
        this.searchPath = searchPath;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void init() {
        if (this.registry == null) {
            this.registry = (ScriptProcessorRegistry)this.applicationContext.getBean(WEBSCRIPTS_SCRIPT_REGISTRY_ID);
        }
        if (this.factory != null) {
            ScriptProcessor scriptProcessor = this.factory.newInstance();
            if (scriptProcessor instanceof AbstractScriptProcessor) {
                if (this.searchPath == null) {
                    this.searchPath = (SearchPath)this.applicationContext.getBean(WEBSCRIPTS_SEARCHPATH_ID);
                }
                ((AbstractScriptProcessor)scriptProcessor).setSearchPath(this.searchPath);
            }
            this.registry.registerScriptProcessor(scriptProcessor, this.extension, this.name);
        }
    }
}

